/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.api.core.AsyncAutoCloseable;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.Tablet;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.internal.core.config.ConfigChangeEvent;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.control.ControlConnection;
import com.datastax.oss.driver.internal.core.metadata.AddNodeRefresh;
import com.datastax.oss.driver.internal.core.metadata.AddTabletRefresh;
import com.datastax.oss.driver.internal.core.metadata.DefaultEndPoint;
import com.datastax.oss.driver.internal.core.metadata.DefaultMetadata;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.DefaultTabletMap;
import com.datastax.oss.driver.internal.core.metadata.FullNodeListRefresh;
import com.datastax.oss.driver.internal.core.metadata.InitialNodeListRefresh;
import com.datastax.oss.driver.internal.core.metadata.MetadataRefresh;
import com.datastax.oss.driver.internal.core.metadata.NodeInfo;
import com.datastax.oss.driver.internal.core.metadata.NodesRefresh;
import com.datastax.oss.driver.internal.core.metadata.RemoveNodeRefresh;
import com.datastax.oss.driver.internal.core.metadata.TokensChangedRefresh;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.SchemaParserFactory;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.KeyspaceFilter;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.SchemaQueriesFactory;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.SchemaRows;
import com.datastax.oss.driver.internal.core.metadata.schema.refresh.SchemaRefresh;
import com.datastax.oss.driver.internal.core.util.Loggers;
import com.datastax.oss.driver.internal.core.util.NanoTime;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.internal.core.util.concurrent.Debouncer;
import com.datastax.oss.driver.internal.core.util.concurrent.RunOrSchedule;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.driver.shaded.netty.util.concurrent.EventExecutor;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class MetadataManager
implements AsyncAutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataManager.class);
    static final EndPoint DEFAULT_CONTACT_POINT = new DefaultEndPoint(new InetSocketAddress("127.0.0.1", 9042));
    private final InternalDriverContext context;
    private final String logPrefix;
    private final EventExecutor adminExecutor;
    private final DriverExecutionProfile config;
    private final SingleThreaded singleThreaded;
    private final ControlConnection controlConnection;
    private volatile DefaultMetadata metadata;
    private volatile boolean schemaEnabledInConfig;
    private volatile List<String> refreshedKeyspaces;
    private volatile KeyspaceFilter keyspaceFilter;
    private volatile Boolean schemaEnabledProgrammatically;
    private volatile boolean tokenMapEnabled;
    private volatile Set<DefaultNode> contactPoints;
    private volatile boolean wasImplicitContactPoint;
    private volatile TypeCodec<TupleValue> tabletPayloadCodec = null;

    public MetadataManager(InternalDriverContext context) {
        this(context, DefaultMetadata.EMPTY);
    }

    protected MetadataManager(InternalDriverContext context, DefaultMetadata initialMetadata) {
        this.context = context;
        this.metadata = initialMetadata;
        this.logPrefix = context.getSessionName();
        this.adminExecutor = context.getNettyOptions().adminEventExecutorGroup().next();
        this.config = context.getConfig().getDefaultProfile();
        this.singleThreaded = new SingleThreaded(context, this.config);
        this.controlConnection = context.getControlConnection();
        this.schemaEnabledInConfig = this.config.getBoolean(DefaultDriverOption.METADATA_SCHEMA_ENABLED);
        this.refreshedKeyspaces = this.config.getStringList(DefaultDriverOption.METADATA_SCHEMA_REFRESHED_KEYSPACES, Collections.emptyList());
        this.keyspaceFilter = KeyspaceFilter.newInstance(this.logPrefix, this.refreshedKeyspaces);
        this.tokenMapEnabled = this.config.getBoolean(DefaultDriverOption.METADATA_TOKEN_MAP_ENABLED);
        context.getEventBus().register(ConfigChangeEvent.class, this::onConfigChanged);
    }

    private void onConfigChanged(ConfigChangeEvent event) {
        boolean schemaEnabledBefore = this.isSchemaEnabled();
        boolean tokenMapEnabledBefore = this.tokenMapEnabled;
        List<String> keyspacesBefore = this.refreshedKeyspaces;
        this.schemaEnabledInConfig = this.config.getBoolean(DefaultDriverOption.METADATA_SCHEMA_ENABLED);
        this.refreshedKeyspaces = this.config.getStringList(DefaultDriverOption.METADATA_SCHEMA_REFRESHED_KEYSPACES, Collections.emptyList());
        this.keyspaceFilter = KeyspaceFilter.newInstance(this.logPrefix, this.refreshedKeyspaces);
        this.tokenMapEnabled = this.config.getBoolean(DefaultDriverOption.METADATA_TOKEN_MAP_ENABLED);
        if ((!schemaEnabledBefore || !keyspacesBefore.equals(this.refreshedKeyspaces) || !tokenMapEnabledBefore && this.tokenMapEnabled) && this.isSchemaEnabled()) {
            this.refreshSchema(null, false, true).whenComplete((metadata, error) -> {
                if (error != null) {
                    Loggers.warnWithException(LOG, "[{}] Unexpected error while refreshing schema after it was re-enabled in the configuration, keeping previous version", this.logPrefix, error);
                }
            });
        }
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void addContactPoints(Set<EndPoint> providedContactPoints) {
        ImmutableSet.Builder contactPointsBuilder = ImmutableSet.builder();
        if (providedContactPoints == null || providedContactPoints.isEmpty()) {
            LOG.info("[{}] No contact points provided, defaulting to {}", (Object)this.logPrefix, (Object)DEFAULT_CONTACT_POINT);
            this.wasImplicitContactPoint = true;
            contactPointsBuilder.add((Object)new DefaultNode(DEFAULT_CONTACT_POINT, this.context));
        } else {
            for (EndPoint endPoint : providedContactPoints) {
                contactPointsBuilder.add((Object)new DefaultNode(endPoint, this.context));
            }
        }
        this.contactPoints = contactPointsBuilder.build();
        LOG.debug("[{}] Adding initial contact points {}", (Object)this.logPrefix, this.contactPoints);
    }

    public Set<DefaultNode> getContactPoints() {
        return this.contactPoints;
    }

    public boolean wasImplicitContactPoint() {
        return this.wasImplicitContactPoint;
    }

    public CompletionStage<Void> refreshNodes() {
        return this.context.getTopologyMonitor().refreshNodeList().thenApplyAsync(x$0 -> this.singleThreaded.refreshNodes(x$0), this.adminExecutor);
    }

    public CompletionStage<Void> refreshNode(Node node) {
        return this.context.getTopologyMonitor().refreshNode(node).thenApplyAsync(maybeInfo -> {
            if (maybeInfo.isPresent()) {
                boolean tokensChanged = NodesRefresh.copyInfos((NodeInfo)maybeInfo.get(), (DefaultNode)node, this.context);
                if (tokensChanged) {
                    this.apply(new TokensChangedRefresh());
                }
            } else {
                LOG.debug("[{}] Topology monitor did not return any info for the refresh of {}, skipping", (Object)this.logPrefix, (Object)node);
            }
            return null;
        }, this.adminExecutor);
    }

    public void addNode(InetSocketAddress broadcastRpcAddress) {
        this.context.getTopologyMonitor().getNewNodeInfo(broadcastRpcAddress).whenCompleteAsync((info, error) -> {
            if (error != null) {
                LOG.debug("[{}] Error refreshing node info for {}, this will be retried on the next full refresh", new Object[]{this.logPrefix, broadcastRpcAddress, error});
            } else {
                this.singleThreaded.addNode(broadcastRpcAddress, info.orElse(null));
            }
        }, this.adminExecutor);
    }

    public void removeNode(InetSocketAddress broadcastRpcAddress) {
        RunOrSchedule.on(this.adminExecutor, () -> this.singleThreaded.removeNode(broadcastRpcAddress));
    }

    public CompletionStage<RefreshSchemaResult> refreshSchema(String keyspace, boolean evenIfDisabled, boolean flushNow) {
        CompletableFuture<RefreshSchemaResult> future = new CompletableFuture<RefreshSchemaResult>();
        RunOrSchedule.on(this.adminExecutor, () -> this.singleThreaded.refreshSchema(keyspace, evenIfDisabled, flushNow, future));
        return future;
    }

    public boolean isSchemaEnabled() {
        return this.schemaEnabledProgrammatically != null ? this.schemaEnabledProgrammatically : this.schemaEnabledInConfig;
    }

    public CompletionStage<Metadata> setSchemaEnabled(Boolean newValue) {
        boolean wasEnabledBefore = this.isSchemaEnabled();
        this.schemaEnabledProgrammatically = newValue;
        if (!wasEnabledBefore && this.isSchemaEnabled()) {
            return this.refreshSchema(null, false, true).thenApply(RefreshSchemaResult::getMetadata);
        }
        return CompletableFuture.completedFuture(this.metadata);
    }

    @Override
    @NonNull
    public CompletionStage<Void> closeFuture() {
        return this.singleThreaded.closeFuture;
    }

    @Override
    @NonNull
    public CompletionStage<Void> closeAsync() {
        RunOrSchedule.on(this.adminExecutor, () -> this.singleThreaded.close());
        return this.singleThreaded.closeFuture;
    }

    @Override
    @NonNull
    public CompletionStage<Void> forceCloseAsync() {
        return this.closeAsync();
    }

    @VisibleForTesting
    Void apply(MetadataRefresh refresh) {
        boolean isFirstSchemaRefresh;
        assert (this.adminExecutor.inEventLoop());
        MetadataRefresh.Result result = refresh.compute(this.metadata, this.tokenMapEnabled, this.context);
        this.metadata = result.newMetadata;
        boolean bl = isFirstSchemaRefresh = refresh instanceof SchemaRefresh && !this.singleThreaded.firstSchemaRefreshFuture.isDone();
        if (!this.singleThreaded.closeWasCalled && !isFirstSchemaRefresh) {
            for (Object event : result.events) {
                this.context.getEventBus().fire(event);
            }
        }
        return null;
    }

    private TypeCodec<TupleValue> getTabletPayloadCodec() {
        if (this.tabletPayloadCodec == null) {
            TupleType payloadOuterTuple = DataTypes.tupleOf(DataTypes.BIGINT, DataTypes.BIGINT, DataTypes.listOf(DataTypes.tupleOf(DataTypes.UUID, DataTypes.INT)));
            this.tabletPayloadCodec = this.context.getCodecRegistry().codecFor(payloadOuterTuple);
        }
        return this.tabletPayloadCodec;
    }

    public void addTabletFromPayload(CqlIdentifier keyspace, CqlIdentifier table, @NonNull Map<String, ByteBuffer> incomingPayload) {
        TupleValue tabletTuple = this.getTabletPayloadCodec().decode(incomingPayload.get("tablets-routing-v1"), this.context.getProtocolVersion());
        if (tabletTuple == null) {
            LOG.warn("Custom payload containing tablet information for table {}.{} decoded to null. This should not ever happen.", (Object)keyspace, (Object)table);
            return;
        }
        DefaultTabletMap.DefaultTablet tabletToAdd = DefaultTabletMap.DefaultTablet.parseTabletPayloadV1(tabletTuple, this.getMetadata().getNodes());
        RunOrSchedule.on(this.adminExecutor, () -> this.singleThreaded.addTablet(keyspace, table, tabletToAdd));
    }

    private class SingleThreaded {
        private final CompletableFuture<Void> closeFuture = new CompletableFuture();
        private boolean closeWasCalled;
        private final CompletableFuture<Void> firstSchemaRefreshFuture = new CompletableFuture();
        private final Debouncer<CompletableFuture<RefreshSchemaResult>, CompletableFuture<RefreshSchemaResult>> schemaRefreshDebouncer;
        private final SchemaQueriesFactory schemaQueriesFactory;
        private final SchemaParserFactory schemaParserFactory;
        private CompletableFuture<RefreshSchemaResult> currentSchemaRefresh;
        private CompletableFuture<RefreshSchemaResult> queuedSchemaRefresh;
        private boolean didFirstNodeListRefresh;

        private SingleThreaded(InternalDriverContext context, DriverExecutionProfile config) {
            this.schemaRefreshDebouncer = new Debouncer(MetadataManager.this.logPrefix + "|metadata debouncer", MetadataManager.this.adminExecutor, this::coalesceSchemaRequests, this::startSchemaRequest, config.getDuration(DefaultDriverOption.METADATA_SCHEMA_WINDOW), config.getInt(DefaultDriverOption.METADATA_SCHEMA_MAX_EVENTS));
            this.schemaQueriesFactory = context.getSchemaQueriesFactory();
            this.schemaParserFactory = context.getSchemaParserFactory();
        }

        private Void refreshNodes(Iterable<NodeInfo> nodeInfos) {
            NodesRefresh refresh = this.didFirstNodeListRefresh ? new FullNodeListRefresh(nodeInfos) : new InitialNodeListRefresh(nodeInfos, MetadataManager.this.contactPoints);
            this.didFirstNodeListRefresh = true;
            return MetadataManager.this.apply(refresh);
        }

        private void addNode(InetSocketAddress address, NodeInfo info) {
            try {
                if (info != null) {
                    if (!address.equals(info.getBroadcastRpcAddress().orElse(null))) {
                        LOG.warn("[{}] Received a request to add a node for broadcast RPC address {}, but the provided info reports {}, ignoring it", new Object[]{MetadataManager.this.logPrefix, address, info.getBroadcastAddress()});
                    } else {
                        MetadataManager.this.apply(new AddNodeRefresh(info));
                    }
                } else {
                    LOG.debug("[{}] Ignoring node addition for {} because the topology monitor didn't return any information", (Object)MetadataManager.this.logPrefix, (Object)address);
                }
            }
            catch (Throwable t) {
                LOG.warn("[" + MetadataManager.this.logPrefix + "] Unexpected exception while handling added node", (Object)MetadataManager.this.logPrefix);
            }
        }

        private void removeNode(InetSocketAddress broadcastRpcAddress) {
            MetadataManager.this.apply(new RemoveNodeRefresh(broadcastRpcAddress));
        }

        private void refreshSchema(String keyspace, boolean evenIfDisabled, boolean flushNow, CompletableFuture<RefreshSchemaResult> future) {
            boolean isRefreshedKeyspace;
            if (!this.didFirstNodeListRefresh) {
                future.complete(new RefreshSchemaResult(MetadataManager.this.metadata));
                return;
            }
            boolean bl = isRefreshedKeyspace = keyspace == null || MetadataManager.this.keyspaceFilter.includes(keyspace);
            if (isRefreshedKeyspace && (evenIfDisabled || MetadataManager.this.isSchemaEnabled())) {
                this.acceptSchemaRequest(future, flushNow);
            } else {
                future.complete(new RefreshSchemaResult(MetadataManager.this.metadata));
                ((MetadataManager)MetadataManager.this).singleThreaded.firstSchemaRefreshFuture.complete(null);
            }
        }

        private void acceptSchemaRequest(CompletableFuture<RefreshSchemaResult> future, boolean flushNow) {
            assert (MetadataManager.this.adminExecutor.inEventLoop());
            if (this.closeWasCalled) {
                future.complete(new RefreshSchemaResult(MetadataManager.this.metadata));
            } else {
                this.schemaRefreshDebouncer.receive(future);
                if (flushNow) {
                    this.schemaRefreshDebouncer.flushNow();
                }
            }
        }

        private CompletableFuture<RefreshSchemaResult> coalesceSchemaRequests(List<CompletableFuture<RefreshSchemaResult>> futures) {
            assert (MetadataManager.this.adminExecutor.inEventLoop());
            assert (!futures.isEmpty());
            CompletableFuture<RefreshSchemaResult> result = null;
            for (CompletableFuture<RefreshSchemaResult> future : futures) {
                if (result == null) {
                    result = future;
                    continue;
                }
                CompletableFutures.completeFrom(result, future);
            }
            return result;
        }

        private void startSchemaRequest(CompletableFuture<RefreshSchemaResult> refreshFuture) {
            assert (MetadataManager.this.adminExecutor.inEventLoop());
            if (this.closeWasCalled) {
                refreshFuture.complete(new RefreshSchemaResult(MetadataManager.this.metadata));
                return;
            }
            if (this.currentSchemaRefresh == null) {
                this.currentSchemaRefresh = refreshFuture;
                LOG.debug("[{}] Starting schema refresh", (Object)MetadataManager.this.logPrefix);
                this.initControlConnectionForSchema().thenCompose(v -> MetadataManager.this.context.getTopologyMonitor().checkSchemaAgreement()).whenComplete((schemaInAgreement, agreementError) -> {
                    if (agreementError != null) {
                        refreshFuture.completeExceptionally((Throwable)agreementError);
                    } else {
                        try {
                            this.schemaQueriesFactory.newInstance().execute().thenApplyAsync(this::parseAndApplySchemaRows, MetadataManager.this.adminExecutor).whenComplete((newMetadata, metadataError) -> {
                                if (metadataError != null) {
                                    refreshFuture.completeExceptionally((Throwable)metadataError);
                                } else {
                                    refreshFuture.complete(new RefreshSchemaResult((Metadata)newMetadata, (boolean)schemaInAgreement));
                                }
                                this.firstSchemaRefreshFuture.complete(null);
                                this.currentSchemaRefresh = null;
                                if (this.queuedSchemaRefresh != null) {
                                    CompletableFuture<RefreshSchemaResult> tmp = this.queuedSchemaRefresh;
                                    this.queuedSchemaRefresh = null;
                                    this.startSchemaRequest(tmp);
                                }
                            });
                        }
                        catch (Throwable t) {
                            LOG.debug("[{}] Exception getting new metadata", (Object)MetadataManager.this.logPrefix, (Object)t);
                            refreshFuture.completeExceptionally(t);
                        }
                    }
                });
            } else if (this.queuedSchemaRefresh == null) {
                this.queuedSchemaRefresh = refreshFuture;
            } else {
                CompletableFutures.completeFrom(this.queuedSchemaRefresh, refreshFuture);
            }
        }

        private CompletionStage<Void> initControlConnectionForSchema() {
            if (this.firstSchemaRefreshFuture.isDone()) {
                return this.firstSchemaRefreshFuture;
            }
            return MetadataManager.this.controlConnection.init(false, true, false);
        }

        private Metadata parseAndApplySchemaRows(SchemaRows schemaRows) {
            assert (MetadataManager.this.adminExecutor.inEventLoop());
            SchemaRefresh schemaRefresh = this.schemaParserFactory.newInstance(schemaRows).parse();
            long start = System.nanoTime();
            MetadataManager.this.apply(schemaRefresh);
            LOG.debug("[{}] Applying schema refresh took {}", (Object)MetadataManager.this.logPrefix, (Object)NanoTime.formatTimeSince(start));
            return MetadataManager.this.metadata;
        }

        private void addTablet(CqlIdentifier keyspace, CqlIdentifier table, Tablet tablet) {
            MetadataManager.this.apply(new AddTabletRefresh(keyspace, table, tablet));
        }

        private void close() {
            if (this.closeWasCalled) {
                return;
            }
            this.closeWasCalled = true;
            LOG.debug("[{}] Closing", (Object)MetadataManager.this.logPrefix);
            if (this.queuedSchemaRefresh != null) {
                this.queuedSchemaRefresh.completeExceptionally(new IllegalStateException("Cluster is closed"));
            }
            this.closeFuture.complete(null);
        }
    }

    public static class RefreshSchemaResult {
        private final Metadata metadata;
        private final boolean isSchemaInAgreement;

        public RefreshSchemaResult(Metadata metadata, boolean isSchemaInAgreement) {
            this.metadata = metadata;
            this.isSchemaInAgreement = isSchemaInAgreement;
        }

        public RefreshSchemaResult(Metadata metadata) {
            this(metadata, true);
        }

        public Metadata getMetadata() {
            return this.metadata;
        }

        public boolean isSchemaInAgreement() {
            return this.isSchemaInAgreement;
        }
    }
}

