/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.shaded.esri.core.geometry;

import com.datastax.oss.driver.shaded.esri.core.geometry.Envelope;
import com.datastax.oss.driver.shaded.esri.core.geometry.Envelope2D;
import com.datastax.oss.driver.shaded.esri.core.geometry.Geometry;
import com.datastax.oss.driver.shaded.esri.core.geometry.GeometryCursor;
import com.datastax.oss.driver.shaded.esri.core.geometry.GeometryException;
import com.datastax.oss.driver.shaded.esri.core.geometry.MultiPath;
import com.datastax.oss.driver.shaded.esri.core.geometry.Point;
import com.datastax.oss.driver.shaded.esri.core.geometry.Polygon;
import com.datastax.oss.driver.shaded.esri.core.geometry.Polyline;
import com.datastax.oss.driver.shaded.esri.core.geometry.ProgressTracker;
import com.datastax.oss.driver.shaded.esri.core.geometry.Segment;
import com.datastax.oss.driver.shaded.esri.core.geometry.SegmentIterator;

class OperatorDensifyByLengthCursor
extends GeometryCursor {
    GeometryCursor m_inputGeoms;
    double m_maxLength;
    int m_index = -1;

    public OperatorDensifyByLengthCursor(GeometryCursor inputGeoms1, double maxLength, ProgressTracker progressTracker) {
        this.m_inputGeoms = inputGeoms1;
        this.m_maxLength = maxLength;
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }

    @Override
    public Geometry next() {
        Geometry geom = this.m_inputGeoms.next();
        if (geom != null) {
            this.m_index = this.m_inputGeoms.getGeometryID();
            return this.densifyByLength(geom);
        }
        return null;
    }

    private Geometry densifyByLength(Geometry geom) {
        if (geom.isEmpty() || geom.getDimension() < 1) {
            return geom;
        }
        int geometryType = geom.getType().value();
        if (geometryType == 1736) {
            return this.densifyMultiPath((MultiPath)geom);
        }
        if (1607 == geometryType) {
            return this.densifyMultiPath((MultiPath)geom);
        }
        if (Geometry.isSegment(geometryType)) {
            return this.densifySegment((Segment)geom);
        }
        if (geometryType == 197) {
            return this.densifyEnvelope((Envelope)geom);
        }
        throw GeometryException.GeometryInternalError();
    }

    private Geometry densifySegment(Segment geom) {
        double length = geom.calculateLength2D();
        if (length <= this.m_maxLength) {
            return geom;
        }
        Polyline polyline = new Polyline(geom.getDescription());
        polyline.addSegment(geom, true);
        return this.densifyMultiPath(polyline);
    }

    private Geometry densifyEnvelope(Envelope geom) {
        Polygon polygon = new Polygon(geom.getDescription());
        polygon.addEnvelope(geom, false);
        Envelope2D env2D = new Envelope2D();
        geom.queryEnvelope2D(env2D);
        double w = env2D.getWidth();
        double h = env2D.getHeight();
        if (w <= this.m_maxLength && h <= this.m_maxLength) {
            return polygon;
        }
        return this.densifyMultiPath(polygon);
    }

    private Geometry densifyMultiPath(MultiPath geom) {
        MultiPath densifiedPoly = (MultiPath)geom.createInstance();
        SegmentIterator iter = geom.querySegmentIterator();
        while (iter.nextPath()) {
            boolean bStartNewPath = true;
            while (iter.hasNextSegment()) {
                Segment seg = iter.nextSegment();
                if (seg.getType().value() != 322) {
                    throw new GeometryException("not implemented");
                }
                boolean bIsClosing = iter.isClosingSegment();
                double len = seg.calculateLength2D();
                if (len > this.m_maxLength) {
                    double dt;
                    double dcount = Math.ceil(len / this.m_maxLength);
                    Point point = new Point(geom.getDescription());
                    if (bStartNewPath) {
                        bStartNewPath = false;
                        seg.queryStart(point);
                        densifiedPoly.startPath(point);
                    }
                    double t = dt = 1.0 / dcount;
                    int n = (int)dcount - 1;
                    for (int i = 0; i < n; ++i) {
                        seg.queryCoord(t, point);
                        densifiedPoly.lineTo(point);
                        t += dt;
                    }
                    if (!bIsClosing) {
                        seg.queryEnd(point);
                        densifiedPoly.lineTo(point);
                    } else {
                        densifiedPoly.closePathWithLine();
                    }
                    bStartNewPath = false;
                    continue;
                }
                if (!bIsClosing) {
                    densifiedPoly.addSegment(seg, bStartNewPath);
                } else {
                    densifiedPoly.closePathWithLine();
                }
                bStartNewPath = false;
            }
        }
        return densifiedPoly;
    }
}

