/*
 * Decompiled with CFR 0.152.
 */
package com.tozny.crypto.android;

import android.os.Build;
import android.os.Process;
import android.util.Base64;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.security.Security;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class AesCbcWithIntegrity {
    private static final boolean ALLOW_BROKEN_PRNG = false;
    private static final String CIPHER_TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final String CIPHER = "AES";
    private static final int AES_KEY_LENGTH_BITS = 128;
    private static final int IV_LENGTH_BYTES = 16;
    private static final int PBE_ITERATION_COUNT = 10000;
    private static final int PBE_SALT_LENGTH_BITS = 128;
    private static final String PBE_ALGORITHM = "PBKDF2WithHmacSHA1";
    public static final int BASE64_FLAGS = 2;
    static final AtomicBoolean prngFixed = new AtomicBoolean(false);
    private static final String HMAC_ALGORITHM = "HmacSHA256";
    private static final int HMAC_KEY_LENGTH_BITS = 256;

    public static String keyString(SecretKeys keys) {
        return keys.toString();
    }

    public static SecretKeys keys(String keysStr) throws InvalidKeyException {
        String[] keysArr = keysStr.split(":");
        if (keysArr.length != 2) {
            throw new IllegalArgumentException("Cannot parse aesKey:hmacKey");
        }
        byte[] confidentialityKey = Base64.decode((String)keysArr[0], (int)2);
        if (confidentialityKey.length != 16) {
            throw new InvalidKeyException("Base64 decoded key is not 128 bytes");
        }
        byte[] integrityKey = Base64.decode((String)keysArr[1], (int)2);
        if (integrityKey.length != 32) {
            throw new InvalidKeyException("Base64 decoded key is not 256 bytes");
        }
        return new SecretKeys(new SecretKeySpec(confidentialityKey, 0, confidentialityKey.length, CIPHER), new SecretKeySpec(integrityKey, HMAC_ALGORITHM));
    }

    public static SecretKeys generateKey() throws GeneralSecurityException {
        AesCbcWithIntegrity.fixPrng();
        KeyGenerator keyGen = KeyGenerator.getInstance(CIPHER);
        keyGen.init(128);
        SecretKey confidentialityKey = keyGen.generateKey();
        byte[] integrityKeyBytes = AesCbcWithIntegrity.randomBytes(32);
        SecretKeySpec integrityKey = new SecretKeySpec(integrityKeyBytes, HMAC_ALGORITHM);
        return new SecretKeys(confidentialityKey, integrityKey);
    }

    public static SecretKeys generateKeyFromPassword(String password, byte[] salt) throws GeneralSecurityException {
        return AesCbcWithIntegrity.generateKeyFromPassword(password, salt, 10000);
    }

    public static SecretKeys generateKeyFromPassword(String password, byte[] salt, int iterationCount) throws GeneralSecurityException {
        AesCbcWithIntegrity.fixPrng();
        PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), salt, iterationCount, 384);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(PBE_ALGORITHM);
        byte[] keyBytes = keyFactory.generateSecret(keySpec).getEncoded();
        byte[] confidentialityKeyBytes = AesCbcWithIntegrity.copyOfRange(keyBytes, 0, 16);
        byte[] integrityKeyBytes = AesCbcWithIntegrity.copyOfRange(keyBytes, 16, 48);
        SecretKeySpec confidentialityKey = new SecretKeySpec(confidentialityKeyBytes, CIPHER);
        SecretKeySpec integrityKey = new SecretKeySpec(integrityKeyBytes, HMAC_ALGORITHM);
        return new SecretKeys(confidentialityKey, integrityKey);
    }

    public static SecretKeys generateKeyFromPassword(String password, String salt) throws GeneralSecurityException {
        return AesCbcWithIntegrity.generateKeyFromPassword(password, salt, 10000);
    }

    public static SecretKeys generateKeyFromPassword(String password, String salt, int iterationCount) throws GeneralSecurityException {
        return AesCbcWithIntegrity.generateKeyFromPassword(password, Base64.decode((String)salt, (int)2), iterationCount);
    }

    public static byte[] generateSalt() throws GeneralSecurityException {
        return AesCbcWithIntegrity.randomBytes(128);
    }

    public static String saltString(byte[] salt) {
        return Base64.encodeToString((byte[])salt, (int)2);
    }

    public static byte[] generateIv() throws GeneralSecurityException {
        return AesCbcWithIntegrity.randomBytes(16);
    }

    private static byte[] randomBytes(int length) throws GeneralSecurityException {
        AesCbcWithIntegrity.fixPrng();
        SecureRandom random = new SecureRandom();
        byte[] b = new byte[length];
        random.nextBytes(b);
        return b;
    }

    public static CipherTextIvMac encrypt(String plaintext, SecretKeys secretKeys) throws UnsupportedEncodingException, GeneralSecurityException {
        return AesCbcWithIntegrity.encrypt(plaintext, secretKeys, "UTF-8");
    }

    public static CipherTextIvMac encrypt(String plaintext, SecretKeys secretKeys, String encoding) throws UnsupportedEncodingException, GeneralSecurityException {
        return AesCbcWithIntegrity.encrypt(plaintext.getBytes(encoding), secretKeys);
    }

    public static CipherTextIvMac encrypt(byte[] plaintext, SecretKeys secretKeys) throws GeneralSecurityException {
        byte[] iv = AesCbcWithIntegrity.generateIv();
        Cipher aesCipherForEncryption = Cipher.getInstance(CIPHER_TRANSFORMATION);
        aesCipherForEncryption.init(1, (Key)secretKeys.getConfidentialityKey(), new IvParameterSpec(iv));
        iv = aesCipherForEncryption.getIV();
        byte[] byteCipherText = aesCipherForEncryption.doFinal(plaintext);
        byte[] ivCipherConcat = CipherTextIvMac.ivCipherConcat(iv, byteCipherText);
        byte[] integrityMac = AesCbcWithIntegrity.generateMac(ivCipherConcat, secretKeys.getIntegrityKey());
        return new CipherTextIvMac(byteCipherText, iv, integrityMac);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void fixPrng() {
        if (prngFixed.get()) return;
        Class<PrngFixes> clazz = PrngFixes.class;
        synchronized (PrngFixes.class) {
            if (prngFixed.get()) return;
            PrngFixes.apply();
            prngFixed.set(true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static String decryptString(CipherTextIvMac civ, SecretKeys secretKeys, String encoding) throws UnsupportedEncodingException, GeneralSecurityException {
        return new String(AesCbcWithIntegrity.decrypt(civ, secretKeys), encoding);
    }

    public static String decryptString(CipherTextIvMac civ, SecretKeys secretKeys) throws UnsupportedEncodingException, GeneralSecurityException {
        return AesCbcWithIntegrity.decryptString(civ, secretKeys, "UTF-8");
    }

    public static byte[] decrypt(CipherTextIvMac civ, SecretKeys secretKeys) throws GeneralSecurityException {
        byte[] ivCipherConcat = CipherTextIvMac.ivCipherConcat(civ.getIv(), civ.getCipherText());
        byte[] computedMac = AesCbcWithIntegrity.generateMac(ivCipherConcat, secretKeys.getIntegrityKey());
        if (AesCbcWithIntegrity.constantTimeEq(computedMac, civ.getMac())) {
            Cipher aesCipherForDecryption = Cipher.getInstance(CIPHER_TRANSFORMATION);
            aesCipherForDecryption.init(2, (Key)secretKeys.getConfidentialityKey(), new IvParameterSpec(civ.getIv()));
            return aesCipherForDecryption.doFinal(civ.getCipherText());
        }
        throw new GeneralSecurityException("MAC stored in civ does not match computed MAC.");
    }

    public static byte[] generateMac(byte[] byteCipherText, SecretKey integrityKey) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac sha256_HMAC = Mac.getInstance(HMAC_ALGORITHM);
        sha256_HMAC.init(integrityKey);
        return sha256_HMAC.doFinal(byteCipherText);
    }

    public static boolean constantTimeEq(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int result = 0;
        for (int i = 0; i < a.length; ++i) {
            result |= a[i] ^ b[i];
        }
        return result == 0;
    }

    private static byte[] copyOfRange(byte[] from, int start, int end) {
        int length = end - start;
        byte[] result = new byte[length];
        System.arraycopy(from, start, result, 0, length);
        return result;
    }

    public static final class PrngFixes {
        private static final int VERSION_CODE_JELLY_BEAN = 16;
        private static final int VERSION_CODE_JELLY_BEAN_MR2 = 18;
        private static final byte[] BUILD_FINGERPRINT_AND_DEVICE_SERIAL = PrngFixes.getBuildFingerprintAndDeviceSerial();

        private PrngFixes() {
        }

        public static void apply() {
            PrngFixes.applyOpenSSLFix();
            PrngFixes.installLinuxPRNGSecureRandom();
        }

        private static void applyOpenSSLFix() throws SecurityException {
            if (Build.VERSION.SDK_INT < 16 || Build.VERSION.SDK_INT > 18) {
                return;
            }
            try {
                Class.forName("org.apache.harmony.xnet.provider.jsse.NativeCrypto").getMethod("RAND_seed", byte[].class).invoke(null, new Object[]{PrngFixes.generateSeed()});
                int bytesRead = (Integer)Class.forName("org.apache.harmony.xnet.provider.jsse.NativeCrypto").getMethod("RAND_load_file", String.class, Long.TYPE).invoke(null, "/dev/urandom", 1024);
                if (bytesRead != 1024) {
                    throw new IOException("Unexpected number of bytes read from Linux PRNG: " + bytesRead);
                }
            }
            catch (Exception e) {
                throw new SecurityException("Failed to seed OpenSSL PRNG", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void installLinuxPRNGSecureRandom() throws SecurityException {
            if (Build.VERSION.SDK_INT > 18) {
                return;
            }
            Provider[] secureRandomProviders = Security.getProviders("SecureRandom.SHA1PRNG");
            Class<Security> clazz = Security.class;
            synchronized (Security.class) {
                SecureRandom rng1;
                if (secureRandomProviders == null || secureRandomProviders.length < 1 || !secureRandomProviders[0].getClass().getSimpleName().equals(LinuxPRNGSecureRandomProvider.class.getSimpleName())) {
                    Security.insertProviderAt(new LinuxPRNGSecureRandomProvider(), 1);
                }
                if (!(rng1 = new SecureRandom()).getProvider().getClass().getSimpleName().equals(LinuxPRNGSecureRandomProvider.class.getSimpleName())) {
                    throw new SecurityException("new SecureRandom() backed by wrong Provider: " + rng1.getProvider().getClass());
                }
                SecureRandom rng2 = null;
                try {
                    rng2 = SecureRandom.getInstance("SHA1PRNG");
                }
                catch (NoSuchAlgorithmException e) {
                    new SecurityException("SHA1PRNG not available", e);
                }
                if (!rng2.getProvider().getClass().getSimpleName().equals(LinuxPRNGSecureRandomProvider.class.getSimpleName())) {
                    throw new SecurityException("SecureRandom.getInstance(\"SHA1PRNG\") backed by wrong Provider: " + rng2.getProvider().getClass());
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private static byte[] generateSeed() {
            try {
                ByteArrayOutputStream seedBuffer = new ByteArrayOutputStream();
                DataOutputStream seedBufferOut = new DataOutputStream(seedBuffer);
                seedBufferOut.writeLong(System.currentTimeMillis());
                seedBufferOut.writeLong(System.nanoTime());
                seedBufferOut.writeInt(Process.myPid());
                seedBufferOut.writeInt(Process.myUid());
                seedBufferOut.write(BUILD_FINGERPRINT_AND_DEVICE_SERIAL);
                seedBufferOut.close();
                return seedBuffer.toByteArray();
            }
            catch (IOException e) {
                throw new SecurityException("Failed to generate seed", e);
            }
        }

        private static String getDeviceSerialNumber() {
            try {
                return (String)Build.class.getField("SERIAL").get(null);
            }
            catch (Exception ignored) {
                return null;
            }
        }

        private static byte[] getBuildFingerprintAndDeviceSerial() {
            String serial;
            StringBuilder result = new StringBuilder();
            String fingerprint = Build.FINGERPRINT;
            if (fingerprint != null) {
                result.append(fingerprint);
            }
            if ((serial = PrngFixes.getDeviceSerialNumber()) != null) {
                result.append(serial);
            }
            try {
                return result.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UTF-8 encoding not supported");
            }
        }

        public static class LinuxPRNGSecureRandom
        extends SecureRandomSpi {
            private static final File URANDOM_FILE = new File("/dev/urandom");
            private static final Object sLock = new Object();
            private static DataInputStream sUrandomIn;
            private static OutputStream sUrandomOut;
            private boolean mSeeded;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void engineSetSeed(byte[] bytes) {
                try {
                    OutputStream out;
                    Object object = sLock;
                    synchronized (object) {
                        out = this.getUrandomOutputStream();
                    }
                    out.write(bytes);
                    out.flush();
                }
                catch (IOException e) {
                    Log.w((String)PrngFixes.class.getSimpleName(), (String)("Failed to mix seed into " + URANDOM_FILE));
                }
                finally {
                    this.mSeeded = true;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void engineNextBytes(byte[] bytes) {
                if (!this.mSeeded) {
                    this.engineSetSeed(PrngFixes.generateSeed());
                }
                try {
                    DataInputStream in;
                    Object object = sLock;
                    synchronized (object) {
                        in = this.getUrandomInputStream();
                    }
                    object = in;
                    synchronized (object) {
                        in.readFully(bytes);
                    }
                }
                catch (IOException e) {
                    throw new SecurityException("Failed to read from " + URANDOM_FILE, e);
                }
            }

            @Override
            protected byte[] engineGenerateSeed(int size) {
                byte[] seed = new byte[size];
                this.engineNextBytes(seed);
                return seed;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private DataInputStream getUrandomInputStream() {
                Object object = sLock;
                synchronized (object) {
                    if (sUrandomIn == null) {
                        try {
                            sUrandomIn = new DataInputStream(new FileInputStream(URANDOM_FILE));
                        }
                        catch (IOException e) {
                            throw new SecurityException("Failed to open " + URANDOM_FILE + " for reading", e);
                        }
                    }
                    return sUrandomIn;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private OutputStream getUrandomOutputStream() throws IOException {
                Object object = sLock;
                synchronized (object) {
                    if (sUrandomOut == null) {
                        sUrandomOut = new FileOutputStream(URANDOM_FILE);
                    }
                    return sUrandomOut;
                }
            }
        }

        private static class LinuxPRNGSecureRandomProvider
        extends Provider {
            public LinuxPRNGSecureRandomProvider() {
                super("LinuxPRNG", 1.0, "A Linux-specific random number provider that uses /dev/urandom");
                this.put("SecureRandom.SHA1PRNG", LinuxPRNGSecureRandom.class.getName());
                this.put("SecureRandom.SHA1PRNG ImplementedIn", "Software");
            }
        }
    }

    public static class CipherTextIvMac {
        private final byte[] cipherText;
        private final byte[] iv;
        private final byte[] mac;

        public byte[] getCipherText() {
            return this.cipherText;
        }

        public byte[] getIv() {
            return this.iv;
        }

        public byte[] getMac() {
            return this.mac;
        }

        public CipherTextIvMac(byte[] c, byte[] i, byte[] h) {
            this.cipherText = new byte[c.length];
            System.arraycopy(c, 0, this.cipherText, 0, c.length);
            this.iv = new byte[i.length];
            System.arraycopy(i, 0, this.iv, 0, i.length);
            this.mac = new byte[h.length];
            System.arraycopy(h, 0, this.mac, 0, h.length);
        }

        public CipherTextIvMac(String base64IvAndCiphertext) {
            String[] civArray = base64IvAndCiphertext.split(":");
            if (civArray.length != 3) {
                throw new IllegalArgumentException("Cannot parse iv:ciphertext:mac");
            }
            this.iv = Base64.decode((String)civArray[0], (int)2);
            this.mac = Base64.decode((String)civArray[1], (int)2);
            this.cipherText = Base64.decode((String)civArray[2], (int)2);
        }

        public static byte[] ivCipherConcat(byte[] iv, byte[] cipherText) {
            byte[] combined = new byte[iv.length + cipherText.length];
            System.arraycopy(iv, 0, combined, 0, iv.length);
            System.arraycopy(cipherText, 0, combined, iv.length, cipherText.length);
            return combined;
        }

        public String toString() {
            String ivString = Base64.encodeToString((byte[])this.iv, (int)2);
            String cipherTextString = Base64.encodeToString((byte[])this.cipherText, (int)2);
            String macString = Base64.encodeToString((byte[])this.mac, (int)2);
            return String.format(ivString + ":" + macString + ":" + cipherTextString, new Object[0]);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.cipherText);
            result = 31 * result + Arrays.hashCode(this.iv);
            result = 31 * result + Arrays.hashCode(this.mac);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CipherTextIvMac other = (CipherTextIvMac)obj;
            if (!Arrays.equals(this.cipherText, other.cipherText)) {
                return false;
            }
            if (!Arrays.equals(this.iv, other.iv)) {
                return false;
            }
            return Arrays.equals(this.mac, other.mac);
        }
    }

    public static class SecretKeys {
        private SecretKey confidentialityKey;
        private SecretKey integrityKey;

        public SecretKeys(SecretKey confidentialityKeyIn, SecretKey integrityKeyIn) {
            this.setConfidentialityKey(confidentialityKeyIn);
            this.setIntegrityKey(integrityKeyIn);
        }

        public SecretKey getConfidentialityKey() {
            return this.confidentialityKey;
        }

        public void setConfidentialityKey(SecretKey confidentialityKey) {
            this.confidentialityKey = confidentialityKey;
        }

        public SecretKey getIntegrityKey() {
            return this.integrityKey;
        }

        public void setIntegrityKey(SecretKey integrityKey) {
            this.integrityKey = integrityKey;
        }

        public String toString() {
            return Base64.encodeToString((byte[])this.getConfidentialityKey().getEncoded(), (int)2) + ":" + Base64.encodeToString((byte[])this.getIntegrityKey().getEncoded(), (int)2);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.confidentialityKey.hashCode();
            result = 31 * result + this.integrityKey.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SecretKeys other = (SecretKeys)obj;
            if (!this.integrityKey.equals(other.integrityKey)) {
                return false;
            }
            return this.confidentialityKey.equals(other.confidentialityKey);
        }
    }
}

