/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.schibsted.spt.data.jslt.Callable;
import com.schibsted.spt.data.jslt.JsltException;
import com.schibsted.spt.data.jslt.impl.AbstractNode;
import com.schibsted.spt.data.jslt.impl.DotExpression;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.FunctionExpression;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.NodeUtils;

public abstract class AbstractInvocationExpression
extends AbstractNode {
    private Callable callable;
    protected ExpressionNode[] arguments;

    public AbstractInvocationExpression(ExpressionNode[] arguments, Location location) {
        super(location);
        this.arguments = arguments;
    }

    public void resolve(Callable callable) {
        this.callable = callable;
        if (this.arguments.length < callable.getMinArguments() || this.arguments.length > callable.getMaxArguments()) {
            String kind = this instanceof FunctionExpression ? "Function" : "Macro";
            throw new JsltException(kind + " '" + callable.getName() + "' needs " + callable.getMinArguments() + "-" + callable.getMaxArguments() + " arguments, got " + this.arguments.length, this.location);
        }
    }

    @Override
    public void computeMatchContexts(DotExpression parent) {
        for (int ix = 0; ix < this.arguments.length; ++ix) {
            this.arguments[ix].computeMatchContexts(parent);
        }
    }

    @Override
    public ExpressionNode optimize() {
        for (int ix = 0; ix < this.arguments.length; ++ix) {
            this.arguments[ix] = this.arguments[ix].optimize();
        }
        return this;
    }

    @Override
    public void dump(int level) {
        System.out.println(NodeUtils.indent(level) + this.callable.getName() + "(");
        for (int ix = 0; ix < this.arguments.length; ++ix) {
            this.arguments[ix].dump(level + 1);
        }
        System.out.println(NodeUtils.indent(level) + ')');
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.callable.getName());
        buf.append('(');
        for (int ix = 0; ix < this.arguments.length; ++ix) {
            if (ix > 0) {
                buf.append(", ");
            }
            buf.append(this.arguments[ix].toString());
        }
        buf.append(')');
        return buf.toString();
    }
}

