/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.schibsted.spt.data.jslt.Expression;
import com.schibsted.spt.data.jslt.Function;
import com.schibsted.spt.data.jslt.JsltException;
import com.schibsted.spt.data.jslt.impl.AndOperator;
import com.schibsted.spt.data.jslt.impl.ArrayExpression;
import com.schibsted.spt.data.jslt.impl.ArraySlicer;
import com.schibsted.spt.data.jslt.impl.BiggerComparison;
import com.schibsted.spt.data.jslt.impl.BiggerOrEqualComparison;
import com.schibsted.spt.data.jslt.impl.DivideOperator;
import com.schibsted.spt.data.jslt.impl.DotExpression;
import com.schibsted.spt.data.jslt.impl.EqualsComparison;
import com.schibsted.spt.data.jslt.impl.ExpressionImpl;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.ForExpression;
import com.schibsted.spt.data.jslt.impl.FunctionDeclaration;
import com.schibsted.spt.data.jslt.impl.FunctionExpression;
import com.schibsted.spt.data.jslt.impl.IfExpression;
import com.schibsted.spt.data.jslt.impl.JstlFile;
import com.schibsted.spt.data.jslt.impl.LetExpression;
import com.schibsted.spt.data.jslt.impl.LiteralExpression;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.Macro;
import com.schibsted.spt.data.jslt.impl.MacroExpression;
import com.schibsted.spt.data.jslt.impl.MatcherExpression;
import com.schibsted.spt.data.jslt.impl.MinusOperator;
import com.schibsted.spt.data.jslt.impl.MultiplyOperator;
import com.schibsted.spt.data.jslt.impl.ObjectComprehension;
import com.schibsted.spt.data.jslt.impl.ObjectExpression;
import com.schibsted.spt.data.jslt.impl.OrOperator;
import com.schibsted.spt.data.jslt.impl.PairExpression;
import com.schibsted.spt.data.jslt.impl.ParseContext;
import com.schibsted.spt.data.jslt.impl.PlusOperator;
import com.schibsted.spt.data.jslt.impl.SmallerComparison;
import com.schibsted.spt.data.jslt.impl.SmallerOrEqualsComparison;
import com.schibsted.spt.data.jslt.impl.UnequalsComparison;
import com.schibsted.spt.data.jslt.impl.VariableExpression;
import com.schibsted.spt.data.jslt.parser.JsltParser;
import com.schibsted.spt.data.jslt.parser.ParseException;
import com.schibsted.spt.data.jslt.parser.SimpleNode;
import com.schibsted.spt.data.jslt.parser.Token;
import com.schibsted.spt.data.jslt.parser.TokenMgrError;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class ParserImpl {
    public static Expression compileExpression(ParseContext ctx, JsltParser parser) {
        try {
            parser.Start();
            return ParserImpl.compile(ctx, (SimpleNode)parser.jjtree.rootNode());
        }
        catch (ParseException e) {
            throw new JsltException("Parse error: " + e.getMessage(), ParserImpl.makeLocation(ctx, e.currentToken));
        }
        catch (TokenMgrError e) {
            throw new JsltException("Parse error: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ExpressionImpl compileImport(Collection<Function> functions, ParseContext parent, String jslt) {
        try (Reader reader = parent.getResolver().resolve(jslt);){
            ParseContext ctx = new ParseContext(functions, jslt, parent.getResolver());
            ctx.setParent(parent);
            ExpressionImpl expressionImpl = ParserImpl.compileModule(ctx, new JsltParser(reader));
            return expressionImpl;
        }
        catch (IOException e) {
            throw new JsltException("Couldn't read resource " + jslt, e);
        }
    }

    private static ExpressionImpl compileModule(ParseContext ctx, JsltParser parser) {
        try {
            parser.Module();
            return ParserImpl.compile(ctx, (SimpleNode)parser.jjtree.rootNode());
        }
        catch (ParseException e) {
            throw new JsltException("Parse error: " + e.getMessage(), ParserImpl.makeLocation(ctx, e.currentToken));
        }
        catch (TokenMgrError e) {
            throw new JsltException("Parse error: " + e.getMessage());
        }
    }

    private static ExpressionImpl compile(ParseContext ctx, SimpleNode root) {
        ParserImpl.processImports(ctx, root);
        LetExpression[] lets = ParserImpl.buildLets(ctx, root);
        ParserImpl.collectFunctions(ctx, root);
        SimpleNode expr = ParserImpl.getLastChild(root);
        ExpressionNode top = null;
        if (expr.id == 2) {
            top = ParserImpl.node2expr(ctx, expr);
        }
        ctx.resolveFunctions();
        ExpressionImpl impl = new ExpressionImpl(lets, ctx.getDeclaredFunctions(), top);
        impl.optimize();
        return impl;
    }

    private static ExpressionNode node2expr(ParseContext ctx, SimpleNode node) {
        if (node.id != 2) {
            throw new JsltException("INTERNAL ERROR: Wrong type of node: " + node);
        }
        ExpressionNode first = ParserImpl.node2andexpr(ctx, ParserImpl.getChild(node, 0));
        if (node.jjtGetNumChildren() == 1) {
            return first;
        }
        ExpressionNode second = ParserImpl.node2expr(ctx, ParserImpl.getChild(node, 1));
        return new OrOperator(first, second, ParserImpl.makeLocation(ctx, node));
    }

    private static ExpressionNode node2andexpr(ParseContext ctx, SimpleNode node) {
        if (node.id != 3) {
            throw new JsltException("INTERNAL ERROR: Wrong type of node: " + node);
        }
        ExpressionNode first = ParserImpl.node2compexpr(ctx, ParserImpl.getChild(node, 0));
        if (node.jjtGetNumChildren() == 1) {
            return first;
        }
        ExpressionNode second = ParserImpl.node2andexpr(ctx, ParserImpl.getChild(node, 1));
        return new AndOperator(first, second, ParserImpl.makeLocation(ctx, node));
    }

    private static ExpressionNode node2compexpr(ParseContext ctx, SimpleNode node) {
        if (node.id != 4) {
            throw new JsltException("INTERNAL ERROR: Wrong type of node: " + node);
        }
        ExpressionNode first = ParserImpl.node2addexpr(ctx, ParserImpl.getChild(node, 0));
        if (node.jjtGetNumChildren() == 1) {
            return first;
        }
        ExpressionNode second = ParserImpl.node2addexpr(ctx, ParserImpl.getChild(node, 2));
        Location loc = ParserImpl.makeLocation(ctx, node);
        Token comp = ParserImpl.getChild(node, 1).jjtGetFirstToken();
        if (comp.kind == 27) {
            return new EqualsComparison(first, second, loc);
        }
        if (comp.kind == 28) {
            return new UnequalsComparison(first, second, loc);
        }
        if (comp.kind == 29) {
            return new BiggerOrEqualComparison(first, second, loc);
        }
        if (comp.kind == 30) {
            return new BiggerComparison(first, second, loc);
        }
        if (comp.kind == 31) {
            return new SmallerComparison(first, second, loc);
        }
        if (comp.kind == 32) {
            return new SmallerOrEqualsComparison(first, second, loc);
        }
        throw new JsltException("INTERNAL ERROR: What kind of comparison is this? " + node);
    }

    private static ExpressionNode node2addexpr(ParseContext ctx, SimpleNode node) {
        if (node.id != 6) {
            throw new JsltException("INTERNAL ERROR: Wrong type of node: " + node);
        }
        ExpressionNode first = ParserImpl.node2mulexpr(ctx, ParserImpl.getChild(node, 0));
        if (node.jjtGetNumChildren() == 1) {
            return first;
        }
        ExpressionNode second = ParserImpl.node2addexpr(ctx, ParserImpl.getChild(node, 2));
        Location loc = ParserImpl.makeLocation(ctx, node);
        Token comp = ParserImpl.getChild(node, 1).jjtGetFirstToken();
        if (comp.kind == 33) {
            return new PlusOperator(first, second, loc);
        }
        if (comp.kind == 34) {
            return new MinusOperator(first, second, loc);
        }
        throw new JsltException("INTERNAL ERROR: What kind of operator is this?");
    }

    private static ExpressionNode node2mulexpr(ParseContext ctx, SimpleNode node) {
        if (node.id != 8) {
            throw new JsltException("INTERNAL ERROR: Wrong type of node: " + node);
        }
        ExpressionNode first = ParserImpl.node2baseExpr(ctx, ParserImpl.getChild(node, 0));
        if (node.jjtGetNumChildren() == 1) {
            return first;
        }
        ExpressionNode second = ParserImpl.node2mulexpr(ctx, ParserImpl.getChild(node, 2));
        Location loc = ParserImpl.makeLocation(ctx, node);
        Token comp = ParserImpl.getChild(node, 1).jjtGetFirstToken();
        if (comp.kind == 35) {
            return new MultiplyOperator(first, second, loc);
        }
        if (comp.kind == 36) {
            return new DivideOperator(first, second, loc);
        }
        throw new JsltException("INTERNAL ERROR: What kind of operator is this?");
    }

    private static ExpressionNode node2baseExpr(ParseContext ctx, SimpleNode node) {
        if (node.id != 10) {
            throw new JsltException("INTERNAL ERROR: Wrong type of node: " + node);
        }
        Location loc = ParserImpl.makeLocation(ctx, node);
        Token token = node.jjtGetFirstToken();
        if (token.kind == 10 || token.kind == 14 || token.kind == 21) {
            node = (SimpleNode)node.jjtGetChild(0);
        }
        token = node.jjtGetFirstToken();
        int kind = token.kind;
        if (kind == 6) {
            return new LiteralExpression((JsonNode)NullNode.instance, loc);
        }
        if (kind == 7) {
            IntNode number = new IntNode(Integer.parseInt(token.image));
            return new LiteralExpression((JsonNode)number, loc);
        }
        if (kind == 8) {
            DoubleNode number = new DoubleNode(Double.parseDouble(token.image));
            return new LiteralExpression((JsonNode)number, loc);
        }
        if (kind == 9) {
            return new LiteralExpression((JsonNode)new TextNode(ParserImpl.makeString(ctx, token)), loc);
        }
        if (kind == 16) {
            return new LiteralExpression((JsonNode)BooleanNode.TRUE, loc);
        }
        if (kind == 17) {
            return new LiteralExpression((JsonNode)BooleanNode.FALSE, loc);
        }
        if (kind == 20 || kind == 43 || kind == 41 || kind == 42) {
            return ParserImpl.chainable2Expr(ctx, ParserImpl.getChild(node, 0));
        }
        if (kind == 21) {
            LetExpression[] letelse = null;
            ExpressionNode theelse = null;
            SimpleNode maybeelse = ParserImpl.getLastChild(node);
            if (maybeelse.jjtGetFirstToken().kind == 22) {
                SimpleNode elseexpr = ParserImpl.getLastChild(maybeelse);
                theelse = ParserImpl.node2expr(ctx, elseexpr);
                letelse = ParserImpl.buildLets(ctx, maybeelse);
            }
            LetExpression[] thenelse = ParserImpl.buildLets(ctx, node);
            return new IfExpression(ParserImpl.node2expr(ctx, (SimpleNode)node.jjtGetChild(0)), thenelse, ParserImpl.node2expr(ctx, (SimpleNode)node.jjtGetChild(thenelse.length + 1)), letelse, theelse, loc);
        }
        if (kind == 10) {
            Token next = token.next;
            if (next.kind == 37) {
                return ParserImpl.buildForExpression(ctx, node);
            }
            return new ArrayExpression(ParserImpl.children2Exprs(ctx, node), loc);
        }
        if (kind == 14) {
            Token next = token.next;
            if (next.kind == 37) {
                return ParserImpl.buildObjectComprehension(ctx, node);
            }
            return ParserImpl.buildObject(ctx, node);
        }
        if (kind == 23) {
            SimpleNode parens = ParserImpl.descendTo(node, 13);
            return ParserImpl.node2expr(ctx, ParserImpl.getChild(parens, 0));
        }
        node.dump(">");
        throw new JsltException("INTERNAL ERROR: I'm confused now: " + node.jjtGetNumChildren() + " " + kind);
    }

    private static ExpressionNode chainable2Expr(ParseContext ctx, SimpleNode node) {
        ExpressionNode start;
        if (node.id != 11) {
            throw new JsltException("INTERNAL ERROR: Wrong type of node: " + node);
        }
        Token token = node.jjtGetFirstToken();
        int kind = token.kind;
        Location loc = ParserImpl.makeLocation(ctx, node);
        if (kind == 43) {
            start = new VariableExpression(token.image.substring(1), loc);
        } else if (kind == 41) {
            SimpleNode fnode = ParserImpl.descendTo(node, 25);
            Macro mac = ctx.getMacro(token.image);
            if (mac != null) {
                start = new MacroExpression(mac, ParserImpl.children2Exprs(ctx, fnode), loc);
            } else {
                start = new FunctionExpression(token.image, ParserImpl.children2Exprs(ctx, fnode), loc);
                ctx.rememberFunctionCall((FunctionExpression)start);
            }
        } else if (kind == 42) {
            SimpleNode fnode = ParserImpl.descendTo(node, 25);
            String pident = token.image;
            int colon = pident.indexOf(58);
            String prefix = pident.substring(0, colon);
            String name = pident.substring(colon + 1);
            Function f = ctx.getImportedFunction(prefix, name, loc);
            FunctionExpression fun = new FunctionExpression(pident, ParserImpl.children2Exprs(ctx, fnode), loc);
            fun.resolve(f);
            start = fun;
        } else if (kind == 20) {
            token = token.next;
            if (token.kind != 41 && token.kind != 9 && token.kind != 10) {
                return new DotExpression(loc);
            }
            start = ParserImpl.buildChainLink(ctx, node, null);
        } else {
            throw new JsltException("INTERNAL ERROR: Now I'm *really* confused!");
        }
        if (node.jjtGetNumChildren() > 0 && ParserImpl.getLastChild((SimpleNode)node).id == 12) {
            return ParserImpl.buildDotChain(ctx, ParserImpl.getLastChild(node), start);
        }
        return start;
    }

    private static ExpressionNode buildDotChain(ParseContext ctx, SimpleNode chainLink, ExpressionNode parent) {
        if (chainLink.id != 12) {
            throw new JsltException("INTERNAL ERROR: Wrong type of node: " + chainLink);
        }
        ExpressionNode dot = ParserImpl.buildChainLink(ctx, chainLink, parent);
        if (chainLink.jjtGetNumChildren() == 2) {
            dot = ParserImpl.buildDotChain(ctx, ParserImpl.getChild(chainLink, 1), dot);
        }
        return dot;
    }

    private static ExpressionNode buildChainLink(ParseContext ctx, SimpleNode node, ExpressionNode parent) {
        Token token = node.jjtGetFirstToken();
        if (token.kind == 20) {
            token = token.next;
            Location loc = ParserImpl.makeLocation(ctx, node);
            if (token.kind == 10) {
                return new DotExpression(loc);
            }
            String key = ParserImpl.identOrString(ctx, token);
            return new DotExpression(key, parent, loc);
        }
        return ParserImpl.buildArraySlicer(ctx, ParserImpl.getChild(node, 0), parent);
    }

    private static ExpressionNode buildArraySlicer(ParseContext ctx, SimpleNode node, ExpressionNode parent) {
        boolean colon = false;
        ExpressionNode left = null;
        SimpleNode first = ParserImpl.getChild(node, 0);
        if (first.id != 16) {
            left = ParserImpl.node2expr(ctx, first);
        }
        ExpressionNode right = null;
        SimpleNode last = ParserImpl.getLastChild(node);
        if (node.jjtGetNumChildren() != 1 && last.id != 16) {
            right = ParserImpl.node2expr(ctx, last);
        }
        for (int ix = 0; ix < node.jjtGetNumChildren(); ++ix) {
            colon = colon || ParserImpl.getChild((SimpleNode)node, (int)ix).id == 16;
        }
        Location loc = ParserImpl.makeLocation(ctx, node);
        return new ArraySlicer(left, colon, right, parent, loc);
    }

    private static ForExpression buildForExpression(ParseContext ctx, SimpleNode node) {
        ExpressionNode valueExpr = ParserImpl.node2expr(ctx, ParserImpl.getChild(node, 0));
        LetExpression[] lets = ParserImpl.buildLets(ctx, node);
        ExpressionNode loopExpr = ParserImpl.node2expr(ctx, ParserImpl.getLastChild(node));
        return new ForExpression(valueExpr, lets, loopExpr, ParserImpl.makeLocation(ctx, node));
    }

    private static String identOrString(ParseContext ctx, Token token) {
        if (token.kind == 9) {
            return ParserImpl.makeString(ctx, token);
        }
        return token.image;
    }

    private static String makeString(ParseContext ctx, Token literal) {
        String string = literal.image;
        char[] result = new char[string.length() - 2];
        int pos = 0;
        block11: for (int ix = 1; ix < string.length() - 1; ++ix) {
            char ch = string.charAt(ix);
            if (ch != '\\') {
                result[pos++] = ch;
                continue;
            }
            ch = string.charAt(++ix);
            switch (ch) {
                case '\\': {
                    result[pos++] = ch;
                    continue block11;
                }
                case '\"': {
                    result[pos++] = ch;
                    continue block11;
                }
                case 'n': {
                    result[pos++] = 10;
                    continue block11;
                }
                case 'b': {
                    result[pos++] = 8;
                    continue block11;
                }
                case 'f': {
                    result[pos++] = 12;
                    continue block11;
                }
                case 'r': {
                    result[pos++] = 13;
                    continue block11;
                }
                case 't': {
                    result[pos++] = 9;
                    continue block11;
                }
                case '/': {
                    result[pos++] = 47;
                    continue block11;
                }
                case 'u': {
                    if (ix + 5 >= string.length()) {
                        throw new JsltException("Unfinished Unicode escape sequence", ParserImpl.makeLocation(ctx, literal));
                    }
                    result[pos++] = ParserImpl.interpretUnicodeEscape(string, ix + 1);
                    ix += 4;
                    continue block11;
                }
                default: {
                    throw new JsltException("Unknown escape sequence: \\" + ch, ParserImpl.makeLocation(ctx, literal));
                }
            }
        }
        return new String(result, 0, pos);
    }

    private static char interpretUnicodeEscape(String string, int start) {
        int codepoint = 0;
        for (int ix = 0; ix < 4; ++ix) {
            codepoint = codepoint * 16 + ParserImpl.interpretHexDigit(string.charAt(start + ix));
        }
        return (char)codepoint;
    }

    private static char interpretHexDigit(char digit) {
        if (digit >= '0' && digit <= '9') {
            return (char)(digit - 48);
        }
        if (digit >= 'A' && digit <= 'F') {
            return (char)(digit - 65 + 10);
        }
        if (digit >= 'a' && digit <= 'f') {
            return (char)(digit - 97 + 10);
        }
        throw new JsltException("Bad Unicode escape hex digit: '" + digit + "'");
    }

    private static ExpressionNode[] children2Exprs(ParseContext ctx, SimpleNode node) {
        ExpressionNode[] children = new ExpressionNode[node.jjtGetNumChildren()];
        for (int ix = 0; ix < node.jjtGetNumChildren(); ++ix) {
            children[ix] = ParserImpl.node2expr(ctx, (SimpleNode)node.jjtGetChild(ix));
        }
        return children;
    }

    private static void processImports(ParseContext ctx, SimpleNode parent) {
        for (int ix = 0; ix < parent.jjtGetNumChildren(); ++ix) {
            SimpleNode node = (SimpleNode)parent.jjtGetChild(ix);
            if (node.firstToken.kind != 39) continue;
            Token token = node.jjtGetFirstToken();
            token = token.next;
            String source = ParserImpl.makeString(ctx, token);
            token = token.next;
            token = token.next;
            String prefix = token.image;
            JstlFile module = ParserImpl.doImport(ctx, source, node, prefix);
            ctx.registerModule(prefix, module);
            ctx.addDeclaredFunction(prefix, module);
        }
    }

    private static JstlFile doImport(ParseContext parent, String source, SimpleNode node, String prefix) {
        if (parent.isAlreadyImported(source)) {
            throw new JsltException("Module '" + source + "' is already imported", ParserImpl.makeLocation(parent, node));
        }
        ExpressionImpl expr = ParserImpl.compileImport(parent.getExtensions(), parent, source);
        return new JstlFile(prefix, source, expr);
    }

    private static LetExpression[] buildLets(ParseContext ctx, SimpleNode parent) {
        int letCount = ParserImpl.countChildren(parent, 26);
        int pos = 0;
        LetExpression[] lets = new LetExpression[letCount];
        for (int ix = 0; ix < parent.jjtGetNumChildren(); ++ix) {
            SimpleNode node = (SimpleNode)parent.jjtGetChild(ix);
            if (node.firstToken.kind != 25) continue;
            Location loc = ParserImpl.makeLocation(ctx, node);
            Token ident = node.jjtGetFirstToken().next;
            SimpleNode expr = (SimpleNode)node.jjtGetChild(0);
            lets[pos++] = new LetExpression(ident.image, ParserImpl.node2expr(ctx, expr), loc);
        }
        return lets;
    }

    private static void collectFunctions(ParseContext ctx, SimpleNode parent) {
        HashMap functions = new HashMap();
        for (int ix = 0; ix < parent.jjtGetNumChildren(); ++ix) {
            SimpleNode node = (SimpleNode)parent.jjtGetChild(ix);
            if (node.firstToken.kind != 38) continue;
            String name = node.jjtGetFirstToken().next.image;
            String[] params = ParserImpl.collectParams(node);
            LetExpression[] lets = ParserImpl.buildLets(ctx, node);
            SimpleNode expr = ParserImpl.getLastChild(node);
            ctx.addDeclaredFunction(name, new FunctionDeclaration(name, params, lets, ParserImpl.node2expr(ctx, expr)));
        }
    }

    private static String[] collectParams(SimpleNode node) {
        Token token = node.jjtGetFirstToken();
        token = token.next;
        token = token.next;
        ArrayList<String> params = new ArrayList<String>();
        while (token.kind != 24) {
            if (token.kind == 41) {
                params.add(token.image);
            }
            token = token.next;
        }
        return params.toArray(new String[0]);
    }

    private static ObjectExpression buildObject(ParseContext ctx, SimpleNode node) {
        LetExpression[] lets = ParserImpl.buildLets(ctx, node);
        SimpleNode last = ParserImpl.getLastChild(node);
        MatcherExpression matcher = ParserImpl.collectMatcher(ctx, last);
        List<PairExpression> pairs = ParserImpl.collectPairs(ctx, last);
        PairExpression[] children = new PairExpression[pairs.size()];
        children = pairs.toArray(children);
        return new ObjectExpression(lets, children, matcher, ParserImpl.makeLocation(ctx, node));
    }

    private static MatcherExpression collectMatcher(ParseContext ctx, SimpleNode node) {
        if (node == null) {
            return null;
        }
        SimpleNode last = ParserImpl.getLastChild(node);
        if (node.id == 21) {
            if (node.jjtGetNumChildren() == 1) {
                return null;
            }
            return ParserImpl.collectMatcher(ctx, last);
        }
        if (node.id == 19) {
            ArrayList<String> minuses = new ArrayList<String>();
            if (node.jjtGetNumChildren() == 2) {
                ParserImpl.collectMinuses(ctx, ParserImpl.getChild(node, 0), minuses);
            }
            return new MatcherExpression(ParserImpl.node2expr(ctx, last), minuses, ParserImpl.makeLocation(ctx, last));
        }
        if (node.id == 26) {
            return null;
        }
        throw new JsltException("INTERNAL ERROR: This is wrong: " + node);
    }

    private static void collectMinuses(ParseContext ctx, SimpleNode node, List<String> minuses) {
        Token token = node.jjtGetFirstToken();
        token = token.next;
        while (true) {
            minuses.add(ParserImpl.identOrString(ctx, token));
            token = token.next;
            if (token.kind == 13) break;
            token = token.next;
        }
    }

    private static List<PairExpression> collectPairs(ParseContext ctx, SimpleNode pair) {
        return ParserImpl.collectPairs(ctx, pair, new ArrayList<PairExpression>());
    }

    private static List<PairExpression> collectPairs(ParseContext ctx, SimpleNode pair, List<PairExpression> pairs) {
        if (pair != null && pair.id == 21) {
            String key = ParserImpl.makeString(ctx, pair.jjtGetFirstToken());
            ExpressionNode val = ParserImpl.node2expr(ctx, (SimpleNode)pair.jjtGetChild(0));
            pairs.add(new PairExpression(key, val, ParserImpl.makeLocation(ctx, pair)));
            if (pair.jjtGetNumChildren() > 1) {
                ParserImpl.collectPairs(ctx, ParserImpl.getLastChild(pair), pairs);
            }
            return pairs;
        }
        return pairs;
    }

    private static ObjectComprehension buildObjectComprehension(ParseContext ctx, SimpleNode node) {
        ExpressionNode loopExpr = ParserImpl.node2expr(ctx, ParserImpl.getChild(node, 0));
        int ix = node.jjtGetNumChildren() - 2;
        ExpressionNode keyExpr = ParserImpl.node2expr(ctx, ParserImpl.getChild(node, ix));
        ExpressionNode valueExpr = ParserImpl.node2expr(ctx, ParserImpl.getLastChild(node));
        return new ObjectComprehension(loopExpr, keyExpr, valueExpr, ParserImpl.makeLocation(ctx, node));
    }

    private static SimpleNode getChild(SimpleNode node, int ix) {
        return (SimpleNode)node.jjtGetChild(ix);
    }

    private static SimpleNode getLastChild(SimpleNode node) {
        if (node.jjtGetNumChildren() == 0) {
            return null;
        }
        return (SimpleNode)node.jjtGetChild(node.jjtGetNumChildren() - 1);
    }

    private static SimpleNode descendTo(SimpleNode node, int type) {
        if (node.id == type) {
            return node;
        }
        return ParserImpl.descendTo((SimpleNode)node.jjtGetChild(0), type);
    }

    private static int countChildren(SimpleNode node, int type) {
        int count = 0;
        for (int ix = 0; ix < node.jjtGetNumChildren(); ++ix) {
            if (ParserImpl.getChild((SimpleNode)node, (int)ix).id != type) continue;
            ++count;
        }
        return count;
    }

    private static Location makeLocation(ParseContext ctx, SimpleNode node) {
        Token token = node.jjtGetFirstToken();
        return new Location(ctx.getSource(), token.beginLine, token.beginColumn);
    }

    private static Location makeLocation(ParseContext ctx, Token token) {
        return new Location(ctx.getSource(), token.beginLine, token.beginColumn);
    }
}

