/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.schibsted.spt.data.jslt.Callable;
import com.schibsted.spt.data.jslt.Function;
import com.schibsted.spt.data.jslt.JsltException;
import com.schibsted.spt.data.jslt.Module;
import com.schibsted.spt.data.jslt.impl.ExpressionImpl;
import com.schibsted.spt.data.jslt.impl.Scope;

public class JstlFile
implements Module,
Function {
    private String prefix;
    private ExpressionImpl body;
    private String source;

    public JstlFile(String prefix, String source, ExpressionImpl body) {
        this.prefix = prefix;
        this.source = source;
        this.body = body;
    }

    @Override
    public Callable getCallable(String name) {
        return this.body.getFunction(name);
    }

    @Override
    public String getName() {
        return this.prefix;
    }

    @Override
    public int getMinArguments() {
        return 1;
    }

    @Override
    public int getMaxArguments() {
        return 1;
    }

    @Override
    public JsonNode call(JsonNode input, JsonNode[] arguments) {
        if (!this.body.hasBody()) {
            throw new JsltException("Module '" + this.prefix + "' has no body, so cannot " + "be called as a function");
        }
        return this.body.apply(arguments[0]);
    }

    public void evaluateLetsOnly(Scope scope, JsonNode input) {
        this.body.evaluateLetsOnly(scope, input);
    }
}

