/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.schibsted.spt.data.jslt.impl.AbstractNode;
import com.schibsted.spt.data.jslt.impl.DotExpression;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.LetExpression;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.NodeUtils;
import com.schibsted.spt.data.jslt.impl.Scope;

public class IfExpression
extends AbstractNode {
    private ExpressionNode test;
    private LetExpression[] thenlets;
    private ExpressionNode then;
    private LetExpression[] elselets;
    private ExpressionNode orelse;

    public IfExpression(ExpressionNode test, LetExpression[] thenlets, ExpressionNode then, LetExpression[] elselets, ExpressionNode orelse, Location location) {
        super(location);
        this.test = test;
        this.thenlets = thenlets;
        this.then = then;
        this.elselets = elselets;
        this.orelse = orelse;
    }

    @Override
    public JsonNode apply(Scope scope, JsonNode input) {
        if (NodeUtils.isTrue(this.test.apply(scope, input))) {
            return this.then.apply(NodeUtils.evalLets(scope, input, this.thenlets), input);
        }
        if (this.orelse != null) {
            return this.orelse.apply(NodeUtils.evalLets(scope, input, this.elselets), input);
        }
        return NullNode.instance;
    }

    @Override
    public void computeMatchContexts(DotExpression parent) {
        int ix;
        for (ix = 0; ix < this.thenlets.length; ++ix) {
            this.thenlets[ix].computeMatchContexts(parent);
        }
        this.then.computeMatchContexts(parent);
        if (this.orelse != null) {
            this.orelse.computeMatchContexts(parent);
            for (ix = 0; ix < this.elselets.length; ++ix) {
                this.elselets[ix].computeMatchContexts(parent);
            }
        }
    }

    @Override
    public ExpressionNode optimize() {
        int ix;
        for (ix = 0; ix < this.thenlets.length; ++ix) {
            this.thenlets[ix].optimize();
        }
        if (this.elselets != null) {
            for (ix = 0; ix < this.elselets.length; ++ix) {
                this.elselets[ix].optimize();
            }
        }
        this.test = this.test.optimize();
        this.then = this.then.optimize();
        if (this.orelse != null) {
            this.orelse = this.orelse.optimize();
        }
        return this;
    }

    @Override
    public void dump(int level) {
        int ix;
        System.out.println(NodeUtils.indent(level) + "if (");
        this.test.dump(level + 1);
        System.out.println(NodeUtils.indent(level) + ")");
        for (ix = 0; ix < this.thenlets.length; ++ix) {
            this.thenlets[ix].dump(level + 1);
        }
        this.then.dump(level + 1);
        if (this.orelse != null) {
            System.out.println(NodeUtils.indent(level) + "else");
            for (ix = 0; ix < this.elselets.length; ++ix) {
                this.elselets[ix].dump(level + 1);
            }
            this.orelse.dump(level + 1);
        }
    }
}

