/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.schibsted.spt.data.jslt.JsltException;
import com.schibsted.spt.data.jslt.impl.AbstractNode;
import com.schibsted.spt.data.jslt.impl.DotExpression;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.LetExpression;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.NodeUtils;
import com.schibsted.spt.data.jslt.impl.Scope;

public class ForExpression
extends AbstractNode {
    private ExpressionNode valueExpr;
    private LetExpression[] lets;
    private ExpressionNode loopExpr;

    public ForExpression(ExpressionNode valueExpr, LetExpression[] lets, ExpressionNode loopExpr, Location location) {
        super(location);
        this.valueExpr = valueExpr;
        this.lets = lets;
        this.loopExpr = loopExpr;
    }

    @Override
    public JsonNode apply(Scope scope, JsonNode input) {
        JsonNode array = this.valueExpr.apply(scope, input);
        if (array.isNull()) {
            return NullNode.instance;
        }
        if (array.isObject()) {
            array = NodeUtils.convertObjectToArray(array);
        } else if (!array.isArray()) {
            throw new JsltException("For loop can't iterate over " + array, this.location);
        }
        Scope newscope = scope;
        ArrayNode result = NodeUtils.mapper.createArrayNode();
        for (int ix = 0; ix < array.size(); ++ix) {
            JsonNode value = array.get(ix);
            if (this.lets.length > 0) {
                newscope = NodeUtils.evalLets(scope, value, this.lets);
            }
            result.add(this.loopExpr.apply(newscope, value));
        }
        return result;
    }

    @Override
    public void computeMatchContexts(DotExpression parent) {
        this.loopExpr.computeMatchContexts(new DotExpression(this.location));
    }

    @Override
    public ExpressionNode optimize() {
        for (int ix = 0; ix < this.lets.length; ++ix) {
            this.lets[ix].optimize();
        }
        this.valueExpr = this.valueExpr.optimize();
        this.loopExpr = this.loopExpr.optimize();
        return this;
    }

    @Override
    public void dump(int level) {
        System.out.println(NodeUtils.indent(level) + "for (");
        this.valueExpr.dump(level + 1);
        System.out.println(NodeUtils.indent(level) + ")");
        this.loopExpr.dump(level + 1);
    }

    public String toString() {
        return "[for (" + this.valueExpr + ") " + this.loopExpr + "]";
    }
}

