/*
 * Decompiled with CFR 0.152.
 */
package com.scglab.common.widget;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;

public class SoftKeyboardDectectorView
extends View {
    private boolean mShownKeyboard;
    private OnShownKeyboardListener mOnShownSoftKeyboard;
    private OnHiddenKeyboardListener onHiddenSoftKeyboard;

    public SoftKeyboardDectectorView(Context context) {
        this(context, null);
    }

    public SoftKeyboardDectectorView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        Activity activity = (Activity)this.getContext();
        Rect rect = new Rect();
        activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
        int statusBarHeight = rect.top;
        int screenHeight = activity.getWindowManager().getDefaultDisplay().getHeight();
        int diffHeight = screenHeight - statusBarHeight - h;
        if (diffHeight > 100 && !this.mShownKeyboard) {
            this.mShownKeyboard = true;
            this.onShownSoftKeyboard();
        } else if (diffHeight < 100 && this.mShownKeyboard) {
            this.mShownKeyboard = false;
            this.onHiddenSoftKeyboard();
        }
        super.onSizeChanged(w, h, oldw, oldh);
    }

    public void onHiddenSoftKeyboard() {
        if (this.onHiddenSoftKeyboard != null) {
            this.onHiddenSoftKeyboard.onHiddenSoftKeyboard();
        }
    }

    public void onShownSoftKeyboard() {
        if (this.mOnShownSoftKeyboard != null) {
            this.mOnShownSoftKeyboard.onShowSoftKeyboard();
        }
    }

    public void setOnShownKeyboard(OnShownKeyboardListener listener) {
        this.mOnShownSoftKeyboard = listener;
    }

    public void setOnHiddenKeyboard(OnHiddenKeyboardListener listener) {
        this.onHiddenSoftKeyboard = listener;
    }

    public static interface OnHiddenKeyboardListener {
        public void onHiddenSoftKeyboard();
    }

    public static interface OnShownKeyboardListener {
        public void onShowSoftKeyboard();
    }
}

