/*
 * Decompiled with CFR 0.152.
 */
package com.scglab.common.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.scglab.common.widget.NetworkImageView;
import com.scglab.common.widget.R;

public class RoundImageView
extends NetworkImageView {
    private float cornerSize;
    private float maxSize;
    private float minSize;

    public RoundImageView(Context context) {
        super(context);
    }

    public RoundImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public RoundImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected float getCornerSize() {
        return this.cornerSize;
    }

    @Override
    protected int[] getStyleable() {
        return R.styleable.RoundImageView;
    }

    @Override
    protected Point getResultSize() {
        if (null == this.drawImage && this.emptyImage != null) {
            return new Point(this.emptyImage.getWidth(), this.emptyImage.getHeight());
        }
        Point point = super.getResultSize();
        float rate = 1.0f;
        if ((float)point.x > this.maxSize || (float)point.y > this.maxSize) {
            rate = point.x > point.y ? (float)point.x / this.maxSize : (float)point.y / this.maxSize;
        }
        if (this.minSize != -1.0f && ((float)point.x < this.minSize || (float)point.y < this.minSize)) {
            rate = point.x > point.y ? (float)point.x / this.maxSize : (float)point.y / this.maxSize;
        }
        return new Point((int)((float)point.x / rate), (int)((float)point.y / rate));
    }

    @Override
    protected void initStyle(TypedArray typedArray) {
        super.initStyle(typedArray);
        float density = this.getResources().getDisplayMetrics().density;
        this.cornerSize = typedArray.getFloat(R.styleable.RoundImageView_cornerSize, 10.0f);
        this.cornerSize = (int)(density * this.cornerSize);
        this.maxSize = typedArray.getFloat(R.styleable.RoundImageView_maxSize, 200.0f);
        this.maxSize = (int)(density * this.maxSize);
        this.minSize = typedArray.getFloat(R.styleable.RoundImageView_minSize, -1.0f);
        this.minSize = (int)(density * this.minSize);
        Point point = this.getResultSize();
        this.emptyImage = Bitmap.createScaledBitmap((Bitmap)this.emptyImage, (int)point.x, (int)point.y, (boolean)true);
        this.emptyImage = this.roundBitmap(this.emptyImage);
    }

    @Override
    protected void retouchDrawImage(Point point) {
        super.retouchDrawImage(point);
        this.drawImage = this.roundBitmap(this.drawImage);
    }

    protected Bitmap roundBitmap(Bitmap bitmap) {
        Path clipPath = new Path();
        RectF rect = new RectF(0.0f, 0.0f, (float)bitmap.getWidth(), (float)bitmap.getHeight());
        clipPath.addRoundRect(rect, this.cornerSize, this.cornerSize, Path.Direction.CW);
        Bitmap image = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(image);
        canvas.save();
        canvas.clipPath(clipPath);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        canvas.restore();
        return image;
    }
}

