/*
 * Decompiled with CFR 0.152.
 */
package com.scglab.common.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;

public class PhotoView
extends View {
    private Paint paint;
    private int pointColor;
    private int halfBlackColor;
    private Rect bitmapSrc;
    private Rect bitmapDst;
    private Bitmap bitmap;
    private boolean isCropMode;
    private boolean isRateMode;
    private Rect cropRect;
    private Rect cropMode;
    private PointF cropLeft;
    private PointF cropRight;
    private PointF cropTop;
    private PointF cropBottom;
    private PointF cropRightBottom;
    private double zoomStart = 1.0;
    private PointF firstZoomPoint;
    private PointF currentZoomPoint;
    private PointF cropTouchPoint;
    private PointF firstMovePoint;
    private Point currentMovePoint;
    private Point displaySize;
    private float zoomLevel = 1.0f;
    private float zoomStartDistance = Float.MIN_VALUE;
    private PointF[] zoomTouchPoints = new PointF[2];

    public PhotoView(Context context) {
        super(context);
    }

    public PhotoView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PhotoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.init();
        this.invalidate();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
    }

    protected void onDraw(Canvas canvas) {
        if (null == this.displaySize) {
            this.displaySize = new Point(canvas.getWidth(), canvas.getHeight());
        }
        if (null == this.bitmap) {
            return;
        }
        if (null == this.bitmapSrc || null == this.bitmapDst) {
            this.bitmapSrc = new Rect(0, 0, this.bitmap.getWidth(), this.bitmap.getHeight());
            float scale = (float)canvas.getWidth() / (float)this.bitmapSrc.width();
            int top = (canvas.getHeight() - (int)((float)this.bitmap.getHeight() * scale)) / 2;
            int height = top + (int)((float)this.bitmap.getHeight() * scale);
            if (height > canvas.getHeight()) {
                scale = (float)canvas.getHeight() / (float)this.bitmapSrc.height();
                int left = (canvas.getWidth() - (int)((float)this.bitmap.getWidth() * scale)) / 2;
                this.bitmapDst = new Rect(left, 0, left + (int)((float)this.bitmap.getWidth() * scale), canvas.getHeight());
            } else {
                this.bitmapDst = new Rect(0, top, canvas.getWidth(), top + (int)((float)this.bitmap.getHeight() * scale));
            }
        }
        canvas.drawBitmap(this.bitmap, this.bitmapSrc, this.bitmapDst, this.paint);
        if (this.isCropMode) {
            if (null == this.cropRect) {
                int height;
                int width = this.bitmapDst.width();
                int size = (int)((float)(width < (height = this.bitmapDst.height()) ? width : height) / 1.25f);
                this.cropRect = new Rect(this.bitmapDst.left + width / 2 - size / 2, this.bitmapDst.top + height / 2 - size / 2, this.bitmapDst.left + width / 2 + size / 2, this.bitmapDst.top + height / 2 + size / 2);
                this.cropLeft = new PointF((float)this.cropRect.left, (float)((this.cropRect.top + this.cropRect.bottom) / 2));
                this.cropRight = new PointF((float)this.cropRect.right, (float)((this.cropRect.top + this.cropRect.bottom) / 2));
                this.cropTop = new PointF((float)((this.cropRect.left + this.cropRect.right) / 2), (float)this.cropRect.top);
                this.cropBottom = new PointF((float)((this.cropRect.left + this.cropRect.right) / 2), (float)this.cropRect.bottom);
                this.cropRightBottom = new PointF(this.cropRight.x, this.cropBottom.y);
            }
            this.paint.setColor(this.halfBlackColor);
            canvas.drawRect(0.0f, 0.0f, (float)canvas.getWidth(), (float)this.cropRect.top, this.paint);
            canvas.drawRect(0.0f, (float)this.cropRect.top, (float)this.cropRect.left, (float)this.cropRect.bottom, this.paint);
            canvas.drawRect((float)this.cropRect.right, (float)this.cropRect.top, (float)canvas.getWidth(), (float)this.cropRect.bottom, this.paint);
            canvas.drawRect(0.0f, (float)this.cropRect.bottom, (float)canvas.getWidth(), (float)canvas.getHeight(), this.paint);
            this.paint.setStrokeWidth(10.0f);
            this.paint.setColor(this.pointColor);
            canvas.drawLine((float)this.cropRect.left, (float)this.cropRect.top, (float)this.cropRect.right, (float)this.cropRect.top, this.paint);
            canvas.drawLine((float)this.cropRect.left, (float)this.cropRect.bottom, (float)this.cropRect.right, (float)this.cropRect.bottom, this.paint);
            canvas.drawLine((float)this.cropRect.left, (float)this.cropRect.top, (float)this.cropRect.left, (float)this.cropRect.bottom, this.paint);
            canvas.drawLine((float)this.cropRect.right, (float)this.cropRect.top, (float)this.cropRect.right, (float)this.cropRect.bottom, this.paint);
            this.paint.setAlpha(127);
            this.paint.setStrokeWidth(5.0f);
            canvas.drawLine((float)(this.cropRect.left + this.cropRect.width() / 3), (float)this.cropRect.top, (float)(this.cropRect.left + this.cropRect.width() / 3), (float)this.cropRect.bottom, this.paint);
            canvas.drawLine((float)(this.cropRect.right - this.cropRect.width() / 3), (float)this.cropRect.top, (float)(this.cropRect.right - this.cropRect.width() / 3), (float)this.cropRect.bottom, this.paint);
            canvas.drawLine((float)this.cropRect.left, (float)(this.cropRect.top + this.cropRect.height() / 3), (float)this.cropRect.right, (float)(this.cropRect.top + this.cropRect.height() / 3), this.paint);
            canvas.drawLine((float)this.cropRect.left, (float)(this.cropRect.bottom - this.cropRect.height() / 3), (float)this.cropRect.right, (float)(this.cropRect.bottom - this.cropRect.height() / 3), this.paint);
            this.paint.setAlpha(255);
            if (this.isRateMode) {
                canvas.drawCircle(this.cropRightBottom.x, this.cropRightBottom.y, 30.0f, this.paint);
            } else {
                canvas.drawCircle(this.cropLeft.x, this.cropLeft.y, 30.0f, this.paint);
                canvas.drawCircle(this.cropRight.x, this.cropRight.y, 30.0f, this.paint);
                canvas.drawCircle(this.cropTop.x, this.cropTop.y, 30.0f, this.paint);
                canvas.drawCircle(this.cropBottom.x, this.cropBottom.y, 30.0f, this.paint);
            }
            if (null != this.cropMode) {
                this.paint.setAlpha(200);
                if (this.isRateMode) {
                    if (this.cropMode.right == 1 && this.cropMode.bottom == 1 && this.cropMode.left == 0 && this.cropMode.top == 0) {
                        canvas.drawCircle(this.cropRightBottom.x, this.cropRightBottom.y, 60.0f, this.paint);
                    }
                } else if (this.cropMode.left == 1) {
                    canvas.drawCircle(this.cropLeft.x, this.cropLeft.y, 60.0f, this.paint);
                } else if (this.cropMode.top == 1) {
                    canvas.drawCircle(this.cropTop.x, this.cropTop.y, 60.0f, this.paint);
                } else if (this.cropMode.right == 1) {
                    canvas.drawCircle(this.cropRight.x, this.cropRight.y, 60.0f, this.paint);
                } else if (this.cropMode.bottom == 1) {
                    canvas.drawCircle(this.cropBottom.x, this.cropBottom.y, 60.0f, this.paint);
                }
                this.paint.setAlpha(255);
            }
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.bitmapSrc == null) {
            return false;
        }
        if (this.isCropMode) {
            this.cropEventProcess(event);
        } else {
            this.zoomEventProcess(event);
        }
        return true;
    }

    private void cropEventProcess(MotionEvent event) {
        PointF point = new PointF(event.getX(0), event.getY(0));
        switch (event.getAction()) {
            case 0: {
                this.cropTouchPoint = new PointF(point.x, point.y);
                this.cropStart(point);
                this.invalidate();
                break;
            }
            case 2: {
                this.cropChanged(point);
                this.cropTouchPoint.x = point.x;
                this.cropTouchPoint.y = point.y;
                this.invalidate();
                break;
            }
            case 1: {
                this.cropMode = null;
                this.invalidate();
            }
        }
    }

    private void zoomEventProcess(MotionEvent event) {
        switch (event.getAction()) {
            case 2: {
                if (this.zoomLevel == 1.0f) {
                    this.setPivotX(0.0f);
                    this.setPivotY(0.0f);
                }
                if (this.zoomTouchPoints[0] == null) {
                    this.zoomTouchPoints[0] = new PointF(event.getX(0), event.getY(0));
                }
                if (this.zoomTouchPoints[1] == null && event.getPointerCount() == 2) {
                    this.zoomTouchPoints[1] = new PointF(event.getX(1), event.getY(1));
                    return;
                }
                float pivotX = this.getPivotX();
                float pivotY = this.getPivotY();
                if (this.zoomTouchPoints[1] == null && this.zoomLevel != 1.0f) {
                    pivotX = pivotX + this.zoomTouchPoints[0].x - event.getX(0);
                    pivotY = pivotY + this.zoomTouchPoints[0].y - event.getY(0);
                } else if (this.zoomTouchPoints[0] != null && this.zoomTouchPoints[1] != null && event.getPointerCount() >= 2) {
                    float distanceX = event.getX(0) - event.getX(1);
                    float distanceY = event.getY(0) - event.getY(1);
                    float distance = (float)Math.sqrt(Math.abs(distanceX * distanceX) + Math.abs(distanceY * distanceY));
                    if (this.zoomStartDistance == Float.MIN_VALUE) {
                        this.zoomStartDistance = distance;
                    }
                    this.zoomLevel += (distance - this.zoomStartDistance) / 400.0f;
                    if (this.zoomLevel > 10.0f) {
                        this.zoomLevel = 10.0f;
                    }
                    if (this.zoomLevel < 1.0f) {
                        this.zoomLevel = 1.0f;
                    }
                    this.setScaleX(this.zoomLevel);
                    this.setScaleY(this.zoomLevel);
                    pivotX += this.zoomTouchPoints[0].x - event.getX(0) + (this.zoomTouchPoints[1].x - event.getX(1));
                    pivotY += this.zoomTouchPoints[0].y - event.getY(0) + (this.zoomTouchPoints[1].y - event.getY(1));
                }
                pivotX = pivotX < 0.0f ? 0.0f : pivotX;
                pivotX = pivotX > (float)this.displaySize.x ? (float)this.displaySize.x : pivotX;
                this.setPivotX(pivotX);
                this.setPivotY(pivotY);
                break;
            }
            case 1: {
                this.zoomStartDistance = Float.MIN_VALUE;
                this.zoomTouchPoints[0] = null;
                this.zoomTouchPoints[1] = null;
            }
        }
    }

    public void clear() {
        this.bitmap = null;
        this.invalidate();
    }

    public void setBitmap(Bitmap bitmap) {
        if (null == bitmap) {
            return;
        }
        this.bitmap = bitmap;
        this.bitmapSrc = null;
        this.bitmapDst = null;
        this.isCropMode = false;
        this.cropRect = null;
        this.invalidate();
    }

    public float getZoomLevel() {
        return this.zoomLevel;
    }

    public void startCropMode(boolean isRate) {
        if (this.isCropMode) {
            return;
        }
        this.isRateMode = isRate;
        this.isCropMode = true;
        this.cropRect = null;
        this.invalidate();
    }

    public void stopCropMode(boolean isSave) {
        if (!this.isCropMode) {
            return;
        }
        Bitmap bitmap = null;
        if (isSave) {
            bitmap = this.getBitmap();
        }
        this.isCropMode = false;
        this.cropRect = null;
        if (null != bitmap) {
            this.setBitmap(bitmap);
        } else {
            this.invalidate();
        }
    }

    public void rotate(int value) {
        this.stopCropMode(false);
        Matrix matrix = new Matrix();
        matrix.postRotate((float)value);
        this.bitmap = Bitmap.createBitmap((Bitmap)this.bitmap, (int)0, (int)0, (int)this.bitmap.getWidth(), (int)this.bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        this.bitmapSrc = null;
        this.bitmapDst = null;
        this.invalidate();
    }

    public Bitmap getBitmap() {
        if (this.isCropMode) {
            float widthScale = (float)this.cropRect.width() / (float)this.bitmapDst.width();
            float heightScale = (float)this.cropRect.height() / (float)this.bitmapDst.height();
            float newWidth = (float)this.bitmapSrc.width() * widthScale;
            float newHeight = (float)this.bitmapSrc.height() * heightScale;
            widthScale = (float)(this.cropRect.left - this.bitmapDst.left) / (float)this.bitmapDst.width();
            heightScale = (float)(this.cropRect.top - this.bitmapDst.top) / (float)this.bitmapDst.height();
            float x = (float)this.bitmapSrc.width() * widthScale;
            float y = (float)this.bitmapSrc.height() * heightScale;
            this.bitmap = Bitmap.createBitmap((Bitmap)this.bitmap, (int)((int)x), (int)((int)y), (int)((int)newWidth), (int)((int)newHeight));
        }
        this.bitmapSrc = null;
        this.bitmapDst = null;
        this.invalidate();
        return this.bitmap;
    }

    private void init() {
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setStrokeWidth(5.0f);
        this.paint.setStrokeJoin(Paint.Join.ROUND);
        this.paint.setStrokeCap(Paint.Cap.ROUND);
        Resources resources = this.getResources();
        this.pointColor = resources.getColor(17170443);
        this.halfBlackColor = Color.argb((int)127, (int)0, (int)0, (int)0);
    }

    private void cropStart(PointF point) {
        double leftDistance = this.getDistance(this.cropLeft, point);
        double rightDistance = this.getDistance(this.cropRight, point);
        double topDistance = this.getDistance(this.cropTop, point);
        double bottomDistance = this.getDistance(this.cropBottom, point);
        double rightBottomDistance = this.getDistance(this.cropRightBottom, point);
        double minDistance = Math.min(Math.min(Math.min(Math.min(leftDistance, rightDistance), topDistance), bottomDistance), rightBottomDistance);
        double minDistanceDP = minDistance / (double)this.getContext().getResources().getDisplayMetrics().density;
        if (minDistanceDP < 50.0) {
            if (this.isRateMode) {
                this.cropMode = minDistance == rightBottomDistance ? new Rect(0, 0, 1, 1) : new Rect(0, 0, 0, 0);
            } else if (minDistance == leftDistance) {
                this.cropMode = new Rect(1, 0, 0, 0);
            } else if (minDistance == rightDistance) {
                this.cropMode = new Rect(0, 0, 1, 0);
            } else if (minDistance == topDistance) {
                this.cropMode = new Rect(0, 1, 0, 0);
            } else if (minDistance == bottomDistance) {
                this.cropMode = new Rect(0, 0, 0, 1);
            }
        } else {
            this.cropMode = new Rect(0, 0, 0, 0);
        }
    }

    private void cropChanged(PointF point) {
        if (null == this.cropMode) {
            return;
        }
        Rect tempRect = new Rect(this.cropRect);
        int minSize = 50;
        if (this.cropMode.right == 1 && this.cropMode.bottom == 1 && this.cropMode.left == 0 && this.cropMode.top == 0) {
            boolean isValid;
            float temp = Math.min(this.cropRightBottom.x - point.x, this.cropRightBottom.y - point.y);
            do {
                isValid = true;
                float tempRight = (float)tempRect.right - temp;
                float tempBottom = (float)tempRect.bottom - temp;
                if (tempRight > (float)this.bitmapDst.right) {
                    temp = tempRect.right - this.bitmapDst.right;
                    isValid = false;
                }
                if (tempBottom > (float)this.bitmapDst.bottom) {
                    temp = tempRect.bottom - this.bitmapDst.bottom;
                    isValid = false;
                }
                if (!(tempRight < (float)(tempRect.left + 50))) continue;
                temp -= (float)(tempRect.left + 50) - tempRight;
                isValid = false;
            } while (!isValid);
            tempRect.right = (int)((float)tempRect.right - temp);
            tempRect.bottom = (int)((float)tempRect.bottom - temp);
        } else if (this.cropMode.left == 1) {
            tempRect.left -= (int)(this.cropTouchPoint.x - point.x);
            if (tempRect.left < this.bitmapDst.left) {
                tempRect.left = this.bitmapDst.left;
            }
            if (tempRect.left > tempRect.right - 50) {
                tempRect.left = tempRect.right - 50;
            }
        } else if (this.cropMode.right == 1) {
            tempRect.right -= (int)(this.cropTouchPoint.x - point.x);
            if (tempRect.right > this.bitmapDst.right) {
                tempRect.right = this.bitmapDst.right;
            }
            if (tempRect.right < tempRect.left + 50) {
                tempRect.right = tempRect.left + 50;
            }
        } else if (this.cropMode.top == 1) {
            tempRect.top -= (int)(this.cropTouchPoint.y - point.y);
            if (tempRect.top < this.bitmapDst.top) {
                tempRect.top = this.bitmapDst.top;
            }
            if (tempRect.top > tempRect.bottom - 50) {
                tempRect.top = tempRect.bottom - 50;
            }
        } else if (this.cropMode.bottom == 1) {
            tempRect.bottom -= (int)(this.cropTouchPoint.y - point.y);
            if (tempRect.bottom > this.bitmapDst.bottom) {
                tempRect.bottom = this.bitmapDst.bottom;
            }
            if (tempRect.bottom < tempRect.top + 50) {
                tempRect.bottom = tempRect.top + 50;
            }
        } else {
            tempRect.right -= (int)(this.cropTouchPoint.x - point.x);
            tempRect.top -= (int)(this.cropTouchPoint.y - point.y);
            tempRect.left -= (int)(this.cropTouchPoint.x - point.x);
            tempRect.bottom -= (int)(this.cropTouchPoint.y - point.y);
            if (tempRect.left < this.bitmapDst.left) {
                tempRect.left = this.bitmapDst.left;
                tempRect.right = this.bitmapDst.left + this.cropRect.width();
            }
            if (tempRect.right > this.bitmapDst.right) {
                tempRect.right = this.bitmapDst.right;
                tempRect.left = this.bitmapDst.right - this.cropRect.width();
            }
            if (tempRect.top < this.bitmapDst.top) {
                tempRect.top = this.bitmapDst.top;
                tempRect.bottom = this.bitmapDst.top + this.cropRect.height();
            }
            if (tempRect.bottom > this.bitmapDst.bottom) {
                tempRect.bottom = this.bitmapDst.bottom;
                tempRect.top = this.bitmapDst.bottom - this.cropRect.height();
            }
        }
        this.cropRect.left = tempRect.left;
        this.cropRect.right = tempRect.right;
        this.cropRect.top = tempRect.top;
        this.cropRect.bottom = tempRect.bottom;
        this.cropLeft.x = this.cropRect.left;
        this.cropLeft.y = (this.cropRect.top + this.cropRect.bottom) / 2;
        this.cropRight.x = this.cropRect.right;
        this.cropRight.y = (this.cropRect.top + this.cropRect.bottom) / 2;
        this.cropTop.x = (this.cropRect.left + this.cropRect.right) / 2;
        this.cropTop.y = this.cropRect.top;
        this.cropBottom.x = (this.cropRect.left + this.cropRect.right) / 2;
        this.cropBottom.y = this.cropRect.bottom;
        this.cropRightBottom.x = this.cropRight.x;
        this.cropRightBottom.y = this.cropBottom.y;
    }

    private double getDistance(PointF p1, PointF p2) {
        return Math.sqrt(Math.pow(p1.x - p2.x, 2.0) + Math.pow(p1.y - p2.y, 2.0));
    }
}

