/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.core.internal.sdk.extensions;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Looper;
import android.util.Size;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.scandit.datacapture.core.R;
import com.scandit.datacapture.core.internal.sdk.extensions.ContextExtensionsKt;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0013\u001a\u00020\u0014*\u00020\u00022\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a\u0012\u0010\u0017\u001a\u00020\u0018*\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0007\u001a\n\u0010\u001a\u001a\u00020\u0014*\u00020\u001b\u001a\n\u0010\u001c\u001a\u00020\u0014*\u00020\u0002\u001a<\u0010\u001d\u001a\u00020\u0014\"\b\b\u0000\u0010\u001e*\u00020\u0002*\u0002H\u001e2!\u0010\u001f\u001a\u001d\u0012\u0013\u0012\u0011H\u001e\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00140 \u00a2\u0006\u0002\u0010$\u001a\u0014\u0010%\u001a\u00020\u0014*\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0016\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"*\u0010\b\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00078\u00c6\u0002@\u00c6\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\"*\u0010\f\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00078\u00c6\u0002@\u00c6\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000b\"\u0016\u0010\u000e\u001a\u00020\u0007*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\t\"\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006("}, d2={"children", "", "Landroid/view/View;", "Landroid/view/ViewGroup;", "getChildren", "(Landroid/view/ViewGroup;)Ljava/lang/Iterable;", "value", "", "isGone", "(Landroid/view/View;)Z", "setGone", "(Landroid/view/View;Z)V", "isInvisible", "setInvisible", "isVisible", "orientation", "", "getOrientation", "(Landroid/view/View;)I", "addRippleForeground", "", "mask", "Landroid/graphics/drawable/Drawable;", "getCorrectedViewSize", "Landroid/util/Size;", "isPortrait", "removeAllRules", "Landroid/widget/RelativeLayout$LayoutParams;", "removeFromSuperview", "runOnMainThread", "T", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "view", "(Landroid/view/View;Lkotlin/jvm/functions/Function1;)V", "setRippleWrappedDrawable", "Landroid/widget/ImageView;", "content", "scandit-capture-core"})
public final class ViewExtensionsKt {
    /*
     * WARNING - void declaration
     */
    public static final <T extends View> void runOnMainThread(@NotNull T $this$runOnMainThread, @NotNull Function1<? super T, Unit> block) {
        void var1_1;
        T t2;
        Intrinsics.checkNotNullParameter(t2, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            var1_1.invoke(t2);
        } else {
            t2.post(() -> ViewExtensionsKt.a((Function1)var1_1, t2));
        }
    }

    public static final void removeFromSuperview(@NotNull View $this$removeFromSuperview) {
        View view = $this$removeFromSuperview;
        Intrinsics.checkNotNullParameter((Object)view, (String)"<this>");
        Object object = view.getParent();
        object = object instanceof ViewGroup ? (ViewGroup)object : null;
        if (object != null) {
            View view2;
            object.removeView(view2);
        }
    }

    @NotNull
    public static final Size getCorrectedViewSize(@NotNull View $this$getCorrectedViewSize, boolean isPortrait) {
        Size size;
        View view;
        Intrinsics.checkNotNullParameter((Object)view, (String)"<this>");
        if (isPortrait) {
            Size size2;
            size = size2;
            size2 = new Size(Math.min(view.getWidth(), view.getHeight()), Math.max(view.getWidth(), view.getHeight()));
        } else {
            Size size3;
            size = size3;
            size3 = new Size(Math.max(view.getWidth(), view.getHeight()), Math.min(view.getWidth(), view.getHeight()));
        }
        return size;
    }

    public static final int getOrientation(@NotNull View $this$orientation) {
        View view = $this$orientation;
        Intrinsics.checkNotNullParameter((Object)view, (String)"<this>");
        Context context = view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        return ContextExtensionsKt.getOrientation(context);
    }

    public static final boolean isVisible(@NotNull View $this$isVisible) {
        Intrinsics.checkNotNullParameter((Object)$this$isVisible, (String)"<this>");
        boolean $i$f$isVisible = false;
        return $this$isVisible.getVisibility() == 0;
    }

    public static final boolean isInvisible(@NotNull View $this$isInvisible) {
        Intrinsics.checkNotNullParameter((Object)$this$isInvisible, (String)"<this>");
        boolean $i$f$isInvisible = false;
        return $this$isInvisible.getVisibility() == 4;
    }

    public static final void setInvisible(@NotNull View $this$isInvisible, boolean value) {
        Intrinsics.checkNotNullParameter((Object)$this$isInvisible, (String)"<this>");
        boolean $i$f$setInvisible = false;
        $this$isInvisible.setVisibility(value ? 4 : 0);
    }

    public static final boolean isGone(@NotNull View $this$isGone) {
        Intrinsics.checkNotNullParameter((Object)$this$isGone, (String)"<this>");
        boolean $i$f$isGone = false;
        return $this$isGone.getVisibility() == 8;
    }

    public static final void setGone(@NotNull View $this$isGone, boolean value) {
        Intrinsics.checkNotNullParameter((Object)$this$isGone, (String)"<this>");
        boolean $i$f$setGone = false;
        $this$isGone.setVisibility(value ? 8 : 0);
    }

    public static final void removeAllRules(@NotNull RelativeLayout.LayoutParams $this$removeAllRules) {
        RelativeLayout.LayoutParams layoutParams = $this$removeAllRules;
        Intrinsics.checkNotNullParameter((Object)layoutParams, (String)"<this>");
        int n2 = layoutParams.getRules().length;
        for (int i2 = 0; i2 < n2; ++i2) {
            RelativeLayout.LayoutParams layoutParams2;
            layoutParams2.removeRule(i2);
        }
    }

    public static final void addRippleForeground(@NotNull View $this$addRippleForeground, @Nullable Drawable mask) {
        Drawable drawable2;
        View view;
        View view2 = view;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"<this>");
        ColorStateList colorStateList = ColorStateList.valueOf((int)view2.getContext().getColor(R.color.sc_default_ripple));
        Drawable drawable3 = null;
        if (mask == null) {
            drawable2 = view.getBackground();
        }
        RippleDrawable rippleDrawable = new RippleDrawable(colorStateList, drawable3, drawable2);
        view.setForeground((Drawable)rippleDrawable);
    }

    public static /* synthetic */ void addRippleForeground$default(View view, Drawable drawable2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            drawable2 = null;
        }
        ViewExtensionsKt.addRippleForeground(view, drawable2);
    }

    /*
     * WARNING - void declaration
     */
    public static final void setRippleWrappedDrawable(@NotNull ImageView $this$setRippleWrappedDrawable, @Nullable Drawable content) {
        void var1_2;
        ImageView imageView;
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"<this>");
        if (content == null) {
            imageView.setImageDrawable(null);
            return;
        }
        ImageView imageView2 = imageView;
        int n2 = imageView2.getContext().getColor(R.color.sc_default_ripple);
        imageView2.setImageDrawable((Drawable)new RippleDrawable(ColorStateList.valueOf((int)n2), (Drawable)var1_2, null));
    }

    @NotNull
    public static final Iterable<View> getChildren(@NotNull ViewGroup $this$children) {
        ViewGroup viewGroup;
        Intrinsics.checkNotNullParameter((Object)$this$children, (String)"<this>");
        return new Iterable<View>(viewGroup){
            final /* synthetic */ ViewGroup a;
            {
                this.a = viewGroup;
            }

            @NotNull
            public Iterator<View> iterator() {
                Ref.IntRef intRef;
                int n2 = this.a.getChildCount();
                Ref.IntRef intRef2 = intRef;
                intRef = new Ref.IntRef();
                return new Iterator<View>(intRef2, n2, this.a){
                    final /* synthetic */ Ref.IntRef a;
                    final /* synthetic */ int b;
                    final /* synthetic */ ViewGroup c;
                    {
                        this.a = intRef;
                        this.b = n2;
                        this.c = viewGroup;
                    }

                    public boolean hasNext() {
                        return this.a.element < this.b;
                    }

                    @NotNull
                    public View next() throws NoSuchElementException {
                        int n2;
                        View view;
                        View view2;
                        try {
                            View view3 = this.c.getChildAt(this.a.element);
                            view2 = view3;
                            view = view3;
                            Ref.IntRef intRef = this.a;
                            Ref.IntRef intRef2 = intRef;
                            n2 = intRef.element;
                        }
                        catch (Throwable throwable) {
                            throw new NoSuchElementException();
                        }
                        intRef2.element = n2 + 1;
                        Intrinsics.checkNotNull((Object)view2);
                        return view;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }

    private static final void a(Function1 function1, View view) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$block");
        Intrinsics.checkNotNullParameter((Object)view, (String)"$this_runOnMainThread");
        function1.invoke((Object)view);
    }
}

