/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.core.internal.sdk.extensions;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.DrawableRes;
import com.scandit.datacapture.core.internal.sdk.extensions.DrawableExtensionsKt;
import com.scandit.datacapture.core.internal.sdk.utils.AndroidVersionUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0016\u0010\u0007\u001a\u00020\b*\u00020\u00022\b\b\u0001\u0010\t\u001a\u00020\u0001H\u0000\u001a\u0016\u0010\n\u001a\u00020\u000b*\u00020\u00022\b\b\u0001\u0010\t\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\"\u001b\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\f\u0012\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"rotation", "", "Landroid/content/Context;", "getRotation$annotations", "(Landroid/content/Context;)V", "getRotation", "(Landroid/content/Context;)I", "getBitmap", "Landroid/graphics/Bitmap;", "resourceId", "getDrawableCompat", "Landroid/graphics/drawable/Drawable;", "openAssetFd", "Landroid/content/res/AssetFileDescriptor;", "assetName", "", "scandit-capture-core"})
public final class ContextExtensionsKt {
    public static /* synthetic */ void getRotation$annotations(Context context) {
    }

    public static final int getRotation(@NotNull Context $this$rotation) {
        Context context;
        Intrinsics.checkNotNullParameter((Object)$this$rotation, (String)"$this$rotation");
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        Display display = ((WindowManager)object).getDefaultDisplay();
        Intrinsics.checkNotNullExpressionValue((Object)display, (String)"(getSystemService(Contex\u2026owManager).defaultDisplay");
        return display.getRotation();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final AssetFileDescriptor openAssetFd(@NotNull Context $this$openAssetFd, @NotNull String assetName) {
        void var1_1;
        Context context;
        Intrinsics.checkNotNullParameter((Object)$this$openAssetFd, (String)"$this$openAssetFd");
        Intrinsics.checkNotNullParameter((Object)assetName, (String)"assetName");
        AssetFileDescriptor assetFileDescriptor = context.getAssets().openFd((String)var1_1);
        Intrinsics.checkNotNullExpressionValue((Object)assetFileDescriptor, (String)"assets.openFd(assetName)");
        return assetFileDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Drawable getDrawableCompat(@NotNull Context $this$getDrawableCompat, @DrawableRes int resourceId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getDrawableCompat, (String)"$this$getDrawableCompat");
        Drawable drawable = AndroidVersionUtilsKt.isAtLeastAndroidVersion(21) ? $this$getDrawableCompat.getDrawable(resourceId) : string.getResources().getDrawable(resourceId);
        if (drawable == null) {
            void var1_1;
            string = "Cannot retrieve drawable for resource " + (int)var1_1;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return drawable;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Bitmap getBitmap(@NotNull Context $this$getBitmap, @DrawableRes int resourceId) {
        void var1_1;
        Context context;
        Intrinsics.checkNotNullParameter((Object)$this$getBitmap, (String)"$this$getBitmap");
        return DrawableExtensionsKt.toBitmap(ContextExtensionsKt.getDrawableCompat(context, (int)var1_1));
    }
}

