/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.core.internal.sdk.extensions;

import com.scandit.datacapture.core.common.graphic.ImagePlane;
import com.scandit.datacapture.core.internal.sdk.common.geometry.NativeImageBuffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\t\u001a\u00020\u0006*\u00020\u0003\u00a8\u0006\n"}, d2={"getByteArraySize", "", "imageBuffer", "Lcom/scandit/datacapture/core/internal/sdk/common/geometry/NativeImageBuffer;", "targetBitsPerPixel", "getDataFromImage", "", "sourceBitsPerPixel", "byteArraySize", "toByteArray", "scandit-capture-core"})
public final class ImageExtensionsKt {
    @NotNull
    public static final byte[] toByteArray(@NotNull NativeImageBuffer $this$toByteArray) {
        NativeImageBuffer nativeImageBuffer;
        Intrinsics.checkNotNullParameter((Object)$this$toByteArray, (String)"$this$toByteArray");
        int n2 = 12;
        n2 = 8;
        Object object = nativeImageBuffer;
        int n3 = ((NativeImageBuffer)object).getWidth();
        int n4 = ((NativeImageBuffer)object).getHeight();
        byte[] byArray = new byte[ImageExtensionsKt.a((NativeImageBuffer)object, 12)];
        ArrayList<ImagePlane> arrayList = ((NativeImageBuffer)object).getPlanes();
        object = arrayList;
        object = arrayList;
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"planes");
        Collection collection = arrayList;
        int n5 = !collection.isEmpty() ? 1 : 0;
        if (n5 == 0) {
            String string = "Failed to get image planes";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        n5 = 0;
        ImagePlane imagePlane = ((ArrayList)object).get(0);
        Intrinsics.checkNotNullExpressionValue((Object)imagePlane, (String)"planes[0]");
        byte[] byArray2 = new byte[imagePlane.getRowStride()];
        int n6 = ((Collection)object).size();
        for (int i2 = 0; i2 < n6; ++i2) {
            int n7;
            int n8;
            int n9;
            ImagePlane imagePlane2 = ((ArrayList)object).get(i2);
            Intrinsics.checkNotNullExpressionValue((Object)imagePlane2, (String)"planes[i]");
            imagePlane2.getSubsamplingX();
            ImagePlane imagePlane3 = ((ArrayList)object).get(i2);
            Intrinsics.checkNotNullExpressionValue((Object)imagePlane3, (String)"planes[i]");
            if (imagePlane3.getData() == null) {
                String string = "Fail to get bytebuffer from plane";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            ImagePlane imagePlane4 = ((ArrayList)object).get(i2);
            Intrinsics.checkNotNullExpressionValue((Object)imagePlane4, (String)"planes[i]");
            int n10 = imagePlane4.getRowStride();
            int n11 = n9 = n10 >= n3 ? 1 : 0;
            if (_Assertions.ENABLED && n9 == 0) {
                String string = "rowStride should be no less than width";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            ImagePlane imagePlane5 = ((ArrayList)object).get(i2);
            Intrinsics.checkNotNullExpressionValue((Object)imagePlane5, (String)"planes[i]");
            n9 = imagePlane5.getPixelStride();
            int n12 = n8 = n9 > 0 ? 1 : 0;
            if (_Assertions.ENABLED && n8 == 0) {
                String string = "pixel stride " + n9 + " is invalid";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            n8 = i2 == 0 ? n3 : n3 / 2;
            int n13 = i2 == 0 ? n4 : n4 / 2;
            int n14 = n7 = n10 >= n8 ? 1 : 0;
            if (_Assertions.ENABLED && n7 == 0) {
                object = "rowStride " + n10 + " should be >= width " + n8;
                throw (Throwable)((Object)new AssertionError(object));
            }
            for (n7 = 0; n7 < n13; ++n7) {
                ByteBuffer byteBuffer;
                int n15;
                if (n9 == 1) {
                    n15 = n8;
                    byteBuffer.get(byArray, n5, n15);
                    ByteBuffer byteBuffer2 = byteBuffer;
                    byteBuffer2.position(byteBuffer2.position() + n10 - n15);
                    n5 += n15;
                    continue;
                }
                byteBuffer.get(byArray2, 0, n10);
                int n16 = n8;
                for (n15 = 0; n15 < n16; ++n15) {
                    byArray[n5++] = byArray2[n15 * n9];
                }
            }
        }
        return byArray;
    }

    public static final int byteArraySize(@NotNull NativeImageBuffer $this$byteArraySize) {
        NativeImageBuffer nativeImageBuffer;
        Intrinsics.checkNotNullParameter((Object)$this$byteArraySize, (String)"$this$byteArraySize");
        return ImageExtensionsKt.a(nativeImageBuffer, 12);
    }

    private static final int a(NativeImageBuffer nativeImageBuffer, int n2) {
        return nativeImageBuffer.getWidth() * nativeImageBuffer.getHeight() * n2 / 8;
    }
}

