/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.core.imu;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.scandit.datacapture.core.imu.ImuMeasurement;
import com.scandit.datacapture.core.imu.ImuRotationMeasurement;
import com.scandit.datacapture.core.internal.sdk.AppAndroidEnvironment;
import com.scandit.datacapture.core.internal.sdk.capture.NativeInertialMeasurementType;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, bv={}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u000f\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a8\u0006\f"}, d2={"Lcom/scandit/datacapture/core/imu/ImuDataCollector;", "", "", "enable", "", "setEnabled", "Lcom/scandit/datacapture/core/imu/ImuDataCollector$Listener;", "listener", "<init>", "(Lcom/scandit/datacapture/core/imu/ImuDataCollector$Listener;)V", "Listener", "a", "scandit-capture-core"})
public final class ImuDataCollector {
    @NotNull
    private final Listener a;
    private final SensorManager b;
    @NotNull
    private final List<Sensor> c;
    @NotNull
    private final a d;

    /*
     * WARNING - void declaration
     */
    public ImuDataCollector(@NotNull Listener listener) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"listener");
        this.a = var1_1;
        this.b = (SensorManager)AppAndroidEnvironment.INSTANCE.getApplicationContext().getSystemService(SensorManager.class);
        this.c = this.a();
        this.d = new a(this);
    }

    private final List<Sensor> a() {
        List list;
        ImuDataCollector imuDataCollector = imuDataCollector.b;
        if (imuDataCollector != null) {
            ArrayList arrayList;
            list = arrayList;
            arrayList = new ArrayList();
            Iterator iterator = CollectionsKt.mutableListOf((Object[])new Integer[]{1, 4, 9, 11}).iterator();
            while (iterator.hasNext()) {
                Sensor sensor = imuDataCollector.getDefaultSensor(((Number)iterator.next()).intValue());
                if (sensor == null) continue;
                list.add(sensor);
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public static final void access$onSensorEvent(ImuDataCollector $this, SensorEvent event) {
        float[] fArray;
        Object object;
        SensorEvent sensorEvent = event;
        object.getClass();
        long l5 = sensorEvent.timestamp / (long)1000;
        int n5 = sensorEvent.sensor.getType();
        if (n5 != 1) {
            if (n5 != 4) {
                if (n5 != 9) {
                    if (n5 == 11) {
                        float[] fArray2 = new float[4];
                        object = fArray2;
                        fArray = fArray.values;
                        object[0] = fArray[3];
                        object[1] = fArray[0];
                        object[2] = fArray[1];
                        fArray2[3] = fArray.values[2];
                        ((ImuDataCollector)object).a.onRotationMeasurement(new ImuRotationMeasurement(fArray2, l5));
                    }
                } else {
                    object = ((ImuDataCollector)object).a;
                    NativeInertialMeasurementType nativeInertialMeasurementType = NativeInertialMeasurementType.GRAVITY;
                    int n6 = 3;
                    float[] fArray3 = new float[3];
                    for (int i5 = 0; i5 < 3; ++i5) {
                        fArray3[i5] = fArray.values[i5];
                    }
                    float f5 = 9.81f;
                    Intrinsics.checkNotNullParameter((Object)fArray3, (String)"<this>");
                    float[] fArray4 = new float[n6];
                    for (int i6 = 0; i6 < n6; ++i6) {
                        fArray4[i6] = fArray3[i6] / f5;
                    }
                    ImuMeasurement imuMeasurement = new ImuMeasurement(nativeInertialMeasurementType, fArray4, l5);
                    object.onMeasurement(imuMeasurement);
                }
            } else {
                object = ((ImuDataCollector)object).a;
                NativeInertialMeasurementType nativeInertialMeasurementType = NativeInertialMeasurementType.GYROSCOPE;
                float[] fArray5 = new float[3];
                for (int i7 = 0; i7 < 3; ++i7) {
                    fArray5[i7] = fArray.values[i7];
                }
                ImuMeasurement imuMeasurement = new ImuMeasurement(nativeInertialMeasurementType, fArray5, l5);
                object.onMeasurement(imuMeasurement);
            }
        } else {
            object = ((ImuDataCollector)object).a;
            NativeInertialMeasurementType nativeInertialMeasurementType = NativeInertialMeasurementType.ACCELEROMETER;
            int n7 = 3;
            float[] fArray6 = new float[3];
            for (int i8 = 0; i8 < 3; ++i8) {
                fArray6[i8] = fArray.values[i8];
            }
            float f6 = 9.81f;
            Intrinsics.checkNotNullParameter((Object)fArray6, (String)"<this>");
            float[] fArray7 = new float[n7];
            for (int i9 = 0; i9 < n7; ++i9) {
                fArray7[i9] = fArray6[i9] / f6;
            }
            ImuMeasurement imuMeasurement = new ImuMeasurement(nativeInertialMeasurementType, fArray7, l5);
            object.onMeasurement(imuMeasurement);
        }
    }

    public final void setEnabled(boolean enable) {
        if (enable) {
            for (Sensor sensor : this.c) {
                SensorManager sensorManager = this.b;
                if (sensorManager == null) continue;
                sensorManager.registerListener((SensorEventListener)this.d, sensor, 10000, 0);
            }
        } else {
            for (Sensor sensor : this.c) {
                SensorManager sensorManager = this.b;
                if (sensorManager == null) continue;
                sensorManager.unregisterListener((SensorEventListener)this.d, sensor);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/scandit/datacapture/core/imu/ImuDataCollector$Listener;", "", "onMeasurement", "", "measurement", "Lcom/scandit/datacapture/core/imu/ImuMeasurement;", "onRotationMeasurement", "Lcom/scandit/datacapture/core/imu/ImuRotationMeasurement;", "scandit-capture-core"})
    public static interface Listener {
        public void onMeasurement(@NotNull ImuMeasurement var1);

        public void onRotationMeasurement(@NotNull ImuRotationMeasurement var1);
    }

    private static final class a
    implements SensorEventListener {
        @NotNull
        private final WeakReference<ImuDataCollector> a;

        public a(@NotNull ImuDataCollector imuDataCollector) {
            WeakReference<ImuDataCollector> weakReference;
            Intrinsics.checkNotNullParameter((Object)imuDataCollector, (String)"owner");
            WeakReference<ImuDataCollector> weakReference2 = weakReference;
            weakReference = new WeakReference<ImuDataCollector>(imuDataCollector);
            v1.a = weakReference2;
        }

        public final void onSensorChanged(@NotNull SensorEvent sensorEvent) {
            Intrinsics.checkNotNullParameter((Object)sensorEvent, (String)"event");
            ImuDataCollector imuDataCollector = (ImuDataCollector)((a)((Object)imuDataCollector)).a.get();
            if (imuDataCollector != null) {
                ImuDataCollector.access$onSensorEvent(imuDataCollector, sensorEvent);
            }
        }

        public final void onAccuracyChanged(@NotNull Sensor sensor, int n5) {
            Intrinsics.checkNotNullParameter((Object)sensor, (String)"sensor");
        }
    }
}

