/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.core.internal.sdk.utils;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\bH\u0002\u001a\u0012\u0010\t\u001a\u00020\u00032\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u0010\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0002\u00a8\u0006\r"}, d2={"jsonFromObject", "", "obj", "", "jsonObjectFromDouble", "value", "", "jsonObjectFromFloat", "", "jsonObjectFromObject", "objectFromJson", "json", "objectFromJsonObject", "sdc-core-android_release"})
@JvmName(name="JsonUtils")
public final class JsonUtils {
    @Nullable
    public static final Object objectFromJson(@NotNull String json) throws JSONException {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        try {
            Object[] objectArray;
            Object object = JsonUtils.a(new JSONArray("[" + (String)objectArray + ']'));
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<*>");
            }
            objectArray = (Object[])object;
            return objectArray[0];
        }
        catch (Exception exception) {
            throw (Throwable)new JSONException("JSON Parsing failed due to unknown reason");
        }
    }

    private static final Object a(Object objectArray) throws JSONException {
        Object[] objectArray2 = objectArray;
        if (Intrinsics.areEqual((Object)objectArray, (Object)JSONObject.NULL)) {
            return null;
        }
        if (objectArray2 instanceof JSONObject) {
            objectArray2 = new LinkedHashMap();
            Map map = objectArray2;
            Iterator iterator = ((JSONObject)objectArray).keys();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterator, (String)"json.keys()");
            Iterator iterator2 = iterator;
            iterator2 = iterator;
            while (iterator2.hasNext()) {
                String string;
                String string2 = string = (String)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"key");
                Object object = ((JSONObject)objectArray).get(string);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"json.get(key)");
                map.put(string2, JsonUtils.a(object));
            }
            return objectArray2;
        }
        if (objectArray2 instanceof JSONArray) {
            Object[] objectArray3 = objectArray2 = new Object[((JSONArray)objectArray).length()];
            int n2 = ((JSONArray)objectArray).length();
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = ((JSONArray)objectArray).get(i2);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"json.get(i)");
                objectArray3[i2] = JsonUtils.a(object);
            }
            return objectArray2;
        }
        if (objectArray2 instanceof String || objectArray2 instanceof Boolean || objectArray2 instanceof Integer || objectArray2 instanceof Double) {
            return objectArray;
        }
        if (objectArray2 instanceof Float) {
            return (double)((Number)objectArray).floatValue();
        }
        throw (Throwable)new JSONException(objectArray.getClass().getSimpleName() + " is not a json type");
    }

    @NotNull
    public static final String jsonFromObject(@Nullable Object obj) throws JSONException {
        Object object;
        Object object2 = obj;
        if (object2 == null) {
            return JSONObject.NULL.toString();
        }
        if (object2 instanceof Map) {
            Object object3 = JsonUtils.b(obj);
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.json.JSONObject");
            }
            String string = ((JSONObject)object3).toString(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(jsonObjectFromObject(ob\u2026s JSONObject).toString(0)");
            return string;
        }
        if (object2 instanceof Collection) {
            Object object4 = JsonUtils.b(obj);
            if (object4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.json.JSONArray");
            }
            String string = ((JSONArray)object4).toString(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(jsonObjectFromObject(ob\u2026as JSONArray).toString(0)");
            return string;
        }
        if (object2 instanceof Object[]) {
            Object object5 = JsonUtils.b(obj);
            if (object5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.json.JSONArray");
            }
            String string = ((JSONArray)object5).toString(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(jsonObjectFromObject(ob\u2026as JSONArray).toString(0)");
            return string;
        }
        if (object2 instanceof String || object2 instanceof Boolean || object2 instanceof Integer) {
            return obj.toString();
        }
        if (object2 instanceof Double) {
            double d2 = ((Number)obj).doubleValue();
            if (Double.isInfinite(d2) || Double.isNaN(d2 = ((Number)obj).doubleValue())) {
                throw (Throwable)new JSONException("JSON prohibits infinities or NaNs");
            }
            return obj.toString();
        }
        if (object2 instanceof Float) {
            float f2 = ((Number)obj).floatValue();
            if (Float.isInfinite(f2) || Float.isNaN(f2 = ((Number)obj).floatValue())) {
                throw (Throwable)new JSONException("JSON prohibits infinities or NaNs");
            }
            return String.valueOf((double)((Number)obj).floatValue());
        }
        throw (Throwable)new JSONException(object.getClass().getSimpleName() + " cannot be serialized to json");
    }

    private static final Object b(Object object) throws JSONException {
        Object object2;
        Object[] objectArray = object;
        if (object == null) {
            object2 = JSONObject.NULL;
        } else if (objectArray instanceof Map) {
            objectArray = new JSONObject();
            JSONObject jSONObject = objectArray;
            Map map = (Map)object;
            object = map;
            object = map;
            for (Map.Entry entry : map.entrySet()) {
                Map.Entry entry2 = entry;
                entry2 = entry;
                object = entry;
                Object k2 = entry.getKey();
                object = entry2;
                object = object.getValue();
                if (k2 == null) {
                    throw (Throwable)new JSONException("Maps with null keys cannot be serialized to json");
                }
                if (!(k2 instanceof String)) {
                    throw (Throwable)new JSONException("Maps with keys of type " + k2.getClass().getSimpleName() + " cannot be serialized to json");
                }
                jSONObject.put((String)k2, JsonUtils.b(object));
            }
            object2 = objectArray;
        } else if (objectArray instanceof Collection) {
            objectArray = new JSONArray();
            JSONArray jSONArray = objectArray;
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object e2;
                Object e3 = e2 = object.next();
                jSONArray.put(JsonUtils.b(e3));
            }
            object2 = objectArray;
        } else if (objectArray instanceof Object[]) {
            objectArray = new JSONArray();
            JSONArray jSONArray = objectArray;
            Object[] objectArray2 = object;
            object = objectArray2;
            object = objectArray2;
            int n2 = objectArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object3 = object[i2];
                jSONArray.put(JsonUtils.b(object3));
            }
            object2 = objectArray;
        } else if (objectArray instanceof String || objectArray instanceof Boolean || objectArray instanceof Integer) {
            object2 = object;
        } else if (objectArray instanceof Double) {
            object2 = JsonUtils.a(((Number)object).doubleValue());
        } else if (objectArray instanceof Float) {
            object2 = JsonUtils.a(((Number)object).floatValue());
        } else {
            throw (Throwable)new JSONException(object.getClass().getSimpleName() + " cannot be serialized to json");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"when (obj) {\n    null ->\u2026be serialized to json\")\n}");
        return object2;
    }

    private static final Object a(double d2) throws JSONException {
        double d3 = d2;
        if (Double.isInfinite(d3) || Double.isNaN(d3 = d2)) {
            throw (Throwable)new JSONException("JSON prohibits infinities or NaNs");
        }
        return d2;
    }

    private static final Object a(float f2) throws JSONException {
        float f3 = f2;
        if (Float.isInfinite(f3) || Float.isNaN(f3 = f2)) {
            throw (Throwable)new JSONException("JSON prohibits infinities or NaNs");
        }
        return (double)f2;
    }
}

