/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.core.internal.sdk.utils;

import com.scandit.datacapture.core.j0;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, bv={}, k=2, d1={"\u0000\u000e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\u001a\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u00a8\u0006\u0006"}, d2={"", "json", "", "objectFromJson", "obj", "jsonFromObject", "scandit-capture-core"})
@JvmName(name="JsonUtils")
public final class JsonUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final Object objectFromJson(@NotNull String json) throws JSONException {
        Object object;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        try {
            object = JsonUtils.b(new JSONArray('[' + (String)object + ']'));
            if (object == null) throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<*>");
        }
        catch (Exception exception) {
            throw new JSONException("JSON Parsing failed due to unknown reason");
        }
        return ((Object[])object)[0];
    }

    private static final Object b(Object object) throws JSONException {
        block8: {
            block5: {
                block7: {
                    block6: {
                        LinkedHashMap linkedHashMap;
                        block4: {
                            if (!Intrinsics.areEqual((Object)object, (Object)JSONObject.NULL)) break block4;
                            object = null;
                            break block5;
                        }
                        if (!(object instanceof JSONObject)) break block6;
                        Object[] objectArray = object;
                        object = linkedHashMap;
                        linkedHashMap = new LinkedHashMap();
                        JSONObject jSONObject = (JSONObject)objectArray;
                        Iterator iterator = jSONObject.keys();
                        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"json.keys()");
                        while (iterator.hasNext()) {
                            String string = (String)iterator.next();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key");
                            Object object2 = jSONObject.get(string);
                            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"json.get(key)");
                            object.put(string, JsonUtils.b(object2));
                        }
                        break block5;
                    }
                    if (!(object instanceof JSONArray)) break block7;
                    object = (JSONArray)object;
                    Object[] objectArray = new Object[object.length()];
                    int n3 = object.length();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        Object object3 = object.get(i3);
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"json.get(i)");
                        objectArray[i3] = JsonUtils.b(object3);
                    }
                    object = objectArray;
                    break block5;
                }
                if (((object instanceof String ? true : object instanceof Boolean) ? true : object instanceof Integer) ? true : object instanceof Double) break block5;
                if (!(object instanceof Float)) break block8;
                object = (double)((Number)object).floatValue();
            }
            return object;
        }
        throw new JSONException(object.getClass().getSimpleName() + " is not a json type");
    }

    @NotNull
    public static final String jsonFromObject(@Nullable Object obj) throws JSONException {
        Object object;
        block10: {
            block11: {
                block3: {
                    block8: {
                        block9: {
                            block7: {
                                block6: {
                                    block5: {
                                        block4: {
                                            block2: {
                                                if (obj != null) break block2;
                                                object = JSONObject.NULL.toString();
                                                break block3;
                                            }
                                            if (!(object instanceof Map)) break block4;
                                            object = ((JSONObject)JsonUtils.a(object)).toString(0);
                                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jsonObjectFromObject(obj\u2026s JSONObject).toString(0)");
                                            break block3;
                                        }
                                        if (!(object instanceof Collection)) break block5;
                                        object = ((JSONArray)JsonUtils.a(object)).toString(0);
                                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jsonObjectFromObject(obj\u2026as JSONArray).toString(0)");
                                        break block3;
                                    }
                                    if (!(object instanceof Object[])) break block6;
                                    object = ((JSONArray)JsonUtils.a(object)).toString(0);
                                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jsonObjectFromObject(obj\u2026as JSONArray).toString(0)");
                                    break block3;
                                }
                                if (!((object instanceof String ? true : object instanceof Boolean) ? true : object instanceof Integer)) break block7;
                                object = object.toString();
                                break block3;
                            }
                            if (!(object instanceof Double)) break block8;
                            if (Double.isInfinite(((Number)(object = (Number)object)).doubleValue()) || Double.isNaN(((Number)object).doubleValue())) break block9;
                            object = String.valueOf(((Number)object).doubleValue());
                            break block3;
                        }
                        throw new JSONException("JSON prohibits infinities or NaNs");
                    }
                    if (!(object instanceof Float)) break block10;
                    if (Float.isInfinite(((Number)(object = (Number)object)).floatValue()) || Float.isNaN(((Number)object).floatValue())) break block11;
                    object = String.valueOf((double)((Number)object).floatValue());
                }
                return object;
            }
            throw new JSONException("JSON prohibits infinities or NaNs");
        }
        throw new JSONException(object.getClass().getSimpleName() + " cannot be serialized to json");
    }

    /*
     * WARNING - void declaration
     */
    private static final Object a(Object object) throws JSONException {
        block15: {
            block16: {
                block9: {
                    block13: {
                        block14: {
                            block12: {
                                void var2_10;
                                JSONArray jSONArray;
                                block11: {
                                    JSONArray jSONArray2;
                                    block10: {
                                        JSONObject jSONObject;
                                        block8: {
                                            if (object != null) break block8;
                                            object = JSONObject.NULL;
                                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"NULL");
                                            break block9;
                                        }
                                        if (!(object instanceof Map)) break block10;
                                        Object object2 = object;
                                        object = jSONObject;
                                        jSONObject = new JSONObject();
                                        for (Map.Entry i3 : ((Map)object2).entrySet()) {
                                            Object k3 = i3.getKey();
                                            Object v3 = i3.getValue();
                                            if (k3 != null) {
                                                if (k3 instanceof String) {
                                                    String object3 = (String)k3;
                                                    object.put(object3, JsonUtils.a(v3));
                                                    continue;
                                                }
                                                throw new JSONException(j0.a("Maps with keys of type ").append(k3.getClass().getSimpleName()).append(" cannot be serialized to json").toString());
                                            }
                                            throw new JSONException("Maps with null keys cannot be serialized to json");
                                        }
                                        break block9;
                                    }
                                    if (!(object instanceof Collection)) break block11;
                                    Object object3 = object;
                                    object = jSONArray2;
                                    jSONArray2 = new JSONArray();
                                    Iterator iterator = ((Iterable)object3).iterator();
                                    while (iterator.hasNext()) {
                                        object.put(JsonUtils.a(iterator.next()));
                                    }
                                    break block9;
                                }
                                if (!(object instanceof Object[])) break block12;
                                Object object4 = object;
                                object = jSONArray;
                                jSONArray = new JSONArray();
                                Object[] objectArray = (Object[])object4;
                                boolean bl = false;
                                int n3 = objectArray.length;
                                while (var2_10 < n3) {
                                    object.put(JsonUtils.a(objectArray[var2_10]));
                                    ++var2_10;
                                }
                                break block9;
                            }
                            if (((object instanceof String ? true : object instanceof Boolean) ? true : object instanceof Integer) ? true : object instanceof Long) break block9;
                            if (!(object instanceof Double)) break block13;
                            double d3 = ((Number)object).doubleValue();
                            if (Double.isInfinite(d3) || Double.isNaN(d3)) break block14;
                            object = d3;
                            break block9;
                        }
                        throw new JSONException("JSON prohibits infinities or NaNs");
                    }
                    if (!(object instanceof Float)) break block15;
                    float f3 = ((Number)object).floatValue();
                    if (Float.isInfinite(f3) || Float.isNaN(f3)) break block16;
                    object = (double)f3;
                }
                return object;
            }
            throw new JSONException("JSON prohibits infinities or NaNs");
        }
        throw new JSONException(object.getClass().getSimpleName() + " cannot be serialized to json");
    }
}

