/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.barcode.generator;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.scandit.datacapture.barcode.data.Symbology;
import com.scandit.datacapture.barcode.generator.BarcodeGeneratorKt;
import com.scandit.datacapture.barcode.generator.BarcodeGeneratorOptions;
import com.scandit.datacapture.barcode.generator.BarcodeGeneratorProxy;
import com.scandit.datacapture.barcode.generator.BarcodeGeneratorProxyAdapter;
import com.scandit.datacapture.barcode.generator.QrCodeErrorCorrectionLevel;
import com.scandit.datacapture.barcode.internal.module.generator.NativeBarcodeGenerator;
import com.scandit.datacapture.barcode.internal.module.generator.NativeBarcodeGeneratorFactoryResult;
import com.scandit.datacapture.barcode.internal.module.generator.NativeBarcodeGeneratorGenerateResult;
import com.scandit.datacapture.barcode.internal.module.generator.NativeBarcodeGeneratorOptions;
import com.scandit.datacapture.core.capture.DataCaptureContext;
import com.scandit.datacapture.core.common.graphic.ImageBuffer;
import com.scandit.datacapture.core.component.DataCaptureComponent;
import com.scandit.datacapture.core.internal.sdk.component.NativeDataCaptureComponent;
import com.scandit.datacapture.core.internal.sdk.extensions.CollectionsExtensionsKt;
import com.scandit.datacapture.tools.internal.sdk.NativeImpl;
import com.scandit.datacapture.tools.internal.sdk.ProxyFunction;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, bv={}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\b\u0016\u0017\u0018\u0015\u0019\u001a\u001b\u001cB\u0011\b\u0000\u0012\u0006\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0013\u0010\u0014J\t\u0010\u0004\u001a\u00020\u0003H\u0097\u0001J\t\u0010\u0006\u001a\u00020\u0005H\u0097\u0001J\u0016\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tJ\u0016\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\tR\u0014\u0010\u0011\u001a\u00020\r8WX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator;", "Lcom/scandit/datacapture/core/component/DataCaptureComponent;", "Lcom/scandit/datacapture/barcode/generator/BarcodeGeneratorProxy;", "Lcom/scandit/datacapture/core/internal/sdk/component/NativeDataCaptureComponent;", "_dataCaptureComponentImpl", "Lcom/scandit/datacapture/barcode/internal/module/generator/NativeBarcodeGenerator;", "_impl", "", "data", "", "imageWidth", "Landroid/graphics/Bitmap;", "generate", "", "text", "getId", "()Ljava/lang/String;", "id", "impl", "<init>", "(Lcom/scandit/datacapture/barcode/internal/module/generator/NativeBarcodeGenerator;)V", "Companion", "BarcodeGeneratorBuilder", "Code128BarcodeGeneratorBuilder", "Code39BarcodeGeneratorBuilder", "DataMatrixBarcodeGeneratorBuilder", "Ean13BarcodeGeneratorBuilder", "InterleavedTwoOfFiveBarcodeGeneratorBuilder", "QrCodeBarcodeGeneratorBuilder", "scandit-barcode-capture"})
public final class BarcodeGenerator
implements DataCaptureComponent,
BarcodeGeneratorProxy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final /* synthetic */ BarcodeGeneratorProxyAdapter a;

    /*
     * WARNING - void declaration
     */
    public BarcodeGenerator(@NotNull NativeBarcodeGenerator impl) {
        BarcodeGeneratorProxyAdapter barcodeGeneratorProxyAdapter;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"impl");
        BarcodeGeneratorProxy this_ = barcodeGeneratorProxyAdapter;
        barcodeGeneratorProxyAdapter = new BarcodeGeneratorProxyAdapter((NativeBarcodeGenerator)var1_1, null, 2, null);
        v1.a = this_;
    }

    @JvmStatic
    @NotNull
    public static final Code39BarcodeGeneratorBuilder code39BarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
        DataCaptureContext dataCaptureContext2;
        return Companion.code39BarcodeGeneratorBuilder(dataCaptureContext2);
    }

    @JvmStatic
    @NotNull
    public static final Code128BarcodeGeneratorBuilder code128BarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
        DataCaptureContext dataCaptureContext2;
        return Companion.code128BarcodeGeneratorBuilder(dataCaptureContext2);
    }

    @JvmStatic
    @NotNull
    public static final Ean13BarcodeGeneratorBuilder ean13BarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
        DataCaptureContext dataCaptureContext2;
        return Companion.ean13BarcodeGeneratorBuilder(dataCaptureContext2);
    }

    @JvmStatic
    @NotNull
    public static final InterleavedTwoOfFiveBarcodeGeneratorBuilder interleavedTwoOfFiveBarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
        DataCaptureContext dataCaptureContext2;
        return Companion.interleavedTwoOfFiveBarcodeGeneratorBuilder(dataCaptureContext2);
    }

    @JvmStatic
    @NotNull
    public static final QrCodeBarcodeGeneratorBuilder qrCodeBarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
        DataCaptureContext dataCaptureContext2;
        return Companion.qrCodeBarcodeGeneratorBuilder(dataCaptureContext2);
    }

    @JvmStatic
    @NotNull
    public static final DataMatrixBarcodeGeneratorBuilder dataMatrixBarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
        DataCaptureContext dataCaptureContext2;
        return Companion.dataMatrixBarcodeGeneratorBuilder(dataCaptureContext2);
    }

    @Override
    @ProxyFunction(nativeName="getIdentifier", property="id")
    @NotNull
    public String getId() {
        return this.a.getId();
    }

    @Override
    @NativeImpl
    @NotNull
    public NativeDataCaptureComponent _dataCaptureComponentImpl() {
        return this.a._dataCaptureComponentImpl();
    }

    @Override
    @NativeImpl
    @NotNull
    public NativeBarcodeGenerator _impl() {
        return this.a._impl();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bitmap generate(@NotNull byte[] data, int imageWidth) {
        block10: {
            Object object;
            block9: {
                void var2_6;
                ArrayList arrayList;
                Object object2;
                block8: {
                    ImageBuffer imageBuffer;
                    BarcodeGenerator barcodeGenerator = this_;
                    Intrinsics.checkNotNullParameter((Object)object2, (String)"data");
                    Object this_ = CollectionsKt.emptyList();
                    this_ = barcodeGenerator._impl().generate((byte[])object2, CollectionsExtensionsKt.toArrayList((Iterable)this_));
                    if (!((NativeBarcodeGeneratorGenerateResult)this_).ok()) {
                        this_ = ((NativeBarcodeGeneratorGenerateResult)this_).error();
                        Intrinsics.checkNotNullExpressionValue((Object)this_, (String)"errorMessage");
                        if (StringsKt.contains((CharSequence)this_, (CharSequence)"Invalid input", (boolean)true)) {
                            IllegalArgumentException illegalArgumentException;
                            object2 = illegalArgumentException;
                            illegalArgumentException = new IllegalArgumentException((String)this_);
                        } else {
                            RuntimeException runtimeException;
                            object2 = runtimeException;
                            runtimeException = new RuntimeException((String)this_);
                        }
                        throw object2;
                    }
                    this_ = ((NativeBarcodeGeneratorGenerateResult)this_).value().getImageBuffer();
                    object2 = imageBuffer;
                    Object object3 = this_;
                    int n4 = object3.getWidth();
                    int n5 = object3.getHeight();
                    arrayList = object3.getPlanes();
                    Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"nativeBuffer.planes");
                    if (var2_6 != new ImageBuffer(n4, n5, arrayList).getWidth()) break block8;
                    object = object2.toBitmap();
                    break block9;
                }
                if (var2_6 <= 0) break block10;
                float f4 = (float)object2.getWidth() / (float)object2.getHeight();
                float f5 = (float)var2_6;
                int n6 = (int)(f5 / f4);
                if (var2_6 < object2.getWidth()) {
                    object = Bitmap.createScaledBitmap((Bitmap)object2.toBitmap(), (int)var2_6, (int)n6, (boolean)true);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createScaledBitmap(\n    \u2026       true\n            )");
                } else {
                    RectF rectF;
                    Paint paint;
                    arrayList = BarcodeGeneratorKt.access$toBitmap(object2, (int)var2_6, n6);
                    int n7 = (int)Math.ceil(f5 / (float)object2.getWidth());
                    Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)arrayList, (int)(object2.getWidth() * n7), (int)(object2.getHeight() * n7), (boolean)false);
                    object2 = bitmap;
                    arrayList.reconfigure((int)var2_6, n6, Bitmap.Config.ARGB_8888);
                    object = paint;
                    new Paint().setFilterBitmap(true);
                    object2 = rectF;
                    ArrayList arrayList2 = arrayList;
                    float f6 = arrayList2.getWidth();
                    float f7 = arrayList2.getHeight();
                    rectF = new RectF(0.0f, 0.0f, f6, f7);
                    new Canvas((Bitmap)arrayList).drawBitmap((Bitmap)object2, null, (RectF)object2, (Paint)object);
                    bitmap.recycle();
                    object = arrayList;
                }
            }
            return object;
        }
        throw new IllegalStateException("Image width should be bigger than zero!".toString());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bitmap generate(@NotNull String text, int imageWidth) {
        void var2_2;
        void var1_1;
        void v02 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v02, (String)"text");
        byte[] byArray = v02.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return this.generate(byArray, (int)var2_2);
    }

    @Metadata(mv={1, 7, 1}, bv={}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\u0010\b\u0000\u0010\u0001 \u0001*\b\u0012\u0004\u0012\u00028\u00000\u00002\u00020\u0002B\u0019\b\u0000\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0006\u0010\u0004\u001a\u00020\u0003J\u0015\u0010\u0007\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\bR\u001a\u0010\u0010\u001a\u00020\u000b8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$BarcodeGeneratorBuilder;", "BuilderType", "", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator;", "build", "", "backgroundColor", "withBackgroundColor", "(I)Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$BarcodeGeneratorBuilder;", "foregroundColor", "withForegroundColor", "Lcom/scandit/datacapture/barcode/generator/BarcodeGeneratorOptions;", "c", "Lcom/scandit/datacapture/barcode/generator/BarcodeGeneratorOptions;", "getOptions$scandit_barcode_capture", "()Lcom/scandit/datacapture/barcode/generator/BarcodeGeneratorOptions;", "options", "Lcom/scandit/datacapture/core/capture/DataCaptureContext;", "dataCaptureContext", "Lcom/scandit/datacapture/barcode/data/Symbology;", "symbology", "<init>", "(Lcom/scandit/datacapture/core/capture/DataCaptureContext;Lcom/scandit/datacapture/barcode/data/Symbology;)V", "scandit-barcode-capture"})
    public static abstract class BarcodeGeneratorBuilder<BuilderType extends BarcodeGeneratorBuilder<? extends BuilderType>> {
        @NotNull
        private final DataCaptureContext a;
        @NotNull
        private final Symbology b;
        @NotNull
        private final BarcodeGeneratorOptions c;

        /*
         * WARNING - void declaration
         */
        public BarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext, @NotNull Symbology symbology) {
            void var2_2;
            void var1_1;
            BarcodeGeneratorBuilder barcodeGeneratorBuilder = this;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"dataCaptureContext");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"symbology");
            this.a = var1_1;
            barcodeGeneratorBuilder.b = var2_2;
            barcodeGeneratorBuilder.c = com.scandit.datacapture.barcode.generator.BarcodeGenerator$Companion.access$createDefaultOptions(Companion, (Symbology)var2_2);
        }

        @NotNull
        public final BarcodeGeneratorOptions getOptions$scandit_barcode_capture() {
            return this.c;
        }

        @NotNull
        public final BarcodeGenerator build() {
            BarcodeGeneratorBuilder barcodeGeneratorBuilder = barcodeGeneratorBuilder2;
            BarcodeGeneratorBuilder barcodeGeneratorBuilder2 = barcodeGeneratorBuilder.a;
            Symbology symbology = barcodeGeneratorBuilder.b;
            BarcodeGeneratorOptions barcodeGeneratorOptions = barcodeGeneratorBuilder.c;
            return com.scandit.datacapture.barcode.generator.BarcodeGenerator$Companion.access$create(Companion, (DataCaptureContext)barcodeGeneratorBuilder2, symbology, barcodeGeneratorOptions);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BuilderType withBackgroundColor(int backgroundColor) {
            void var1_1;
            BarcodeGeneratorBuilder barcodeGeneratorBuilder = this;
            barcodeGeneratorBuilder.c.setBackgroundColor$scandit_barcode_capture((int)var1_1);
            Intrinsics.checkNotNull((Object)barcodeGeneratorBuilder, (String)"null cannot be cast to non-null type BuilderType of com.scandit.datacapture.barcode.generator.BarcodeGenerator.BarcodeGeneratorBuilder");
            return (BuilderType)barcodeGeneratorBuilder;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BuilderType withForegroundColor(int foregroundColor) {
            void var1_1;
            BarcodeGeneratorBuilder barcodeGeneratorBuilder = this;
            barcodeGeneratorBuilder.c.setForegroundColor$scandit_barcode_capture((int)var1_1);
            Intrinsics.checkNotNull((Object)barcodeGeneratorBuilder, (String)"null cannot be cast to non-null type BuilderType of com.scandit.datacapture.barcode.generator.BarcodeGenerator.BarcodeGeneratorBuilder");
            return (BuilderType)barcodeGeneratorBuilder;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$Code128BarcodeGeneratorBuilder;", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$BarcodeGeneratorBuilder;", "dataCaptureContext", "Lcom/scandit/datacapture/core/capture/DataCaptureContext;", "(Lcom/scandit/datacapture/core/capture/DataCaptureContext;)V", "scandit-barcode-capture"})
    public static final class Code128BarcodeGeneratorBuilder
    extends BarcodeGeneratorBuilder<Code128BarcodeGeneratorBuilder> {
        /*
         * WARNING - void declaration
         */
        public Code128BarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"dataCaptureContext");
            super((DataCaptureContext)var1_1, Symbology.CODE128);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$Code39BarcodeGeneratorBuilder;", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$BarcodeGeneratorBuilder;", "dataCaptureContext", "Lcom/scandit/datacapture/core/capture/DataCaptureContext;", "(Lcom/scandit/datacapture/core/capture/DataCaptureContext;)V", "scandit-barcode-capture"})
    public static final class Code39BarcodeGeneratorBuilder
    extends BarcodeGeneratorBuilder<Code39BarcodeGeneratorBuilder> {
        /*
         * WARNING - void declaration
         */
        public Code39BarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"dataCaptureContext");
            super((DataCaptureContext)var1_1, Symbology.CODE39);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$Ean13BarcodeGeneratorBuilder;", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$BarcodeGeneratorBuilder;", "dataCaptureContext", "Lcom/scandit/datacapture/core/capture/DataCaptureContext;", "(Lcom/scandit/datacapture/core/capture/DataCaptureContext;)V", "scandit-barcode-capture"})
    public static final class Ean13BarcodeGeneratorBuilder
    extends BarcodeGeneratorBuilder<Ean13BarcodeGeneratorBuilder> {
        /*
         * WARNING - void declaration
         */
        public Ean13BarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"dataCaptureContext");
            super((DataCaptureContext)var1_1, Symbology.EAN13_UPCA);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$InterleavedTwoOfFiveBarcodeGeneratorBuilder;", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$BarcodeGeneratorBuilder;", "dataCaptureContext", "Lcom/scandit/datacapture/core/capture/DataCaptureContext;", "(Lcom/scandit/datacapture/core/capture/DataCaptureContext;)V", "scandit-barcode-capture"})
    public static final class InterleavedTwoOfFiveBarcodeGeneratorBuilder
    extends BarcodeGeneratorBuilder<InterleavedTwoOfFiveBarcodeGeneratorBuilder> {
        /*
         * WARNING - void declaration
         */
        public InterleavedTwoOfFiveBarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"dataCaptureContext");
            super((DataCaptureContext)var1_1, Symbology.INTERLEAVED_TWO_OF_FIVE);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$DataMatrixBarcodeGeneratorBuilder;", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$BarcodeGeneratorBuilder;", "dataCaptureContext", "Lcom/scandit/datacapture/core/capture/DataCaptureContext;", "(Lcom/scandit/datacapture/core/capture/DataCaptureContext;)V", "scandit-barcode-capture"})
    public static final class DataMatrixBarcodeGeneratorBuilder
    extends BarcodeGeneratorBuilder<DataMatrixBarcodeGeneratorBuilder> {
        /*
         * WARNING - void declaration
         */
        public DataMatrixBarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"dataCaptureContext");
            super((DataCaptureContext)var1_1, Symbology.DATA_MATRIX);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$QrCodeBarcodeGeneratorBuilder;", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$BarcodeGeneratorBuilder;", "dataCaptureContext", "Lcom/scandit/datacapture/core/capture/DataCaptureContext;", "(Lcom/scandit/datacapture/core/capture/DataCaptureContext;)V", "withErrorCorrectionLevel", "errorCorrectionLevel", "Lcom/scandit/datacapture/barcode/generator/QrCodeErrorCorrectionLevel;", "withVersionNumber", "versionNumber", "", "scandit-barcode-capture"})
    public static final class QrCodeBarcodeGeneratorBuilder
    extends BarcodeGeneratorBuilder<QrCodeBarcodeGeneratorBuilder> {
        /*
         * WARNING - void declaration
         */
        public QrCodeBarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"dataCaptureContext");
            super((DataCaptureContext)var1_1, Symbology.QR);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final QrCodeBarcodeGeneratorBuilder withErrorCorrectionLevel(@NotNull QrCodeErrorCorrectionLevel errorCorrectionLevel) {
            void var1_1;
            QrCodeBarcodeGeneratorBuilder qrCodeBarcodeGeneratorBuilder = this;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"errorCorrectionLevel");
            qrCodeBarcodeGeneratorBuilder.getOptions$scandit_barcode_capture().setErrorCorrectionLevel$scandit_barcode_capture((QrCodeErrorCorrectionLevel)var1_1);
            return qrCodeBarcodeGeneratorBuilder;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final QrCodeBarcodeGeneratorBuilder withVersionNumber(int versionNumber) {
            void var1_1;
            QrCodeBarcodeGeneratorBuilder qrCodeBarcodeGeneratorBuilder = this;
            qrCodeBarcodeGeneratorBuilder.getOptions$scandit_barcode_capture().setVersionNumber$scandit_barcode_capture((int)var1_1);
            return qrCodeBarcodeGeneratorBuilder;
        }
    }

    @Metadata(mv={1, 7, 1}, bv={}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002H\u0007J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0007J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0002H\u0007J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0007J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a8\u0006\u0010"}, d2={"Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$Companion;", "", "Lcom/scandit/datacapture/core/capture/DataCaptureContext;", "dataCaptureContext", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$Code39BarcodeGeneratorBuilder;", "code39BarcodeGeneratorBuilder", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$Code128BarcodeGeneratorBuilder;", "code128BarcodeGeneratorBuilder", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$Ean13BarcodeGeneratorBuilder;", "ean13BarcodeGeneratorBuilder", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$InterleavedTwoOfFiveBarcodeGeneratorBuilder;", "interleavedTwoOfFiveBarcodeGeneratorBuilder", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$QrCodeBarcodeGeneratorBuilder;", "qrCodeBarcodeGeneratorBuilder", "Lcom/scandit/datacapture/barcode/generator/BarcodeGenerator$DataMatrixBarcodeGeneratorBuilder;", "dataMatrixBarcodeGeneratorBuilder", "scandit-barcode-capture"})
    public static final class Companion {
        private Companion() {
        }

        public static final BarcodeGeneratorOptions access$createDefaultOptions(Companion $this, Symbology symbology) {
            Companion companion;
            companion.getClass();
            NativeBarcodeGeneratorOptions nativeBarcodeGeneratorOptions = NativeBarcodeGenerator.createDefaultOptions(symbology);
            Intrinsics.checkNotNullExpressionValue((Object)nativeBarcodeGeneratorOptions, (String)"createDefaultOptions(symbology)");
            return BarcodeGeneratorKt.access$toApi(nativeBarcodeGeneratorOptions);
        }

        /*
         * WARNING - void declaration
         */
        public static final BarcodeGenerator access$create(Companion $this, DataCaptureContext dataCaptureContext, Symbology symbology, BarcodeGeneratorOptions options) {
            void var3_3;
            void var2_2;
            Object object;
            object.getClass();
            object = NativeBarcodeGenerator.create(dataCaptureContext._impl(), (Symbology)var2_2, BarcodeGeneratorKt.toNativeOptions((BarcodeGeneratorOptions)var3_3));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(\n                \u2026tions()\n                )");
            if (((NativeBarcodeGeneratorFactoryResult)object).ok()) {
                object = ((NativeBarcodeGeneratorFactoryResult)object).value();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"native.value()");
                return new BarcodeGenerator((NativeBarcodeGenerator)object);
            }
            throw new InvalidParameterException(((NativeBarcodeGeneratorFactoryResult)object).error());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Code39BarcodeGeneratorBuilder code39BarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)dataCaptureContext, (String)"dataCaptureContext");
            return new Code39BarcodeGeneratorBuilder((DataCaptureContext)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Code128BarcodeGeneratorBuilder code128BarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)dataCaptureContext, (String)"dataCaptureContext");
            return new Code128BarcodeGeneratorBuilder((DataCaptureContext)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Ean13BarcodeGeneratorBuilder ean13BarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)dataCaptureContext, (String)"dataCaptureContext");
            return new Ean13BarcodeGeneratorBuilder((DataCaptureContext)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final InterleavedTwoOfFiveBarcodeGeneratorBuilder interleavedTwoOfFiveBarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)dataCaptureContext, (String)"dataCaptureContext");
            return new InterleavedTwoOfFiveBarcodeGeneratorBuilder((DataCaptureContext)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final QrCodeBarcodeGeneratorBuilder qrCodeBarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)dataCaptureContext, (String)"dataCaptureContext");
            return new QrCodeBarcodeGeneratorBuilder((DataCaptureContext)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final DataMatrixBarcodeGeneratorBuilder dataMatrixBarcodeGeneratorBuilder(@NotNull DataCaptureContext dataCaptureContext) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)dataCaptureContext, (String)"dataCaptureContext");
            return new DataMatrixBarcodeGeneratorBuilder((DataCaptureContext)var1_1);
        }
    }
}

