/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.barcode.tracking.impl.data;

import com.scandit.datacapture.barcode.impl.data.NativeBarcode;
import com.scandit.datacapture.core.common.geometry.Quadrilateral;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class NativeTrackedBarcode {
    public abstract int getIdentifier();

    public abstract NativeBarcode getBarcode();

    public abstract Quadrilateral getPredictedLocation();

    public abstract boolean shouldAnimateFromPreviousToNextState();

    public abstract float getDeltaTime();

    private static final class CppProxy
    extends NativeTrackedBarcode {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void _djinni_private_destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public int getIdentifier() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getIdentifier(this.nativeRef);
        }

        private native int native_getIdentifier(long var1);

        @Override
        public NativeBarcode getBarcode() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getBarcode(this.nativeRef);
        }

        private native NativeBarcode native_getBarcode(long var1);

        @Override
        public Quadrilateral getPredictedLocation() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getPredictedLocation(this.nativeRef);
        }

        private native Quadrilateral native_getPredictedLocation(long var1);

        @Override
        public boolean shouldAnimateFromPreviousToNextState() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_shouldAnimateFromPreviousToNextState(this.nativeRef);
        }

        private native boolean native_shouldAnimateFromPreviousToNextState(long var1);

        @Override
        public float getDeltaTime() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getDeltaTime(this.nativeRef);
        }

        private native float native_getDeltaTime(long var1);
    }
}

