/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.annotationprocessor;

import com.sap.cloud.sdk.service.annotationprocessor.AnnotationException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.sap.cloud.sdk.service.prov.api.operations.*", "com.sap.cloud.sdk.service.prov.api.annotations.*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class AnnotationProcessor
extends AbstractProcessor {
    private Diagnostic.Kind messageKind = Diagnostic.Kind.ERROR;
    private Map<String, Map<String, Object>> annoRules;
    private static final String NAME = "name";
    private static final String PUBLIC = "public";
    private static final String ACCESS_MODIFIER = "accessModifier";
    private static final String RETURN_TYPE = "returnType";
    private static final String INPUT_PARAMS = "inputParams";
    private static final String ERROR_MSG = "-> inputParams -> value must be a list of strings";
    private static final String QUERY = "@com.sap.cloud.sdk.service.prov.api.operations.Query";
    private static final String AFTERCREATE = "@com.sap.cloud.sdk.service.prov.api.annotations.AfterCreate";
    private static final String BEFORECREATE = "@com.sap.cloud.sdk.service.prov.api.annotations.BeforeCreate";
    private static final String AFTERDELETE = "@com.sap.cloud.sdk.service.prov.api.annotations.AfterDelete";
    private static final String BEFOREDELETE = "@com.sap.cloud.sdk.service.prov.api.annotations.BeforeDelete";
    private static final String AFTERQUERY = "@com.sap.cloud.sdk.service.prov.api.annotations.AfterQuery";
    private static final String BEFOREQUERY = "@com.sap.cloud.sdk.service.prov.api.annotations.BeforeQuery";
    private static final String AFTERREAD = "@com.sap.cloud.sdk.service.prov.api.annotations.AfterRead";
    private static final String BEFOREREAD = "@com.sap.cloud.sdk.service.prov.api.annotations.BeforeRead";
    private static final String AFTERUPDATE = "@com.sap.cloud.sdk.service.prov.api.annotations.AfterUpdate";
    private static final String BEFOREUPDATE = "@com.sap.cloud.sdk.service.prov.api.annotations.BeforeUpdate";
    private static final String EXTENDACTION = "@com.sap.cloud.sdk.service.prov.api.annotations.ExtendAction";
    private static final String EXTENDFUNCTION = "@com.sap.cloud.sdk.service.prov.api.annotations.ExtendFunction";
    private static final String EXTENDCREATE = "@com.sap.cloud.sdk.service.prov.api.annotations.ExtendCreate";
    private static final String EXTENDDELETE = "@com.sap.cloud.sdk.service.prov.api.annotations.ExtendDelete";
    private static final String EXTENDREAD = "@com.sap.cloud.sdk.service.prov.api.annotations.ExtendRead";
    private static final String EXTENDUPDATE = "@com.sap.cloud.sdk.service.prov.api.annotations.ExtendUpdate";
    private static final String CREATE_RESPONSE = "com.sap.cloud.sdk.service.prov.api.response.CreateResponse";
    private static final String CREATE_REQUEST = "com.sap.cloud.sdk.service.prov.api.request.CreateRequest";
    private static final String CREATE_RESPONSE_ACCESSOR = "com.sap.cloud.sdk.service.prov.api.response.CreateResponseAccessor";
    private static final String UPDATE_RESPONSE_ACCESSOR = "com.sap.cloud.sdk.service.prov.api.response.UpdateResponseAccessor";
    private static final String DELETE_RESPONSE_ACCESSOR = "com.sap.cloud.sdk.service.prov.api.response.DeleteResponseAccessor";
    private static final String QUERY_RESPONSE_ACCESSOR = "com.sap.cloud.sdk.service.prov.api.response.QueryResponseAccessor";
    private static final String READ_RESPONSE_ACCESSOR = "com.sap.cloud.sdk.service.prov.api.response.ReadResponseAccessor";
    private static final String BEFORE_CREATE_RESPONSE = "com.sap.cloud.sdk.service.prov.api.exits.BeforeCreateResponse";
    private static final String BEFORE_UPDATE_RESPONSE = "com.sap.cloud.sdk.service.prov.api.exits.BeforeUpdateResponse";
    private static final String BEFORE_DELETE_RESPONSE = "com.sap.cloud.sdk.service.prov.api.exits.BeforeDeleteResponse";
    private static final String BEFORE_QUERY_RESPONSE = "com.sap.cloud.sdk.service.prov.api.exits.BeforeQueryResponse";
    private static final String BEFORE_READ_RESPONSE = "com.sap.cloud.sdk.service.prov.api.exits.BeforeReadResponse";
    private static final String EXTENSION_HELPER = "com.sap.cloud.sdk.service.prov.api.ExtensionHelper";
    private static final String QUERY_RESPONSE = "com.sap.cloud.sdk.service.prov.api.response.QueryResponse";
    private static final String QUERY_REQUEST = "com.sap.cloud.sdk.service.prov.api.request.QueryRequest";
    private static final String READ_RESPONSE = "com.sap.cloud.sdk.service.prov.api.response.ReadResponse";
    private static final String READ_REQUEST = "com.sap.cloud.sdk.service.prov.api.request.ReadRequest";
    private static final String UPDATE_RESPONSE = "com.sap.cloud.sdk.service.prov.api.response.UpdateResponse";
    private static final String UPDATE_REQUEST = "com.sap.cloud.sdk.service.prov.api.request.UpdateRequest";
    private static final String DELETE_RESPONSE = "com.sap.cloud.sdk.service.prov.api.response.DeleteResponse";
    private static final String DELETE_REQUEST = "com.sap.cloud.sdk.service.prov.api.request.DeleteRequest";
    private static final String OPERATION_RESPONSE = "com.sap.cloud.sdk.service.prov.api.response.OperationResponse";
    private static final String OPERATION_REQUEST = "com.sap.cloud.sdk.service.prov.api.request.OperationRequest";

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.annoRules = this.setAnnoRules();
        this.validateAnnoRules(this.annoRules);
    }

    public Map<String, Map<String, Object>> setAnnoRules() {
        HashMap<String, Map<String, Object>> annotationRules = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        HashMap<String, Object> afterCreateMap = new HashMap<String, Object>();
        HashMap<String, Object> beforeCreateMap = new HashMap<String, Object>();
        HashMap<String, Object> afterDeleteMap = new HashMap<String, Object>();
        HashMap<String, Object> beforeDeleteMap = new HashMap<String, Object>();
        HashMap<String, Object> afterQueryMap = new HashMap<String, Object>();
        HashMap<String, Object> beforeQueryMap = new HashMap<String, Object>();
        HashMap<String, Object> afterReadMap = new HashMap<String, Object>();
        HashMap<String, Object> beforeReadMap = new HashMap<String, Object>();
        HashMap<String, Object> afterUpdateMap = new HashMap<String, Object>();
        HashMap<String, Object> beforeUpdateMap = new HashMap<String, Object>();
        HashMap<String, Object> extendCreateMap = new HashMap<String, Object>();
        HashMap<String, Object> extendDeleteMap = new HashMap<String, Object>();
        HashMap<String, Object> extendReadMap = new HashMap<String, Object>();
        HashMap<String, Object> extendUpdateMap = new HashMap<String, Object>();
        HashMap<String, Object> extendActionMap = new HashMap<String, Object>();
        HashMap<String, Object> extendFunctionMap = new HashMap<String, Object>();
        queryMap.put(NAME, QUERY);
        queryMap.put(ACCESS_MODIFIER, PUBLIC);
        queryMap.put(RETURN_TYPE, QUERY_RESPONSE);
        queryMap.put(INPUT_PARAMS, Arrays.asList(QUERY_REQUEST));
        annotationRules.put(QUERY, queryMap);
        afterCreateMap.put(NAME, AFTERCREATE);
        afterCreateMap.put(ACCESS_MODIFIER, PUBLIC);
        afterCreateMap.put(RETURN_TYPE, CREATE_RESPONSE);
        afterCreateMap.put(INPUT_PARAMS, Arrays.asList(CREATE_REQUEST, CREATE_RESPONSE_ACCESSOR, EXTENSION_HELPER));
        annotationRules.put(AFTERCREATE, afterCreateMap);
        beforeCreateMap.put(NAME, BEFORECREATE);
        beforeCreateMap.put(ACCESS_MODIFIER, PUBLIC);
        beforeCreateMap.put(RETURN_TYPE, BEFORE_CREATE_RESPONSE);
        beforeCreateMap.put(INPUT_PARAMS, Arrays.asList(CREATE_REQUEST, EXTENSION_HELPER));
        annotationRules.put(BEFORECREATE, beforeCreateMap);
        afterDeleteMap.put(NAME, AFTERDELETE);
        afterDeleteMap.put(ACCESS_MODIFIER, PUBLIC);
        afterDeleteMap.put(RETURN_TYPE, DELETE_RESPONSE);
        afterDeleteMap.put(INPUT_PARAMS, Arrays.asList(DELETE_REQUEST, DELETE_RESPONSE_ACCESSOR, EXTENSION_HELPER));
        annotationRules.put(AFTERDELETE, afterDeleteMap);
        beforeDeleteMap.put(NAME, BEFOREDELETE);
        beforeDeleteMap.put(ACCESS_MODIFIER, PUBLIC);
        beforeDeleteMap.put(RETURN_TYPE, BEFORE_DELETE_RESPONSE);
        beforeDeleteMap.put(INPUT_PARAMS, Arrays.asList(DELETE_REQUEST, EXTENSION_HELPER));
        annotationRules.put(BEFOREDELETE, beforeDeleteMap);
        afterQueryMap.put(NAME, AFTERQUERY);
        afterQueryMap.put(ACCESS_MODIFIER, PUBLIC);
        afterQueryMap.put(RETURN_TYPE, QUERY_RESPONSE);
        afterQueryMap.put(INPUT_PARAMS, Arrays.asList(QUERY_REQUEST, QUERY_RESPONSE_ACCESSOR, EXTENSION_HELPER));
        annotationRules.put(AFTERQUERY, afterQueryMap);
        beforeQueryMap.put(NAME, BEFOREQUERY);
        beforeQueryMap.put(ACCESS_MODIFIER, PUBLIC);
        beforeQueryMap.put(RETURN_TYPE, BEFORE_QUERY_RESPONSE);
        beforeQueryMap.put(INPUT_PARAMS, Arrays.asList(QUERY_REQUEST, EXTENSION_HELPER));
        annotationRules.put(BEFOREQUERY, beforeQueryMap);
        afterReadMap.put(NAME, AFTERREAD);
        afterReadMap.put(ACCESS_MODIFIER, PUBLIC);
        afterReadMap.put(RETURN_TYPE, READ_RESPONSE);
        afterReadMap.put(INPUT_PARAMS, Arrays.asList(READ_REQUEST, READ_RESPONSE_ACCESSOR, EXTENSION_HELPER));
        annotationRules.put(AFTERREAD, afterReadMap);
        beforeReadMap.put(NAME, BEFOREREAD);
        beforeReadMap.put(ACCESS_MODIFIER, PUBLIC);
        beforeReadMap.put(RETURN_TYPE, BEFORE_READ_RESPONSE);
        beforeReadMap.put(INPUT_PARAMS, Arrays.asList(READ_REQUEST, EXTENSION_HELPER));
        annotationRules.put(BEFOREREAD, beforeReadMap);
        afterUpdateMap.put(NAME, AFTERUPDATE);
        afterUpdateMap.put(ACCESS_MODIFIER, PUBLIC);
        afterUpdateMap.put(RETURN_TYPE, UPDATE_RESPONSE);
        afterUpdateMap.put(INPUT_PARAMS, Arrays.asList(UPDATE_REQUEST, UPDATE_RESPONSE_ACCESSOR, EXTENSION_HELPER));
        annotationRules.put(AFTERUPDATE, afterUpdateMap);
        beforeUpdateMap.put(NAME, BEFOREUPDATE);
        beforeUpdateMap.put(ACCESS_MODIFIER, PUBLIC);
        beforeUpdateMap.put(RETURN_TYPE, BEFORE_UPDATE_RESPONSE);
        beforeUpdateMap.put(INPUT_PARAMS, Arrays.asList(UPDATE_REQUEST, EXTENSION_HELPER));
        annotationRules.put(BEFOREUPDATE, beforeUpdateMap);
        extendCreateMap.put(NAME, EXTENDCREATE);
        extendCreateMap.put(ACCESS_MODIFIER, PUBLIC);
        extendCreateMap.put(RETURN_TYPE, CREATE_RESPONSE);
        extendCreateMap.put(INPUT_PARAMS, Arrays.asList(CREATE_REQUEST, EXTENSION_HELPER));
        annotationRules.put(EXTENDCREATE, extendCreateMap);
        extendDeleteMap.put(NAME, EXTENDDELETE);
        extendDeleteMap.put(ACCESS_MODIFIER, PUBLIC);
        extendDeleteMap.put(RETURN_TYPE, DELETE_RESPONSE);
        extendDeleteMap.put(INPUT_PARAMS, Arrays.asList(DELETE_REQUEST, EXTENSION_HELPER));
        annotationRules.put(EXTENDDELETE, extendDeleteMap);
        extendReadMap.put(NAME, EXTENDREAD);
        extendReadMap.put(ACCESS_MODIFIER, PUBLIC);
        extendReadMap.put(RETURN_TYPE, READ_RESPONSE);
        extendReadMap.put(INPUT_PARAMS, Arrays.asList(READ_REQUEST, EXTENSION_HELPER));
        annotationRules.put(EXTENDREAD, extendReadMap);
        extendUpdateMap.put(NAME, EXTENDUPDATE);
        extendUpdateMap.put(ACCESS_MODIFIER, PUBLIC);
        extendUpdateMap.put(RETURN_TYPE, UPDATE_RESPONSE);
        extendUpdateMap.put(INPUT_PARAMS, Arrays.asList(UPDATE_REQUEST, EXTENSION_HELPER));
        annotationRules.put(EXTENDUPDATE, extendUpdateMap);
        extendActionMap.put(NAME, EXTENDACTION);
        extendActionMap.put(ACCESS_MODIFIER, PUBLIC);
        extendActionMap.put(RETURN_TYPE, OPERATION_RESPONSE);
        extendActionMap.put(INPUT_PARAMS, Arrays.asList(OPERATION_REQUEST, EXTENSION_HELPER));
        annotationRules.put(EXTENDACTION, extendActionMap);
        extendFunctionMap.put(NAME, EXTENDFUNCTION);
        extendFunctionMap.put(ACCESS_MODIFIER, PUBLIC);
        extendFunctionMap.put(RETURN_TYPE, OPERATION_RESPONSE);
        extendFunctionMap.put(INPUT_PARAMS, Arrays.asList(OPERATION_REQUEST, EXTENSION_HELPER));
        annotationRules.put(EXTENDFUNCTION, extendFunctionMap);
        return annotationRules;
    }

    public boolean validateAnnoRules(Map<String, Map<String, Object>> annoRulesObj) {
        boolean returnValue = true;
        Pattern checkDigitPattern = Pattern.compile(".*\\d.*");
        HashSet<String> acceptableAccessModifierSet = new HashSet<String>();
        acceptableAccessModifierSet.add(PUBLIC);
        acceptableAccessModifierSet.add("private");
        acceptableAccessModifierSet.add("default");
        acceptableAccessModifierSet.add("protected");
        HashSet<String> acceptableKeySet = new HashSet<String>();
        acceptableKeySet.add(NAME);
        acceptableKeySet.add(ACCESS_MODIFIER);
        acceptableKeySet.add(RETURN_TYPE);
        acceptableKeySet.add(INPUT_PARAMS);
        int countErrorMsg = 0;
        StringBuilder allErrorMessage = new StringBuilder("");
        for (Map.Entry<String, Map<String, Object>> entry : annoRulesObj.entrySet()) {
            String key = entry.getKey();
            Map<String, Object> value = entry.getValue();
            Set<String> keySet = value.keySet();
            if (!keySet.equals(acceptableKeySet)) {
                returnValue = false;
                allErrorMessage.append("\n" + ++countErrorMsg + ". The key set value for " + key + " must be " + ((Object)acceptableKeySet).toString());
            }
            for (Map.Entry<String, Object> subEntry : value.entrySet()) {
                String subKey = subEntry.getKey();
                String nameValue = null;
                String accessModifier = null;
                List inputParams = null;
                if (NAME.equals(subKey)) {
                    if (subEntry.getValue() instanceof String) {
                        nameValue = (String)subEntry.getValue();
                    } else {
                        allErrorMessage.append("\n" + ++countErrorMsg + ". " + key + "-> name -> value must be type string");
                    }
                    if (nameValue != null && nameValue.equals(key)) continue;
                    allErrorMessage.append("\n" + ++countErrorMsg + ". " + key + "-> name -> value must be " + key);
                    continue;
                }
                if (RETURN_TYPE.equals(subKey)) {
                    if (subEntry.getValue() instanceof String) continue;
                    allErrorMessage.append("\n" + ++countErrorMsg + ". " + key + "-> returnType -> value must be type string");
                    continue;
                }
                if (INPUT_PARAMS.equals(subKey)) {
                    if (subEntry.getValue() instanceof List) {
                        List paramList = (List)subEntry.getValue();
                        if (!paramList.isEmpty()) {
                            if (paramList.get(0) instanceof String) {
                                inputParams = (List)subEntry.getValue();
                            } else {
                                allErrorMessage.append("\n" + ++countErrorMsg + ". " + key + ERROR_MSG);
                            }
                        } else {
                            allErrorMessage.append("\n" + ++countErrorMsg + ". " + key + ERROR_MSG);
                        }
                    } else {
                        allErrorMessage.append("\n" + ++countErrorMsg + ". " + key + ERROR_MSG);
                    }
                    if (inputParams == null) continue;
                    for (int i = 0; i < inputParams.size(); ++i) {
                        String param = null;
                        param = (String)inputParams.get(i);
                        if (param == null || !checkDigitPattern.matcher(param).matches()) continue;
                        allErrorMessage.append("\n" + ++countErrorMsg + ". " + key + "-> inputParams -> value must be a list of strings without any digits");
                    }
                    continue;
                }
                if (!ACCESS_MODIFIER.equals(subKey)) continue;
                if (subEntry.getValue() instanceof String) {
                    accessModifier = (String)subEntry.getValue();
                } else {
                    allErrorMessage.append("\n" + ++countErrorMsg + ". " + key + "-> accessModifier -> value must be type string");
                }
                if (acceptableAccessModifierSet.contains(accessModifier)) continue;
                allErrorMessage.append("\n" + ++countErrorMsg + ". " + key + "-> accessModifier must be on of the following " + ((Object)acceptableAccessModifierSet).toString());
            }
        }
        if (countErrorMsg > 0) {
            throw new AnnotationException("Found " + countErrorMsg + " errors in Annotation Rules:" + allErrorMessage.toString());
        }
        return returnValue;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Messager messager = this.processingEnv.getMessager();
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                this.checkAndValidateAnnotationIfPresent(element, messager);
            }
        }
        return true;
    }

    public String checkAccessModifier(Name methodSimpleName, ExecutableElement executableElement, String acceptableAccessModifier) {
        StringBuilder message = new StringBuilder("");
        Set<Modifier> modifiers = executableElement.getModifiers();
        boolean correctModifierFlag = false;
        for (Modifier modifier : modifiers) {
            if (!modifier.toString().equals(acceptableAccessModifier)) continue;
            correctModifierFlag = true;
            break;
        }
        if (!correctModifierFlag) {
            message = new StringBuilder("Method " + methodSimpleName.toString() + " must be a " + acceptableAccessModifier + " method.");
        }
        return message.toString();
    }

    private String extractParams(List<String> params) {
        int paramSize = params.size();
        StringBuilder message = new StringBuilder("(");
        for (int i = 0; i < paramSize; ++i) {
            if (i == 0) {
                message.append(params.get(i));
                continue;
            }
            message.append(", " + params.get(i));
        }
        message.append(")");
        return message.toString();
    }

    public String checkImportingParams(Name methodSimpleName, ExecutableElement executableElement, List<String> acceptableParam) {
        TypeMirror paramMirror;
        VariableElement paramve;
        int i;
        StringBuilder message = new StringBuilder("");
        List<? extends VariableElement> parameters = executableElement.getParameters();
        int paramSize = parameters.size();
        int acceptableParamSize = acceptableParam.size();
        boolean createErrorMessage = false;
        if (paramSize == 0 && acceptableParamSize > 0) {
            message = new StringBuilder("The method " + methodSimpleName.toString() + "() must have the parameters " + this.extractParams(acceptableParam) + ".");
        } else if (paramSize != acceptableParamSize) {
            createErrorMessage = true;
        } else {
            for (i = 0; i < acceptableParamSize; ++i) {
                paramve = parameters.get(i);
                paramMirror = paramve.asType();
                if (paramMirror.toString().equals(acceptableParam.get(i))) continue;
                createErrorMessage = true;
                break;
            }
        }
        if (createErrorMessage) {
            message = new StringBuilder("The parameters (");
            for (i = 0; i < paramSize; ++i) {
                paramve = parameters.get(i);
                paramMirror = paramve.asType();
                if (i == 0) {
                    message.append(paramMirror.toString());
                    continue;
                }
                message.append(", " + paramMirror.toString());
            }
            message.append(") does not match the method " + methodSimpleName.toString() + this.extractParams(acceptableParam) + ".");
        }
        return message.toString();
    }

    public String checkReturnType(Name methodSimpleName, ExecutableElement executableElement, String returnType) {
        StringBuilder message = new StringBuilder("");
        TypeMirror returnTypeMirror = executableElement.getReturnType();
        if (returnTypeMirror == null || !returnTypeMirror.toString().equals(returnType)) {
            message = new StringBuilder("Method " + methodSimpleName.toString() + " must return an object of " + returnType + ".");
        }
        return message.toString();
    }

    public void checkAndValidateAnnotationIfPresent(Element e, Messager messager) {
        List<? extends AnnotationMirror> amlist = e.getAnnotationMirrors();
        AnnotationMirror am = amlist.get(0);
        String annoDefinition = am.toString();
        String[] annoDefinationStr = annoDefinition.split("\\(");
        String annoName = annoDefinationStr[0];
        Map<String, Object> value = this.annoRules.get(annoName);
        if (value != null) {
            String returnType = null;
            String accessModifier = null;
            List inputParams = null;
            for (Map.Entry<String, Object> subEntry : value.entrySet()) {
                String key = subEntry.getKey();
                if (RETURN_TYPE.equals(key)) {
                    returnType = (String)subEntry.getValue();
                    continue;
                }
                if (INPUT_PARAMS.equals(key)) {
                    inputParams = (List)subEntry.getValue();
                    continue;
                }
                if (!ACCESS_MODIFIER.equals(key)) continue;
                accessModifier = (String)subEntry.getValue();
            }
            Name methodSimpleName = e.getSimpleName();
            ExecutableElement executableElement = (ExecutableElement)e;
            String importingParamsErrorMsg = this.checkImportingParams(methodSimpleName, executableElement, inputParams);
            this.printValidationMsg(importingParamsErrorMsg, messager, e);
            String returnTypeErrorMsg = this.checkReturnType(methodSimpleName, executableElement, returnType);
            this.printValidationMsg(returnTypeErrorMsg, messager, e);
            String accessModifierErrorMsg = this.checkAccessModifier(methodSimpleName, executableElement, accessModifier);
            this.printValidationMsg(accessModifierErrorMsg, messager, e);
        }
    }

    private void printValidationMsg(String errorMsg, Messager messager, Element e) {
        if (errorMsg != null && !"".equals(errorMsg)) {
            messager.printMessage(this.messageKind, errorMsg, e);
        }
    }
}

