/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.annotationprocessor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.regex.Pattern;

import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;




@SupportedAnnotationTypes({ "com.sap.cloud.sdk.service.prov.api.operations.*", "com.sap.cloud.sdk.service.prov.api.annotations.*" })

@SupportedSourceVersion(SourceVersion.RELEASE_8)
/** 
 * This is the Annotation processor
 */
public class AnnotationProcessor extends AbstractProcessor {
	private Diagnostic.Kind messageKind = Diagnostic.Kind.ERROR;
	private Map<String, Map<String, Object>> annoRules;
	
	private static final String NAME = "name";
	private static final String PUBLIC = "public";
	private static final String ACCESS_MODIFIER = "accessModifier";
	private static final String RETURN_TYPE = "returnType";
	private static final String INPUT_PARAMS = "inputParams";
	private static final String ERROR_MSG = "-> inputParams -> value must be a list of strings";
	//private static final String BOOLEAN ="boolean";
	
	//private static final String CREATE = "@com.sap.cloud.sdk.service.prov.api.operations.Create";
	private static final String QUERY = "@com.sap.cloud.sdk.service.prov.api.operations.Query";
	//private static final String READ = "@com.sap.cloud.sdk.service.prov.api.operations.Read";
	//private static final String UPDATE = "@com.sap.cloud.sdk.service.prov.api.operations.Update";
	//private static final String DELETE = "@com.sap.cloud.sdk.service.prov.api.operations.Delete";
	private static final String AFTERCREATE = "@com.sap.cloud.sdk.service.prov.api.annotations.AfterCreate";
	private static final String BEFORECREATE = "@com.sap.cloud.sdk.service.prov.api.annotations.BeforeCreate";
	private static final String AFTERDELETE = "@com.sap.cloud.sdk.service.prov.api.annotations.AfterDelete";
	private static final String BEFOREDELETE = "@com.sap.cloud.sdk.service.prov.api.annotations.BeforeDelete";
	private static final String AFTERQUERY = "@com.sap.cloud.sdk.service.prov.api.annotations.AfterQuery";
	private static final String BEFOREQUERY = "@com.sap.cloud.sdk.service.prov.api.annotations.BeforeQuery";
	private static final String AFTERREAD = "@com.sap.cloud.sdk.service.prov.api.annotations.AfterRead";
	private static final String BEFOREREAD = "@com.sap.cloud.sdk.service.prov.api.annotations.BeforeRead";
	private static final String AFTERUPDATE = "@com.sap.cloud.sdk.service.prov.api.annotations.AfterUpdate";
	private static final String BEFOREUPDATE = "@com.sap.cloud.sdk.service.prov.api.annotations.BeforeUpdate";
	//private static final String CLEANUPTRANSACTION = "@com.sap.cloud.sdk.service.prov.api.annotations.CleanupTransaction";
	//private static final String ENDTRANSACTION = "@com.sap.cloud.sdk.service.prov.api.annotations.EndTransaction";
	//private static final String INITTRANSACTION = "@com.sap.cloud.sdk.service.prov.api.annotations.InitTransaction";
	
	
	private static final String EXTENDACTION = "@com.sap.cloud.sdk.service.prov.api.annotations.ExtendAction";
	private static final String EXTENDFUNCTION = "@com.sap.cloud.sdk.service.prov.api.annotations.ExtendFunction";
	
	private static final String EXTENDCREATE = "@com.sap.cloud.sdk.service.prov.api.annotations.ExtendCreate";
	private static final String EXTENDDELETE = "@com.sap.cloud.sdk.service.prov.api.annotations.ExtendDelete";
	private static final String EXTENDREAD = "@com.sap.cloud.sdk.service.prov.api.annotations.ExtendRead";
	private static final String EXTENDUPDATE = "@com.sap.cloud.sdk.service.prov.api.annotations.ExtendUpdate";
	
	//cleanupTransaction parameter
	//private static final String REQUEST_LIST = "java.util.List<com.sap.cloud.sdk.service.prov.api.request.Request>";
	
	private static final String CREATE_RESPONSE = "com.sap.cloud.sdk.service.prov.api.response.CreateResponse";
	private static final String CREATE_REQUEST = "com.sap.cloud.sdk.service.prov.api.request.CreateRequest";
	//private static final String UPDATE_REQUEST = "com.sap.cloud.sdk.service.prov.api.request.UpdateRequest";
	
	private static final String CREATE_RESPONSE_ACCESSOR = "com.sap.cloud.sdk.service.prov.api.response.CreateResponseAccessor";
	private static final String UPDATE_RESPONSE_ACCESSOR = "com.sap.cloud.sdk.service.prov.api.response.UpdateResponseAccessor";
	private static final String DELETE_RESPONSE_ACCESSOR = "com.sap.cloud.sdk.service.prov.api.response.DeleteResponseAccessor";
	private static final String QUERY_RESPONSE_ACCESSOR = "com.sap.cloud.sdk.service.prov.api.response.QueryResponseAccessor";
	private static final String READ_RESPONSE_ACCESSOR = "com.sap.cloud.sdk.service.prov.api.response.ReadResponseAccessor";
	
	private static final String BEFORE_CREATE_RESPONSE = "com.sap.cloud.sdk.service.prov.api.exits.BeforeCreateResponse";
	private static final String BEFORE_UPDATE_RESPONSE = "com.sap.cloud.sdk.service.prov.api.exits.BeforeUpdateResponse";
	private static final String BEFORE_DELETE_RESPONSE = "com.sap.cloud.sdk.service.prov.api.exits.BeforeDeleteResponse";
	private static final String BEFORE_QUERY_RESPONSE = "com.sap.cloud.sdk.service.prov.api.exits.BeforeQueryResponse";
	private static final String BEFORE_READ_RESPONSE = "com.sap.cloud.sdk.service.prov.api.exits.BeforeReadResponse";
	
	private static final String EXTENSION_HELPER = "com.sap.cloud.sdk.service.prov.api.ExtensionHelper";
	
	private static final String QUERY_RESPONSE = "com.sap.cloud.sdk.service.prov.api.response.QueryResponse";
	private static final String QUERY_REQUEST = "com.sap.cloud.sdk.service.prov.api.request.QueryRequest";
	
	private static final String READ_RESPONSE = "com.sap.cloud.sdk.service.prov.api.response.ReadResponse";
	private static final String READ_REQUEST = "com.sap.cloud.sdk.service.prov.api.request.ReadRequest";
	
	private static final String UPDATE_RESPONSE = "com.sap.cloud.sdk.service.prov.api.response.UpdateResponse";
	private static final String UPDATE_REQUEST = "com.sap.cloud.sdk.service.prov.api.request.UpdateRequest";
	
	private static final String DELETE_RESPONSE = "com.sap.cloud.sdk.service.prov.api.response.DeleteResponse";
	private static final String DELETE_REQUEST = "com.sap.cloud.sdk.service.prov.api.request.DeleteRequest";
	
	private static final String OPERATION_RESPONSE = "com.sap.cloud.sdk.service.prov.api.response.OperationResponse";
	private static final String OPERATION_REQUEST = "com.sap.cloud.sdk.service.prov.api.request.OperationRequest";
	@Override
	public synchronized void init(ProcessingEnvironment processingEnv) {

		super.init(processingEnv);
		annoRules = setAnnoRules();
		validateAnnoRules(annoRules);
	} 

	public Map<String, Map<String, Object>> setAnnoRules() {
		Map<String,Map<String,Object>> annotationRules = new HashMap<>();
//		Map<String,Object> createMap = new HashMap<>();
//		Map<String,Object> readMap = new HashMap<>();
//		Map<String,Object> deleteMap = new HashMap<>();
		Map<String,Object> queryMap = new HashMap<>();
//		Map<String,Object> updateMap = new HashMap<>();
		Map<String,Object> afterCreateMap = new HashMap<>();
		Map<String,Object> beforeCreateMap = new HashMap<>();
		Map<String,Object> afterDeleteMap = new HashMap<>();
		Map<String,Object> beforeDeleteMap = new HashMap<>();
		Map<String,Object> afterQueryMap = new HashMap<>();
		Map<String,Object> beforeQueryMap = new HashMap<>();
		Map<String,Object> afterReadMap = new HashMap<>();
		Map<String,Object> beforeReadMap = new HashMap<>();
		Map<String,Object> afterUpdateMap = new HashMap<>();
		Map<String,Object> beforeUpdateMap = new HashMap<>();
//		Map<String,Object> cleanUpTransactionMap = new HashMap<>();
//		Map<String,Object> endTransactionMap = new HashMap<>();
//		Map<String,Object> initTransactionMap = new HashMap<>();
		Map<String,Object> extendCreateMap = new HashMap<>();
		Map<String,Object> extendDeleteMap = new HashMap<>();
		Map<String,Object> extendReadMap = new HashMap<>();
		Map<String,Object> extendUpdateMap = new HashMap<>();
		Map<String,Object> extendActionMap = new HashMap<>();
		Map<String,Object> extendFunctionMap = new HashMap<>();
		
		
		queryMap.put(NAME,QUERY);
		queryMap.put(ACCESS_MODIFIER,PUBLIC);
		queryMap.put(RETURN_TYPE,QUERY_RESPONSE);
		queryMap.put(INPUT_PARAMS,Arrays.asList(QUERY_REQUEST));
		annotationRules.put(QUERY,queryMap);
		
		//Commenting out the signature validations for @Create,@Update, @Update, @Delete methods so that we can use the annotations for both signatures. 
		/*
		createMap.put(NAME,CREATE);
		createMap.put(ACCESS_MODIFIER,PUBLIC);
		createMap.put(RETURN_TYPE,CREATE_RESPONSE);
		createMap.put(INPUT_PARAMS,Arrays.asList(CREATE_REQUEST));		
		annotationRules.put(CREATE,createMap);
		*/

		/*
		readMap.put(NAME,READ);
		readMap.put(ACCESS_MODIFIER,PUBLIC);
		readMap.put(RETURN_TYPE,READ_RESPONSE);
		readMap.put(INPUT_PARAMS,Arrays.asList(READ_REQUEST));
		annotationRules.put(READ,readMap);
		*/
		
		/*
		updateMap.put(NAME,UPDATE);
		updateMap.put(ACCESS_MODIFIER,PUBLIC);
		updateMap.put(RETURN_TYPE,UPDATE_RESPONSE);
		updateMap.put(INPUT_PARAMS,Arrays.asList(UPDATE_REQUEST));
		annotationRules.put(UPDATE,updateMap);
		*/
		
		/*
		deleteMap.put(NAME,DELETE);
		deleteMap.put(ACCESS_MODIFIER,PUBLIC);
		deleteMap.put(RETURN_TYPE,DELETE_RESPONSE);
		deleteMap.put(INPUT_PARAMS,Arrays.asList(DELETE_REQUEST));
		annotationRules.put(DELETE,deleteMap);	
		*/
		
		afterCreateMap.put(NAME,AFTERCREATE);
        afterCreateMap.put(ACCESS_MODIFIER,PUBLIC);
        afterCreateMap.put(RETURN_TYPE,CREATE_RESPONSE);
        afterCreateMap.put(INPUT_PARAMS,Arrays.asList(CREATE_REQUEST,CREATE_RESPONSE_ACCESSOR,EXTENSION_HELPER));
        annotationRules.put(AFTERCREATE,afterCreateMap);
        
        beforeCreateMap.put(NAME,BEFORECREATE);
        beforeCreateMap.put(ACCESS_MODIFIER,PUBLIC);
        beforeCreateMap.put(RETURN_TYPE,BEFORE_CREATE_RESPONSE);
        beforeCreateMap.put(INPUT_PARAMS,Arrays.asList(CREATE_REQUEST,EXTENSION_HELPER));
        annotationRules.put(BEFORECREATE,beforeCreateMap);
        
        afterDeleteMap.put(NAME,AFTERDELETE);
        afterDeleteMap.put(ACCESS_MODIFIER,PUBLIC);
        afterDeleteMap.put(RETURN_TYPE,DELETE_RESPONSE);
        afterDeleteMap.put(INPUT_PARAMS,Arrays.asList(DELETE_REQUEST,DELETE_RESPONSE_ACCESSOR,EXTENSION_HELPER));
        annotationRules.put(AFTERDELETE,afterDeleteMap);
        
        beforeDeleteMap.put(NAME,BEFOREDELETE);
        beforeDeleteMap.put(ACCESS_MODIFIER,PUBLIC);
        beforeDeleteMap.put(RETURN_TYPE,BEFORE_DELETE_RESPONSE);
        beforeDeleteMap.put(INPUT_PARAMS,Arrays.asList(DELETE_REQUEST,EXTENSION_HELPER));
        annotationRules.put(BEFOREDELETE,beforeDeleteMap);
        
        afterQueryMap.put(NAME,AFTERQUERY);
        afterQueryMap.put(ACCESS_MODIFIER,PUBLIC);
        afterQueryMap.put(RETURN_TYPE,QUERY_RESPONSE);
        afterQueryMap.put(INPUT_PARAMS,Arrays.asList(QUERY_REQUEST,QUERY_RESPONSE_ACCESSOR,EXTENSION_HELPER));
        annotationRules.put(AFTERQUERY,afterQueryMap);
        
        beforeQueryMap.put(NAME,BEFOREQUERY);
        beforeQueryMap.put(ACCESS_MODIFIER,PUBLIC);
        beforeQueryMap.put(RETURN_TYPE,BEFORE_QUERY_RESPONSE);
        beforeQueryMap.put(INPUT_PARAMS,Arrays.asList(QUERY_REQUEST,EXTENSION_HELPER));
        annotationRules.put(BEFOREQUERY,beforeQueryMap);
        
        afterReadMap.put(NAME,AFTERREAD);
        afterReadMap.put(ACCESS_MODIFIER,PUBLIC);
        afterReadMap.put(RETURN_TYPE,READ_RESPONSE);
        afterReadMap.put(INPUT_PARAMS,Arrays.asList(READ_REQUEST,READ_RESPONSE_ACCESSOR,EXTENSION_HELPER));
        annotationRules.put(AFTERREAD,afterReadMap);
        
        beforeReadMap.put(NAME,BEFOREREAD);
        beforeReadMap.put(ACCESS_MODIFIER,PUBLIC);
        beforeReadMap.put(RETURN_TYPE,BEFORE_READ_RESPONSE);
        beforeReadMap.put(INPUT_PARAMS,Arrays.asList(READ_REQUEST,EXTENSION_HELPER));
        annotationRules.put(BEFOREREAD,beforeReadMap);
        
        afterUpdateMap.put(NAME,AFTERUPDATE);
        afterUpdateMap.put(ACCESS_MODIFIER,PUBLIC);
        afterUpdateMap.put(RETURN_TYPE,UPDATE_RESPONSE);
        afterUpdateMap.put(INPUT_PARAMS,Arrays.asList(UPDATE_REQUEST,UPDATE_RESPONSE_ACCESSOR,EXTENSION_HELPER));
        annotationRules.put(AFTERUPDATE,afterUpdateMap);
        
        beforeUpdateMap.put(NAME,BEFOREUPDATE);
        beforeUpdateMap.put(ACCESS_MODIFIER,PUBLIC);
        beforeUpdateMap.put(RETURN_TYPE,BEFORE_UPDATE_RESPONSE);
        beforeUpdateMap.put(INPUT_PARAMS,Arrays.asList(UPDATE_REQUEST,EXTENSION_HELPER));
        annotationRules.put(BEFOREUPDATE,beforeUpdateMap);
        
        
        //Removed so that input Params can accept a list of Generic Requests :: https://support.wdf.sap.corp/sap/support/message/1870314358
       /* cleanUpTransactionMap.put(NAME,CLEANUPTRANSACTION);
        cleanUpTransactionMap.put(ACCESS_MODIFIER,PUBLIC);
        cleanUpTransactionMap.put(RETURN_TYPE,"void");
        cleanUpTransactionMap.put(INPUT_PARAMS,Arrays.asList(BOOLEAN, REQUEST_LIST, EXTENSION_HELPER));
        annotationRules.put(CLEANUPTRANSACTION,cleanUpTransactionMap);
        
        endTransactionMap.put(NAME,ENDTRANSACTION);
        endTransactionMap.put(ACCESS_MODIFIER,PUBLIC);
        endTransactionMap.put(RETURN_TYPE,"void");
        endTransactionMap.put(INPUT_PARAMS,Arrays.asList(REQUEST_LIST, EXTENSION_HELPER));
        annotationRules.put(ENDTRANSACTION,endTransactionMap);*/

// Currently the followings are being commented out as the expected return type is now different                
//        initTransactionMap.put(NAME,INITTRANSACTION);
//        initTransactionMap.put(ACCESS_MODIFIER,PUBLIC);
//        initTransactionMap.put(RETURN_TYPE,"void");
//        initTransactionMap.put(INPUT_PARAMS,Arrays.asList(REQUEST_LIST, EXTENSION_HELPER));
//        annotationRules.put(INITTRANSACTION,initTransactionMap);
        
        
        extendCreateMap.put(NAME,EXTENDCREATE);
        extendCreateMap.put(ACCESS_MODIFIER,PUBLIC);
        extendCreateMap.put(RETURN_TYPE,CREATE_RESPONSE);
        extendCreateMap.put(INPUT_PARAMS,Arrays.asList(CREATE_REQUEST, EXTENSION_HELPER));
        annotationRules.put(EXTENDCREATE,extendCreateMap);

        extendDeleteMap.put(NAME,EXTENDDELETE);
        extendDeleteMap.put(ACCESS_MODIFIER,PUBLIC);
        extendDeleteMap.put(RETURN_TYPE,DELETE_RESPONSE);
        extendDeleteMap.put(INPUT_PARAMS,Arrays.asList(DELETE_REQUEST, EXTENSION_HELPER));
        annotationRules.put(EXTENDDELETE,extendDeleteMap);
        
        extendReadMap.put(NAME,EXTENDREAD);
        extendReadMap.put(ACCESS_MODIFIER,PUBLIC);
        extendReadMap.put(RETURN_TYPE,READ_RESPONSE);
        extendReadMap.put(INPUT_PARAMS,Arrays.asList(READ_REQUEST, EXTENSION_HELPER));
        annotationRules.put(EXTENDREAD,extendReadMap);
        
        extendUpdateMap.put(NAME,EXTENDUPDATE);
        extendUpdateMap.put(ACCESS_MODIFIER,PUBLIC);
        extendUpdateMap.put(RETURN_TYPE,UPDATE_RESPONSE);
        extendUpdateMap.put(INPUT_PARAMS,Arrays.asList(UPDATE_REQUEST, EXTENSION_HELPER));
        annotationRules.put(EXTENDUPDATE,extendUpdateMap);
        
        extendActionMap.put(NAME,EXTENDACTION);
        extendActionMap.put(ACCESS_MODIFIER,PUBLIC);
        extendActionMap.put(RETURN_TYPE,OPERATION_RESPONSE);
        extendActionMap.put(INPUT_PARAMS,Arrays.asList(OPERATION_REQUEST, EXTENSION_HELPER));
        annotationRules.put(EXTENDACTION,extendActionMap);
        
        extendFunctionMap.put(NAME,EXTENDFUNCTION);
        extendFunctionMap.put(ACCESS_MODIFIER,PUBLIC);
        extendFunctionMap.put(RETURN_TYPE,OPERATION_RESPONSE);
        extendFunctionMap.put(INPUT_PARAMS,Arrays.asList(OPERATION_REQUEST, EXTENSION_HELPER));
        annotationRules.put(EXTENDFUNCTION,extendFunctionMap);
        
        
		return annotationRules;
	
	}
/**
 * 
 * @param annoRulesObj
 * 			Map
 * @return returnValue
 * 			boolean 
 */
	public boolean validateAnnoRules(Map<String, Map<String, Object>> annoRulesObj) {
		boolean returnValue = true;
		Pattern checkDigitPattern = Pattern.compile(".*\\d.*");
		Set<String> acceptableAccessModifierSet = new HashSet<>();
		acceptableAccessModifierSet.add(PUBLIC);
		acceptableAccessModifierSet.add("private");
		acceptableAccessModifierSet.add("default");
		acceptableAccessModifierSet.add("protected");

		Set<String> acceptableKeySet = new HashSet<>();
		acceptableKeySet.add(NAME);
		acceptableKeySet.add(ACCESS_MODIFIER);
		acceptableKeySet.add(RETURN_TYPE);
		acceptableKeySet.add(INPUT_PARAMS);

		int countErrorMsg = 0;
		StringBuilder allErrorMessage = new StringBuilder("");
			for (Entry<String, Map<String, Object>> entry : annoRulesObj.entrySet()) {
				String key = entry.getKey();
				
				Map<String, Object> value = entry.getValue();

				Set<String> keySet = value.keySet();

				if (!keySet.equals(acceptableKeySet)) {
					returnValue = false;
					countErrorMsg++;
					allErrorMessage.append("\n" + countErrorMsg + ". The key set value for " + key + " must be "
							+ acceptableKeySet.toString());
				}
				for (Entry<String, Object> subEntry : (value.entrySet())) {
					String subKey = subEntry.getKey(); 
					String nameValue = null;
					String accessModifier = null;
					List<String> inputParams = null;
					if (NAME.equals(subKey)) {
						/* check if the value of name is of type string */
						
						if(subEntry.getValue() instanceof String){
							nameValue = (String) subEntry.getValue();
						}else{
							countErrorMsg++;
							allErrorMessage
							.append("\n" + countErrorMsg + ". " + key + "-> name -> value must be type string");
							
						}

						if (!(nameValue != null && nameValue.equals(key))) {
							countErrorMsg++;
							allErrorMessage.append("\n" + countErrorMsg + ". " + key + "-> name -> value must be " + key);
						}

					} else if (RETURN_TYPE.equals(subKey)) {
						
						
						 if(!(subEntry.getValue() instanceof String)){
							
							 countErrorMsg++;
								allErrorMessage.append(
										"\n" + countErrorMsg + ". " + key + "-> returnType -> value must be type string");
						 }

					} else if (INPUT_PARAMS.equals(subKey)) {
						
						if( (subEntry.getValue()) instanceof List<?> ){
							List<?> paramList = (List<?>) subEntry.getValue();
							if(!paramList.isEmpty()){
								if( paramList.get(0) instanceof String){
									inputParams = (List<String>) subEntry.getValue();
								}
								else{
									countErrorMsg++;
									allErrorMessage.append("\n" + countErrorMsg + ". " + key
											+ ERROR_MSG);
								}
								
							}
							else{
								countErrorMsg++;
								allErrorMessage.append("\n" + countErrorMsg + ". " + key
										+ ERROR_MSG);
							}
							
						}else{
							countErrorMsg++;
							allErrorMessage.append("\n" + countErrorMsg + ". " + key
									+ ERROR_MSG);
						}
						if (inputParams != null) {

							for (int i = 0; i < inputParams.size(); i++) {
								String param = null;

								param = inputParams.get(i);

								if (param != null && checkDigitPattern.matcher(param).matches()) {
									countErrorMsg++;
									allErrorMessage.append("\n" + countErrorMsg + ". " + key
											+ "-> inputParams -> value must be a list of strings without any digits");
								}
							}
						}
					} else if (ACCESS_MODIFIER.equals(subKey)) {
				
						
					  if( (subEntry.getValue() instanceof String)){  
						  accessModifier = (String) subEntry.getValue();
						  
					    } else{
					    	 countErrorMsg++;
								allErrorMessage.append(
										"\n" + countErrorMsg + ". " + key + "-> accessModifier -> value must be type string");
					    }
						  
						  
						if (!acceptableAccessModifierSet.contains(accessModifier)) {

							countErrorMsg++;
							allErrorMessage.append(
									"\n" + countErrorMsg + ". " + key + "-> accessModifier must be on of the following "
											+ acceptableAccessModifierSet.toString());
						}
					}
				}
			}
		

		if (countErrorMsg > 0) {
			
			throw new AnnotationException("Found " + countErrorMsg +
					 " errors in Annotation Rules:" + allErrorMessage.toString());
		
			 
		}
		return returnValue;
	}

	@Override
	public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
		Messager messager = processingEnv.getMessager();
		for (TypeElement te : annotations) {
			for (Element e : roundEnv.getElementsAnnotatedWith(te)) {
				checkAndValidateAnnotationIfPresent(e, messager);
			}
		}
		return true;
	}

	/**
	 * Checks the access modifier for the annotated method.
	 * @return message
	 * 			 message 
	 * 
	 * @param methodSimpleName
	 *            annotated method name
	 * @param executableElement
	 *            the element to be proccesed
	 * @param acceptableAccessModifier
	 *            the access modifier
	 */
	public String checkAccessModifier(Name methodSimpleName, ExecutableElement executableElement,
			String acceptableAccessModifier) {

		StringBuilder message = new StringBuilder("");
		Set<Modifier> modifiers = executableElement.getModifiers();
		boolean correctModifierFlag = false;
		for (Modifier modifier : modifiers) {
			if (modifier.toString().equals(acceptableAccessModifier)) {
				correctModifierFlag = true;
				break;
			}
		}
		if (!correctModifierFlag) {
			message = new StringBuilder(
					"Method " + methodSimpleName.toString() + " must be a " + acceptableAccessModifier + " method.");

		}
		return message.toString();
	}

	/**
	 * Formats the list of strings and return a string like "(a,b,c,..)".
	 * 
	 * @param params
	 * @return String
	 * 			the formatted coma seperated paramteres string
	 */
	private String extractParams(List<String> params) {

		int paramSize = params.size();
		StringBuilder message = new StringBuilder("(");

		for (int i = 0; i < paramSize; i++) {
			if (i == 0) {
				message.append(params.get(i));
			} else {
				message.append(", " + params.get(i));
			}
		}
		message.append(")");
		return message.toString();
	}

	/**
	 * Checks the arguments passed to the annoted method and validates them.
	 * @return message
	 * 			message
	 * @param methodSimpleName
	 *            annotated method name
	 * @param executableElement
	 *            the element to be proccesed
	 * @param acceptableParam
	 *            the list of acceptable argument strings
	 */
	public String checkImportingParams(Name methodSimpleName, ExecutableElement executableElement,
			List<String> acceptableParam) {
		StringBuilder message = new StringBuilder("");

		List<? extends VariableElement> parameters = executableElement.getParameters();
		int paramSize = parameters.size();
		int acceptableParamSize = acceptableParam.size();

		VariableElement paramve;
		TypeMirror paramMirror;
		boolean createErrorMessage = false;

		/* check the arguments size */
		if (paramSize == 0 && acceptableParamSize > 0) {
			message = new StringBuilder("The method " + methodSimpleName.toString() + "() must have the parameters "
					+ extractParams(acceptableParam) + ".");
		} else if (paramSize != acceptableParamSize) {
			createErrorMessage = true;
		} else {
			/* check order of arguments with acceptable arguments */
			for (int i = 0; i < acceptableParamSize; i++) {
				paramve = parameters.get(i);
				paramMirror = paramve.asType();

				if (!(paramMirror.toString().equals(acceptableParam.get(i)))) {
					createErrorMessage = true;
					break;
				}
			}

		}
		/*
		 * The parameters (a, b, c) does not match the method xyz (j, k, l)
		 * 
		 */
		if (createErrorMessage) {
			message = new StringBuilder("The parameters (");
			for (int i = 0; i < paramSize; i++) {
				paramve = parameters.get(i);
				paramMirror = paramve.asType();

				if (i == 0) {
					message.append(paramMirror.toString());
				} else {
					message.append(", " + paramMirror.toString());
				}
			}
			message.append(") does not match the method " + methodSimpleName.toString() + extractParams(acceptableParam)
					+ ".");
		}

		return message.toString();
	}

	/**
	 * Checks and vallidates the return type for the annotated method.
	 * @return message
	 * 			message
	 * @param methodSimpleName
	 *            annotated method name
	 * @param executableElement
	 *            the element to be proccesed
	 * @param returnType
	 *            acceptable return type for the annotated method
	 */
	public String checkReturnType(Name methodSimpleName, ExecutableElement executableElement, String returnType) {

		TypeMirror returnTypeMirror;
		StringBuilder message = new StringBuilder("");
		returnTypeMirror = executableElement.getReturnType();
		/*-- when there is a Return type Return Type--*/
		if (returnTypeMirror == null || !(returnTypeMirror.toString().equals(returnType))) {

			message = new StringBuilder(
					"Method " + methodSimpleName.toString() + " must return an object of " + returnType + ".");
		}

		return message.toString();

	}

	/**
	 * Checks and validates the supported annotations and the respective
	 * annotated methods.
	 * 
	 * @param e
	 *            - element
	 * @param messager
	 *            - to report error
	 * @param te
	 *            - the element type
	 */

	@SuppressWarnings("unchecked")
	public void checkAndValidateAnnotationIfPresent(Element e, Messager messager) {
		List<AnnotationMirror> amlist = (List<AnnotationMirror>) e.getAnnotationMirrors();
		AnnotationMirror am = amlist.get(0);
		String annoDefinition = am.toString();
		String[] annoDefinationStr = annoDefinition.split("\\(");
		String annoName = annoDefinationStr[0];
		Object value = annoRules.get(annoName);
		if (value != null) {

			String returnType = null;
			String accessModifier = null;
			List<String> inputParams = null;
			for (Entry<String, Object> subEntry : ((Map<String, Object>) value).entrySet()) {
				String key = subEntry.getKey();
				if (RETURN_TYPE.equals(key)) {
					returnType = (String) subEntry.getValue();
				} else if (INPUT_PARAMS.equals(key)) {
					inputParams =  (List<String>) subEntry.getValue();
				} else if (ACCESS_MODIFIER.equals(key)) {
					accessModifier = (String) subEntry.getValue();
				}
			}

			Name methodSimpleName = e.getSimpleName();
			/*--  A method is an Executable Element --*/
			ExecutableElement executableElement = (ExecutableElement) e;

			/*-- Importing Parameter type Check --*/
			String importingParamsErrorMsg = checkImportingParams(methodSimpleName, executableElement, inputParams);
			printValidationMsg(importingParamsErrorMsg,messager,e);
			/*-- Check for Return Type--*/
			String returnTypeErrorMsg = checkReturnType(methodSimpleName, executableElement, returnType);
			printValidationMsg(returnTypeErrorMsg,messager,e);

			/*-- Modifier Check --*/
			String accessModifierErrorMsg = checkAccessModifier(methodSimpleName, executableElement, accessModifier);
			printValidationMsg(accessModifierErrorMsg,messager,e);

			
		}
	}
	
	private void printValidationMsg(String errorMsg, Messager messager,Element e ){
		
		if (errorMsg != null && !("").equals(errorMsg)) {
			messager.printMessage(messageKind, errorMsg, e);

		}
	}
}

@SuppressWarnings("serial")
class AnnotationException extends RuntimeException{

	   public AnnotationException(String message){
	      super(message);
	   }

	}
