/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.producer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.provider.AnnotationAttribute;
import org.apache.olingo.odata2.api.edm.provider.AnnotationElement;
import org.apache.olingo.odata2.api.edm.provider.Association;
import org.apache.olingo.odata2.api.edm.provider.AssociationEnd;
import org.apache.olingo.odata2.api.edm.provider.AssociationSet;
import org.apache.olingo.odata2.api.edm.provider.AssociationSetEnd;
import org.apache.olingo.odata2.api.edm.provider.ComplexProperty;
import org.apache.olingo.odata2.api.edm.provider.ComplexType;
import org.apache.olingo.odata2.api.edm.provider.CustomizableFeedMappings;
import org.apache.olingo.odata2.api.edm.provider.DataServices;
import org.apache.olingo.odata2.api.edm.provider.Documentation;
import org.apache.olingo.odata2.api.edm.provider.EntityContainer;
import org.apache.olingo.odata2.api.edm.provider.EntitySet;
import org.apache.olingo.odata2.api.edm.provider.EntityType;
import org.apache.olingo.odata2.api.edm.provider.FunctionImport;
import org.apache.olingo.odata2.api.edm.provider.FunctionImportParameter;
import org.apache.olingo.odata2.api.edm.provider.Key;
import org.apache.olingo.odata2.api.edm.provider.NavigationProperty;
import org.apache.olingo.odata2.api.edm.provider.OnDelete;
import org.apache.olingo.odata2.api.edm.provider.Property;
import org.apache.olingo.odata2.api.edm.provider.PropertyRef;
import org.apache.olingo.odata2.api.edm.provider.ReferentialConstraint;
import org.apache.olingo.odata2.api.edm.provider.ReferentialConstraintRole;
import org.apache.olingo.odata2.api.edm.provider.Schema;
import org.apache.olingo.odata2.api.edm.provider.SimpleProperty;
import org.apache.olingo.odata2.api.edm.provider.Using;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.core.ep.EntityProviderProducerException;
import org.apache.olingo.odata2.core.exception.ODataRuntimeException;

public class XmlMetadataProducer {
    public static void writeMetadata(DataServices metadata, XMLStreamWriter xmlStreamWriter, Map<String, String> predefinedNamespaces) throws EntityProviderException {
        try {
            String edmxNamespace = "http://schemas.microsoft.com/ado/2007/06/edmx";
            String defaultNamespace = "http://schemas.microsoft.com/ado/2008/09/edm";
            if (predefinedNamespaces == null) {
                predefinedNamespaces = new HashMap<String, String>();
            } else {
                String string;
                String predefinedEdmxNamespace = predefinedNamespaces.get("edmx");
                if (predefinedEdmxNamespace != null) {
                    edmxNamespace = predefinedEdmxNamespace;
                    predefinedNamespaces.remove("edmx");
                }
                if ((string = predefinedNamespaces.get(null)) != null) {
                    defaultNamespace = string;
                    predefinedNamespaces.remove(null);
                }
            }
            xmlStreamWriter.writeStartDocument();
            xmlStreamWriter.setPrefix("edmx", edmxNamespace);
            xmlStreamWriter.setPrefix("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata");
            xmlStreamWriter.writeStartElement(edmxNamespace, "Edmx");
            xmlStreamWriter.writeNamespace("edmx", edmxNamespace);
            if (metadata.getCustomEdmxVersion() == null) {
                xmlStreamWriter.writeAttribute("Version", "1.0");
            } else {
                xmlStreamWriter.writeAttribute("Version", metadata.getCustomEdmxVersion());
            }
            for (Map.Entry entry : predefinedNamespaces.entrySet()) {
                xmlStreamWriter.writeNamespace((String)entry.getKey(), (String)entry.getValue());
            }
            XmlMetadataProducer.writeAnnotationElements(metadata.getAnnotationElements(), predefinedNamespaces, xmlStreamWriter);
            xmlStreamWriter.writeStartElement(edmxNamespace, "DataServices");
            xmlStreamWriter.setDefaultNamespace(defaultNamespace);
            xmlStreamWriter.writeAttribute("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "DataServiceVersion", metadata.getDataServiceVersion());
            xmlStreamWriter.writeNamespace("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata");
            List<Schema> schemas = metadata.getSchemas();
            if (schemas != null) {
                for (Schema schema : schemas) {
                    List<EntityContainer> list;
                    List<Association> associations;
                    List<ComplexType> list2;
                    List<Property> properties;
                    List<EntityType> entityTypes;
                    xmlStreamWriter.writeStartElement("Schema");
                    if (schema.getAlias() != null) {
                        xmlStreamWriter.writeAttribute("Alias", schema.getAlias());
                    }
                    xmlStreamWriter.writeAttribute("Namespace", schema.getNamespace());
                    xmlStreamWriter.writeDefaultNamespace(defaultNamespace);
                    XmlMetadataProducer.writeAnnotationAttributes(schema.getAnnotationAttributes(), predefinedNamespaces, null, xmlStreamWriter);
                    List<Using> usings = schema.getUsings();
                    if (usings != null) {
                        for (Using using : usings) {
                            xmlStreamWriter.writeStartElement("Using");
                            xmlStreamWriter.writeAttribute("Namespace", using.getNamespace());
                            xmlStreamWriter.writeAttribute("Alias", using.getAlias());
                            XmlMetadataProducer.writeAnnotationAttributes(using.getAnnotationAttributes(), predefinedNamespaces, null, xmlStreamWriter);
                            XmlMetadataProducer.writeDocumentation(using.getDocumentation(), predefinedNamespaces, xmlStreamWriter);
                            XmlMetadataProducer.writeAnnotationElements(using.getAnnotationElements(), predefinedNamespaces, xmlStreamWriter);
                            xmlStreamWriter.writeEndElement();
                        }
                    }
                    if ((entityTypes = schema.getEntityTypes()) != null) {
                        for (Object entityType : entityTypes) {
                            List<NavigationProperty> navigationProperties;
                            xmlStreamWriter.writeStartElement("EntityType");
                            xmlStreamWriter.writeAttribute("Name", ((ComplexType)entityType).getName());
                            if (((ComplexType)entityType).getBaseType() != null) {
                                xmlStreamWriter.writeAttribute("BaseType", ((ComplexType)entityType).getBaseType().toString());
                            }
                            if (((ComplexType)entityType).isAbstract()) {
                                xmlStreamWriter.writeAttribute("Abstract", "true");
                            }
                            if (((EntityType)entityType).isHasStream()) {
                                xmlStreamWriter.writeAttribute("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "HasStream", "true");
                            }
                            XmlMetadataProducer.writeCustomizableFeedMappings(((EntityType)entityType).getCustomizableFeedMappings(), xmlStreamWriter);
                            XmlMetadataProducer.writeAnnotationAttributes(((ComplexType)entityType).getAnnotationAttributes(), predefinedNamespaces, null, xmlStreamWriter);
                            XmlMetadataProducer.writeDocumentation(((ComplexType)entityType).getDocumentation(), predefinedNamespaces, xmlStreamWriter);
                            Key key = ((EntityType)entityType).getKey();
                            if (key != null) {
                                xmlStreamWriter.writeStartElement("Key");
                                XmlMetadataProducer.writeAnnotationAttributes(key.getAnnotationAttributes(), predefinedNamespaces, null, xmlStreamWriter);
                                List<PropertyRef> propertyRefs = ((EntityType)entityType).getKey().getKeys();
                                for (PropertyRef propertyRef : propertyRefs) {
                                    xmlStreamWriter.writeStartElement("PropertyRef");
                                    XmlMetadataProducer.writeAnnotationAttributes(propertyRef.getAnnotationAttributes(), predefinedNamespaces, null, xmlStreamWriter);
                                    xmlStreamWriter.writeAttribute("Name", propertyRef.getName());
                                    XmlMetadataProducer.writeAnnotationElements(propertyRef.getAnnotationElements(), predefinedNamespaces, xmlStreamWriter);
                                    xmlStreamWriter.writeEndElement();
                                }
                                XmlMetadataProducer.writeAnnotationElements(key.getAnnotationElements(), predefinedNamespaces, xmlStreamWriter);
                                xmlStreamWriter.writeEndElement();
                            }
                            if ((properties = ((ComplexType)entityType).getProperties()) != null) {
                                XmlMetadataProducer.writeProperties(properties, predefinedNamespaces, xmlStreamWriter);
                            }
                            if ((navigationProperties = ((EntityType)entityType).getNavigationProperties()) != null) {
                                for (Object navigationProperty : navigationProperties) {
                                    xmlStreamWriter.writeStartElement("NavigationProperty");
                                    xmlStreamWriter.writeAttribute("Name", ((NavigationProperty)navigationProperty).getName());
                                    xmlStreamWriter.writeAttribute("Relationship", ((NavigationProperty)navigationProperty).getRelationship().toString());
                                    xmlStreamWriter.writeAttribute("FromRole", ((NavigationProperty)navigationProperty).getFromRole());
                                    xmlStreamWriter.writeAttribute("ToRole", ((NavigationProperty)navigationProperty).getToRole());
                                    XmlMetadataProducer.writeAnnotationAttributes(((NavigationProperty)navigationProperty).getAnnotationAttributes(), predefinedNamespaces, null, xmlStreamWriter);
                                    XmlMetadataProducer.writeDocumentation(((NavigationProperty)navigationProperty).getDocumentation(), predefinedNamespaces, xmlStreamWriter);
                                    XmlMetadataProducer.writeAnnotationElements(((NavigationProperty)navigationProperty).getAnnotationElements(), predefinedNamespaces, xmlStreamWriter);
                                    xmlStreamWriter.writeEndElement();
                                }
                            }
                            XmlMetadataProducer.writeAnnotationElements(((ComplexType)entityType).getAnnotationElements(), predefinedNamespaces, xmlStreamWriter);
                            xmlStreamWriter.writeEndElement();
                        }
                    }
                    if ((list2 = schema.getComplexTypes()) != null) {
                        Object entityType;
                        entityType = list2.iterator();
                        while (entityType.hasNext()) {
                            ComplexType complexType = (ComplexType)entityType.next();
                            xmlStreamWriter.writeStartElement("ComplexType");
                            xmlStreamWriter.writeAttribute("Name", complexType.getName());
                            if (complexType.getBaseType() != null) {
                                xmlStreamWriter.writeAttribute("BaseType", complexType.getBaseType().toString());
                            }
                            if (complexType.isAbstract()) {
                                xmlStreamWriter.writeAttribute("Abstract", "true");
                            }
                            XmlMetadataProducer.writeAnnotationAttributes(complexType.getAnnotationAttributes(), predefinedNamespaces, null, xmlStreamWriter);
                            XmlMetadataProducer.writeDocumentation(complexType.getDocumentation(), predefinedNamespaces, xmlStreamWriter);
                            properties = complexType.getProperties();
                            if (properties != null) {
                                XmlMetadataProducer.writeProperties(properties, predefinedNamespaces, xmlStreamWriter);
                            }
                            XmlMetadataProducer.writeAnnotationElements(complexType.getAnnotationElements(), predefinedNamespaces, xmlStreamWriter);
                            xmlStreamWriter.writeEndElement();
                        }
                    }
                    if ((associations = schema.getAssociations()) != null) {
                        for (Association association : associations) {
                            xmlStreamWriter.writeStartElement("Association");
                            xmlStreamWriter.writeAttribute("Name", association.getName());
                            XmlMetadataProducer.writeAnnotationAttributes(association.getAnnotationAttributes(), predefinedNamespaces, null, xmlStreamWriter);
                            XmlMetadataProducer.writeDocumentation(association.getDocumentation(), predefinedNamespaces, xmlStreamWriter);
                            XmlMetadataProducer.writeAssociationEnd(association.getEnd1(), predefinedNamespaces, xmlStreamWriter);
                            XmlMetadataProducer.writeAssociationEnd(association.getEnd2(), predefinedNamespaces, xmlStreamWriter);
                            ReferentialConstraint referentialConstraint = association.getReferentialConstraint();
                            if (referentialConstraint != null) {
                                Object navigationProperty;
                                xmlStreamWriter.writeStartElement("ReferentialConstraint");
                                XmlMetadataProducer.writeAnnotationAttributes(referentialConstraint.getAnnotationAttributes(), predefinedNamespaces, null, xmlStreamWriter);
                                XmlMetadataProducer.writeDocumentation(referentialConstraint.getDocumentation(), predefinedNamespaces, xmlStreamWriter);
                                ReferentialConstraintRole referentialConstraintRole = referentialConstraint.getPrincipal();
                                xmlStreamWriter.writeStartElement("Principal");
                                xmlStreamWriter.writeAttribute("Role", referentialConstraintRole.getRole());
                                XmlMetadataProducer.writeAnnotationAttributes(referentialConstraintRole.getAnnotationAttributes(), predefinedNamespaces, null, xmlStreamWriter);
                                navigationProperty = referentialConstraintRole.getPropertyRefs().iterator();
                                while (navigationProperty.hasNext()) {
                                    PropertyRef propertyRef = (PropertyRef)navigationProperty.next();
                                    xmlStreamWriter.writeStartElement("PropertyRef");
                                    xmlStreamWriter.writeAttribute("Name", propertyRef.getName());
                                    xmlStreamWriter.writeEndElement();
                                }
                                XmlMetadataProducer.writeAnnotationElements(referentialConstraintRole.getAnnotationElements(), predefinedNamespaces, xmlStreamWriter);
                                xmlStreamWriter.writeEndElement();
                                ReferentialConstraintRole dependent = referentialConstraint.getDependent();
                                xmlStreamWriter.writeStartElement("Dependent");
                                xmlStreamWriter.writeAttribute("Role", dependent.getRole());
                                XmlMetadataProducer.writeAnnotationAttributes(dependent.getAnnotationAttributes(), predefinedNamespaces, null, xmlStreamWriter);
                                for (PropertyRef propertyRef3 : dependent.getPropertyRefs()) {
                                    xmlStreamWriter.writeStartElement("PropertyRef");
                                    xmlStreamWriter.writeAttribute("Name", propertyRef3.getName());
                                    xmlStreamWriter.writeEndElement();
                                }
                                XmlMetadataProducer.writeAnnotationElements(dependent.getAnnotationElements(), predefinedNamespaces, xmlStreamWriter);
                                xmlStreamWriter.writeEndElement();
                                XmlMetadataProducer.writeAnnotationElements(referentialConstraint.getAnnotationElements(), predefinedNamespaces, xmlStreamWriter);
                                xmlStreamWriter.writeEndElement();
                            }
                            XmlMetadataProducer.writeAnnotationElements(association.getAnnotationElements(), predefinedNamespaces, xmlStreamWriter);
                            xmlStreamWriter.writeEndElement();
                        }
                    }
                    if ((list = schema.getEntityContainers()) != null) {
                        for (EntityContainer entityContainer : list) {
                            List<FunctionImport> list3;
                            List<AssociationSet> associationSets;
                            xmlStreamWriter.writeStartElement("EntityContainer");
                            xmlStreamWriter.writeAttribute("Name", entityContainer.getName());
                            if (entityContainer.getExtendz() != null) {
                                xmlStreamWriter.writeAttribute("Extendz", entityContainer.getExtendz());
                            }
                            if (entityContainer.isDefaultEntityContainer()) {
                                xmlStreamWriter.writeAttribute("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "IsDefaultEntityContainer", "true");
                            }
                            XmlMetadataProducer.writeAnnotationAttributes(entityContainer.getAnnotationAttributes(), predefinedNamespaces, null, xmlStreamWriter);
                            XmlMetadataProducer.writeDocumentation(entityContainer.getDocumentation(), predefinedNamespaces, xmlStreamWriter);
                            List<EntitySet> list4 = entityContainer.getEntitySets();
                            if (list4 != null) {
                                for (EntitySet entitySet : list4) {
                                    xmlStreamWriter.writeStartElement("EntitySet");
                                    xmlStreamWriter.writeAttribute("Name", entitySet.getName());
                                    xmlStreamWriter.writeAttribute("EntityType", entitySet.getEntityType().toString());
                                    XmlMetadataProducer.writeAnnotationAttributes(entitySet.getAnnotationAttributes(), predefinedNamespaces, null, xmlStreamWriter);
                                    XmlMetadataProducer.writeDocumentation(entitySet.getDocumentation(), predefinedNamespaces, xmlStreamWriter);
                                    XmlMetadataProducer.writeAnnotationElements(entitySet.getAnnotationElements(), predefinedNamespaces, xmlStreamWriter);
                                    xmlStreamWriter.writeEndElement();
                                }
                            }
                            if ((associationSets = entityContainer.getAssociationSets()) != null) {
                                for (AssociationSet associationSet : associationSets) {
                                    xmlStreamWriter.writeStartElement("AssociationSet");
                                    xmlStreamWriter.writeAttribute("Name", associationSet.getName());
                                    xmlStreamWriter.writeAttribute("Association", associationSet.getAssociation().toString());
                                    XmlMetadataProducer.writeAnnotationAttributes(associationSet.getAnnotationAttributes(), predefinedNamespaces, null, xmlStreamWriter);
                                    XmlMetadataProducer.writeDocumentation(associationSet.getDocumentation(), predefinedNamespaces, xmlStreamWriter);
                                    XmlMetadataProducer.writeAssociationSetEnd(associationSet.getEnd1(), predefinedNamespaces, xmlStreamWriter);
                                    XmlMetadataProducer.writeAssociationSetEnd(associationSet.getEnd2(), predefinedNamespaces, xmlStreamWriter);
                                    XmlMetadataProducer.writeAnnotationElements(associationSet.getAnnotationElements(), predefinedNamespaces, xmlStreamWriter);
                                    xmlStreamWriter.writeEndElement();
                                }
                            }
                            if ((list3 = entityContainer.getFunctionImports()) != null) {
                                for (FunctionImport functionImport : list3) {
                                    xmlStreamWriter.writeStartElement("FunctionImport");
                                    xmlStreamWriter.writeAttribute("Name", functionImport.getName());
                                    if (functionImport.getReturnType() != null) {
                                        xmlStreamWriter.writeAttribute("ReturnType", functionImport.getReturnType().toString());
                                    }
                                    if (functionImport.getEntitySet() != null) {
                                        xmlStreamWriter.writeAttribute("EntitySet", functionImport.getEntitySet());
                                    }
                                    if (functionImport.getHttpMethod() != null) {
                                        xmlStreamWriter.writeAttribute("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "HttpMethod", functionImport.getHttpMethod());
                                    }
                                    XmlMetadataProducer.writeAnnotationAttributes(functionImport.getAnnotationAttributes(), predefinedNamespaces, null, xmlStreamWriter);
                                    XmlMetadataProducer.writeDocumentation(functionImport.getDocumentation(), predefinedNamespaces, xmlStreamWriter);
                                    List<FunctionImportParameter> functionImportParameters = functionImport.getParameters();
                                    if (functionImportParameters != null) {
                                        for (FunctionImportParameter functionImportParameter : functionImportParameters) {
                                            xmlStreamWriter.writeStartElement("Parameter");
                                            xmlStreamWriter.writeAttribute("Name", functionImportParameter.getName());
                                            xmlStreamWriter.writeAttribute("Type", functionImportParameter.getType().getFullQualifiedName().toString());
                                            if (functionImportParameter.getMode() != null) {
                                                xmlStreamWriter.writeAttribute("Mode", functionImportParameter.getMode());
                                            }
                                            XmlMetadataProducer.writeFacets(xmlStreamWriter, functionImportParameter.getFacets());
                                            XmlMetadataProducer.writeAnnotationAttributes(functionImportParameter.getAnnotationAttributes(), predefinedNamespaces, null, xmlStreamWriter);
                                            XmlMetadataProducer.writeDocumentation(functionImportParameter.getDocumentation(), predefinedNamespaces, xmlStreamWriter);
                                            XmlMetadataProducer.writeAnnotationElements(functionImportParameter.getAnnotationElements(), predefinedNamespaces, xmlStreamWriter);
                                            xmlStreamWriter.writeEndElement();
                                        }
                                    }
                                    XmlMetadataProducer.writeAnnotationElements(functionImport.getAnnotationElements(), predefinedNamespaces, xmlStreamWriter);
                                    xmlStreamWriter.writeEndElement();
                                }
                            }
                            XmlMetadataProducer.writeAnnotationElements(entityContainer.getAnnotationElements(), predefinedNamespaces, xmlStreamWriter);
                            xmlStreamWriter.writeEndElement();
                        }
                    }
                    XmlMetadataProducer.writeAnnotationElements(schema.getAnnotationElements(), predefinedNamespaces, xmlStreamWriter);
                    xmlStreamWriter.writeEndElement();
                }
            }
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndDocument();
            xmlStreamWriter.flush();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderProducerException(EntityProviderException.COMMON, (Throwable)e);
        }
        catch (FactoryConfigurationError e) {
            throw new EntityProviderProducerException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private static void writeCustomizableFeedMappings(CustomizableFeedMappings customizableFeedMappings, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        if (customizableFeedMappings != null) {
            if (customizableFeedMappings.getFcKeepInContent() != null) {
                xmlStreamWriter.writeAttribute("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "FC_KeepInContent", customizableFeedMappings.getFcKeepInContent().toString().toLowerCase(Locale.ROOT));
            }
            if (customizableFeedMappings.getFcContentKind() != null) {
                xmlStreamWriter.writeAttribute("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "FC_ContentKind", customizableFeedMappings.getFcContentKind().toString());
            }
            if (customizableFeedMappings.getFcNsPrefix() != null) {
                xmlStreamWriter.writeAttribute("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "FC_NsPrefix", customizableFeedMappings.getFcNsPrefix());
            }
            if (customizableFeedMappings.getFcNsUri() != null) {
                xmlStreamWriter.writeAttribute("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "FC_NsUri", customizableFeedMappings.getFcNsUri());
            }
            if (customizableFeedMappings.getFcSourcePath() != null) {
                xmlStreamWriter.writeAttribute("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "FC_SourcePath", customizableFeedMappings.getFcSourcePath());
            }
            if (customizableFeedMappings.getFcTargetPath() != null) {
                xmlStreamWriter.writeAttribute("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "FC_TargetPath", customizableFeedMappings.getFcTargetPath().toString());
            }
        }
    }

    private static void writeProperties(Collection<Property> properties, Map<String, String> predefinedNamespaces, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        for (Property property : properties) {
            xmlStreamWriter.writeStartElement("Property");
            xmlStreamWriter.writeAttribute("Name", property.getName());
            if (property instanceof SimpleProperty) {
                xmlStreamWriter.writeAttribute("Type", ((SimpleProperty)property).getType().getFullQualifiedName().toString());
            } else if (property instanceof ComplexProperty) {
                xmlStreamWriter.writeAttribute("Type", ((ComplexProperty)property).getType().toString());
            } else {
                throw new ODataRuntimeException();
            }
            XmlMetadataProducer.writeFacets(xmlStreamWriter, property.getFacets());
            if (property.getMimeType() != null) {
                xmlStreamWriter.writeAttribute("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "MimeType", property.getMimeType());
            }
            XmlMetadataProducer.writeCustomizableFeedMappings(property.getCustomizableFeedMappings(), xmlStreamWriter);
            XmlMetadataProducer.writeAnnotationAttributes(property.getAnnotationAttributes(), predefinedNamespaces, null, xmlStreamWriter);
            XmlMetadataProducer.writeDocumentation(property.getDocumentation(), predefinedNamespaces, xmlStreamWriter);
            XmlMetadataProducer.writeAnnotationElements(property.getAnnotationElements(), predefinedNamespaces, xmlStreamWriter);
            xmlStreamWriter.writeEndElement();
        }
    }

    private static void writeFacets(XMLStreamWriter xmlStreamWriter, EdmFacets facets) throws XMLStreamException {
        if (facets != null) {
            if (facets.isNullable() != null) {
                xmlStreamWriter.writeAttribute("Nullable", facets.isNullable().toString().toLowerCase(Locale.ROOT));
            }
            if (facets.getDefaultValue() != null) {
                xmlStreamWriter.writeAttribute("DefaultValue", facets.getDefaultValue());
            }
            if (facets.getMaxLength() != null) {
                xmlStreamWriter.writeAttribute("MaxLength", facets.getMaxLength().toString());
            }
            if (facets.isFixedLength() != null) {
                xmlStreamWriter.writeAttribute("FixedLength", facets.isFixedLength().toString().toLowerCase(Locale.ROOT));
            }
            if (facets.getPrecision() != null) {
                xmlStreamWriter.writeAttribute("Precision", facets.getPrecision().toString());
            }
            if (facets.getScale() != null) {
                xmlStreamWriter.writeAttribute("Scale", facets.getScale().toString());
            }
            if (facets.isUnicode() != null) {
                xmlStreamWriter.writeAttribute("Unicode", facets.isUnicode().toString());
            }
            if (facets.getCollation() != null) {
                xmlStreamWriter.writeAttribute("Collation", facets.getCollation());
            }
            if (facets.getConcurrencyMode() != null) {
                xmlStreamWriter.writeAttribute("ConcurrencyMode", facets.getConcurrencyMode().toString());
            }
        }
    }

    private static void writeAssociationEnd(AssociationEnd end, Map<String, String> predefinedNamespaces, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("End");
        xmlStreamWriter.writeAttribute("Type", end.getType().toString());
        xmlStreamWriter.writeAttribute("Multiplicity", end.getMultiplicity().toString());
        if (end.getRole() != null) {
            xmlStreamWriter.writeAttribute("Role", end.getRole());
        }
        XmlMetadataProducer.writeAnnotationAttributes(end.getAnnotationAttributes(), predefinedNamespaces, null, xmlStreamWriter);
        XmlMetadataProducer.writeDocumentation(end.getDocumentation(), predefinedNamespaces, xmlStreamWriter);
        OnDelete onDelete = end.getOnDelete();
        if (onDelete != null) {
            xmlStreamWriter.writeStartElement("OnDelete");
            xmlStreamWriter.writeAttribute("Action", onDelete.getAction().toString());
            XmlMetadataProducer.writeAnnotationAttributes(onDelete.getAnnotationAttributes(), predefinedNamespaces, null, xmlStreamWriter);
            XmlMetadataProducer.writeDocumentation(onDelete.getDocumentation(), predefinedNamespaces, xmlStreamWriter);
            XmlMetadataProducer.writeAnnotationElements(onDelete.getAnnotationElements(), predefinedNamespaces, xmlStreamWriter);
            xmlStreamWriter.writeEndElement();
        }
        XmlMetadataProducer.writeAnnotationElements(end.getAnnotationElements(), predefinedNamespaces, xmlStreamWriter);
        xmlStreamWriter.writeEndElement();
    }

    private static void writeAssociationSetEnd(AssociationSetEnd end, Map<String, String> predefinedNamespaces, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("End");
        xmlStreamWriter.writeAttribute("EntitySet", end.getEntitySet().toString());
        if (end.getRole() != null) {
            xmlStreamWriter.writeAttribute("Role", end.getRole());
        }
        XmlMetadataProducer.writeAnnotationAttributes(end.getAnnotationAttributes(), predefinedNamespaces, null, xmlStreamWriter);
        XmlMetadataProducer.writeDocumentation(end.getDocumentation(), predefinedNamespaces, xmlStreamWriter);
        XmlMetadataProducer.writeAnnotationElements(end.getAnnotationElements(), predefinedNamespaces, xmlStreamWriter);
        xmlStreamWriter.writeEndElement();
    }

    private static void writeDocumentation(Documentation documentation, Map<String, String> predefinedNamespaces, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        if (documentation != null) {
            xmlStreamWriter.writeStartElement("Documentation");
            XmlMetadataProducer.writeAnnotationAttributes(documentation.getAnnotationAttributes(), predefinedNamespaces, null, xmlStreamWriter);
            if (documentation.getSummary() != null) {
                xmlStreamWriter.writeStartElement("Summary");
                xmlStreamWriter.writeCharacters(documentation.getSummary());
                xmlStreamWriter.writeEndElement();
            }
            if (documentation.getLongDescription() != null) {
                xmlStreamWriter.writeStartElement("LongDescription");
                xmlStreamWriter.writeCharacters(documentation.getLongDescription());
                xmlStreamWriter.writeEndElement();
            }
            XmlMetadataProducer.writeAnnotationElements(documentation.getAnnotationElements(), predefinedNamespaces, xmlStreamWriter);
            xmlStreamWriter.writeEndElement();
        }
    }

    private static void writeAnnotationAttributes(Collection<AnnotationAttribute> annotationAttributes, Map<String, String> predefinedNamespaces, ArrayList<String> setNamespaces, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        if (annotationAttributes != null) {
            if (setNamespaces == null) {
                setNamespaces = new ArrayList();
            }
            for (AnnotationAttribute annotationAttribute : annotationAttributes) {
                if (annotationAttribute.getNamespace() != null) {
                    xmlStreamWriter.writeAttribute(annotationAttribute.getPrefix(), annotationAttribute.getNamespace(), annotationAttribute.getName(), annotationAttribute.getText());
                    if (setNamespaces.contains(annotationAttribute.getNamespace()) || predefinedNamespaces.containsValue(annotationAttribute.getNamespace())) continue;
                    xmlStreamWriter.writeNamespace(annotationAttribute.getPrefix(), annotationAttribute.getNamespace());
                    setNamespaces.add(annotationAttribute.getNamespace());
                    continue;
                }
                xmlStreamWriter.writeAttribute(annotationAttribute.getName(), annotationAttribute.getText());
            }
        }
    }

    private static void writeAnnotationElements(Collection<AnnotationElement> annotationElements, Map<String, String> predefinedNamespaces, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        if (annotationElements != null) {
            for (AnnotationElement annotationElement : annotationElements) {
                ArrayList<String> setNamespaces = new ArrayList<String>();
                if (annotationElement.getNamespace() != null) {
                    if (annotationElement.getPrefix() != null) {
                        xmlStreamWriter.writeStartElement(annotationElement.getPrefix(), annotationElement.getName(), annotationElement.getNamespace());
                        if (!predefinedNamespaces.containsValue(annotationElement.getNamespace())) {
                            xmlStreamWriter.writeNamespace(annotationElement.getPrefix(), annotationElement.getNamespace());
                            setNamespaces.add(annotationElement.getNamespace());
                        }
                    } else {
                        xmlStreamWriter.writeStartElement("", annotationElement.getName(), annotationElement.getNamespace());
                        if (!predefinedNamespaces.containsValue(annotationElement.getNamespace())) {
                            xmlStreamWriter.writeNamespace("", annotationElement.getNamespace());
                            setNamespaces.add(annotationElement.getNamespace());
                        }
                    }
                } else {
                    xmlStreamWriter.writeStartElement(annotationElement.getName());
                }
                XmlMetadataProducer.writeAnnotationAttributes(annotationElement.getAttributes(), predefinedNamespaces, setNamespaces, xmlStreamWriter);
                if (annotationElement.getChildElements() != null) {
                    XmlMetadataProducer.writeAnnotationElements(annotationElement.getChildElements(), predefinedNamespaces, xmlStreamWriter);
                } else if (annotationElement.getText() != null) {
                    xmlStreamWriter.writeCharacters(annotationElement.getText());
                }
                xmlStreamWriter.writeEndElement();
            }
        }
    }
}

