/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.client.core.ep.serializer;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.client.api.ep.Entity;
import org.apache.olingo.odata2.client.api.ep.EntityCollection;
import org.apache.olingo.odata2.client.api.ep.EntityCollectionSerializerProperties;
import org.apache.olingo.odata2.client.api.ep.EntitySerializerProperties;
import org.apache.olingo.odata2.client.core.ep.serializer.AtomEntryEntitySerializer;
import org.apache.olingo.odata2.client.core.ep.serializer.JsonFeedEntitySerializer;
import org.apache.olingo.odata2.client.core.ep.serializer.JsonLinkEntitySerializer;
import org.apache.olingo.odata2.client.core.ep.serializer.JsonPropertyEntitySerializer;
import org.apache.olingo.odata2.core.commons.ContentType;
import org.apache.olingo.odata2.core.ep.EntityProviderProducerException;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.util.JsonStreamWriter;

public class JsonEntryEntitySerializer {
    private final EntitySerializerProperties properties;
    private String location;
    private String idlocation;
    private JsonStreamWriter jsonStreamWriter;
    private static final String VALUE = "/$value";

    public JsonEntryEntitySerializer(EntitySerializerProperties properties) {
        this.properties = properties == null ? EntitySerializerProperties.serviceRoot(null).build() : properties;
    }

    public void append(Writer writer, EntityInfoAggregator entityInfo, Entity data) throws EntityProviderException {
        if (data == null) {
            throw new EntityProviderException(EntityProviderException.NULL_VALUE);
        }
        EdmEntityType type = entityInfo.getEntityType();
        try {
            this.jsonStreamWriter = new JsonStreamWriter(writer);
            this.jsonStreamWriter.beginObject();
            boolean containsMetadata = false;
            if (this.properties.isIncludeMetadata()) {
                this.writeMetadata(entityInfo, data.getProperties(), type);
                containsMetadata = true;
            }
            this.writeProperties(entityInfo, data.getProperties(), type, containsMetadata);
            this.writeNavigationProperties(writer, entityInfo, data.getNavigations(), type, data.getProperties().isEmpty());
            this.jsonStreamWriter.endObject();
            writer.flush();
        }
        catch (IOException e) {
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
        catch (EdmException e) {
            throw new EntityProviderProducerException(e.getMessageReference(), (Throwable)e);
        }
    }

    private void writeNavigationProperties(Writer writer, EntityInfoAggregator entityInfo, Map<String, Object> data, EdmEntityType type, boolean emptyData) throws EdmException, EntityProviderException, IOException {
        for (String navigationPropertyName : type.getNavigationPropertyNames()) {
            if (!data.containsKey(navigationPropertyName)) continue;
            if (data.get(navigationPropertyName) == null) {
                throw new EntityProviderException(EntityProviderException.NULL_VALUE);
            }
            if (data.get(navigationPropertyName) instanceof Entity || data.get(navigationPropertyName) instanceof EntityCollection) {
                if (!emptyData) {
                    this.jsonStreamWriter.separator();
                }
                emptyData = false;
                this.jsonStreamWriter.name(navigationPropertyName);
                this.writeExpandedNavigationProperty(writer, entityInfo, data, type, navigationPropertyName);
                continue;
            }
            if (data.get(navigationPropertyName) instanceof Map) {
                this.writeNavigationLinks(entityInfo, data);
                continue;
            }
            throw new EntityProviderException(EntityProviderException.INCORRECT_NAVIGATION_TYPE);
        }
    }

    private void writeExpandedNavigationProperty(Writer writer, EntityInfoAggregator entityInfo, Map<String, Object> data, EdmEntityType type, String navigationPropertyName) throws EdmException, EntityProviderException, IOException {
        EdmNavigationProperty navigationProperty = (EdmNavigationProperty)type.getProperty(navigationPropertyName);
        boolean isFeed = navigationProperty.getMultiplicity() == EdmMultiplicity.MANY;
        EdmEntitySet entitySet = entityInfo.getEntitySet();
        EdmEntitySet inlineEntitySet = entitySet.getRelatedEntitySet(navigationProperty);
        if (isFeed) {
            EntityCollection inlineData = (EntityCollection)data.get(navigationProperty.getName());
            if (inlineData == null) {
                throw new EntityProviderException(EntityProviderException.NULL_VALUE);
            }
            EntityCollectionSerializerProperties inlineProperties = inlineData.getCollectionProperties() == null ? EntityCollectionSerializerProperties.serviceRoot(this.properties.getServiceRoot()).build() : inlineData.getCollectionProperties();
            JsonFeedEntitySerializer jsonFeedEntityProducer = new JsonFeedEntitySerializer(inlineProperties);
            EntityInfoAggregator inlineEntityInfo = EntityInfoAggregator.create(inlineEntitySet, null);
            jsonFeedEntityProducer.appendAsArray(writer, inlineEntityInfo, inlineData);
        } else {
            Entity inlineData = (Entity)data.get(navigationProperty.getName());
            if (inlineData == null) {
                throw new EntityProviderException(EntityProviderException.NULL_VALUE);
            }
            if (inlineData != null && inlineData.getProperties() != null) {
                EntitySerializerProperties inlineProperties = inlineData.getWriteProperties() == null ? EntitySerializerProperties.serviceRoot(this.properties.getServiceRoot()).build() : inlineData.getWriteProperties();
                EntityInfoAggregator inlineEntityInfo = EntityInfoAggregator.create(inlineEntitySet, null);
                new JsonEntryEntitySerializer(inlineProperties).append(writer, inlineEntityInfo, inlineData);
            } else {
                this.jsonStreamWriter.beginObject();
                this.jsonStreamWriter.endObject();
            }
        }
    }

    private void writeProperties(EntityInfoAggregator entityInfo, Map<String, Object> data, EdmEntityType type, boolean containsMetadata) throws EdmException, EntityProviderException, IOException {
        boolean omitComma = !containsMetadata;
        List<String> propertyNames = type.getPropertyNames();
        for (String propertyName : propertyNames) {
            if (!data.containsKey(propertyName)) continue;
            omitComma = this.appendPropertyNameValue(entityInfo, data, omitComma, propertyName);
        }
    }

    private boolean appendPropertyNameValue(EntityInfoAggregator entityInfo, Map<String, Object> data, boolean omitComma, String propertyName) throws IOException, EdmException, EntityProviderException {
        if (omitComma) {
            omitComma = false;
        } else {
            this.jsonStreamWriter.separator();
        }
        this.jsonStreamWriter.name(propertyName);
        JsonPropertyEntitySerializer.appendPropertyValue(this.jsonStreamWriter, entityInfo.getPropertyInfo(propertyName), data.get(propertyName), this.properties.isValidatingFacets(), this.properties.isDateTimeJsonRelaxed());
        return omitComma;
    }

    private void writeMetadata(EntityInfoAggregator entityInfo, Map<String, Object> data, EdmEntityType type) throws IOException, EntityProviderException, EdmException {
        if (this.properties.getServiceRoot() == null) {
            this.location = "";
            this.idlocation = "";
        } else {
            this.location = this.properties.getServiceRoot().toASCIIString() + AtomEntryEntitySerializer.createSelfLink(entityInfo, data, null, this.properties.isKeyAutoGenerated(), false);
            this.idlocation = this.properties.getServiceRoot().toASCIIString() + AtomEntryEntitySerializer.createSelfLink(entityInfo, data, null, this.properties.isKeyAutoGenerated(), true);
        }
        this.jsonStreamWriter.name("__metadata");
        this.jsonStreamWriter.beginObject();
        this.jsonStreamWriter.namedStringValue("id", this.idlocation);
        this.jsonStreamWriter.separator();
        this.jsonStreamWriter.namedStringValue("uri", this.location);
        this.jsonStreamWriter.separator();
        this.jsonStreamWriter.namedStringValueRaw("type", type.getNamespace() + "." + type.getName());
        if (type.hasStream()) {
            this.jsonStreamWriter.separator();
            EdmMapping entityTypeMapping = entityInfo.getEntityType().getMapping();
            String mediaResourceMimeType = null;
            String mediaSrc = null;
            if (entityTypeMapping != null) {
                String mediaResourceMimeTypeKey;
                String mediaResourceSourceKey = entityTypeMapping.getMediaResourceSourceKey();
                if (mediaResourceSourceKey != null) {
                    mediaSrc = (String)data.get(mediaResourceSourceKey);
                }
                if (mediaSrc == null) {
                    mediaSrc = this.location + VALUE;
                }
                if ((mediaResourceMimeTypeKey = entityTypeMapping.getMediaResourceMimeTypeKey()) != null) {
                    mediaResourceMimeType = (String)data.get(mediaResourceMimeTypeKey);
                }
                if (mediaResourceMimeType == null) {
                    mediaResourceMimeType = ContentType.APPLICATION_OCTET_STREAM.toString();
                }
            } else {
                mediaSrc = this.location + VALUE;
                mediaResourceMimeType = ContentType.APPLICATION_OCTET_STREAM.toString();
            }
            this.jsonStreamWriter.namedStringValueRaw("content_type", mediaResourceMimeType);
            this.jsonStreamWriter.separator();
            this.jsonStreamWriter.namedStringValue("media_src", mediaSrc);
            this.jsonStreamWriter.separator();
            this.jsonStreamWriter.namedStringValue("edit_media", this.location + VALUE);
        }
        this.jsonStreamWriter.endObject();
    }

    private String createCustomTargetLink(EntityInfoAggregator entityInfo, String navigationPropertyName, Map<String, Object> key) throws EntityProviderException, EdmException {
        EntityInfoAggregator targetEntityInfo = EntityInfoAggregator.create(entityInfo.getEntitySet().getRelatedEntitySet((EdmNavigationProperty)entityInfo.getEntityType().getProperty(navigationPropertyName)));
        String target = (this.properties.getServiceRoot() == null ? "" : this.properties.getServiceRoot().toASCIIString()) + AtomEntryEntitySerializer.createSelfLink(targetEntityInfo, key, null, this.properties.isKeyAutoGenerated(), false);
        return target;
    }

    private void writeNavigationLinks(EntityInfoAggregator entityInfo, Map<String, Object> navigationLinks) throws IOException, EntityProviderException, EdmException {
        if (navigationLinks != null && !navigationLinks.isEmpty()) {
            for (Map.Entry<String, Object> entry : navigationLinks.entrySet()) {
                Map navigationKeyMap;
                String target = null;
                if (!(entry.getValue() instanceof HashMap) || (navigationKeyMap = (Map)entry.getValue()) == null || navigationKeyMap.isEmpty()) continue;
                target = this.createCustomTargetLink(entityInfo, entry.getKey(), navigationKeyMap);
                this.jsonStreamWriter.separator();
                this.jsonStreamWriter.name(entry.getKey());
                this.jsonStreamWriter.beginObject().name("__deferred");
                JsonLinkEntitySerializer.appendUri(this.jsonStreamWriter, target);
                this.jsonStreamWriter.endObject();
            }
        }
    }

    public String getLocation() {
        return this.location;
    }
}

