/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.client.core.ep.serializer;

import java.net.URI;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.client.api.ep.Entity;
import org.apache.olingo.odata2.client.api.ep.EntityCollection;
import org.apache.olingo.odata2.client.api.ep.EntityCollectionSerializerProperties;
import org.apache.olingo.odata2.client.api.ep.EntitySerializerProperties;
import org.apache.olingo.odata2.client.core.ep.serializer.AtomEntryEntitySerializer;
import org.apache.olingo.odata2.core.commons.Encoder;
import org.apache.olingo.odata2.core.edm.EdmDateTimeOffset;
import org.apache.olingo.odata2.core.ep.EntityProviderProducerException;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;

public class AtomFeedSerializer {
    private final EntityCollectionSerializerProperties properties;

    public AtomFeedSerializer(EntityCollectionSerializerProperties properties) {
        this.properties = properties == null ? EntityCollectionSerializerProperties.serviceRoot(null).build() : properties;
    }

    public void append(XMLStreamWriter writer, EntityInfoAggregator eia, EntityCollection data, boolean isInline) throws EntityProviderException {
        try {
            if (this.properties.getServiceRoot() == null) {
                throw new EntityProviderProducerException(EntityProviderException.MANDATORY_WRITE_PROPERTY);
            }
            writer.writeStartElement("feed");
            if (!isInline) {
                writer.writeDefaultNamespace("http://www.w3.org/2005/Atom");
                writer.writeNamespace("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata");
                writer.writeNamespace("d", "http://schemas.microsoft.com/ado/2007/08/dataservices");
            }
            writer.writeAttribute("xml", "http://www.w3.org/XML/1998/namespace", "base", this.properties.getServiceRoot().toASCIIString());
            this.appendAtomMandatoryParts(writer, eia);
            this.appendAtomSelfLink(writer, eia);
            this.appendEntries(writer, eia, data);
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderProducerException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private void appendEntries(XMLStreamWriter writer, EntityInfoAggregator eia, EntityCollection data) throws EntityProviderException {
        for (Entity singleEntryData : data.getEntities()) {
            AtomEntryEntitySerializer entryProvider = singleEntryData.getWriteProperties() == null ? (data.getGlobalEntityProperties() == null ? new AtomEntryEntitySerializer(EntitySerializerProperties.serviceRoot(data.getCollectionProperties().getServiceRoot()).build()) : new AtomEntryEntitySerializer(data.getGlobalEntityProperties())) : new AtomEntryEntitySerializer(singleEntryData.getWriteProperties());
            entryProvider.append(writer, eia, singleEntryData, false, true);
        }
    }

    private void appendAtomSelfLink(XMLStreamWriter writer, EntityInfoAggregator eia) throws EntityProviderException {
        URI self = this.properties.getSelfLink();
        String selfLink = "";
        selfLink = self == null ? this.createSelfLink(eia) : self.toASCIIString();
        try {
            writer.writeStartElement("link");
            writer.writeAttribute("href", selfLink);
            writer.writeAttribute("rel", "self");
            writer.writeAttribute("title", eia.getEntitySetName());
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderProducerException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private String createSelfLink(EntityInfoAggregator eia) {
        StringBuilder sb = new StringBuilder();
        if (!eia.isDefaultEntityContainer()) {
            String entityContainerName = Encoder.encode(eia.getEntityContainerName());
            sb.append(entityContainerName).append(".");
        }
        String entitySetName = Encoder.encode(eia.getEntitySetName());
        sb.append(entitySetName);
        return sb.toString();
    }

    private void appendAtomMandatoryParts(XMLStreamWriter writer, EntityInfoAggregator eia) throws EntityProviderException {
        try {
            writer.writeStartElement("id");
            writer.writeCharacters(this.createAtomId(eia));
            writer.writeEndElement();
            writer.writeStartElement("title");
            writer.writeAttribute("type", "text");
            writer.writeCharacters(eia.getEntitySetName());
            writer.writeEndElement();
            writer.writeStartElement("updated");
            Date updateDate = null;
            EdmFacets updateFacets = null;
            updateDate = new Date();
            writer.writeCharacters(EdmDateTimeOffset.getInstance().valueToString(updateDate, EdmLiteralKind.DEFAULT, updateFacets));
            writer.writeEndElement();
            writer.writeStartElement("author");
            writer.writeStartElement("name");
            writer.writeEndElement();
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderProducerException(EntityProviderException.COMMON, (Throwable)e);
        }
        catch (EdmSimpleTypeException e) {
            throw new EntityProviderProducerException(e.getMessageReference(), (Throwable)e);
        }
    }

    private String createAtomId(EntityInfoAggregator eia) throws EntityProviderException {
        return this.properties.getServiceRoot() + this.createSelfLink(eia);
    }
}

