/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.client.core.ep.deserializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.client.api.ep.DeserializerProperties;
import org.apache.olingo.odata2.core.ep.aggregator.EntityComplexPropertyInfo;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.aggregator.EntityPropertyInfo;
import org.apache.olingo.odata2.core.ep.aggregator.EntityTypeMapping;

public class XmlPropertyDeserializer {
    protected static final String TRUE = "true";
    protected static final String FALSE = "false";

    public Map<String, Object> readProperty(XMLStreamReader reader, EdmProperty property, DeserializerProperties readProperties) throws EntityProviderException {
        return this.readProperty(reader, EntityInfoAggregator.create(property), readProperties);
    }

    public Map<String, Object> readProperty(XMLStreamReader reader, EntityPropertyInfo propertyInfo, DeserializerProperties readProperties) throws EntityProviderException {
        EntityTypeMapping typeMappings = EntityTypeMapping.create(readProperties == null ? Collections.emptyMap() : readProperties.getTypeMappings());
        try {
            reader.next();
            Object value = this.readStartedElement(reader, propertyInfo.getName(), propertyInfo, typeMappings, readProperties);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put(propertyInfo.getName(), value);
            return result;
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
        catch (EdmException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    public List<Object> readCollection(XMLStreamReader reader, EntityPropertyInfo info, DeserializerProperties properties) throws EntityProviderException {
        String collectionName = info.getName();
        EntityTypeMapping typeMappings = EntityTypeMapping.create(properties == null || !properties.getTypeMappings().containsKey(collectionName) ? Collections.emptyMap() : Collections.singletonMap("element", properties.getTypeMappings().get(collectionName)));
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            reader.nextTag();
            reader.require(1, "http://schemas.microsoft.com/ado/2007/08/dataservices", collectionName);
            reader.nextTag();
            while (reader.isStartElement()) {
                result.add(this.readStartedElement(reader, "element", info, typeMappings, properties));
                reader.nextTag();
            }
            reader.require(2, "http://schemas.microsoft.com/ado/2007/08/dataservices", collectionName);
            reader.next();
            reader.require(8, null, null);
            return result;
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
        catch (EdmException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    protected Object readStartedElement(XMLStreamReader reader, String name, EntityPropertyInfo propertyInfo, EntityTypeMapping typeMappings, DeserializerProperties readProperties) throws EntityProviderException, EdmException {
        HashMap<String, Object> result = null;
        try {
            reader.require(1, "http://schemas.microsoft.com/ado/2007/08/dataservices", name);
            String nullAttribute = reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "null");
            if (nullAttribute != null && !TRUE.equals(nullAttribute) && !FALSE.equals(nullAttribute)) {
                throw new EntityProviderException(EntityProviderException.COMMON);
            }
            if (TRUE.equals(nullAttribute)) {
                if ((readProperties == null || readProperties.isValidatingFacets()) && propertyInfo.isMandatory()) {
                    throw new EntityProviderException(EntityProviderException.INVALID_PROPERTY_VALUE.addContent(name));
                }
                reader.nextTag();
            } else if (propertyInfo.isComplex()) {
                String expectedTypeAttributeValue;
                String typeAttribute = reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "type");
                if (typeAttribute != null && !(expectedTypeAttributeValue = propertyInfo.getType().getNamespace() + "." + propertyInfo.getType().getName()).equals(typeAttribute)) {
                    throw new EntityProviderException(EntityProviderException.INVALID_COMPLEX_TYPE.addContent(expectedTypeAttributeValue).addContent(typeAttribute));
                }
                reader.nextTag();
                HashMap<String, Object> name2Value = new HashMap<String, Object>();
                while (reader.hasNext() && !reader.isEndElement()) {
                    String childName = reader.getLocalName();
                    EntityPropertyInfo childProperty = ((EntityComplexPropertyInfo)propertyInfo).getPropertyInfo(childName);
                    if (childProperty == null) {
                        throw new EntityProviderException(EntityProviderException.INVALID_PROPERTY.addContent(childName));
                    }
                    Object value = this.readStartedElement(reader, childName, childProperty, typeMappings.getEntityTypeMapping(name), readProperties);
                    name2Value.put(childName, value);
                    reader.nextTag();
                }
                result = name2Value;
            } else {
                result = this.convert(propertyInfo, reader.getElementText(), typeMappings.getMappingClass(name), readProperties);
            }
            reader.require(2, "http://schemas.microsoft.com/ado/2007/08/dataservices", name);
            return result;
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    private Object convert(EntityPropertyInfo property, String value, Class<?> typeMapping, DeserializerProperties readProperties) throws EdmSimpleTypeException {
        EdmSimpleType type = (EdmSimpleType)property.getType();
        return type.valueOfString(value, EdmLiteralKind.DEFAULT, readProperties == null || readProperties.isValidatingFacets() ? property.getFacets() : null, typeMapping == null ? type.getDefaultType() : typeMapping);
    }
}

