/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.client.core.ep.deserializer;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmAction;
import org.apache.olingo.odata2.api.edm.EdmAnnotationAttribute;
import org.apache.olingo.odata2.api.edm.EdmAnnotationElement;
import org.apache.olingo.odata2.api.edm.EdmAssociation;
import org.apache.olingo.odata2.api.edm.EdmAssociationEnd;
import org.apache.olingo.odata2.api.edm.EdmAssociationSet;
import org.apache.olingo.odata2.api.edm.EdmAssociationSetEnd;
import org.apache.olingo.odata2.api.edm.EdmComplexType;
import org.apache.olingo.odata2.api.edm.EdmConcurrencyMode;
import org.apache.olingo.odata2.api.edm.EdmContentKind;
import org.apache.olingo.odata2.api.edm.EdmCustomizableFeedMappings;
import org.apache.olingo.odata2.api.edm.EdmEntityContainer;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmParameter;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmReferentialConstraint;
import org.apache.olingo.odata2.api.edm.EdmReferentialConstraintRole;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.edm.EdmTypeKind;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.apache.olingo.odata2.api.edm.FullQualifiedName;
import org.apache.olingo.odata2.api.edm.provider.Facets;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.client.api.edm.EdmDataServices;
import org.apache.olingo.odata2.client.api.edm.EdmSchema;
import org.apache.olingo.odata2.client.api.edm.EdmUsing;
import org.apache.olingo.odata2.client.core.edm.EdmMetadataAssociationEnd;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmAnnotationAttributeImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmAnnotationElementImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmAnnotationsImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmAssociationEndImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmAssociationImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmAssociationSetEndImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmAssociationSetImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmComplexPropertyImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmComplexTypeImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmCustomizableFeedMappingsImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmEntityContainerImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmEntitySetImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmEntityTypeImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmFunctionImportImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmFunctionImportParameter;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmKeyImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmNavigationPropertyImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmOnDeleteImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmParameterImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmPropertyImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmPropertyRefImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmReferentialConstraintImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmReferentialConstraintRoleImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmSchemaImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmSimplePropertyImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmTypedImpl;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmUsingImpl;
import org.apache.olingo.odata2.core.commons.XmlHelper;
import org.apache.olingo.odata2.core.edm.EdmSimpleTypeFacadeImpl;

public class XmlMetadataDeserializer {
    private Map<String, Set<String>> inscopeMap = new HashMap<String, Set<String>>();
    private Map<String, String> aliasNamespaceMap = new HashMap<String, String>();
    private Map<String, String> xmlNamespaceMap;
    private Map<String, String> mandatoryNamespaces;
    private Map<FullQualifiedName, EdmEntityType> entityTypesMap = new HashMap<FullQualifiedName, EdmEntityType>();
    private Map<FullQualifiedName, EdmComplexType> complexTypesMap = new HashMap<FullQualifiedName, EdmComplexType>();
    private Map<FullQualifiedName, EdmProperty> complexPropertyMap = new HashMap<FullQualifiedName, EdmProperty>();
    private Map<FullQualifiedName, EdmAssociation> associationsMap = new HashMap<FullQualifiedName, EdmAssociation>();
    private Map<String, EdmAssociationSet> associationSetMap = new HashMap<String, EdmAssociationSet>();
    private Map<String, EdmAssociationSet> tempAssociationSetMap = new HashMap<String, EdmAssociationSet>();
    private Map<String, List<EdmAssociationSetEndImpl>> associationSetEndMap = new HashMap<String, List<EdmAssociationSetEndImpl>>();
    private Map<FullQualifiedName, EdmEntityContainer> containerMap = new HashMap<FullQualifiedName, EdmEntityContainer>();
    private Map<FullQualifiedName, FullQualifiedName> entityBaseTypeMap = new HashMap<FullQualifiedName, FullQualifiedName>();
    private Map<FullQualifiedName, FullQualifiedName> complexBaseTypeMap = new HashMap<FullQualifiedName, FullQualifiedName>();
    private List<EdmFunctionImport> edmFunctionImportList = new ArrayList<EdmFunctionImport>();
    private List<EdmEntitySet> edmEntitySetList = new ArrayList<EdmEntitySet>();
    private List<EdmNavigationProperty> navProperties = new ArrayList<EdmNavigationProperty>();
    private String currentHandledStartTagName;
    private String currentNamespace;
    private String edmNamespace = "http://schemas.microsoft.com/ado/2008/09/edm";
    private Set<String> edmNamespaces;
    private EdmEntityContainer defaultEdmEntityContainer;

    public EdmDataServices readMetadata(InputStream content, boolean validate) throws EntityProviderException, EdmException {
        try {
            this.initialize();
            EdmDataServices dataServices = new EdmDataServices();
            ArrayList<EdmSchema> schemas = new ArrayList<EdmSchema>();
            EdmImpl edm = new EdmImpl();
            XMLStreamReader reader = XmlHelper.createStreamReader(content);
            while (!(!reader.hasNext() || reader.isEndElement() && "http://schemas.microsoft.com/ado/2007/06/edmx".equals(reader.getNamespaceURI()) && "Edmx".equals(reader.getLocalName()))) {
                reader.next();
                if (!reader.isStartElement()) continue;
                this.extractNamespaces(reader);
                if ("Schema".equals(reader.getLocalName())) {
                    this.edmNamespace = reader.getNamespaceURI();
                    this.checkEdmNamespace();
                    schemas.add(this.readSchema(reader, edm));
                    continue;
                }
                if (!"DataServices".equals(reader.getLocalName())) continue;
                dataServices.setDataServiceVersion(reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "DataServiceVersion"));
            }
            if (!reader.isEndElement() || !"Edmx".equals(reader.getLocalName())) {
                throw new EntityProviderException(EntityProviderException.MISSING_TAG.addContent("Edmx"));
            }
            this.setBaseTypeForEntityType();
            this.setBaseTypeForComplexType();
            this.setDetailsForEntitySet();
            this.setAssociationSetForNavigations();
            if (validate) {
                this.validate();
            }
            edm.setEdmSchemas(schemas);
            dataServices.setClientEdm(edm);
            reader.close();
            return dataServices;
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    private EdmSchema readSchema(XMLStreamReader reader, EdmImpl edm) throws XMLStreamException, EntityProviderException, EdmException {
        reader.require(1, this.edmNamespace, "Schema");
        EdmSchemaImpl schemaImpl = new EdmSchemaImpl();
        ArrayList<EdmUsing> usings = new ArrayList<EdmUsing>();
        ArrayList<EdmComplexType> complexTypes = new ArrayList<EdmComplexType>();
        ArrayList<EdmEntityType> entityTypes = new ArrayList<EdmEntityType>();
        ArrayList<EdmAssociation> associations = new ArrayList<EdmAssociation>();
        ArrayList<EdmEntityContainer> entityContainers = new ArrayList<EdmEntityContainer>();
        ArrayList<EdmAnnotationElement> annotationElements = new ArrayList<EdmAnnotationElement>();
        schemaImpl.setNamespace(reader.getAttributeValue(null, "Namespace"));
        this.inscopeMap.put(schemaImpl.getNamespace(), new HashSet());
        schemaImpl.setAlias(reader.getAttributeValue(null, "Alias"));
        schemaImpl.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        this.currentNamespace = schemaImpl.getNamespace();
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "Schema".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            this.currentHandledStartTagName = reader.getLocalName();
            if ("Using".equals(this.currentHandledStartTagName)) {
                usings.add(this.readUsing(reader, schemaImpl.getNamespace()));
                continue;
            }
            if ("EntityType".equals(this.currentHandledStartTagName)) {
                entityTypes.add(this.readEntityType(reader, edm));
                continue;
            }
            if ("ComplexType".equals(this.currentHandledStartTagName)) {
                complexTypes.add(this.readComplexType(reader, edm));
                continue;
            }
            if ("Association".equals(this.currentHandledStartTagName)) {
                associations.add(this.readAssociation(reader, edm));
                continue;
            }
            if ("EntityContainer".equals(this.currentHandledStartTagName)) {
                entityContainers.add(this.readEntityContainer(reader, edm));
                continue;
            }
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (schemaImpl.getAlias() != null) {
            this.aliasNamespaceMap.put(schemaImpl.getAlias(), schemaImpl.getNamespace());
            edm.setAliasToNamespaceInfo(this.aliasNamespaceMap);
        }
        if (!annotationElements.isEmpty()) {
            schemaImpl.setAnnotationElements(annotationElements);
        }
        schemaImpl.setUsings(usings).setEntityTypes(entityTypes).setComplexTypes(complexTypes).setAssociations(associations).setEntityContainers(entityContainers);
        edm.setAliasToNamespaceInfo(this.aliasNamespaceMap).setEdmAssociations(this.associationsMap).setEdmComplexTypes(this.complexTypesMap).setEdmEntityContainers(this.containerMap).setDefaultEntityContainer(this.defaultEdmEntityContainer).setEdmEntitySets(this.edmEntitySetList).setEdmEntityTypes(this.entityTypesMap).setEdmFunctionImports(this.edmFunctionImportList);
        return schemaImpl;
    }

    private void setAssociationSetForNavigations() throws EdmException {
        for (EdmEntitySet edmEntitySet : this.edmEntitySetList) {
            List<String> navigations = edmEntitySet.getEntityType().getNavigationPropertyNames();
            if (navigations == null || navigations.isEmpty()) continue;
            for (EdmNavigationProperty navigationProperty : this.navProperties) {
                if (!navigations.contains(navigationProperty.getName())) continue;
                FullQualifiedName associationName = ((EdmNavigationPropertyImpl)navigationProperty).getRelationshipName();
                String toRoleName = ((EdmNavigationPropertyImpl)navigationProperty).getToRole();
                EdmAssociationEnd end = this.associationsMap.get(associationName).getEnd(toRoleName);
                if (end == null) {
                    throw new EdmException(EdmException.ASSOCIATIONNOTFOUND);
                }
                String relation = associationName.toString();
                StringBuilder key = new StringBuilder();
                key.append(edmEntitySet.getName());
                key.append(">>");
                key.append(relation);
                key.append(">>");
                key.append(navigationProperty.getFromRole());
                ((EdmNavigationPropertyImpl)navigationProperty).setMultiplicity(end.getMultiplicity());
                this.associationSetMap.put(key.toString(), this.tempAssociationSetMap.get(relation));
            }
        }
    }

    private void setDetailsForEntitySet() throws EdmException {
        for (EdmEntitySet entitySet : this.edmEntitySetList) {
            EdmEntitySetImpl entitySetImpl = (EdmEntitySetImpl)entitySet;
            FullQualifiedName entityTypeKey = entitySetImpl.getEntityTypeName();
            if (this.aliasNamespaceMap.get(entitySetImpl.getEntityTypeName().getNamespace()) != null) {
                entityTypeKey = new FullQualifiedName(this.aliasNamespaceMap.get(entitySetImpl.getEntityTypeName().getNamespace()), entitySetImpl.getEntityTypeName().getName());
            }
            if (entitySetImpl.getEntityType() == null && entityTypeKey != null) {
                if (this.entityTypesMap.get(entityTypeKey) != null) {
                    entitySetImpl.setEdmEntityType(this.entityTypesMap.get(entityTypeKey));
                } else {
                    EdmEntityTypeImpl edmEntityType = new EdmEntityTypeImpl();
                    edmEntityType.setName(entitySetImpl.getEntityTypeName().getName());
                    edmEntityType.setNamespace(entitySetImpl.getEntityTypeName().getNamespace());
                    entitySetImpl.setEdmEntityType(edmEntityType);
                }
            }
            if (this.associationSetEndMap.get(entitySet.getName()) == null) continue;
            List<EdmAssociationSetEndImpl> ends = this.associationSetEndMap.get(entitySet.getName());
            for (EdmAssociationSetEndImpl end : ends) {
                end.setEntitySet(entitySet);
            }
        }
    }

    private void setBaseTypeForComplexType() throws EdmException {
        for (Map.Entry<FullQualifiedName, EdmComplexType> entity : this.complexTypesMap.entrySet()) {
            EdmComplexTypeImpl entityType = (EdmComplexTypeImpl)entity.getValue();
            if (((EdmComplexTypeImpl)entity.getValue()).getEdmBaseTypeName() == null || entity.getValue().getBaseType() != null) continue;
            FullQualifiedName fqname = entityType.getEdmBaseTypeName();
            if (this.complexTypesMap.get(entityType.getEdmBaseTypeName()) != null) {
                entityType.setEdmBaseType(this.complexTypesMap.get(fqname));
                continue;
            }
            if (this.aliasNamespaceMap.containsKey(fqname.getNamespace())) {
                FullQualifiedName changedName = new FullQualifiedName(this.aliasNamespaceMap.get(fqname.getNamespace()), fqname.getName());
                entityType.setEdmBaseType(this.complexTypesMap.get(changedName));
                continue;
            }
            EdmComplexTypeImpl newBaseType = new EdmComplexTypeImpl();
            newBaseType.setName(fqname.getName());
            newBaseType.setNamespace(fqname.getNamespace());
            ((EdmComplexTypeImpl)entity.getValue()).setEdmBaseType(newBaseType);
            break;
        }
        this.setBaseTypePropertiesForComplexType(this.complexBaseTypeMap);
    }

    private void setBaseTypeForEntityType() throws EdmException {
        for (Map.Entry<FullQualifiedName, EdmEntityType> entity : this.entityTypesMap.entrySet()) {
            EdmEntityTypeImpl entityType = (EdmEntityTypeImpl)entity.getValue();
            if (entityType.getBaseTypeName() == null || entity.getValue().getBaseType() != null) continue;
            FullQualifiedName fqname = entityType.getBaseTypeName();
            if (this.entityTypesMap.get(entityType.getBaseTypeName()) != null) {
                entityType.setEdmBaseType(this.entityTypesMap.get(fqname));
                continue;
            }
            if (this.aliasNamespaceMap.containsKey(fqname.getNamespace())) {
                FullQualifiedName changedName = new FullQualifiedName(this.aliasNamespaceMap.get(fqname.getNamespace()), fqname.getName());
                entityType.setEdmBaseType(this.entityTypesMap.get(changedName));
                continue;
            }
            EdmEntityTypeImpl newBaseType = new EdmEntityTypeImpl();
            newBaseType.setName(fqname.getName());
            newBaseType.setNamespace(fqname.getNamespace());
            entityType.setEdmBaseType(newBaseType);
            break;
        }
        this.setBaseTypePropertiesForEntityType(this.entityBaseTypeMap);
    }

    private void setBaseTypePropertiesForEntityType(Map<FullQualifiedName, FullQualifiedName> baseTypeMap) throws EdmException {
        this.changeAliasNamespaces(baseTypeMap);
        while (!baseTypeMap.isEmpty()) {
            Iterator<Map.Entry<FullQualifiedName, FullQualifiedName>> iterator = baseTypeMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<FullQualifiedName, FullQualifiedName> baseType = iterator.next();
                if (baseTypeMap.get(baseType.getValue()) != null) continue;
                EdmEntityType entityType = this.entityTypesMap.get(baseType.getKey());
                List<String> properties = entityType.getPropertyNames();
                if (this.entityTypesMap.get(baseType.getValue()) != null) {
                    properties.addAll(this.entityTypesMap.get(baseType.getValue()).getPropertyNames());
                }
                iterator.remove();
            }
        }
    }

    private void setBaseTypePropertiesForComplexType(Map<FullQualifiedName, FullQualifiedName> baseTypeMap) throws EdmException {
        this.changeAliasNamespaces(baseTypeMap);
        while (!baseTypeMap.isEmpty()) {
            Iterator<Map.Entry<FullQualifiedName, FullQualifiedName>> iterator = baseTypeMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<FullQualifiedName, FullQualifiedName> baseType = iterator.next();
                if (baseTypeMap.get(baseType.getValue()) != null) continue;
                EdmComplexType entityType = this.complexTypesMap.get(baseType.getKey());
                List<String> properties = entityType.getPropertyNames();
                if (this.complexTypesMap.get(baseType.getValue()) != null) {
                    properties.addAll(this.complexTypesMap.get(baseType.getValue()).getPropertyNames());
                }
                iterator.remove();
            }
        }
    }

    private void changeAliasNamespaces(Map<FullQualifiedName, FullQualifiedName> baseTypeMap) {
        for (Map.Entry<FullQualifiedName, FullQualifiedName> entry : baseTypeMap.entrySet()) {
            FullQualifiedName value;
            if (this.aliasNamespaceMap.containsKey(entry.getKey().getNamespace())) {
                value = baseTypeMap.get(entry.getKey());
                FullQualifiedName name = new FullQualifiedName(this.aliasNamespaceMap.get(entry.getKey().getNamespace()), entry.getKey().getName());
                baseTypeMap.put(name, value);
                baseTypeMap.remove(entry.getKey());
            }
            if (!this.aliasNamespaceMap.containsKey(entry.getValue().getNamespace())) continue;
            value = new FullQualifiedName(this.aliasNamespaceMap.get(entry.getValue().getNamespace()), entry.getValue().getName());
            baseTypeMap.remove(entry.getKey());
            baseTypeMap.put(entry.getKey(), value);
        }
    }

    private EdmUsingImpl readUsing(XMLStreamReader reader, String schemaNamespace) throws XMLStreamException, EntityProviderException {
        reader.require(1, this.edmNamespace, "Using");
        EdmUsingImpl using = new EdmUsingImpl();
        using.setNamespace(reader.getAttributeValue(null, "Namespace"));
        this.inscopeMap.get(schemaNamespace).add(using.getNamespace());
        using.setAlias(reader.getAttributeValue(null, "Alias"));
        using.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        ArrayList<EdmAnnotationElement> annotationElements = new ArrayList<EdmAnnotationElement>();
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "Using".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            this.currentHandledStartTagName = reader.getLocalName();
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (!annotationElements.isEmpty()) {
            using.setAnnotationElements(annotationElements);
        }
        if (using.getAlias() != null) {
            this.aliasNamespaceMap.put(using.getAlias(), using.getNamespace());
        }
        return using;
    }

    private EdmEntityContainer readEntityContainer(XMLStreamReader reader, EdmImpl edm) throws XMLStreamException, EntityProviderException, EdmException {
        reader.require(1, this.edmNamespace, "EntityContainer");
        EdmEntityContainerImpl container = new EdmEntityContainerImpl(edm);
        ArrayList<EdmAnnotationElement> annotationElements = new ArrayList<EdmAnnotationElement>();
        ArrayList<EdmEntitySet> edmEntitySets = new ArrayList<EdmEntitySet>();
        ArrayList<EdmFunctionImport> edmFunctionImports = new ArrayList<EdmFunctionImport>();
        ArrayList<EdmAssociationSet> edmAssociationSets = new ArrayList<EdmAssociationSet>();
        container.setName(reader.getAttributeValue(null, "Name"));
        if (reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "IsDefaultEntityContainer") != null) {
            container.setDefaultContainer("true".equalsIgnoreCase(reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "IsDefaultEntityContainer")));
            this.defaultEdmEntityContainer = container;
        }
        container.setExtendz(reader.getAttributeValue(null, "Extendz"));
        List<EdmAnnotationAttribute> annotationAttribute = this.readAnnotationAttribute(reader);
        EdmAnnotationsImpl annotations = new EdmAnnotationsImpl();
        annotations.setAnnotationAttributes(annotationAttribute);
        container.setAnnotations(annotations);
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "EntityContainer".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            this.currentHandledStartTagName = reader.getLocalName();
            if ("EntitySet".equals(this.currentHandledStartTagName)) {
                EdmEntitySetImpl entity = this.readEntitySet(reader);
                entity.setEdmEntityContainer(container);
                edmEntitySets.add(entity);
                continue;
            }
            if ("AssociationSet".equals(this.currentHandledStartTagName)) {
                EdmAssociationSet association = this.readAssociationSet(reader, edm);
                edmAssociationSets.add(association);
                continue;
            }
            if ("FunctionImport".equals(this.currentHandledStartTagName)) {
                edmFunctionImports.add(this.readFunctionImport(reader, edm));
                continue;
            }
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (!annotationElements.isEmpty()) {
            annotations.setAnnotationElements(annotationElements);
            container.setAnnotations(annotations);
        }
        if (edmFunctionImports != null && !edmFunctionImports.isEmpty()) {
            this.setContainerInFunctionImport(edmFunctionImports, container);
        }
        if (edmAssociationSets != null && !edmAssociationSets.isEmpty()) {
            this.setConatinerInAssociationSet(edmAssociationSets, container);
        }
        container.setNamespace(this.currentNamespace);
        container.setEdmEntitySets(edmEntitySets).setEdmAssociationSets(edmAssociationSets).setEdmFunctionImports(edmFunctionImports);
        this.containerMap.put(new FullQualifiedName(this.currentNamespace, container.getName()), container);
        this.edmEntitySetList.addAll(edmEntitySets);
        this.edmFunctionImportList.addAll(edmFunctionImports);
        return container;
    }

    private void setConatinerInAssociationSet(List<EdmAssociationSet> edmAssociationSets, EdmEntityContainerImpl containerImpl) {
        for (EdmAssociationSet associationSet : edmAssociationSets) {
            EdmAssociationSetImpl assocationSetImpl = (EdmAssociationSetImpl)associationSet;
            assocationSetImpl.setEdmEntityContainer(containerImpl);
        }
        containerImpl.setEdmAssociationSetMap(this.associationSetMap);
    }

    private void setContainerInFunctionImport(List<EdmFunctionImport> functionImports, EdmEntityContainerImpl containerImpl) {
        for (EdmFunctionImport funcImport : functionImports) {
            EdmFunctionImportImpl functionImpl = (EdmFunctionImportImpl)funcImport;
            functionImpl.setEdmEntityContainer(containerImpl);
        }
    }

    private EdmFunctionImport readFunctionImport(XMLStreamReader reader, EdmImpl edm) throws XMLStreamException, EntityProviderException, EdmException {
        reader.require(1, this.edmNamespace, "FunctionImport");
        EdmFunctionImportImpl function = new EdmFunctionImportImpl();
        ArrayList<EdmFunctionImportParameter> functionImportParameters = new ArrayList<EdmFunctionImportParameter>();
        HashMap<String, ArrayList<EdmFunctionImportParameter>> functionParameters = new HashMap<String, ArrayList<EdmFunctionImportParameter>>();
        ArrayList<EdmAnnotationElement> annotationElements = new ArrayList<EdmAnnotationElement>();
        EdmAnnotationsImpl annotations = new EdmAnnotationsImpl();
        HashMap<String, EdmParameter> edmParamMap = new HashMap<String, EdmParameter>();
        ArrayList<String> parametersList = new ArrayList<String>();
        function.setName(reader.getAttributeValue(null, "Name"));
        function.setHttpMethod(reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "HttpMethod"));
        String entitySet = reader.getAttributeValue(null, "EntitySet");
        function.setEntitySet(entitySet);
        String returnTypeString = reader.getAttributeValue(null, "ReturnType");
        EdmTypedImpl returnType = new EdmTypedImpl();
        if (returnTypeString != null) {
            if (returnTypeString.startsWith("Collection") || returnTypeString.startsWith("collection")) {
                returnTypeString = returnTypeString.substring(returnTypeString.indexOf("(") + 1, returnTypeString.length() - 1);
                returnType.setMultiplicity(EdmMultiplicity.MANY);
            } else {
                returnType.setMultiplicity(EdmMultiplicity.ONE);
            }
            FullQualifiedName fqName = this.extractFQName(returnTypeString);
            returnType.setTypeName(fqName);
            returnType.setName(fqName.getName());
            returnType.setEdm(edm);
            function.setReturnType(returnType);
        }
        annotations.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "FunctionImport".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            this.currentHandledStartTagName = reader.getLocalName();
            if ("Parameter".equals(this.currentHandledStartTagName)) {
                EdmFunctionImportParameter edmFunctionImportParameter = this.readFunctionImportParameter(reader);
                functionImportParameters.add(edmFunctionImportParameter);
                EdmParameterImpl edmParamImpl = new EdmParameterImpl();
                edmParamImpl.setEdm(edm);
                edmParamImpl.setName(edmFunctionImportParameter.getName());
                edmParamImpl.setFacets(edmFunctionImportParameter.getFacets());
                edmParamImpl.setMapping(edmFunctionImportParameter.getMapping());
                edmParamImpl.setMultiplicity(returnType.getMultiplicity());
                edmParamImpl.setParameter(edmFunctionImportParameter);
                edmParamImpl.setTypeName(edmFunctionImportParameter.getType().getFullQualifiedName());
                edmParamImpl.setAnnotations(edmFunctionImportParameter.getAnnotations());
                parametersList.add(edmParamImpl.getName());
                edmParamMap.put(edmFunctionImportParameter.getName(), edmParamImpl);
                continue;
            }
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (!annotationElements.isEmpty()) {
            annotations.setAnnotationElements(annotationElements);
        }
        function.setAnnotations(annotations);
        functionParameters.put(function.getName(), functionImportParameters);
        function.setParameters(functionParameters);
        function.setEdmParameters(edmParamMap);
        function.setParametersList(parametersList);
        return function;
    }

    private EdmFunctionImportParameter readFunctionImportParameter(XMLStreamReader reader) throws EntityProviderException, XMLStreamException, EdmException {
        reader.require(1, this.edmNamespace, "Parameter");
        EdmFunctionImportParameter functionParameter = new EdmFunctionImportParameter();
        EdmAnnotationsImpl annotations = new EdmAnnotationsImpl();
        ArrayList<EdmAnnotationElement> annotationElements = new ArrayList<EdmAnnotationElement>();
        functionParameter.setName(reader.getAttributeValue(null, "Name"));
        functionParameter.setMode(reader.getAttributeValue(null, "Mode"));
        String type = reader.getAttributeValue(null, "Type");
        if (type == null) {
            throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent("Type").addContent("Parameter"));
        }
        functionParameter.setType(EdmSimpleTypeKind.valueOf(this.extractFQName(type).getName()));
        EdmFacets facets = this.readFacets(reader);
        functionParameter.setFacets(facets);
        annotations.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "Parameter".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (!annotationElements.isEmpty()) {
            annotations.setAnnotationElements(annotationElements);
        }
        functionParameter.setAnnotations(annotations);
        return functionParameter;
    }

    private EdmAssociationSet readAssociationSet(XMLStreamReader reader, EdmImpl edm) throws XMLStreamException, EntityProviderException, EdmException {
        reader.require(1, this.edmNamespace, "AssociationSet");
        EdmAssociationSetImpl associationSet = new EdmAssociationSetImpl();
        ArrayList<EdmAssociationSetEndImpl> ends = new ArrayList<EdmAssociationSetEndImpl>();
        EdmAnnotationsImpl annotation = new EdmAnnotationsImpl();
        String entitySetName = null;
        ArrayList<EdmAnnotationElement> annotationElements = new ArrayList<EdmAnnotationElement>();
        associationSet.setName(reader.getAttributeValue(null, "Name"));
        String association = reader.getAttributeValue(null, "Association");
        if (association == null) {
            throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent("Association").addContent("AssociationSet"));
        }
        associationSet.setAssociation(this.extractFQName(association));
        annotation.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "AssociationSet".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            this.currentHandledStartTagName = reader.getLocalName();
            if ("End".equals(this.currentHandledStartTagName)) {
                EdmAssociationSetEndImpl associationSetEnd = new EdmAssociationSetEndImpl();
                entitySetName = reader.getAttributeValue(null, "EntitySet");
                associationSetEnd.setEntitySetName(entitySetName);
                associationSetEnd.setRole(reader.getAttributeValue(null, "Role"));
                ends.add(associationSetEnd);
                List<EdmAssociationSetEndImpl> associationSetEndList = this.associationSetEndMap.get(entitySetName) == null ? new ArrayList<EdmAssociationSetEndImpl>() : this.associationSetEndMap.get(entitySetName);
                associationSetEndList.add(associationSetEnd);
                this.associationSetEndMap.put(entitySetName, associationSetEndList);
                continue;
            }
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (ends.size() != 2) {
            throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent("Count of AssociationSet ends should be 2"));
        }
        associationSet.setEnd1((EdmAssociationSetEnd)ends.get(0));
        associationSet.setEnd2((EdmAssociationSetEnd)ends.get(1));
        if (!annotationElements.isEmpty()) {
            annotation.setAnnotationElements(annotationElements);
        }
        this.tempAssociationSetMap.put(associationSet.getAssociationSetFQName().toString(), associationSet);
        associationSet.setAnnotations(annotation);
        associationSet.setEdm(edm);
        return associationSet;
    }

    private EdmEntitySetImpl readEntitySet(XMLStreamReader reader) throws XMLStreamException, EntityProviderException, EdmException {
        reader.require(1, this.edmNamespace, "EntitySet");
        EdmEntitySetImpl entitySet = new EdmEntitySetImpl();
        EdmAnnotationsImpl annotations = new EdmAnnotationsImpl();
        ArrayList<EdmAnnotationElement> annotationElements = new ArrayList<EdmAnnotationElement>();
        entitySet.setName(reader.getAttributeValue(null, "Name"));
        String entityType = reader.getAttributeValue(null, "EntityType");
        if (entityType == null) {
            throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent("EntityType").addContent("EntitySet"));
        }
        FullQualifiedName fqName = this.extractFQName(entityType);
        entitySet.setEdmEntityTypeName(fqName);
        annotations.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "EntitySet".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (!annotationElements.isEmpty()) {
            annotations.setAnnotationElements(annotationElements);
        }
        entitySet.setAnnotations(annotations);
        return entitySet;
    }

    private EdmAssociation readAssociation(XMLStreamReader reader, EdmImpl edm) throws XMLStreamException, EntityProviderException, EdmException {
        reader.require(1, this.edmNamespace, "Association");
        EdmAssociationImpl association = new EdmAssociationImpl();
        association.setName(reader.getAttributeValue(null, "Name"));
        association.setNamespace(this.currentNamespace);
        ArrayList<EdmMetadataAssociationEnd> associationEnds = new ArrayList<EdmMetadataAssociationEnd>();
        ArrayList<EdmAnnotationElement> annotationElements = new ArrayList<EdmAnnotationElement>();
        EdmAnnotationsImpl annotations = new EdmAnnotationsImpl();
        annotations.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "Association".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            this.currentHandledStartTagName = reader.getLocalName();
            if ("End".equals(this.currentHandledStartTagName)) {
                associationEnds.add(this.readAssociationEnd(reader, edm));
                continue;
            }
            if ("ReferentialConstraint".equals(this.currentHandledStartTagName)) {
                association.setReferentialConstraint(this.readReferentialConstraint(reader));
                continue;
            }
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (associationEnds.size() < 2 && associationEnds.size() > 2) {
            throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent("Count of association ends should be 2"));
        }
        if (!annotationElements.isEmpty()) {
            annotations.setAnnotationElements(annotationElements);
        }
        association.setAnnotations(annotations);
        association.setEdm(edm);
        association.setAssociationEnds(associationEnds);
        this.associationsMap.put(new FullQualifiedName(this.currentNamespace, association.getName()), association);
        return association;
    }

    private EdmReferentialConstraint readReferentialConstraint(XMLStreamReader reader) throws XMLStreamException, EntityProviderException, EdmException {
        reader.require(1, this.edmNamespace, "ReferentialConstraint");
        EdmReferentialConstraintImpl refConstraint = new EdmReferentialConstraintImpl();
        ArrayList<EdmAnnotationElement> annotationElements = new ArrayList<EdmAnnotationElement>();
        EdmAnnotationsImpl annotations = new EdmAnnotationsImpl();
        annotations.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "ReferentialConstraint".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            this.currentHandledStartTagName = reader.getLocalName();
            if ("Principal".equals(this.currentHandledStartTagName)) {
                reader.require(1, this.edmNamespace, "Principal");
                refConstraint.setPrincipal(this.readReferentialConstraintRole(reader));
                continue;
            }
            if ("Dependent".equals(this.currentHandledStartTagName)) {
                reader.require(1, this.edmNamespace, "Dependent");
                refConstraint.setDependent(this.readReferentialConstraintRole(reader));
                continue;
            }
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (!annotationElements.isEmpty()) {
            annotations.setAnnotationElements(annotationElements);
        }
        refConstraint.setAnnotations(annotations);
        return refConstraint;
    }

    private EdmReferentialConstraintRole readReferentialConstraintRole(XMLStreamReader reader) throws EntityProviderException, XMLStreamException, EdmException {
        EdmReferentialConstraintRoleImpl rcRole = new EdmReferentialConstraintRoleImpl();
        rcRole.setRoleName(reader.getAttributeValue(null, "Role"));
        ArrayList<EdmPropertyImpl> properties = new ArrayList<EdmPropertyImpl>();
        ArrayList<EdmAnnotationElement> annotationElements = new ArrayList<EdmAnnotationElement>();
        ArrayList<String> refNames = new ArrayList<String>();
        EdmAnnotationsImpl annotations = new EdmAnnotationsImpl();
        annotations.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && ("Principal".equals(reader.getLocalName()) || "Dependent".equals(reader.getLocalName())))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            this.currentHandledStartTagName = reader.getLocalName();
            if ("PropertyRef".equals(this.currentHandledStartTagName)) {
                EdmPropertyImpl property = (EdmPropertyImpl)this.readPropertyRef(reader);
                properties.add(property);
                refNames.add(property.getName());
                continue;
            }
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (!annotationElements.isEmpty()) {
            annotations.setAnnotationElements(annotationElements);
        }
        rcRole.setProperty(properties);
        rcRole.setRefNames(refNames);
        rcRole.setAnnotations(annotations);
        return rcRole;
    }

    private EdmComplexType readComplexType(XMLStreamReader reader, Edm edm) throws XMLStreamException, EntityProviderException, EdmException {
        reader.require(1, this.edmNamespace, "ComplexType");
        EdmComplexTypeImpl complexType = new EdmComplexTypeImpl();
        complexType.setEdmTypeKind(EdmTypeKind.COMPLEX);
        ArrayList<EdmProperty> properties = new ArrayList<EdmProperty>();
        ArrayList<EdmAnnotationElement> annotationElements = new ArrayList<EdmAnnotationElement>();
        complexType.setName(reader.getAttributeValue(null, "Name"));
        complexType.setNamespace(this.currentNamespace);
        String baseType = reader.getAttributeValue(null, "BaseType");
        if (baseType != null) {
            FullQualifiedName fqname = this.extractFQName(baseType);
            complexType.setBaseTypeName(fqname);
            this.complexBaseTypeMap.put(new FullQualifiedName(complexType.getNamespace(), complexType.getName()), fqname);
        }
        if (reader.getAttributeValue(null, "Abstract") != null) {
            complexType.setAbstract("true".equalsIgnoreCase(reader.getAttributeValue(null, "Abstract")));
        }
        EdmAnnotationsImpl annotations = new EdmAnnotationsImpl();
        annotations.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "ComplexType".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            this.currentHandledStartTagName = reader.getLocalName();
            if ("Property".equals(this.currentHandledStartTagName)) {
                properties.add(this.readProperty(reader, edm));
                continue;
            }
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (!annotationElements.isEmpty()) {
            annotations.setAnnotationElements(annotationElements);
        }
        complexType.setProperties(properties);
        ArrayList<String> edmPropertyNames = new ArrayList<String>();
        for (EdmProperty name : properties) {
            edmPropertyNames.add(name.getName());
        }
        complexType.setEdmPropertyNames(edmPropertyNames);
        if (complexType.getName() != null) {
            FullQualifiedName fqName = new FullQualifiedName(this.currentNamespace, complexType.getName());
            this.complexTypesMap.put(fqName, complexType);
            if (this.complexPropertyMap.get(fqName) != null) {
                ((EdmComplexPropertyImpl)this.complexPropertyMap.get(fqName)).setEdmType(complexType);
            }
        } else {
            throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent("Name"));
        }
        return complexType;
    }

    private EdmEntityType readEntityType(XMLStreamReader reader, EdmImpl edm) throws XMLStreamException, EntityProviderException, EdmException {
        String baseType;
        reader.require(1, this.edmNamespace, "EntityType");
        EdmEntityTypeImpl entityType = new EdmEntityTypeImpl();
        ArrayList<EdmProperty> properties = new ArrayList<EdmProperty>();
        ArrayList<String> edmPropertyNames = new ArrayList<String>();
        ArrayList<EdmNavigationProperty> edmNavProperties = new ArrayList<EdmNavigationProperty>();
        ArrayList<EdmAnnotationElement> annotationElements = new ArrayList<EdmAnnotationElement>();
        ArrayList<String> edmNavigationPropertyNames = new ArrayList<String>();
        ArrayList<String> edmKeyPropertyNames = new ArrayList<String>();
        ArrayList<EdmProperty> edmKeyProperties = new ArrayList<EdmProperty>();
        EdmKeyImpl key = null;
        entityType.setName(reader.getAttributeValue(null, "Name"));
        entityType.setNamespace(this.currentNamespace);
        entityType.setEdm(edm);
        String hasStream = reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "HasStream");
        if (hasStream != null) {
            entityType.setHasStream("true".equalsIgnoreCase(hasStream));
        }
        if (reader.getAttributeValue(null, "Abstract") != null) {
            entityType.setAbstract("true".equalsIgnoreCase(reader.getAttributeValue(null, "Abstract")));
        }
        if ((baseType = reader.getAttributeValue(null, "BaseType")) != null) {
            FullQualifiedName fqName = this.extractFQName(baseType);
            entityType.setBaseType(fqName);
            this.entityBaseTypeMap.put(this.extractFQNameFromEntityType(entityType), fqName);
        }
        entityType.setCustomizableFeedMappings(this.readCustomizableFeedMappings(reader));
        EdmAnnotationsImpl annotations = new EdmAnnotationsImpl();
        annotations.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "EntityType".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.currentHandledStartTagName = reader.getLocalName();
            if ("Key".equals(this.currentHandledStartTagName)) {
                key = this.readEntityTypeKey(reader);
            } else if ("Property".equals(this.currentHandledStartTagName)) {
                properties.add(this.readProperty(reader, edm));
            } else if ("NavigationProperty".equals(this.currentHandledStartTagName)) {
                edmNavProperties.add(this.readNavigationProperty(reader, edm));
            } else {
                annotationElements.add(this.readAnnotationElement(reader));
            }
            this.extractNamespaces(reader);
        }
        if (!annotationElements.isEmpty()) {
            annotations.setAnnotationElements(annotationElements);
        }
        for (EdmProperty property : properties) {
            edmPropertyNames.add(property.getName());
            if (key == null) continue;
            for (EdmProperty keyProperty : key.getKeys()) {
                if (!property.getName().equals(keyProperty.getName())) continue;
                edmKeyPropertyNames.add(keyProperty.getName());
                edmKeyProperties.add(property);
            }
        }
        for (EdmNavigationProperty navigations : edmNavProperties) {
            edmNavigationPropertyNames.add(navigations.getName());
        }
        entityType.setAnnotations(annotations);
        entityType.setEdmKeyProperties(edmKeyProperties);
        entityType.setNavigationProperties(edmNavProperties);
        entityType.setEdmNavigationPropertyNames(edmNavigationPropertyNames);
        entityType.setEdmKeyPropertyNames(edmKeyPropertyNames);
        entityType.setProperties(properties);
        entityType.setEdmPropertyNames(edmPropertyNames);
        if (entityType.getName() == null) {
            throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent("Name"));
        }
        FullQualifiedName fqName = new FullQualifiedName(this.currentNamespace, entityType.getName());
        this.entityTypesMap.put(fqName, entityType);
        return entityType;
    }

    private EdmKeyImpl readEntityTypeKey(XMLStreamReader reader) throws XMLStreamException, EntityProviderException, EdmException {
        reader.require(1, this.edmNamespace, "Key");
        ArrayList<EdmProperty> keys = new ArrayList<EdmProperty>();
        ArrayList<EdmAnnotationElement> annotationElements = new ArrayList<EdmAnnotationElement>();
        List<EdmAnnotationAttribute> annotationAttributes = this.readAnnotationAttribute(reader);
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "Key".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            this.currentHandledStartTagName = reader.getLocalName();
            if ("PropertyRef".equals(this.currentHandledStartTagName)) {
                reader.require(1, this.edmNamespace, "PropertyRef");
                keys.add(this.readPropertyRef(reader));
                continue;
            }
            annotationElements.add(this.readAnnotationElement(reader));
        }
        EdmKeyImpl key = new EdmKeyImpl().setKeys(keys).setAnnotationAttributes(annotationAttributes);
        if (!annotationElements.isEmpty()) {
            key.setAnnotationElements(annotationElements);
        }
        return key;
    }

    private EdmProperty readPropertyRef(XMLStreamReader reader) throws XMLStreamException, EntityProviderException, EdmException {
        reader.require(1, this.edmNamespace, "PropertyRef");
        EdmPropertyRefImpl propertyRef = new EdmPropertyRefImpl();
        propertyRef.setName(reader.getAttributeValue(null, "Name"));
        EdmAnnotationsImpl annotations = new EdmAnnotationsImpl();
        ArrayList<EdmAnnotationElement> annotationElements = new ArrayList<EdmAnnotationElement>();
        annotations.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "PropertyRef".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (!annotationElements.isEmpty()) {
            annotations.setAnnotationElements(annotationElements);
        }
        propertyRef.setAnnotations(annotations);
        return propertyRef;
    }

    private EdmNavigationProperty readNavigationProperty(XMLStreamReader reader, EdmImpl edm) throws XMLStreamException, EntityProviderException, EdmException {
        reader.require(1, this.edmNamespace, "NavigationProperty");
        EdmNavigationPropertyImpl navProperty = new EdmNavigationPropertyImpl();
        ArrayList<EdmAnnotationElement> annotationElements = new ArrayList<EdmAnnotationElement>();
        navProperty.setName(reader.getAttributeValue(null, "Name"));
        String relationship = reader.getAttributeValue(null, "Relationship");
        if (relationship == null) {
            throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent("Relationship").addContent("NavigationProperty"));
        }
        FullQualifiedName fqName = this.extractFQName(relationship);
        navProperty.setRelationshipName(fqName);
        navProperty.setFromRole(reader.getAttributeValue(null, "FromRole"));
        navProperty.setToRole(reader.getAttributeValue(null, "ToRole"));
        EdmAnnotationsImpl annotations = new EdmAnnotationsImpl();
        annotations.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "NavigationProperty".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (!annotationElements.isEmpty()) {
            annotations.setAnnotationElements(annotationElements);
        }
        navProperty.setAnnotations(annotations);
        navProperty.setEdm(edm);
        this.navProperties.add(navProperty);
        return navProperty;
    }

    private EdmProperty readProperty(XMLStreamReader reader, Edm edm) throws XMLStreamException, EntityProviderException, EdmException {
        reader.require(1, this.edmNamespace, "Property");
        ArrayList<EdmAnnotationElement> annotationElements = new ArrayList<EdmAnnotationElement>();
        String type = reader.getAttributeValue(null, "Type");
        if (type == null) {
            throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent("Type").addContent("Property"));
        }
        FullQualifiedName fqName = this.extractFQName(type);
        EdmPropertyImpl property = "Edm".equals(fqName.getNamespace()) ? this.readSimpleProperty(reader, fqName) : this.readComplexProperty(reader, fqName, edm);
        property.setFacets(this.readFacets(reader));
        property.setCustomizableFeedMappings(this.readCustomizableFeedMappings(reader));
        property.setMimeType(reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "MimeType"));
        EdmAnnotationsImpl annotations = new EdmAnnotationsImpl();
        annotations.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "Property".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (!annotationElements.isEmpty()) {
            annotations.setAnnotationElements(annotationElements);
        }
        property.setAnnotations(annotations);
        return property;
    }

    private EdmPropertyImpl readComplexProperty(XMLStreamReader reader, FullQualifiedName fqName, Edm edm) throws XMLStreamException, EdmException {
        EdmComplexPropertyImpl property = new EdmComplexPropertyImpl();
        property.setName(reader.getAttributeValue(null, "Name"));
        property.setTypeName(fqName);
        property.setEdm((EdmImpl)edm);
        this.complexPropertyMap.put(fqName, property);
        return property;
    }

    private EdmPropertyImpl readSimpleProperty(XMLStreamReader reader, FullQualifiedName fqName) throws XMLStreamException, EdmException {
        EdmSimplePropertyImpl property = new EdmSimplePropertyImpl();
        property.setName(reader.getAttributeValue(null, "Name"));
        property.setTypeName(fqName);
        property.setSimpleType(EdmSimpleTypeKind.valueOf(fqName.getName()));
        property.setEdmType(EdmSimpleTypeFacadeImpl.getEdmSimpleType(property.getSimpleType()));
        return property;
    }

    private EdmFacets readFacets(XMLStreamReader reader) throws XMLStreamException {
        String isNullable = reader.getAttributeValue(null, "Nullable");
        String maxLength = reader.getAttributeValue(null, "MaxLength");
        String precision = reader.getAttributeValue(null, "Precision");
        String scale = reader.getAttributeValue(null, "Scale");
        String isFixedLength = reader.getAttributeValue(null, "FixedLength");
        String isUnicode = reader.getAttributeValue(null, "Unicode");
        String concurrencyMode = reader.getAttributeValue(null, "ConcurrencyMode");
        String defaultValue = reader.getAttributeValue(null, "DefaultValue");
        String collation = reader.getAttributeValue(null, "Collation");
        if (isNullable != null || maxLength != null || precision != null || scale != null || isFixedLength != null || isUnicode != null || concurrencyMode != null || defaultValue != null || collation != null) {
            Facets facets = new Facets();
            if (isNullable != null) {
                facets.setNullable("true".equalsIgnoreCase(isNullable));
            }
            if (maxLength != null) {
                if ("Max".equals(maxLength) || "max".equals(maxLength)) {
                    facets.setMaxLength(Integer.MAX_VALUE);
                } else {
                    facets.setMaxLength(Integer.parseInt(maxLength));
                }
            }
            if (precision != null) {
                facets.setPrecision(Integer.parseInt(precision));
            }
            if (scale != null) {
                facets.setScale(Integer.parseInt(scale));
            }
            if (isFixedLength != null) {
                facets.setFixedLength("true".equalsIgnoreCase(isFixedLength));
            }
            if (isUnicode != null) {
                facets.setUnicode("true".equalsIgnoreCase(isUnicode));
            }
            for (int i = 0; i < EdmConcurrencyMode.values().length; ++i) {
                if (!EdmConcurrencyMode.values()[i].name().equalsIgnoreCase(concurrencyMode)) continue;
                facets.setConcurrencyMode(EdmConcurrencyMode.values()[i]);
            }
            facets.setDefaultValue(defaultValue);
            facets.setCollation(collation);
            return facets;
        }
        return null;
    }

    private EdmCustomizableFeedMappings readCustomizableFeedMappings(XMLStreamReader reader) {
        String targetPath = reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "FC_TargetPath");
        String sourcePath = reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "FC_SourcePath");
        String nsUri = reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "FC_NsUri");
        String nsPrefix = reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "FC_NsPrefix");
        String keepInContent = reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "FC_KeepInContent");
        String contentKind = reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "FC_ContentKind");
        if (targetPath != null || sourcePath != null || nsUri != null || nsPrefix != null || keepInContent != null || contentKind != null) {
            EdmCustomizableFeedMappingsImpl feedMapping;
            EdmCustomizableFeedMappingsImpl feedMappingImpl = feedMapping = new EdmCustomizableFeedMappingsImpl();
            if (keepInContent != null) {
                feedMappingImpl.setFcKeepInContent("true".equals(keepInContent));
            }
            for (int i = 0; i < EdmContentKind.values().length; ++i) {
                if (!EdmContentKind.values()[i].name().equalsIgnoreCase(contentKind)) continue;
                feedMappingImpl.setFcContentKind(EdmContentKind.values()[i]);
            }
            feedMappingImpl.setFcTargetPath(targetPath).setFcSourcePath(sourcePath).setFcNsUri(nsUri).setFcNsPrefix(nsPrefix);
            return feedMapping;
        }
        return null;
    }

    private EdmMetadataAssociationEnd readAssociationEnd(XMLStreamReader reader, EdmImpl edm) throws EntityProviderException, XMLStreamException {
        reader.require(1, this.edmNamespace, "End");
        EdmAssociationEndImpl associationEnd = new EdmAssociationEndImpl();
        EdmAnnotationsImpl annotations = new EdmAnnotationsImpl();
        ArrayList<EdmAnnotationElement> annotationElements = new ArrayList<EdmAnnotationElement>();
        associationEnd.setRole(reader.getAttributeValue(null, "Role"));
        associationEnd.setMultiplicity(EdmMultiplicity.fromLiteral(reader.getAttributeValue(null, "Multiplicity")));
        String type = reader.getAttributeValue(null, "Type");
        if (type == null) {
            throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent("Type").addContent("End"));
        }
        associationEnd.setEdm(edm);
        associationEnd.setType(this.extractFQName(type));
        annotations.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "End".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            this.currentHandledStartTagName = reader.getLocalName();
            if ("OnDelete".equals(this.currentHandledStartTagName)) {
                EdmOnDeleteImpl onDelete = new EdmOnDeleteImpl();
                for (int i = 0; i < EdmAction.values().length; ++i) {
                    if (!EdmAction.values()[i].name().equalsIgnoreCase(reader.getAttributeValue(null, "Action"))) continue;
                    onDelete.setAction(EdmAction.values()[i]);
                }
                associationEnd.setOnDelete(onDelete);
                continue;
            }
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (!annotationElements.isEmpty()) {
            annotations.setAnnotationElements(annotationElements);
        }
        associationEnd.setAnnotations(annotations);
        return associationEnd;
    }

    private EdmAnnotationElement readAnnotationElement(XMLStreamReader reader) throws XMLStreamException {
        EdmAnnotationElementImpl elementImpl = new EdmAnnotationElementImpl();
        ArrayList<EdmAnnotationElement> annotationElements = new ArrayList<EdmAnnotationElement>();
        ArrayList<EdmAnnotationAttribute> annotationAttributes = new ArrayList<EdmAnnotationAttribute>();
        elementImpl.setName(reader.getLocalName());
        String elementNamespace = reader.getNamespaceURI();
        if (!this.edmNamespaces.contains(elementNamespace)) {
            elementImpl.setPrefix(reader.getPrefix());
            elementImpl.setNamespace(elementNamespace);
        }
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            EdmAnnotationAttributeImpl annotationAttribute = new EdmAnnotationAttributeImpl();
            annotationAttribute.setText(reader.getAttributeValue(i));
            annotationAttribute.setName(reader.getAttributeLocalName(i));
            annotationAttribute.setPrefix(reader.getAttributePrefix(i));
            String namespace = reader.getAttributeNamespace(i);
            if (namespace != null && !this.isDefaultNamespace(namespace)) {
                annotationAttribute.setNamespace(namespace);
            }
            annotationAttributes.add(annotationAttribute);
        }
        if (!annotationAttributes.isEmpty()) {
            elementImpl.setAttributes(annotationAttributes);
        }
        boolean justRead = false;
        if (reader.hasNext()) {
            reader.next();
            justRead = true;
        }
        while (!(!justRead || reader.isEndElement() && elementImpl.getName() != null && elementImpl.getName().equals(reader.getLocalName()))) {
            justRead = false;
            if (reader.isStartElement()) {
                annotationElements.add(this.readAnnotationElement(reader));
                if (!reader.hasNext()) continue;
                reader.next();
                justRead = true;
                continue;
            }
            if (!reader.isCharacters()) continue;
            String elementText = "";
            do {
                justRead = false;
                elementText = elementText + reader.getText();
                if (!reader.hasNext()) continue;
                reader.next();
                justRead = true;
            } while (justRead && reader.isCharacters());
            elementImpl.setText(elementText);
        }
        if (!annotationElements.isEmpty()) {
            elementImpl.setChildElements(annotationElements);
        }
        return elementImpl;
    }

    private List<EdmAnnotationAttribute> readAnnotationAttribute(XMLStreamReader reader) {
        ArrayList<EdmAnnotationAttribute> annotationAttributes = new ArrayList<EdmAnnotationAttribute>();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace == null || this.isDefaultNamespace(attributeNamespace) || this.mandatoryNamespaces.containsValue(attributeNamespace) || this.edmNamespaces.contains(attributeNamespace)) continue;
            annotationAttributes.add(new EdmAnnotationAttributeImpl().setName(reader.getAttributeLocalName(i)).setPrefix(reader.getAttributePrefix(i)).setNamespace(attributeNamespace).setText(reader.getAttributeValue(i)));
        }
        if (annotationAttributes.isEmpty()) {
            return null;
        }
        return annotationAttributes;
    }

    private boolean isDefaultNamespace(String namespace) {
        return namespace.isEmpty();
    }

    private void checkMandatoryNamespacesAvailable() throws EntityProviderException {
        if (!this.xmlNamespaceMap.containsValue("http://schemas.microsoft.com/ado/2007/06/edmx")) {
            throw new EntityProviderException(EntityProviderException.INVALID_NAMESPACE.addContent("http://schemas.microsoft.com/ado/2007/06/edmx"));
        }
        if (!this.xmlNamespaceMap.containsValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata")) {
            throw new EntityProviderException(EntityProviderException.INVALID_NAMESPACE.addContent("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata"));
        }
    }

    private void checkEdmNamespace() throws EntityProviderException {
        if (!this.edmNamespaces.contains(this.edmNamespace)) {
            throw new EntityProviderException(EntityProviderException.INVALID_NAMESPACE.addContent("Schema"));
        }
    }

    private void extractNamespaces(XMLStreamReader reader) throws EntityProviderException {
        int namespaceCount = reader.getNamespaceCount();
        for (int i = 0; i < namespaceCount; ++i) {
            String namespacePrefix = reader.getNamespacePrefix(i);
            String namespaceUri = reader.getNamespaceURI(i);
            if (namespacePrefix == null || this.isDefaultNamespace(namespacePrefix)) {
                namespacePrefix = "edm";
            }
            if (this.xmlNamespaceMap.containsKey(namespacePrefix)) continue;
            this.xmlNamespaceMap.put(namespacePrefix, namespaceUri);
        }
    }

    private FullQualifiedName extractFQName(String name) throws EntityProviderException {
        String[] names = name.split("\\.(?=[^\\.]+$)");
        if (names.length != 2) {
            throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent("Attribute should specify a namespace qualified name or an alias qualified name"));
        }
        return new FullQualifiedName(names[0], names[1]);
    }

    private FullQualifiedName extractFQNameFromEntityType(EdmEntityType entity) throws EntityProviderException, EdmException {
        return new FullQualifiedName(entity.getNamespace(), entity.getName());
    }

    private FullQualifiedName validateEntityTypeWithAlias(FullQualifiedName aliasName) throws EntityProviderException {
        String namespace = this.aliasNamespaceMap.get(aliasName.getNamespace());
        FullQualifiedName fqName = new FullQualifiedName(namespace, aliasName.getName());
        if (!this.entityTypesMap.containsKey(fqName)) {
            throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent("Invalid Type"));
        }
        return fqName;
    }

    private void validateEntityTypes() throws EntityProviderException, EdmException {
        for (Map.Entry<FullQualifiedName, EdmEntityType> entityTypes : this.entityTypesMap.entrySet()) {
            if (entityTypes.getValue() == null || entityTypes.getKey() == null) continue;
            EdmEntityTypeImpl entityType = (EdmEntityTypeImpl)entityTypes.getValue();
            if (entityType.getBaseTypeName() != null) {
                EdmEntityType baseEntityType;
                FullQualifiedName baseTypeFQName = entityType.getBaseTypeName();
                if (!this.entityTypesMap.containsKey(baseTypeFQName)) {
                    FullQualifiedName fqName = this.validateEntityTypeWithAlias(baseTypeFQName);
                    baseEntityType = this.entityTypesMap.get(fqName);
                } else {
                    baseEntityType = this.fetchLastBaseType(baseTypeFQName, this.entityTypesMap);
                }
                if (baseEntityType == null || baseEntityType.getKeyProperties() != null && !baseEntityType.getKeyProperties().isEmpty()) continue;
                throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent("Missing key for EntityType " + baseEntityType.getName()));
            }
            if (entityType.getKeyProperties() != null && !entityType.getKeyProperties().isEmpty()) continue;
            throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent("Missing key for EntityType " + entityType.getName()));
        }
    }

    private EdmEntityType fetchLastBaseType(FullQualifiedName baseTypeFQName, Map<FullQualifiedName, EdmEntityType> entityTypesMap2) throws EntityProviderException, EdmException {
        EdmEntityTypeImpl baseEntityType = null;
        while (baseTypeFQName != null) {
            baseEntityType = (EdmEntityTypeImpl)entityTypesMap2.get(baseTypeFQName);
            if (baseEntityType == null) continue;
            if (baseEntityType.getKeyPropertyNames() != null && !baseEntityType.getKeyPropertyNames().isEmpty()) break;
            if (baseEntityType.getBaseType() != null) {
                baseTypeFQName = baseEntityType.getBaseTypeName();
                continue;
            }
            if (baseEntityType.getBaseType() != null) continue;
            break;
        }
        return baseEntityType;
    }

    private FullQualifiedName validateComplexTypeWithAlias(FullQualifiedName aliasName) throws EntityProviderException {
        String namespace = this.aliasNamespaceMap.get(aliasName.getNamespace());
        FullQualifiedName fqName = new FullQualifiedName(namespace, aliasName.getName());
        if (!this.complexTypesMap.containsKey(fqName)) {
            throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent("Invalid BaseType").addContent(fqName));
        }
        return fqName;
    }

    private void validateComplexTypes() throws EntityProviderException, EdmException {
        for (Map.Entry<FullQualifiedName, EdmComplexType> complexTypes : this.complexTypesMap.entrySet()) {
            FullQualifiedName baseTypeFQName;
            EdmComplexTypeImpl complexType;
            if (complexTypes.getValue() == null || complexTypes.getKey() == null || (complexType = (EdmComplexTypeImpl)complexTypes.getValue()).getBaseType() == null || this.complexTypesMap.containsKey(baseTypeFQName = complexType.getEdmBaseTypeName())) continue;
            this.validateComplexTypeWithAlias(baseTypeFQName);
        }
    }

    private void validateRelationship() throws EntityProviderException, EdmException {
        for (EdmNavigationProperty navProperty : this.navProperties) {
            EdmNavigationPropertyImpl navigationImpl = (EdmNavigationPropertyImpl)navProperty;
            if (this.associationsMap.containsKey(navigationImpl.getRelationshipName())) {
                EdmEntityType entityType;
                EdmAssociationImpl assoc = (EdmAssociationImpl)this.associationsMap.get(navigationImpl.getRelationshipName());
                if (!(assoc.getEnd1().getRole().equals(navProperty.getFromRole()) ^ assoc.getEnd1().getRole().equals(navProperty.getToRole())) || !(assoc.getEnd2().getRole().equals(navProperty.getFromRole()) ^ assoc.getEnd2().getRole().equals(navProperty.getToRole()))) {
                    throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent("Invalid end of association"));
                }
                if (!this.entityTypesMap.containsKey(this.extractFQNameFromEntityType(assoc.getEnd1().getEntityType()))) {
                    entityType = assoc.getEnd1().getEntityType();
                    this.validateEntityTypeWithAlias(this.extractFQNameFromEntityType(entityType));
                }
                if (this.entityTypesMap.containsKey(this.extractFQNameFromEntityType(assoc.getEnd2().getEntityType()))) continue;
                entityType = assoc.getEnd2().getEntityType();
                this.validateEntityTypeWithAlias(this.extractFQNameFromEntityType(entityType));
                continue;
            }
            throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent("Invalid Relationship"));
        }
    }

    private void validateAssociation() throws EntityProviderException, EdmException {
        for (Map.Entry<FullQualifiedName, EdmEntityContainer> container : this.containerMap.entrySet()) {
            for (EdmAssociationSet associationSet : container.getValue().getAssociationSets()) {
                FullQualifiedName association = new FullQualifiedName(associationSet.getAssociation().getNamespace(), associationSet.getAssociation().getName());
                if (this.associationsMap.containsKey(association)) {
                    this.validateAssociationEnd(((EdmAssociationSetImpl)associationSet).getEnd1(), this.associationsMap.get(association));
                    this.validateAssociationEnd(((EdmAssociationSetImpl)associationSet).getEnd2(), this.associationsMap.get(association));
                    boolean end1 = false;
                    boolean end2 = false;
                    for (EdmEntitySet entitySet : container.getValue().getEntitySets()) {
                        EdmAssociationSetEnd associationSetEnd1 = ((EdmAssociationSetImpl)associationSet).getEnd1();
                        if (entitySet.getName().equals(((EdmAssociationSetEndImpl)associationSetEnd1).getEntitySetName())) {
                            end1 = true;
                        }
                        EdmAssociationSetEnd associationSetEnd2 = ((EdmAssociationSetImpl)associationSet).getEnd2();
                        if (!entitySet.getName().equals(((EdmAssociationSetEndImpl)associationSetEnd2).getEntitySetName())) continue;
                        end2 = true;
                    }
                    if (end1 && end2) continue;
                    throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent("Invalid AssociationSet"));
                }
                throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent("Invalid AssociationSet"));
            }
        }
    }

    private void validateAssociationEnd(EdmAssociationSetEnd end, EdmAssociation association) throws EntityProviderException, EdmException {
        if (!(association.getEnd1().getRole().equals(end.getRole()) ^ association.getEnd2().getRole().equals(end.getRole()))) {
            throw new EntityProviderException(EntityProviderException.COMMON.addContent("Invalid Association"));
        }
    }

    private void validateEntitySet() throws EntityProviderException, EdmException {
        for (Map.Entry<FullQualifiedName, EdmEntityContainer> container : this.containerMap.entrySet()) {
            for (EdmEntitySet entitySet : container.getValue().getEntitySets()) {
                FullQualifiedName entityType = this.extractFQNameFromEntityType(entitySet.getEntityType());
                if (this.entityTypesMap.containsKey(entityType)) continue;
                this.validateEntityTypeWithAlias(entityType);
            }
        }
    }

    private void validateFunctionImport() throws EntityProviderException, EdmException {
        for (EdmFunctionImport functionImport : this.edmFunctionImportList) {
            EdmTyped returnType = functionImport.getReturnType();
            if (returnType == null) continue;
            FullQualifiedName fqn = this.extractFQName(returnType.toString());
            String entitySet = ((EdmFunctionImportImpl)functionImport).getEntitySetName();
            if (returnType.getMultiplicity() == EdmMultiplicity.MANY && entitySet == null && this.entityTypesMap.get(fqn) != null) {
                throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent("EntitySet = " + entitySet, "FunctionImport = " + functionImport.getName()));
            }
            if (returnType.getMultiplicity() == EdmMultiplicity.MANY || entitySet == null || this.entityTypesMap.get(fqn) != null) continue;
            throw new EntityProviderException(EntityProviderException.INVALID_ATTRIBUTE.addContent("EntitySet = " + entitySet, "FunctionImport = " + functionImport.getName()));
        }
    }

    private void validate() throws EntityProviderException, EdmException {
        this.checkMandatoryNamespacesAvailable();
        this.validateEntityTypes();
        this.validateComplexTypes();
        this.validateRelationship();
        this.validateEntitySet();
        this.validateAssociation();
        this.validateFunctionImport();
    }

    private void initialize() {
        this.xmlNamespaceMap = new HashMap<String, String>();
        this.mandatoryNamespaces = new HashMap<String, String>();
        this.mandatoryNamespaces.put("edmx", "http://schemas.microsoft.com/ado/2007/06/edmx");
        this.mandatoryNamespaces.put("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata");
        this.edmNamespaces = new HashSet<String>();
        this.edmNamespaces.add("http://schemas.microsoft.com/ado/2006/04/edm");
        this.edmNamespaces.add("http://schemas.microsoft.com/ado/2007/05/edm");
        this.edmNamespaces.add("http://schemas.microsoft.com/ado/2008/01/edm");
        this.edmNamespaces.add("http://schemas.microsoft.com/ado/2008/09/edm");
    }
}

