/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.client.core.ep.deserializer;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.entry.DeletedEntryMetadata;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.ODataDeltaFeed;
import org.apache.olingo.odata2.api.ep.feed.ODataFeed;
import org.apache.olingo.odata2.client.api.ep.DeserializerProperties;
import org.apache.olingo.odata2.client.core.ep.deserializer.JsonEntryDeserializer;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.feed.FeedMetadataImpl;
import org.apache.olingo.odata2.core.ep.feed.JsonFeedEntry;
import org.apache.olingo.odata2.core.ep.feed.ODataDeltaFeedImpl;

public class JsonFeedDeserializer {
    private JsonReader reader;
    private EntityInfoAggregator eia;
    private DeserializerProperties readProperties;
    private List<DeletedEntryMetadata> deletedEntries = new ArrayList<DeletedEntryMetadata>();
    private List<ODataEntry> entries = new ArrayList<ODataEntry>();
    private FeedMetadataImpl feedMetadata = new FeedMetadataImpl();
    private boolean resultsArrayPresent = false;
    private static final String JSONFEED = "JsonFeed";

    public JsonFeedDeserializer(JsonReader reader, EntityInfoAggregator eia, DeserializerProperties readProperties) {
        this.reader = reader;
        this.eia = eia;
        this.readProperties = readProperties;
    }

    public ODataDeltaFeed readFeedStandalone() throws EntityProviderException {
        try {
            this.readFeed();
            if (this.reader.peek() != JsonToken.END_DOCUMENT) {
                throw new EntityProviderException(EntityProviderException.END_DOCUMENT_EXPECTED.addContent(this.reader.peek().toString()));
            }
        }
        catch (IOException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
        catch (EdmException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
        return new ODataDeltaFeedImpl(this.entries, this.feedMetadata, this.deletedEntries);
    }

    private void readFeed() throws IOException, EdmException, EntityProviderException {
        JsonToken peek = this.reader.peek();
        if (peek == JsonToken.BEGIN_ARRAY) {
            this.readArrayContent();
        } else {
            this.reader.beginObject();
            String nextName = this.reader.nextName();
            if ("d".equals(nextName)) {
                if (this.reader.peek() == JsonToken.BEGIN_ARRAY) {
                    this.readArrayContent();
                } else {
                    this.reader.beginObject();
                    this.readFeedContent();
                    this.reader.endObject();
                }
            } else {
                this.handleName(nextName);
                this.readFeedContent();
            }
            this.reader.endObject();
        }
    }

    private void readFeedContent() throws IOException, EdmException, EntityProviderException {
        while (this.reader.hasNext()) {
            String nextName = this.reader.nextName();
            this.handleName(nextName);
        }
        if (!this.resultsArrayPresent) {
            throw new EntityProviderException(EntityProviderException.MISSING_RESULTS_ARRAY);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleName(String nextName) throws IOException, EdmException, EntityProviderException {
        if ("results".equals(nextName)) {
            this.resultsArrayPresent = true;
            this.readArrayContent();
            return;
        } else if ("__count".equals(nextName)) {
            JsonFeedDeserializer.readInlineCount(this.reader, this.feedMetadata);
            return;
        } else if ("__next".equals(nextName)) {
            if (this.reader.peek() != JsonToken.STRING || this.feedMetadata.getNextLink() != null) throw new EntityProviderException(EntityProviderException.INVALID_CONTENT.addContent(nextName).addContent(JSONFEED));
            String nextLink = this.reader.nextString();
            this.feedMetadata.setNextLink(nextLink);
            return;
        } else {
            if (!"__delta".equals(nextName)) throw new EntityProviderException(EntityProviderException.INVALID_CONTENT.addContent(nextName).addContent(JSONFEED));
            if (this.reader.peek() != JsonToken.STRING || this.feedMetadata.getDeltaLink() != null) throw new EntityProviderException(EntityProviderException.INVALID_CONTENT.addContent(nextName).addContent(JSONFEED));
            String deltaLink = this.reader.nextString();
            this.feedMetadata.setDeltaLink(deltaLink);
        }
    }

    private void readArrayContent() throws IOException, EdmException, EntityProviderException {
        this.reader.beginArray();
        while (this.reader.hasNext()) {
            JsonFeedEntry entry = new JsonEntryDeserializer(this.reader, this.eia, this.readProperties).readFeedEntry();
            if (entry.isODataEntry()) {
                this.entries.add(entry.getODataEntry());
                continue;
            }
            this.deletedEntries.add(entry.getDeletedEntryMetadata());
        }
        this.reader.endArray();
    }

    protected static void readInlineCount(JsonReader reader, FeedMetadataImpl feedMetadata) throws IOException, EntityProviderException {
        int inlineCount;
        if (reader.peek() == JsonToken.STRING && feedMetadata.getInlineCount() == null) {
            try {
                inlineCount = reader.nextInt();
            }
            catch (NumberFormatException e) {
                throw new EntityProviderException(EntityProviderException.INLINECOUNT_INVALID.addContent(""), (Throwable)e);
            }
            if (inlineCount < 0) {
                throw new EntityProviderException(EntityProviderException.INLINECOUNT_INVALID.addContent(inlineCount));
            }
        } else {
            throw new EntityProviderException(EntityProviderException.INLINECOUNT_INVALID.addContent(reader.peek()));
        }
        feedMetadata.setInlineCount(inlineCount);
    }

    protected ODataFeed readStartedInlineFeed(String name) throws EdmException, EntityProviderException, IOException {
        this.handleName(name);
        this.readFeedContent();
        return new ODataDeltaFeedImpl(this.entries, this.feedMetadata);
    }

    protected ODataFeed readInlineFeedStandalone() throws EdmException, EntityProviderException, IOException {
        this.readFeed();
        return new ODataDeltaFeedImpl(this.entries, this.feedMetadata);
    }
}

