/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.client.core.edm.Impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmNamed;
import org.apache.olingo.odata2.client.core.edm.Impl.EdmImpl;

public abstract class EdmNamedImpl
implements EdmNamed {
    private static final Pattern PATTERN_VALID_NAME = Pattern.compile("\\A[_\\p{L}\\p{Nl}][_\\p{L}\\p{Nl}\\p{Nd}\\p{Mn}\\p{Mc}\\p{Pc}\\p{Cf}]{0,}\\Z");
    protected EdmImpl edm;
    protected String name;

    public void setEdm(EdmImpl edm) {
        this.edm = edm;
    }

    public void setName(String name) throws EdmException {
        this.name = this.getValidatedName(name);
    }

    @Override
    public String getName() throws EdmException {
        return this.name;
    }

    private String getValidatedName(String name) throws EdmException {
        Matcher matcher = PATTERN_VALID_NAME.matcher(name);
        if (matcher.matches()) {
            return name;
        }
        throw new EdmException(EdmException.NAMINGERROR.addContent(name));
    }

    public String toString() {
        return String.format(this.name, new Object[0]);
    }
}

