/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.client.core;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.exception.ODataNotAcceptableException;
import org.apache.olingo.odata2.api.uri.PathSegment;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.api.uri.UriNotMatchingException;
import org.apache.olingo.odata2.api.uri.UriSyntaxException;
import org.apache.olingo.odata2.client.api.ODataClient;
import org.apache.olingo.odata2.client.api.edm.EdmDataServices;
import org.apache.olingo.odata2.client.api.ep.ContentTypeBasedDeserializer;
import org.apache.olingo.odata2.client.api.ep.ContentTypeBasedSerializer;
import org.apache.olingo.odata2.client.api.ep.DeserializerMetadataProviderInterface;
import org.apache.olingo.odata2.client.api.uri.EdmURIBuilder;
import org.apache.olingo.odata2.client.api.uri.URIBuilder;
import org.apache.olingo.odata2.client.core.ep.AtomSerializerDeserializer;
import org.apache.olingo.odata2.client.core.ep.JsonSerializerDeserializer;
import org.apache.olingo.odata2.client.core.ep.deserializer.XmlMetadataDeserializer;
import org.apache.olingo.odata2.client.core.uri.EdmURIBuilderImpl;
import org.apache.olingo.odata2.client.core.uri.URIBuilderImpl;
import org.apache.olingo.odata2.core.ODataPathSegmentImpl;
import org.apache.olingo.odata2.core.commons.ContentType;
import org.apache.olingo.odata2.core.uri.UriParserImpl;

public class ODataClientImpl
extends ODataClient
implements DeserializerMetadataProviderInterface {
    private static final String AMP = "&";
    private static final String EQUAL = "=";
    private static final String QUESTIONMARK = "\\?";
    private static final String SLASH = "/";

    @Override
    public ContentTypeBasedSerializer createSerializer(String contentType) throws EntityProviderException {
        return this.createSerializer(ContentType.createAsCustom(contentType));
    }

    private ContentTypeBasedSerializer createSerializer(ContentType contentType) throws EntityProviderException {
        try {
            switch (contentType.getODataFormat()) {
                case ATOM: 
                case XML: {
                    return new AtomSerializerDeserializer(contentType.getODataFormat());
                }
                case JSON: {
                    return new JsonSerializerDeserializer();
                }
            }
            throw new ODataNotAcceptableException(ODataNotAcceptableException.NOT_SUPPORTED_CONTENT_TYPE.addContent(contentType));
        }
        catch (ODataNotAcceptableException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    @Override
    public ContentTypeBasedDeserializer createDeserializer(String contentType) throws EntityProviderException {
        return this.createDeserializer(ContentType.createAsCustom(contentType));
    }

    private ContentTypeBasedDeserializer createDeserializer(ContentType contentType) throws EntityProviderException {
        try {
            switch (contentType.getODataFormat()) {
                case ATOM: 
                case XML: {
                    return new AtomSerializerDeserializer(contentType.getODataFormat());
                }
                case JSON: {
                    return new JsonSerializerDeserializer();
                }
            }
            throw new ODataNotAcceptableException(ODataNotAcceptableException.NOT_SUPPORTED_CONTENT_TYPE.addContent(contentType));
        }
        catch (ODataNotAcceptableException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    @Override
    public EdmDataServices readMetadata(InputStream content, boolean validate) throws EntityProviderException, EdmException {
        return new XmlMetadataDeserializer().readMetadata(content, validate);
    }

    @Override
    public UriInfo parseUri(Edm edm, List<PathSegment> pathSegments, Map<String, List<String>> queryParameters) throws UriSyntaxException, UriNotMatchingException, EdmException {
        return new UriParserImpl(edm).parseAll(pathSegments, queryParameters);
    }

    @Override
    public UriInfo parseUri(Edm edm, String uri) throws UriSyntaxException, UriNotMatchingException, EdmException {
        String[] path = uri.split(QUESTIONMARK, -1);
        if (path.length > 2) {
            throw new UriSyntaxException(UriSyntaxException.URISYNTAX);
        }
        List<PathSegment> pathSegments = this.getPathSegments(path[0]);
        Map<Object, Object> queryParameters = path.length == 2 ? this.getQueryParameters(this.unescape(path[1])) : new HashMap();
        return new UriParserImpl(edm).parseAll(pathSegments, queryParameters);
    }

    private Map<String, List<String>> getQueryParameters(String uri) {
        HashMap<String, List<String>> allQueryParameters = new HashMap<String, List<String>>();
        for (String option : uri.split(AMP)) {
            String[] keyAndValue = option.split(EQUAL);
            LinkedList<String> list = allQueryParameters.containsKey(keyAndValue[0]) ? (List)allQueryParameters.get(keyAndValue[0]) : new LinkedList<String>();
            list.add(keyAndValue.length == 2 ? keyAndValue[1] : "");
            allQueryParameters.put(keyAndValue[0], list);
        }
        return allQueryParameters;
    }

    private List<PathSegment> getPathSegments(String uri) throws UriSyntaxException {
        ArrayList<PathSegment> pathSegments = new ArrayList<PathSegment>();
        for (String segment : uri.split(SLASH, -1)) {
            String unescapedSegment = this.unescape(segment);
            ODataPathSegmentImpl oDataSegment = new ODataPathSegmentImpl(unescapedSegment, null);
            pathSegments.add(oDataSegment);
        }
        return pathSegments;
    }

    private String unescape(String s) throws UriSyntaxException {
        try {
            return new URI(s).getPath();
        }
        catch (URISyntaxException e) {
            throw new UriSyntaxException(UriSyntaxException.NOTEXT, (Throwable)e);
        }
    }

    @Override
    public UriInfo parseUriWithStrictFilter(Edm edm, List<PathSegment> pathSegments, Map<String, String> queryParameters, boolean strictFilter) throws UriSyntaxException, UriNotMatchingException, EdmException {
        return new UriParserImpl(edm).parse(pathSegments, queryParameters, strictFilter);
    }

    @Override
    public UriInfo parseUriWithStrictFilter(Edm edm, String uri, boolean strictFilter) throws UriSyntaxException, UriNotMatchingException, EdmException {
        String[] path = uri.split(QUESTIONMARK, -1);
        if (path.length > 2) {
            throw new UriSyntaxException(UriSyntaxException.URISYNTAX);
        }
        List<PathSegment> pathSegments = this.getPathSegments(path[0]);
        Map<Object, Object> queryParameters = path.length == 2 ? this.getQueryParametersWithStrictFilter(this.unescape(path[1])) : new HashMap();
        return new UriParserImpl(edm).parse(pathSegments, queryParameters, strictFilter);
    }

    private Map<String, String> getQueryParametersWithStrictFilter(String uri) {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        for (String option : uri.split(AMP)) {
            String[] keyAndValue = option.split(EQUAL);
            if (keyAndValue.length == 2) {
                queryParameters.put(keyAndValue[0], keyAndValue[1]);
                continue;
            }
            queryParameters.put(keyAndValue[0], "");
        }
        return queryParameters;
    }

    @Override
    public EdmURIBuilder edmUriBuilder(String serviceRoot) {
        return new EdmURIBuilderImpl(serviceRoot);
    }

    @Override
    public URIBuilder uriBuilder(String serviceRoot) {
        return new URIBuilderImpl(serviceRoot);
    }
}

