/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.client.api;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.exception.ODataRuntimeApplicationException;
import org.apache.olingo.odata2.api.uri.PathSegment;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.api.uri.UriNotMatchingException;
import org.apache.olingo.odata2.api.uri.UriSyntaxException;
import org.apache.olingo.odata2.client.api.edm.EdmDataServices;
import org.apache.olingo.odata2.client.api.ep.ContentTypeBasedDeserializer;
import org.apache.olingo.odata2.client.api.ep.ContentTypeBasedSerializer;
import org.apache.olingo.odata2.client.api.uri.EdmURIBuilder;
import org.apache.olingo.odata2.client.api.uri.URIBuilder;

public abstract class ODataClient {
    private static final String IMPLEMENTATION = "org.apache.olingo.odata2.client.core.ODataClientImpl";

    public static ODataClient newInstance() {
        try {
            Class<?> clazz = Class.forName(IMPLEMENTATION);
            Object object = clazz.newInstance();
            return (ODataClient)object;
        }
        catch (Exception e) {
            throw new ODataRuntimeApplicationException(null, null, null, null, e);
        }
    }

    public abstract ContentTypeBasedSerializer createSerializer(String var1) throws EntityProviderException;

    public abstract ContentTypeBasedDeserializer createDeserializer(String var1) throws EntityProviderException;

    public abstract EdmDataServices readMetadata(InputStream var1, boolean var2) throws EntityProviderException, EdmException;

    public abstract UriInfo parseUri(Edm var1, List<PathSegment> var2, Map<String, List<String>> var3) throws UriSyntaxException, UriNotMatchingException, EdmException;

    public abstract UriInfo parseUri(Edm var1, String var2) throws UriSyntaxException, UriNotMatchingException, EdmException;

    public abstract UriInfo parseUriWithStrictFilter(Edm var1, List<PathSegment> var2, Map<String, String> var3, boolean var4) throws UriSyntaxException, UriNotMatchingException, EdmException;

    public abstract UriInfo parseUriWithStrictFilter(Edm var1, String var2, boolean var3) throws UriSyntaxException, UriNotMatchingException, EdmException;

    public abstract EdmURIBuilder edmUriBuilder(String var1);

    public abstract URIBuilder uriBuilder(String var1);
}

