/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataDeserializationException;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataResponseException;
import com.sap.cloud.sdk.datamodel.odata.client.request.MultipartHttpResponse;
import com.sap.cloud.sdk.datamodel.odata.client.request.MultipartParser;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataHealthyResponseValidator;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestBatch;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResult;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultMultipart;
import io.vavr.CheckedFunction0;
import io.vavr.Lazy;
import io.vavr.Tuple2;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODataRequestResultMultipartGeneric
implements ODataRequestResultMultipart,
ODataRequestResult,
AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ODataRequestResultMultipartGeneric.class);
    @Nonnull
    private final ODataRequestBatch batchRequest;
    @Nonnull
    private final HttpResponse httpResponse;
    @Nonnull
    private final Lazy<Try<List<List<HttpResponse>>>> batchResponses = Lazy.of(this::loadBatchResponses);
    @Nonnull
    private final List<Runnable> closeHandlers = new ArrayList<Runnable>();

    ODataRequestResultMultipartGeneric(@Nonnull ODataRequestBatch oDataRequest, @Nonnull HttpResponse httpResponse) {
        this.batchRequest = oDataRequest;
        this.httpResponse = httpResponse;
    }

    @Override
    @Nullable
    public StatusLine getStatusLine() {
        return this.httpResponse.getStatusLine();
    }

    @Override
    @Nonnull
    public ODataRequestBatch getODataRequest() {
        return this.batchRequest;
    }

    @Override
    @Nonnull
    public ODataRequestResultGeneric getResult(@Nonnull ODataRequestGeneric request) throws ODataResponseException, IllegalArgumentException {
        boolean isSingleResponse;
        Tuple2<Integer, Integer> responsePosition = ODataRequestBatch.getBatchItemPosition(this.batchRequest, request);
        if (responsePosition == null) {
            throw new IllegalArgumentException("Incorrect API usage. Please pass the original OData request reference that was handled as batch request item.");
        }
        log.debug("Looking for request {} in batch response at position {}", (Object)request, responsePosition);
        List<List<HttpResponse>> batchResponseItems = this.getBatchedResponses();
        if ((Integer)responsePosition._1() >= batchResponseItems.size()) {
            String msg = "Unable to extract batch response item at position %s. The response contains only %s items.";
            msg = String.format(msg, (Integer)responsePosition._1() + 1, batchResponseItems.size());
            throw new ODataResponseException(this.batchRequest, this.httpResponse, msg, null);
        }
        List<HttpResponse> subResponses = batchResponseItems.get((Integer)responsePosition._1());
        HttpResponse response = subResponses.get((isSingleResponse = responsePosition._2() == null || (Integer)responsePosition._2() >= subResponses.size()) ? 0 : (Integer)responsePosition._2());
        if (response == null) {
            String msg = "Illegal payload for " + String.valueOf(this.batchRequest.getProtocol()) + " batch response item.";
            throw new ODataDeserializationException(this.batchRequest, this.httpResponse, msg, null);
        }
        ODataRequestResultGeneric result = new ODataRequestResultGeneric(this.batchRequest, response);
        ODataHealthyResponseValidator.requireHealthyResponse(result);
        return result;
    }

    @Nonnull
    public List<List<HttpResponse>> getBatchedResponses() {
        return (List)((Try)this.batchResponses.get()).getOrElseThrow(e -> new ODataResponseException(this.getBatchRequest(), this.getHttpResponse(), "Failed to read " + String.valueOf(this.batchRequest.getProtocol()) + " batch response.", (Throwable)e));
    }

    @Nonnull
    private Try<List<List<HttpResponse>>> loadBatchResponses() {
        return Try.of((CheckedFunction0 & Serializable)() -> {
            MultipartParser parser = MultipartParser.ofHttpResponse(this.getHttpResponse());
            this.closeHandlers.add(parser::close);
            return parser.toList(MultipartHttpResponse::ofHttpContent);
        });
    }

    @Override
    public void close() {
        HttpEntity entity = this.getHttpResponse().getEntity();
        Try.run(() -> EntityUtils.consume((HttpEntity)entity)).onFailure(e -> log.warn("Failed to consume the HTTP entity.", e));
        this.closeHandlers.forEach(Runnable::run);
    }

    @Nonnull
    @Generated
    private ODataRequestBatch getBatchRequest() {
        return this.batchRequest;
    }

    @Override
    @Nonnull
    @Generated
    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }
}

