/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultResource;
import io.vavr.control.Option;
import io.vavr.control.Try;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.message.BasicHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
interface ODataRequestResultFactory {
    public static final ODataRequestResultFactory WITHOUT_BUFFER = ODataRequestResultResource::new;
    public static final ODataRequestResultFactory WITH_BUFFER = (oDataRequest, httpResponse, httpClient) -> {
        StatusLine status = httpResponse.getStatusLine();
        BasicHttpResponse copy = new BasicHttpResponse(status);
        Option.of((Object)httpResponse.getLocale()).peek(arg_0 -> ((BasicHttpResponse)copy).setLocale(arg_0));
        Option.of((Object)httpResponse.getAllHeaders()).peek(arg_0 -> ((BasicHttpResponse)copy).setHeaders(arg_0));
        Logger log = LoggerFactory.getLogger(ODataRequestResultFactory.class);
        Option.of((Object)httpResponse.getEntity()).onEmpty(() -> log.debug("HTTP response entity is empty: {}", (Object)status)).map(entity -> Try.run(() -> copy.setEntity((HttpEntity)new BufferedHttpEntity(entity)))).peek(b -> b.onSuccess(v -> log.debug("Successfully buffered the HTTP response entity."))).peek(b -> b.onFailure(e -> log.warn("Failed to buffer HTTP response entity: {}", (Object)status, e)));
        return new ODataRequestResultGeneric(oDataRequest, (HttpResponse)copy, httpClient);
    };

    public ODataRequestResultGeneric create(@Nonnull ODataRequestGeneric var1, @Nonnull HttpResponse var2, @Nullable HttpClient var3);
}

