/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.sap.cloud.sdk.cloudplatform.connectivity.CsrfToken;
import com.sap.cloud.sdk.cloudplatform.connectivity.CsrfTokenRetriever;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultCsrfTokenRetriever;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ODataResourcePath;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataFormat;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataHealthyResponseValidator;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestExecutable;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestListener;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultFactory;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.UriEncodingStrategy;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ODataRequestGeneric
implements ODataRequestExecutable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ODataRequestGeneric.class);
    private static final ODataFormat DEFAULT_FORMAT = ODataFormat.JSON;
    @Nonnull
    protected final String servicePath;
    @Nonnull
    protected final ODataResourcePath resourcePath;
    private final ODataProtocol protocol;
    private final List<ODataRequestListener> listeners = new ArrayList<ODataRequestListener>();
    final Map<String, Collection<String>> headers = new TreeMap<String, Collection<String>>();
    private final Map<String, String> queryParameters = new TreeMap<String, String>();
    @Nullable
    protected CsrfTokenRetriever csrfTokenRetriever;
    @Nonnull
    ODataRequestResultFactory requestResultFactory = ODataRequestResultFactory.WITH_BUFFER;

    ODataRequestGeneric(@Nonnull String servicePath, @Nonnull ODataResourcePath resourcePath, @Nonnull ODataProtocol protocol) {
        this.protocol = protocol;
        this.servicePath = servicePath;
        this.resourcePath = resourcePath;
        this.headers.putIfAbsent("Accept", Lists.newArrayList((Object[])new String[]{DEFAULT_FORMAT.getHttpAccept()}));
    }

    @Nonnull
    public abstract URI getRelativeUri(@Nonnull UriEncodingStrategy var1);

    @Nonnull
    public URI getRelativeUri() {
        return this.getRelativeUri(UriEncodingStrategy.REGULAR);
    }

    @Nonnull
    public String getRequestQuery() {
        return Joiner.on((String)"&").withKeyValueSeparator("=").join(this.queryParameters);
    }

    public void addListener(@Nonnull ODataRequestListener listener) {
        this.listeners.add(listener);
    }

    public void setHeader(@Nonnull String key, @Nullable String value) {
        ArrayList<String> values = new ArrayList<String>(1);
        values.add(value);
        this.headers.put(key, values);
    }

    public void setHeader(@Nonnull String key, @Nonnull Collection<String> values) {
        this.headers.put(key, new ArrayList<String>(values));
    }

    public void addHeader(@Nonnull String key, @Nullable String value) {
        this.headers.computeIfAbsent(key, k -> new ArrayList(1)).add(value);
    }

    public void addHeaderIfAbsent(@Nonnull String key, @Nullable String value) {
        this.headers.putIfAbsent(key, Lists.newArrayList((Object[])new String[]{value}));
    }

    public void addQueryParameter(@Nonnull String key, @Nullable String value) {
        this.queryParameters.put(key, value);
    }

    @Nonnull
    protected Try<ODataRequestResultGeneric> tryExecute(@Nonnull Supplier<HttpResponse> httpOperation, @Nonnull HttpClient httpClient) {
        return Try.ofSupplier(httpOperation).map(response -> this.requestResultFactory.create(this, (HttpResponse)response, httpClient)).andThenTry(ODataHealthyResponseValidator::requireHealthyResponse);
    }

    @Nonnull
    protected Try<ODataRequestResultGeneric> tryExecuteWithCsrfToken(@Nonnull HttpClient httpClient, @Nonnull Supplier<HttpResponse> httpOperation) {
        CsrfTokenRetriever csrfTokenRetriever = (CsrfTokenRetriever)Option.of((Object)this.csrfTokenRetriever).getOrElse(DefaultCsrfTokenRetriever::new);
        if (!csrfTokenRetriever.isEnabled() || this.getHeaders().containsKey("x-csrf-token")) {
            log.debug("CSRF token already present, skipping retrieval.");
            return this.tryExecute(httpOperation, httpClient);
        }
        Try<CsrfToken> csrfToken = this.tryGetCsrfToken(httpClient, csrfTokenRetriever);
        csrfToken.onSuccess(token -> this.addHeader("x-csrf-token", token.getToken()));
        Try<ODataRequestResultGeneric> oDataRequest = this.tryExecute(httpOperation, httpClient);
        if (oDataRequest.isFailure() && csrfToken.isFailure()) {
            oDataRequest.getCause().addSuppressed(csrfToken.getCause());
        }
        return oDataRequest;
    }

    @Nonnull
    public Map<String, Collection<String>> getHeaders() {
        return new TreeMap<String, Collection<String>>(this.headers);
    }

    @Nonnull
    Try<CsrfToken> tryGetCsrfToken(@Nonnull HttpClient httpClient, @Nonnull CsrfTokenRetriever csrfTokenRetriever) {
        return Try.of((CheckedFunction0 & Serializable)() -> csrfTokenRetriever.retrieveCsrfToken(httpClient, this.servicePath, this.getHeaders()));
    }

    void addVersionIdentifierToHeaderIfPresent(@Nullable String versionIdentifier) {
        if (versionIdentifier != null) {
            this.addHeaderIfAbsent("If-Match", versionIdentifier);
        } else {
            log.debug("Version identifier for {} is either not defined on the entity or is explicitly ignored.", (Object)this.getClass().getSimpleName());
        }
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ODataRequestGeneric)) {
            return false;
        }
        ODataRequestGeneric other = (ODataRequestGeneric)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$servicePath = this.getServicePath();
        String other$servicePath = other.getServicePath();
        if (this$servicePath == null ? other$servicePath != null : !this$servicePath.equals(other$servicePath)) {
            return false;
        }
        ODataResourcePath this$resourcePath = this.getResourcePath();
        ODataResourcePath other$resourcePath = other.getResourcePath();
        if (this$resourcePath == null ? other$resourcePath != null : !((Object)this$resourcePath).equals(other$resourcePath)) {
            return false;
        }
        ODataProtocol this$protocol = this.getProtocol();
        ODataProtocol other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        List<ODataRequestListener> this$listeners = this.getListeners();
        List<ODataRequestListener> other$listeners = other.getListeners();
        if (this$listeners == null ? other$listeners != null : !((Object)this$listeners).equals(other$listeners)) {
            return false;
        }
        Map<String, Collection<String>> this$headers = this.getHeaders();
        Map<String, Collection<String>> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Map<String, String> this$queryParameters = this.getQueryParameters();
        Map<String, String> other$queryParameters = other.getQueryParameters();
        if (this$queryParameters == null ? other$queryParameters != null : !((Object)this$queryParameters).equals(other$queryParameters)) {
            return false;
        }
        CsrfTokenRetriever this$csrfTokenRetriever = this.csrfTokenRetriever;
        CsrfTokenRetriever other$csrfTokenRetriever = other.csrfTokenRetriever;
        if (this$csrfTokenRetriever == null ? other$csrfTokenRetriever != null : !this$csrfTokenRetriever.equals(other$csrfTokenRetriever)) {
            return false;
        }
        ODataRequestResultFactory this$requestResultFactory = this.requestResultFactory;
        ODataRequestResultFactory other$requestResultFactory = other.requestResultFactory;
        return !(this$requestResultFactory == null ? other$requestResultFactory != null : !this$requestResultFactory.equals(other$requestResultFactory));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ODataRequestGeneric;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $servicePath = this.getServicePath();
        result = result * 59 + ($servicePath == null ? 43 : $servicePath.hashCode());
        ODataResourcePath $resourcePath = this.getResourcePath();
        result = result * 59 + ($resourcePath == null ? 43 : ((Object)$resourcePath).hashCode());
        ODataProtocol $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        List<ODataRequestListener> $listeners = this.getListeners();
        result = result * 59 + ($listeners == null ? 43 : ((Object)$listeners).hashCode());
        Map<String, Collection<String>> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Map<String, String> $queryParameters = this.getQueryParameters();
        result = result * 59 + ($queryParameters == null ? 43 : ((Object)$queryParameters).hashCode());
        CsrfTokenRetriever $csrfTokenRetriever = this.csrfTokenRetriever;
        result = result * 59 + ($csrfTokenRetriever == null ? 43 : $csrfTokenRetriever.hashCode());
        ODataRequestResultFactory $requestResultFactory = this.requestResultFactory;
        result = result * 59 + ($requestResultFactory == null ? 43 : $requestResultFactory.hashCode());
        return result;
    }

    @Nonnull
    @Generated
    public String getServicePath() {
        return this.servicePath;
    }

    @Nonnull
    @Generated
    protected ODataResourcePath getResourcePath() {
        return this.resourcePath;
    }

    @Generated
    public ODataProtocol getProtocol() {
        return this.protocol;
    }

    @Generated
    protected List<ODataRequestListener> getListeners() {
        return this.listeners;
    }

    @Generated
    protected Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    @Generated
    public void setCsrfTokenRetriever(@Nullable CsrfTokenRetriever csrfTokenRetriever) {
        this.csrfTokenRetriever = csrfTokenRetriever;
    }
}

