/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.google.common.base.Strings;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ODataResourcePath;
import com.sap.cloud.sdk.datamodel.odata.client.query.StructuredQuery;
import com.sap.cloud.sdk.datamodel.odata.client.request.AbstractODataParameters;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataFunctionParameters;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataHttpRequest;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataUriFactory;
import com.sap.cloud.sdk.datamodel.odata.client.request.UriEncodingStrategy;
import io.vavr.control.Try;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.client.HttpClient;

public class ODataRequestFunction
extends ODataRequestGeneric {
    @Nonnull
    private final String query;

    public ODataRequestFunction(@Nonnull String servicePath, @Nonnull String functionName, @Nonnull ODataFunctionParameters parameters, @Nonnull ODataProtocol protocol) {
        this(servicePath, protocol.isEqualTo(ODataProtocol.V2) ? ODataResourcePath.of(functionName) : ODataResourcePath.of(functionName, parameters), protocol.isEqualTo(ODataProtocol.V2) ? parameters.toEncodedString() : null, protocol);
    }

    public ODataRequestFunction(@Nonnull String servicePath, @Nonnull ODataResourcePath functionPath, @Nonnull ODataFunctionParameters parameters, @Nullable String query, @Nonnull ODataProtocol protocol) {
        this(servicePath, ODataRequestFunction.appendResourcePathWithParameters(functionPath, parameters, protocol), ODataRequestFunction.appendQueryWithParameters(query, parameters, protocol), protocol);
    }

    public ODataRequestFunction(@Nonnull String servicePath, @Nonnull ODataResourcePath functionPath, @Nullable String encodedQuery, @Nonnull ODataProtocol protocol) {
        super(servicePath, functionPath, protocol);
        this.query = encodedQuery != null ? encodedQuery : "";
    }

    public ODataRequestFunction(@Nonnull String servicePath, @Nonnull ODataResourcePath functionPath, @Nonnull StructuredQuery structQuery) {
        super(servicePath, functionPath.addSegment(structQuery.getEntityOrPropertyName()), structQuery.getProtocol());
        this.query = structQuery.getEncodedQueryString();
    }

    @Override
    @Nonnull
    public URI getRelativeUri(@Nonnull UriEncodingStrategy strategy) {
        return ODataUriFactory.createAndEncodeUri(this.getServicePath(), this.getResourcePath(), this.getRequestQuery(), strategy);
    }

    @Override
    @Nonnull
    public ODataRequestResultGeneric execute(@Nonnull HttpClient httpClient) {
        ODataHttpRequest request = ODataHttpRequest.withoutBody(this, httpClient);
        Try<ODataRequestResultGeneric> result = this.csrfTokenRetriever == null ? this.tryExecute(request::requestGet, httpClient) : this.tryExecuteWithCsrfToken(httpClient, request::requestGet);
        return (ODataRequestResultGeneric)result.get();
    }

    @Override
    @Nonnull
    public String getRequestQuery() {
        String genericQueryString = super.getRequestQuery();
        if (!genericQueryString.isEmpty() && !this.query.isEmpty()) {
            return this.query + "&" + genericQueryString;
        }
        return this.query + genericQueryString;
    }

    @Nonnull
    private static ODataResourcePath appendResourcePathWithParameters(@Nonnull ODataResourcePath path, @Nonnull ODataFunctionParameters parameters, @Nonnull ODataProtocol protocol) {
        if (protocol.isEqualTo(ODataProtocol.V2)) {
            return path;
        }
        ODataResourcePath appendedPath = new ODataResourcePath();
        path.getSegments().forEach(s -> appendedPath.addSegment((String)s._1, (AbstractODataParameters)s._2));
        return appendedPath.addParameterToLastSegment(parameters);
    }

    @Nullable
    private static String appendQueryWithParameters(@Nullable String query, @Nonnull ODataFunctionParameters parameters, @Nonnull ODataProtocol protocol) {
        if (protocol.isEqualTo(ODataProtocol.V4)) {
            return query;
        }
        String encodedParams = parameters.toEncodedString();
        return Strings.isNullOrEmpty((String)query) ? encodedParams : encodedParams + "&" + query;
    }

    @Nonnull
    @Generated
    public String getQuery() {
        return this.query;
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ODataRequestFunction)) {
            return false;
        }
        ODataRequestFunction other = (ODataRequestFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        return !(this$query == null ? other$query != null : !this$query.equals(other$query));
    }

    @Override
    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ODataRequestFunction;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        return result;
    }
}

