/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.request.AbstractODataParameters;
import com.sap.cloud.sdk.datamodel.odata.client.request.UriEncodingStrategy;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ODataFunctionParameters
extends AbstractODataParameters {
    private final AbstractODataParameters.ParameterFormat parameterFormat;

    public ODataFunctionParameters(@Nonnull ODataProtocol protocol) {
        super(protocol);
        this.parameterFormat = protocol.isEqualTo(ODataProtocol.V2) ? AbstractODataParameters.ParameterFormat.QUERY : AbstractODataParameters.ParameterFormat.PATH;
    }

    @Nonnull
    public static ODataFunctionParameters of(@Nonnull Map<String, Object> parameters, @Nonnull ODataProtocol protocol) {
        ODataFunctionParameters functionParameters = new ODataFunctionParameters(protocol);
        functionParameters.addParameterSetInternal(parameters);
        return functionParameters;
    }

    @Nonnull
    public static ODataFunctionParameters empty(@Nonnull ODataProtocol protocol) {
        return new ODataFunctionParameters(protocol);
    }

    @Nonnull
    public <PrimitiveT> ODataFunctionParameters addParameter(@Nonnull String parameterName, @Nullable PrimitiveT value) {
        this.addParameterInternal(parameterName, value);
        return this;
    }

    @Override
    @Nonnull
    public String toEncodedString() {
        return super.toStringInternal(UriEncodingStrategy.REGULAR, this.parameterFormat);
    }

    @Override
    @Nonnull
    public String toEncodedString(@Nonnull UriEncodingStrategy strategy) {
        return super.toStringInternal(strategy, this.parameterFormat);
    }

    @Override
    @Nonnull
    public String toString() {
        return super.toStringInternal(UriEncodingStrategy.NONE, this.parameterFormat);
    }
}

