/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.sap.cloud.sdk.datamodel.odata.client.request.MultipartParser;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.BasicStatusLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MultipartHttpResponse
extends BasicHttpResponse {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultipartHttpResponse.class);
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Pattern PATTERN_STATUS_LINE = Pattern.compile("^HTTP/(\\d).(\\d) (\\d+) (.*)");
    private static final Pattern PATTERN_NEW_LINE = Pattern.compile("\\R");
    @Nullable
    private final Integer contentId;

    private MultipartHttpResponse(@Nonnull StatusLine statusLine, @Nonnull List<Header> headers, @Nonnull HttpEntity entity, @Nullable Integer contentId) {
        super(statusLine);
        headers.forEach(arg_0 -> ((MultipartHttpResponse)this).addHeader(arg_0));
        this.setEntity(entity);
        this.contentId = contentId;
    }

    @Nonnull
    public static MultipartHttpResponse ofHttpContent(@Nonnull MultipartParser.Entry entry) {
        Matcher contentIdMatcher = Pattern.compile("^Content-ID:\\s*(\\d+)\\s*$", 10).matcher(entry.getMeta());
        Integer contentId = contentIdMatcher.find() ? Integer.valueOf(Integer.parseInt(contentIdMatcher.group(1))) : null;
        String[] lines = PATTERN_NEW_LINE.split(entry.getPayload());
        StatusLine statusLine = MultipartHttpResponse.getStatusLine(lines[0]);
        StringBuilder payload = new StringBuilder();
        StringBuilder header = new StringBuilder();
        boolean isHeaders = true;
        for (int i = 1; i < lines.length; ++i) {
            if (isHeaders) {
                if (lines[i].isEmpty()) {
                    isHeaders = false;
                    continue;
                }
                header.append(lines[i]).append('\n');
                continue;
            }
            payload.append(lines[i]).append('\n');
        }
        List<Header> headers = MultipartHttpResponse.getHeadersFromString(header.toString());
        ContentType contentType = MultipartHttpResponse.getContentType(headers).orElse(ContentType.APPLICATION_JSON);
        ContentType contentTypeCharset = MultipartHttpResponse.withFallbackCharset(contentType, DEFAULT_CHARSET);
        StringEntity httpEntity = new StringEntity(payload.toString(), contentTypeCharset);
        return new MultipartHttpResponse(statusLine, headers, (HttpEntity)httpEntity, contentId);
    }

    @Nonnull
    static List<Header> getHeadersFromString(@Nonnull String headerString) {
        ArrayList<Header> result = new ArrayList<Header>();
        for (String headerLine : PATTERN_NEW_LINE.split(headerString.trim())) {
            String[] split = headerLine.split(":", 2);
            result.add((Header)new BasicHeader(split[0].trim(), split.length > 1 ? split[1].trim() : ""));
        }
        return result;
    }

    @Nonnull
    static Optional<ContentType> getContentType(@Nonnull List<Header> headers) {
        return headers.stream().filter(h -> "Content-Type".equalsIgnoreCase(h.getName())).map(NameValuePair::getValue).map(contentType -> (ContentType)Try.of((CheckedFunction0 & Serializable)() -> ContentType.parse((String)contentType)).getOrNull()).filter(Objects::nonNull).findFirst();
    }

    @Nonnull
    private static ContentType withFallbackCharset(@Nonnull ContentType contentType, @Nonnull Charset fallbackCharset) {
        if (contentType.getCharset() != null) {
            return contentType;
        }
        return contentType.withParameters(new NameValuePair[]{new BasicNameValuePair("charset", fallbackCharset.name())});
    }

    @Nonnull
    private static StatusLine getStatusLine(@Nonnull String firstLine) {
        Matcher m = PATTERN_STATUS_LINE.matcher(firstLine);
        if (m.find()) {
            int major = Integer.parseInt(m.group(1));
            int minor = Integer.parseInt(m.group(2));
            int code = Integer.parseInt(m.group(3));
            String reason = m.group(4);
            return new BasicStatusLine((ProtocolVersion)new HttpVersion(major, minor), code, reason);
        }
        log.error("Failed to construct status line for HTTP protocol response: {}", (Object)firstLine);
        return new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 0, "Unknown");
    }

    @Nullable
    @Generated
    public Integer getContentId() {
        return this.contentId;
    }
}

