/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.expression;

import com.sap.cloud.sdk.datamodel.odata.client.expression.Expressions;
import com.sap.cloud.sdk.datamodel.odata.client.expression.FilterExpressionArithmetic;
import com.sap.cloud.sdk.datamodel.odata.client.expression.FilterExpressionTemporal;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueDate;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueDateTimeOffset;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueDuration;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueNumeric;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueTimeOfDay;
import java.time.Duration;
import javax.annotation.Nonnull;

public interface FilterableDateTimeOffset
extends Expressions.Operand {
    @Nonnull
    default public ValueDate.Expression date() {
        return FilterExpressionTemporal.date(this::getExpression);
    }

    @Nonnull
    default public ValueNumeric.Expression timeFractionalSeconds() {
        ValueDateTimeOffset thisDateTime = this::getExpression;
        return FilterExpressionTemporal.fractionalSeconds(thisDateTime);
    }

    @Nonnull
    default public ValueNumeric.Expression timeSecond() {
        ValueDateTimeOffset thisDateTime = this::getExpression;
        return FilterExpressionTemporal.second(thisDateTime);
    }

    @Nonnull
    default public ValueNumeric.Expression timeMinute() {
        ValueDateTimeOffset thisDateTime = this::getExpression;
        return FilterExpressionTemporal.minute(thisDateTime);
    }

    @Nonnull
    default public ValueNumeric.Expression timeHour() {
        ValueDateTimeOffset thisDateTime = this::getExpression;
        return FilterExpressionTemporal.hour(thisDateTime);
    }

    @Nonnull
    default public ValueNumeric.Expression dateDay() {
        ValueDateTimeOffset thisDateTime = this::getExpression;
        return FilterExpressionTemporal.day(thisDateTime);
    }

    @Nonnull
    default public ValueNumeric.Expression dateMonth() {
        ValueDateTimeOffset thisDateTime = this::getExpression;
        return FilterExpressionTemporal.month(thisDateTime);
    }

    @Nonnull
    default public ValueNumeric.Expression dateYear() {
        ValueDateTimeOffset thisDateTime = this::getExpression;
        return FilterExpressionTemporal.year(thisDateTime);
    }

    @Nonnull
    default public ValueTimeOfDay.Expression time() {
        return FilterExpressionTemporal.time(this::getExpression);
    }

    @Nonnull
    default public ValueNumeric.Expression offsetMinutes() {
        return FilterExpressionTemporal.totalOffsetMinutes(this::getExpression);
    }

    @Nonnull
    default public ValueDateTimeOffset.Expression add(@Nonnull ValueDuration operand) {
        ValueDateTimeOffset thisDateTime = this::getExpression;
        ValueDuration value = operand::getExpression;
        return FilterExpressionArithmetic.add(thisDateTime, value);
    }

    @Nonnull
    default public ValueDateTimeOffset.Expression add(@Nonnull Duration operand) {
        ValueDateTimeOffset thisDateTime = this::getExpression;
        ValueDuration value = ValueDuration.literal(operand);
        return FilterExpressionArithmetic.add(thisDateTime, value);
    }

    @Nonnull
    default public ValueDateTimeOffset.Expression subtract(@Nonnull ValueDuration operand) {
        ValueDateTimeOffset thisDateTime = this::getExpression;
        ValueDuration value = operand::getExpression;
        return FilterExpressionArithmetic.subtract(thisDateTime, value);
    }

    @Nonnull
    default public ValueDateTimeOffset.Expression subtract(@Nonnull Duration operand) {
        ValueDateTimeOffset thisDateTime = this::getExpression;
        ValueDuration value = ValueDuration.literal(operand);
        return FilterExpressionArithmetic.subtract(thisDateTime, value);
    }
}

