/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.expression;

import com.sap.cloud.sdk.datamodel.odata.client.expression.Expressions;
import com.sap.cloud.sdk.datamodel.odata.client.expression.FilterExpressionArithmetic;
import com.sap.cloud.sdk.datamodel.odata.client.expression.FilterExpressionTemporal;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueDate;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueDuration;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueNumeric;
import java.time.Duration;
import javax.annotation.Nonnull;

public interface FilterableDate
extends Expressions.Operand {
    @Nonnull
    default public ValueNumeric.Expression dateDay() {
        ValueDate thisDate = this::getExpression;
        return FilterExpressionTemporal.day(thisDate);
    }

    @Nonnull
    default public ValueNumeric.Expression dateMonth() {
        ValueDate thisDate = this::getExpression;
        return FilterExpressionTemporal.month(thisDate);
    }

    @Nonnull
    default public ValueNumeric.Expression dateYear() {
        ValueDate thisDate = this::getExpression;
        return FilterExpressionTemporal.year(thisDate);
    }

    @Nonnull
    default public ValueDate.Expression add(@Nonnull ValueDuration operand) {
        ValueDate thisDate = this::getExpression;
        ValueDuration value = operand::getExpression;
        return FilterExpressionArithmetic.add(thisDate, value);
    }

    @Nonnull
    default public ValueDate.Expression add(@Nonnull Duration operand) {
        ValueDate thisDate = this::getExpression;
        ValueDuration value = ValueDuration.literal(operand);
        return FilterExpressionArithmetic.add(thisDate, value);
    }

    @Nonnull
    default public ValueDate.Expression subtract(@Nonnull ValueDuration operand) {
        ValueDate thisDate = this::getExpression;
        ValueDuration value = operand::getExpression;
        return FilterExpressionArithmetic.subtract(thisDate, value);
    }

    @Nonnull
    default public ValueDate.Expression subtract(@Nonnull Duration operand) {
        ValueDate thisDate = this::getExpression;
        ValueDuration value = ValueDuration.literal(operand);
        return FilterExpressionArithmetic.subtract(thisDate, value);
    }

    @Nonnull
    default public ValueDuration.Expression difference(@Nonnull ValueDate operand) {
        ValueDate thisDate = this::getExpression;
        return FilterExpressionArithmetic.subtract(thisDate, operand);
    }
}

