/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.exception;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataServiceErrorDetails;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.result.ResultElement;
import com.sap.cloud.sdk.result.ResultObject;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODataServiceError
implements ODataServiceErrorDetails {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ODataServiceError.class);
    private static final String ERROR_DETAILS_FIELD = "errordetails";
    @Nonnull
    @SerializedName(value="code")
    @ElementName(value="code")
    private final String oDataCode;
    @Nonnull
    @SerializedName(value="message")
    @ElementName(value="message")
    @JsonAdapter(value=MessageDeserializer.class)
    private final String oDataMessage;
    @Nullable
    @SerializedName(value="target")
    @ElementName(value="target")
    private final String target;
    @Nullable
    @SerializedName(value="details")
    @ElementName(value="details")
    @JsonAdapter(value=DetailsDeserializer.class)
    private List<ODataServiceErrorDetails> details;
    @Nullable
    @SerializedName(value="innererror")
    @ElementName(value="innererror")
    private Map<String, Object> innerError;

    @Nonnull
    public List<ODataServiceErrorDetails> getDetails() {
        return this.details != null ? this.details : Collections.emptyList();
    }

    @Nonnull
    public Map<String, Object> getInnerError() {
        return this.innerError != null ? this.innerError : Collections.emptyMap();
    }

    @Nonnull
    public static ODataServiceError fromResultObject(@Nonnull ResultObject resultObject, @Nonnull ODataProtocol protocol) throws UnsupportedOperationException {
        if (protocol == ODataProtocol.V4) {
            return (ODataServiceError)resultObject.as(ODataServiceError.class);
        }
        String preparedErrorMessage = "Could not interpret the \"errordetails\" field of the " + String.valueOf(protocol) + " error as a list of OData errors. The list of details on the OData error will be empty.";
        Option maybeDetails = Option.of((Object)resultObject.get("innererror")).filter(r -> r != null && r.isResultObject()).map(r -> r.getAsObject().get(ERROR_DETAILS_FIELD)).filter(r -> r != null && r.isResultCollection()).map(ResultElement::getAsCollection).flatMap(details -> Try.of((CheckedFunction0 & Serializable)() -> details.asList(ODataServiceError.class)).onFailure(e -> log.debug(preparedErrorMessage, e)).toOption());
        ODataServiceError odataError = (ODataServiceError)resultObject.as(ODataServiceError.class);
        if (maybeDetails.isEmpty()) {
            return odataError;
        }
        odataError.getInnerError().remove(ERROR_DETAILS_FIELD);
        odataError.setDetails((List)maybeDetails.get());
        return odataError;
    }

    @Override
    @Nonnull
    public Option<String> getTarget() {
        return Option.of((Object)this.target);
    }

    private void setDetails(@Nullable List<? extends ODataServiceErrorDetails> details) {
        this.details = details;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ODataServiceError)) {
            return false;
        }
        ODataServiceError other = (ODataServiceError)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$oDataCode = this.getODataCode();
        String other$oDataCode = other.getODataCode();
        if (this$oDataCode == null ? other$oDataCode != null : !this$oDataCode.equals(other$oDataCode)) {
            return false;
        }
        String this$oDataMessage = this.getODataMessage();
        String other$oDataMessage = other.getODataMessage();
        if (this$oDataMessage == null ? other$oDataMessage != null : !this$oDataMessage.equals(other$oDataMessage)) {
            return false;
        }
        Option<String> this$target = this.getTarget();
        Option<String> other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        List<ODataServiceErrorDetails> this$details = this.getDetails();
        List<ODataServiceErrorDetails> other$details = other.getDetails();
        if (this$details == null ? other$details != null : !((Object)this$details).equals(other$details)) {
            return false;
        }
        Map<String, Object> this$innerError = this.getInnerError();
        Map<String, Object> other$innerError = other.getInnerError();
        return !(this$innerError == null ? other$innerError != null : !((Object)this$innerError).equals(other$innerError));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ODataServiceError;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oDataCode = this.getODataCode();
        result = result * 59 + ($oDataCode == null ? 43 : $oDataCode.hashCode());
        String $oDataMessage = this.getODataMessage();
        result = result * 59 + ($oDataMessage == null ? 43 : $oDataMessage.hashCode());
        Option<String> $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        List<ODataServiceErrorDetails> $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        Map<String, Object> $innerError = this.getInnerError();
        result = result * 59 + ($innerError == null ? 43 : ((Object)$innerError).hashCode());
        return result;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "ODataServiceError(oDataCode=" + this.getODataCode() + ", oDataMessage=" + this.getODataMessage() + ", target=" + String.valueOf(this.getTarget()) + ", details=" + String.valueOf(this.getDetails()) + ", innerError=" + String.valueOf(this.getInnerError()) + ")";
    }

    @Generated
    public ODataServiceError(@Nonnull String oDataCode, @Nonnull String oDataMessage, @Nullable String target) {
        if (oDataCode == null) {
            throw new NullPointerException("oDataCode is marked non-null but is null");
        }
        if (oDataMessage == null) {
            throw new NullPointerException("oDataMessage is marked non-null but is null");
        }
        this.oDataCode = oDataCode;
        this.oDataMessage = oDataMessage;
        this.target = target;
    }

    @Generated
    public ODataServiceError(@Nonnull String oDataCode, @Nonnull String oDataMessage, @Nullable String target, @Nullable List<ODataServiceErrorDetails> details, @Nullable Map<String, Object> innerError) {
        if (oDataCode == null) {
            throw new NullPointerException("oDataCode is marked non-null but is null");
        }
        if (oDataMessage == null) {
            throw new NullPointerException("oDataMessage is marked non-null but is null");
        }
        this.oDataCode = oDataCode;
        this.oDataMessage = oDataMessage;
        this.target = target;
        this.details = details;
        this.innerError = innerError;
    }

    @Override
    @Nonnull
    @Generated
    public String getODataCode() {
        return this.oDataCode;
    }

    @Override
    @Nonnull
    @Generated
    public String getODataMessage() {
        return this.oDataMessage;
    }

    private static class DetailsDeserializer
    implements JsonDeserializer<List<ODataServiceErrorDetails>> {
        private static final Gson gson = new Gson();
        private static final Type listType = new TypeToken<List<ODataServiceError>>(){}.getType();

        private DetailsDeserializer() {
        }

        public List<ODataServiceErrorDetails> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return json.isJsonNull() ? Collections.emptyList() : (List)gson.fromJson(json, listType);
        }
    }

    private static class MessageDeserializer
    implements JsonDeserializer<String> {
        private MessageDeserializer() {
        }

        @Nullable
        public String deserialize(@Nonnull JsonElement json, @Nonnull Type typeOfT, @Nonnull JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                return json.getAsString();
            }
            if (json.isJsonObject()) {
                JsonElement value = json.getAsJsonObject().get("value");
                if (value != null && value.isJsonPrimitive()) {
                    return value.getAsString();
                }
                log.warn("Unable to deserialize error value from \"message\": {}", (Object)value);
            } else {
                log.warn("Unable to deserialize a \"message\" value from JSON value: {}", (Object)json);
            }
            return null;
        }
    }
}

