/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.google.gson.JsonObject;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataDeserializationException;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataResponseException;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataServiceError;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataServiceErrorException;
import com.sap.cloud.sdk.datamodel.odata.client.request.HttpEntityReader;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataGsonBuilder;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResult;
import com.sap.cloud.sdk.result.GsonResultElementFactory;
import com.sap.cloud.sdk.result.GsonResultObject;
import com.sap.cloud.sdk.result.ResultObject;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;

class ODataHealthyResponseValidator {
    ODataHealthyResponseValidator() {
    }

    static void requireHealthyResponse(@Nonnull ODataRequestResult result) {
        ODataRequestGeneric request = result.getODataRequest();
        HttpResponse httpResponse = result.getHttpResponse();
        StatusLine statusLine = httpResponse.getStatusLine();
        if (statusLine != null && statusLine.getStatusCode() < 400) {
            return;
        }
        Integer statusCode = statusLine == null ? null : Integer.valueOf(statusLine.getStatusCode());
        String msg = "The HTTP response code (" + statusCode + ") indicates an error.";
        ODataResponseException preparedException = new ODataResponseException(request, httpResponse, msg, null);
        Try odataError = Try.of((CheckedFunction0 & Serializable)() -> ODataHealthyResponseValidator.loadErrorFromResponse(result));
        if (odataError.isSuccess()) {
            String msgError = msg + " The OData service responded with an error message.";
            throw new ODataServiceErrorException(request, httpResponse, msgError, null, (ODataServiceError)odataError.get());
        }
        throw preparedException;
    }

    @Nonnull
    private static ODataServiceError loadErrorFromResponse(ODataRequestResult result) throws ODataDeserializationException {
        GsonResultElementFactory elementFactory = new GsonResultElementFactory(ODataGsonBuilder.newGsonBuilder());
        return (ODataServiceError)HttpEntityReader.read(result, (CheckedFunction1 & Serializable)root -> {
            JsonObject error = root.getAsJsonObject().get("error").getAsJsonObject();
            GsonResultObject errorObject = new GsonResultObject(error, elementFactory);
            return ODataServiceError.fromResultObject((ResultObject)errorObject, result.getODataRequest().getProtocol());
        });
    }
}

