/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.result;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.sap.cloud.sdk.result.DefaultResultCollection;
import com.sap.cloud.sdk.result.GsonResultObject;
import com.sap.cloud.sdk.result.GsonResultPrimitive;
import com.sap.cloud.sdk.result.ResultCollection;
import com.sap.cloud.sdk.result.ResultElement;
import com.sap.cloud.sdk.result.ResultElementFactory;
import com.sap.cloud.sdk.result.ResultObject;
import com.sap.cloud.sdk.result.ResultPrimitive;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class GsonResultElementFactory
implements ResultElementFactory<JsonElement> {
    @Nonnull
    protected final GsonBuilder gsonBuilder;

    @Nonnull
    protected ResultPrimitive newPrimitive(@Nonnull JsonElement resultElement) {
        return new GsonResultPrimitive(resultElement.getAsJsonPrimitive());
    }

    @Nonnull
    protected ResultObject newObject(@Nonnull JsonElement resultElement) {
        return new GsonResultObject(resultElement.getAsJsonObject(), this);
    }

    @Nonnull
    protected ResultCollection newCollection(@Nonnull JsonElement resultElement) {
        ArrayList<ResultElement> resultElements = new ArrayList<ResultElement>();
        for (JsonElement jsonElement : resultElement.getAsJsonArray()) {
            resultElements.add(this.create(jsonElement));
        }
        return new DefaultResultCollection(resultElements);
    }

    @Override
    @Nullable
    public ResultElement create(@Nullable JsonElement resultElement) throws IllegalArgumentException {
        if (resultElement == null) {
            return null;
        }
        if (resultElement.isJsonPrimitive()) {
            return this.newPrimitive(resultElement);
        }
        if (resultElement.isJsonObject()) {
            return this.newObject(resultElement);
        }
        if (resultElement.isJsonArray()) {
            return this.newCollection(resultElement);
        }
        throw new IllegalArgumentException("Failed to convert " + JsonElement.class.getSimpleName() + " " + String.valueOf(resultElement) + " to instance of " + ResultElement.class.getSimpleName() + ".");
    }

    @Generated
    public GsonResultElementFactory(@Nonnull GsonBuilder gsonBuilder) {
        if (gsonBuilder == null) {
            throw new NullPointerException("gsonBuilder is marked non-null but is null");
        }
        this.gsonBuilder = gsonBuilder;
    }

    @Nonnull
    @Generated
    public GsonBuilder getGsonBuilder() {
        return this.gsonBuilder;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GsonResultElementFactory)) {
            return false;
        }
        GsonResultElementFactory other = (GsonResultElementFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GsonBuilder this$gsonBuilder = this.getGsonBuilder();
        GsonBuilder other$gsonBuilder = other.getGsonBuilder();
        return !(this$gsonBuilder == null ? other$gsonBuilder != null : !this$gsonBuilder.equals(other$gsonBuilder));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof GsonResultElementFactory;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GsonBuilder $gsonBuilder = this.getGsonBuilder();
        result = result * 59 + ($gsonBuilder == null ? 43 : $gsonBuilder.hashCode());
        return result;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "GsonResultElementFactory(gsonBuilder=" + String.valueOf(this.getGsonBuilder()) + ")";
    }
}

