/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.typeconverter;

import com.sap.cloud.sdk.typeconverter.exception.ObjectNotConvertibleException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class ConvertedObject<T> {
    private final boolean notConvertible;
    @Nullable
    private final T object;

    @Nullable
    public T get() throws ObjectNotConvertibleException {
        if (this.notConvertible) {
            throw new ObjectNotConvertibleException("Object is not convertible.");
        }
        return this.object;
    }

    @Nullable
    public T orNull() {
        return this.orElse(null);
    }

    @Nullable
    public T orElse(@Nullable T defaultValue) {
        if (this.notConvertible) {
            return defaultValue;
        }
        return this.object;
    }

    public boolean isConvertible() {
        return !this.notConvertible;
    }

    @Nonnull
    public static <T> ConvertedObject<T> of(@Nullable T convertedObject) {
        return new ConvertedObject<T>(false, convertedObject);
    }

    @Nonnull
    public static <T> ConvertedObject<T> ofNull() {
        return ConvertedObject.of(null);
    }

    @Nonnull
    public static <T> ConvertedObject<T> ofNotConvertible() {
        return new ConvertedObject<Object>(true, null);
    }

    @Generated
    protected ConvertedObject(boolean notConvertible, @Nullable T object) {
        this.notConvertible = notConvertible;
        this.object = object;
    }

    @Nullable
    @Generated
    public T getObject() {
        return this.object;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConvertedObject)) {
            return false;
        }
        ConvertedObject other = (ConvertedObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNotConvertible() != other.isNotConvertible()) {
            return false;
        }
        T this$object = this.getObject();
        T other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ConvertedObject;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNotConvertible() ? 79 : 97);
        T $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "ConvertedObject(notConvertible=" + this.isNotConvertible() + ", object=" + this.getObject() + ")";
    }

    @Generated
    public boolean isNotConvertible() {
        return this.notConvertible;
    }
}

