/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.principal;

import com.sap.cloud.sdk.cloudplatform.security.principal.DefaultPrincipalFacade;
import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalFacade;
import com.sap.cloud.sdk.cloudplatform.security.principal.exception.PrincipalAccessException;
import com.sap.cloud.sdk.cloudplatform.thread.Executable;
import com.sap.cloud.sdk.cloudplatform.thread.exception.ThreadContextExecutionException;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import io.vavr.control.Try;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PrincipalAccessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrincipalAccessor.class);
    @Nonnull
    private static PrincipalFacade principalFacade = PrincipalAccessor.loadFacadeOrDefault();
    @Nullable
    private static Supplier<Principal> fallbackPrincipal = null;

    @Nonnull
    public static PrincipalFacade getPrincipalFacade() {
        return principalFacade;
    }

    @Nonnull
    public static Try<PrincipalFacade> tryGetPrincipalFacade() {
        return Try.success((Object)principalFacade);
    }

    public static void setPrincipalFacade(@Nullable PrincipalFacade principalFacade) {
        PrincipalAccessor.principalFacade = principalFacade == null ? PrincipalAccessor.loadFacadeOrDefault() : principalFacade;
    }

    @Nonnull
    private static PrincipalFacade loadFacadeOrDefault() {
        return (PrincipalFacade)FacadeLocator.getFacade(PrincipalFacade.class).getOrElseGet(e -> {
            log.debug("No PrincipalFacade found via FacadeLocator. Falling back to DefaultPrincipalFacade.");
            return new DefaultPrincipalFacade();
        });
    }

    @Nonnull
    public static Principal getCurrentPrincipal() throws PrincipalAccessException {
        return (Principal)PrincipalAccessor.tryGetCurrentPrincipal().getOrElseThrow(failure -> {
            if (failure instanceof PrincipalAccessException) {
                throw (PrincipalAccessException)failure;
            }
            throw new PrincipalAccessException("Failed to get current principal.", (Throwable)failure);
        });
    }

    @Nonnull
    public static Try<Principal> tryGetCurrentPrincipal() {
        Try<Principal> principalTry = principalFacade.tryGetCurrentPrincipal();
        if (principalTry.isSuccess() || fallbackPrincipal == null) {
            return principalTry;
        }
        Principal fallback = fallbackPrincipal.get();
        if (fallback == null) {
            return Try.failure((Throwable)new PrincipalAccessException());
        }
        return principalTry.recover(failure -> {
            log.warn("Recovering with fallback principal: {}.", (Object)fallback, failure);
            return fallback;
        });
    }

    @Nullable
    public static <T> T executeWithPrincipal(@Nonnull Principal principal, @Nonnull Callable<T> callable) throws ThreadContextExecutionException {
        PrincipalFacade maybeFacade = PrincipalAccessor.getPrincipalFacade();
        if (maybeFacade == null || !DefaultPrincipalFacade.class.isAssignableFrom(maybeFacade.getClass())) {
            throw new ThreadContextExecutionException(String.format("The 'executeWith...' API is currently supported only when using the Cloud SDK's 'DefaultFacade' implementations (e.g. '%s'). This is an issue especially when using the CAP integration ('cds-integration-cloud-sdk'). To workaround this shortcoming, please refer to the CAP documentation about how to manipulate the request context: https://cap.cloud.sap/docs/java/request-contexts#defining-requestcontext.", DefaultPrincipalFacade.class.getName()));
        }
        return ((DefaultPrincipalFacade)maybeFacade).executeWithPrincipal(principal, callable);
    }

    public static void executeWithPrincipal(@Nonnull Principal principal, @Nonnull Executable executable) throws ThreadContextExecutionException {
        PrincipalAccessor.executeWithPrincipal(principal, () -> {
            executable.execute();
            return null;
        });
    }

    @Nullable
    public static <T> T executeWithFallbackPrincipal(@Nonnull Supplier<Principal> fallbackPrincipal, @Nonnull Callable<T> callable) throws ThreadContextExecutionException {
        Try<Principal> principalTry = PrincipalAccessor.tryGetCurrentPrincipal();
        if (principalTry.isSuccess()) {
            try {
                return callable.call();
            }
            catch (ThreadContextExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ThreadContextExecutionException((Throwable)e);
            }
        }
        return PrincipalAccessor.executeWithPrincipal(fallbackPrincipal.get(), callable);
    }

    public static void executeWithFallbackPrincipal(@Nonnull Supplier<Principal> fallbackPrincipal, @Nonnull Executable executable) throws ThreadContextExecutionException {
        PrincipalAccessor.executeWithFallbackPrincipal(fallbackPrincipal, () -> {
            executable.execute();
            return null;
        });
    }

    @Generated
    private PrincipalAccessor() {
    }

    @Nullable
    @Generated
    public static Supplier<Principal> getFallbackPrincipal() {
        return fallbackPrincipal;
    }

    @Generated
    public static void setFallbackPrincipal(@Nullable Supplier<Principal> fallbackPrincipal) {
        PrincipalAccessor.fallbackPrincipal = fallbackPrincipal;
    }
}

