/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextDecorator;
import com.sap.cloud.security.token.SecurityContext;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.x509.Certificate;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityContextThreadContextDecorator
implements ThreadContextDecorator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityContextThreadContextDecorator.class);
    private final int priority = -1;

    @Nonnull
    public <T> Callable<T> decorateCallable(@Nonnull Callable<T> callable) {
        try {
            Class.forName("com.sap.cloud.security.token.SecurityContext", true, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            log.debug("SecurityContext class not found, no propagation to new Thread necessary.");
            return callable;
        }
        Token tokenToPass = SecurityContext.getToken();
        Certificate certToPass = SecurityContext.getClientCertificate();
        if (tokenToPass == null && certToPass == null) {
            log.debug("Current SecurityContext is empty, no propagation to new Thread necessary.");
            return callable;
        }
        log.debug("Propagating current SecurityContext to new Thread.");
        return () -> {
            Token initialToken = SecurityContext.getToken();
            Certificate initialCert = SecurityContext.getClientCertificate();
            log.debug("Setting current SecurityContext to propagated context.");
            SecurityContext.setToken((Token)tokenToPass);
            SecurityContext.setClientCertificate((Certificate)certToPass);
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                log.debug("Resetting SecurityContext to initial value.");
                SecurityContext.setToken((Token)initialToken);
                SecurityContext.setClientCertificate((Certificate)initialCert);
            }
        };
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }
}

