/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.SSLContextFactory;
import com.sap.cloud.sdk.cloudplatform.util.StringUtils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SSLSocketFactoryUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SSLSocketFactoryUtil.class);

    SSLSocketFactoryUtil() {
    }

    @Nullable
    static Registry<ConnectionSocketFactory> getConnectionSocketFactoryRegistry(@Nullable HttpDestinationProperties destination) throws GeneralSecurityException, IOException {
        if (!SSLSocketFactoryUtil.supportsTls(destination)) {
            return null;
        }
        log.debug("The destination uses HTTPS for target \"{}\".", (Object)destination.getUri());
        LayeredConnectionSocketFactory sslConnectionFactory = SSLSocketFactoryUtil.getConnectionSocketFactory(destination);
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        registryBuilder.register("https", (Object)sslConnectionFactory);
        registryBuilder.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        return registryBuilder.build();
    }

    private static boolean supportsTls(@Nullable HttpDestinationProperties destination) {
        if (destination == null) {
            return false;
        }
        String scheme = destination.getUri().getScheme();
        return "https".equalsIgnoreCase(scheme) || StringUtils.isEmpty((String)scheme);
    }

    @Nonnull
    private static LayeredConnectionSocketFactory getConnectionSocketFactory(@Nonnull HttpDestinationProperties destination) throws GeneralSecurityException, IOException {
        SSLContext sslContext = new SSLContextFactory().createSSLContext(destination);
        HostnameVerifier hostnameVerifier = SSLSocketFactoryUtil.getHostnameVerifier(destination);
        return new SSLConnectionSocketFactory(sslContext, hostnameVerifier);
    }

    private static HostnameVerifier getHostnameVerifier(HttpDestinationProperties destination) {
        return destination.isTrustingAllCertificates() ? new NoopHostnameVerifier() : new DefaultHostnameVerifier();
    }
}

