/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.AbstractHttpClientFactory;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpClientFactory
extends AbstractHttpClientFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpClientFactory.class);
    static final int DEFAULT_TIMEOUT_MINUTES = 2;
    static final int DEFAULT_MAX_TOTAL_CONNECTIONS = 200;
    static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 100;
    private final int timeoutMilliseconds;
    private final int maxConnectionsPerRoute;
    private final int maxConnectionsTotal;

    @Override
    @Nonnull
    protected RequestConfig.Builder getRequestConfigBuilder(@Nullable HttpDestinationProperties destination) {
        return super.getRequestConfigBuilder(destination).setConnectTimeout(this.getTimeoutMilliseconds()).setConnectionRequestTimeout(this.getTimeoutMilliseconds()).setSocketTimeout(this.getTimeoutMilliseconds());
    }

    @Override
    @Nonnull
    protected SocketConfig.Builder getSocketConfigBuilder(@Nullable HttpDestinationProperties destination) {
        return super.getSocketConfigBuilder(destination).setSoTimeout(this.getTimeoutMilliseconds());
    }

    @Override
    @Nonnull
    protected PoolingHttpClientConnectionManager getConnectionManager(@Nullable HttpDestinationProperties destination) throws GeneralSecurityException, IOException {
        PoolingHttpClientConnectionManager connectionManager = super.getConnectionManager(destination);
        connectionManager.setMaxTotal(this.getMaxConnectionsTotal());
        connectionManager.setDefaultMaxPerRoute(this.getMaxConnectionsPerRoute());
        return connectionManager;
    }

    @Generated
    private static int $default$timeoutMilliseconds() {
        return (int)TimeUnit.MINUTES.toMillis(2L);
    }

    @Generated
    private static int $default$maxConnectionsPerRoute() {
        return 100;
    }

    @Generated
    private static int $default$maxConnectionsTotal() {
        return 200;
    }

    @Nonnull
    @Generated
    public static DefaultHttpClientFactoryBuilder builder() {
        return new DefaultHttpClientFactoryBuilder();
    }

    @Generated
    public DefaultHttpClientFactory() {
        this.timeoutMilliseconds = DefaultHttpClientFactory.$default$timeoutMilliseconds();
        this.maxConnectionsPerRoute = DefaultHttpClientFactory.$default$maxConnectionsPerRoute();
        this.maxConnectionsTotal = DefaultHttpClientFactory.$default$maxConnectionsTotal();
    }

    @Generated
    private DefaultHttpClientFactory(int timeoutMilliseconds, int maxConnectionsPerRoute, int maxConnectionsTotal) {
        this.timeoutMilliseconds = timeoutMilliseconds;
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
        this.maxConnectionsTotal = maxConnectionsTotal;
    }

    @Generated
    protected int getTimeoutMilliseconds() {
        return this.timeoutMilliseconds;
    }

    @Generated
    protected int getMaxConnectionsPerRoute() {
        return this.maxConnectionsPerRoute;
    }

    @Generated
    protected int getMaxConnectionsTotal() {
        return this.maxConnectionsTotal;
    }

    @Generated
    public static class DefaultHttpClientFactoryBuilder {
        @Generated
        private boolean timeoutMilliseconds$set;
        @Generated
        private int timeoutMilliseconds$value;
        @Generated
        private boolean maxConnectionsPerRoute$set;
        @Generated
        private int maxConnectionsPerRoute$value;
        @Generated
        private boolean maxConnectionsTotal$set;
        @Generated
        private int maxConnectionsTotal$value;

        @Generated
        DefaultHttpClientFactoryBuilder() {
        }

        @Nonnull
        @Generated
        public DefaultHttpClientFactoryBuilder timeoutMilliseconds(int timeoutMilliseconds) {
            this.timeoutMilliseconds$value = timeoutMilliseconds;
            this.timeoutMilliseconds$set = true;
            return this;
        }

        @Nonnull
        @Generated
        public DefaultHttpClientFactoryBuilder maxConnectionsPerRoute(int maxConnectionsPerRoute) {
            this.maxConnectionsPerRoute$value = maxConnectionsPerRoute;
            this.maxConnectionsPerRoute$set = true;
            return this;
        }

        @Nonnull
        @Generated
        public DefaultHttpClientFactoryBuilder maxConnectionsTotal(int maxConnectionsTotal) {
            this.maxConnectionsTotal$value = maxConnectionsTotal;
            this.maxConnectionsTotal$set = true;
            return this;
        }

        @Nonnull
        @Generated
        public DefaultHttpClientFactory build() {
            int timeoutMilliseconds$value = this.timeoutMilliseconds$value;
            if (!this.timeoutMilliseconds$set) {
                timeoutMilliseconds$value = DefaultHttpClientFactory.$default$timeoutMilliseconds();
            }
            int maxConnectionsPerRoute$value = this.maxConnectionsPerRoute$value;
            if (!this.maxConnectionsPerRoute$set) {
                maxConnectionsPerRoute$value = DefaultHttpClientFactory.$default$maxConnectionsPerRoute();
            }
            int maxConnectionsTotal$value = this.maxConnectionsTotal$value;
            if (!this.maxConnectionsTotal$set) {
                maxConnectionsTotal$value = DefaultHttpClientFactory.$default$maxConnectionsTotal();
            }
            return new DefaultHttpClientFactory(timeoutMilliseconds$value, maxConnectionsPerRoute$value, maxConnectionsTotal$value);
        }

        @Nonnull
        @Generated
        public String toString() {
            return "DefaultHttpClientFactory.DefaultHttpClientFactoryBuilder(timeoutMilliseconds$value=" + this.timeoutMilliseconds$value + ", maxConnectionsPerRoute$value=" + this.maxConnectionsPerRoute$value + ", maxConnectionsTotal$value=" + this.maxConnectionsTotal$value + ")";
        }
    }
}

