/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.cloudplatform.cache.CacheManager;
import com.sap.cloud.sdk.cloudplatform.connectivity.AbstractHttpClientCache;
import com.sap.cloud.sdk.cloudplatform.connectivity.AuthenticationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationUtility;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import io.vavr.control.Try;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpClientCache
extends AbstractHttpClientCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpClientCache.class);
    private final Cache<CacheKey, HttpClient> cache;

    DefaultHttpClientCache() {
        this(1L, TimeUnit.HOURS);
    }

    public DefaultHttpClientCache(long duration, @Nonnull TimeUnit unit) {
        this(duration, unit, Ticker.systemTicker());
    }

    DefaultHttpClientCache(long duration, @Nonnull TimeUnit unit, @Nonnull Ticker ticker) {
        this.cache = Caffeine.newBuilder().expireAfterAccess(duration, unit).ticker(ticker).build();
        CacheManager.register(this.cache);
    }

    @Override
    @Nonnull
    protected Try<Cache<CacheKey, HttpClient>> getCache() {
        return Try.success(this.cache);
    }

    @Override
    @Nonnull
    protected Try<CacheKey> getCacheKey(@Nonnull HttpDestinationProperties destination) {
        if (!DefaultHttpClientCache.requiresPrincipalIsolation(destination)) {
            return Try.success((Object)CacheKey.ofTenantOptionalIsolation().append(new Object[]{destination}));
        }
        Try maybeTenant = TenantAccessor.tryGetCurrentTenant();
        Try principal = PrincipalAccessor.tryGetCurrentPrincipal();
        if (principal.isFailure()) {
            return Try.failure((Throwable)new IllegalStateException("The destination requires a principal, but none was found in the current context.", principal.getCause()));
        }
        if (maybeTenant.isFailure()) {
            String msg = "Tenant and Principal accessors are returning inconsistent results: A principal is defined, but no tenant is defined in the current context.";
            return Try.failure((Throwable)new IllegalStateException("Tenant and Principal accessors are returning inconsistent results: A principal is defined, but no tenant is defined in the current context.", maybeTenant.getCause()));
        }
        return Try.success((Object)CacheKey.of((Tenant)((Tenant)maybeTenant.getOrNull()), (Principal)((Principal)principal.get())).append(new Object[]{destination}));
    }

    static boolean requiresPrincipalIsolation(@Nonnull HttpDestinationProperties destination) {
        return DestinationUtility.requiresUserTokenExchange((DestinationProperties)destination) || destination.getAuthenticationType() == AuthenticationType.PRINCIPAL_PROPAGATION;
    }

    @Override
    @Nonnull
    protected Try<CacheKey> getCacheKey() {
        return Try.of(CacheKey::ofTenantAndPrincipalOptionalIsolation);
    }
}

