/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperty;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientFactory;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientWrapper;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyConfiguration;
import com.sap.cloud.sdk.cloudplatform.connectivity.SSLSocketFactoryUtil;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.HttpClientInstantiationException;
import io.vavr.control.Option;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpClientFactory
implements HttpClientFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractHttpClientFactory.class);

    @Override
    @Nonnull
    public HttpClient createHttpClient(@Nullable HttpDestinationProperties destination) throws DestinationAccessException, HttpClientInstantiationException {
        HttpClientBuilder clientBuilder = this.getHttpClientBuilder(destination);
        CloseableHttpClient httpClient = clientBuilder.build();
        if (destination != null) {
            return new HttpClientWrapper(httpClient, destination);
        }
        return httpClient;
    }

    @Nonnull
    protected RequestConfig.Builder getRequestConfigBuilder(@Nullable HttpDestinationProperties destination) {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        if (this.isValidProxyConfigurationUriInDestination(destination)) {
            URI proxyUri = ((ProxyConfiguration)Objects.requireNonNull(destination).getProxyConfiguration().get()).getUri();
            HttpHost proxyHost = new HttpHost(proxyUri.getHost(), proxyUri.getPort(), proxyUri.getScheme());
            log.debug("Using the following proxy for destination {} pointing to URL {}: {}.", new Object[]{destination.get(DestinationProperty.NAME).getOrElse((Object)"without name"), destination.getUri(), proxyUri});
            requestConfigBuilder.setProxy(proxyHost);
        }
        return requestConfigBuilder;
    }

    @Nonnull
    protected SocketConfig.Builder getSocketConfigBuilder(@Nullable HttpDestinationProperties destination) {
        return SocketConfig.custom();
    }

    protected HttpClientBuilder getHttpClientBuilder(@Nullable HttpDestinationProperties destination) throws HttpClientInstantiationException {
        try {
            HttpClientBuilder clientBuilder = this.createHttpClientBuilder();
            clientBuilder.setDefaultRequestConfig(this.getRequestConfigBuilder(destination).build());
            clientBuilder.setDefaultSocketConfig(this.getSocketConfigBuilder(destination).build());
            clientBuilder.setConnectionManager((HttpClientConnectionManager)this.getConnectionManager(destination));
            return clientBuilder;
        }
        catch (IOException | IllegalArgumentException | GeneralSecurityException e) {
            log.error("Failed to instantiate an {} builder for destination {}", new Object[]{HttpClient.class.getSimpleName(), destination, e});
            throw new HttpClientInstantiationException((Throwable)e);
        }
    }

    @Nonnull
    protected PoolingHttpClientConnectionManager getConnectionManager(@Nullable HttpDestinationProperties destination) throws GeneralSecurityException, IOException {
        Registry<ConnectionSocketFactory> connectionSocketFactoryRegistry = SSLSocketFactoryUtil.getConnectionSocketFactoryRegistry(destination);
        if (connectionSocketFactoryRegistry != null) {
            return new PoolingHttpClientConnectionManager(connectionSocketFactoryRegistry);
        }
        return new PoolingHttpClientConnectionManager();
    }

    @Nonnull
    private HttpClientBuilder createHttpClientBuilder() {
        log.debug("Building a new custom HttpClient.");
        return HttpClients.custom();
    }

    private boolean isValidProxyConfigurationUriInDestination(@Nullable HttpDestinationProperties destination) {
        if (destination == null) {
            log.trace("No destination defined for HTTP client builder.");
            return false;
        }
        Option proxyConfiguration = destination.getProxyConfiguration();
        if (proxyConfiguration.isEmpty()) {
            log.trace("No proxy configuration found for destination {}.", (Object)destination);
            return false;
        }
        URI uri = ((ProxyConfiguration)proxyConfiguration.get()).getUri();
        String undefinedProxyMayBeExpectedMessage = "Failed to load proxy information for destination {}: Undefined {} in URI of proxy configuration. This behavior may be expected in tests and some local runtimes.";
        String host = uri.getHost();
        if (host == null) {
            log.error("Failed to load proxy information for destination {}: Undefined {} in URI of proxy configuration. This behavior may be expected in tests and some local runtimes.", (Object)destination, (Object)"host");
            return false;
        }
        int port = uri.getPort();
        if (port < 0) {
            log.error("Failed to load proxy information for destination {}: Undefined {} in URI of proxy configuration. This behavior may be expected in tests and some local runtimes.", (Object)destination, (Object)"port");
            return false;
        }
        return true;
    }
}

