/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import com.sap.db.util.PlatformUtils;
import java.io.File;
import java.io.IOException;

@Immutable
public final class FileUtils {
    private FileUtils() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static String getDirectoryName(String path) {
        int index = path.lastIndexOf(File.separatorChar);
        return index != -1 ? path.substring(0, index) : ".";
    }

    public static String getFileName(String path) {
        String fileNameWithExtension = path.substring(path.lastIndexOf(File.separatorChar) + 1);
        int index = fileNameWithExtension.lastIndexOf(46);
        return index != -1 ? fileNameWithExtension.substring(0, index) : fileNameWithExtension;
    }

    public static String getFileExtension(String path) {
        int index = path.lastIndexOf(46);
        return index != -1 ? path.substring(index) : "";
    }

    public static File createDirectoryIfNecessary(String path) {
        if (path == null) {
            return null;
        }
        File file = new File(path);
        if (!file.isDirectory() && !file.mkdirs()) {
            return null;
        }
        return file;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void limitAccessToReadWriteByOwner(File file) {
        if (PlatformUtils.isWindows()) {
            try {
                String fileName = file.getCanonicalPath();
                PlatformUtils.execWindowsSystemExecutable("icacls.exe", "\"" + fileName + "\" /inheritance:r", "Can't remove all inherited ACEs");
                for (String sid : new String[]{"SYSTEM", "Administrators", "CREATOR OWNER"}) {
                    PlatformUtils.execWindowsSystemExecutable("icacls.exe", "\"" + fileName + "\" /grant \"" + sid + "\":(F)", "Can't grant full control to " + sid);
                }
                return;
            }
            catch (IOException | SecurityException exception) {
                return;
            }
        } else {
            try {
                if (!file.setExecutable(false, false)) {
                    // empty if block
                }
                if (!file.setWritable(false, false)) {
                    // empty if block
                }
                if (!file.setReadable(false, false)) {
                    // empty if block
                }
                if (!file.setReadable(true)) {
                    // empty if block
                }
                if (file.setWritable(true)) return;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }
}

