/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

@Immutable
public final class StringUtils {
    public static final ThreadLocal<DecimalFormat> DECIMAL_FORMAT = new ThreadLocal<DecimalFormat>(){

        @Override
        public DecimalFormat initialValue() {
            DecimalFormat decimalFormat = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
            decimalFormat.setMaximumFractionDigits(340);
            return decimalFormat;
        }
    };

    private StringUtils() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static boolean isQuoted(String text, char quoteChar) {
        int len;
        return text != null && (len = text.length()) >= 2 && text.charAt(0) == quoteChar && text.charAt(len - 1) == quoteChar;
    }

    public static String quote(String text, char quoteChar, char escapeChar, boolean addEnclosingQuotes, boolean doubleUpQuotes) {
        if (text == null || text.indexOf(quoteChar) == -1 && text.indexOf(escapeChar) == -1 && !addEnclosingQuotes) {
            return text;
        }
        boolean doubleUpEscapes = escapeChar != '\u0000';
        int len = text != null ? text.length() : 0;
        char[] buf = new char[len * 2 + 2];
        int n = 0;
        if (addEnclosingQuotes) {
            buf[n++] = quoteChar;
        }
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            buf[n++] = c;
            if (doubleUpQuotes && c == quoteChar) {
                buf[n++] = quoteChar;
            }
            if (!doubleUpEscapes || c != escapeChar) continue;
            buf[n++] = escapeChar;
        }
        if (addEnclosingQuotes) {
            buf[n++] = quoteChar;
        }
        return new String(buf, 0, n);
    }

    public static String unquote(String text, char quoteChar, char escapeChar, boolean removeEnclosingQuotes, boolean singleDownQuotes) {
        int endIndex;
        int startIndex;
        if (text == null || text.length() <= 1 || text.indexOf(quoteChar) == -1 && text.indexOf(escapeChar) == -1) {
            return text;
        }
        boolean singleDownEscapes = escapeChar != '\u0000';
        int len = text.length();
        if (removeEnclosingQuotes && text.indexOf(quoteChar) == 0 && text.lastIndexOf(quoteChar) == len - 1) {
            startIndex = 1;
            endIndex = len - 1;
        } else {
            startIndex = 0;
            endIndex = len;
        }
        char[] buf = new char[endIndex - startIndex];
        int n = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            char c = text.charAt(i);
            if (singleDownQuotes && c == quoteChar && i < endIndex - 1 && text.charAt(i + 1) == quoteChar) {
                buf[n++] = quoteChar;
                ++i;
                continue;
            }
            if (singleDownEscapes && c == escapeChar && i < endIndex - 1 && text.charAt(i + 1) == escapeChar) {
                buf[n++] = escapeChar;
                ++i;
                continue;
            }
            buf[n++] = c;
        }
        return new String(buf, 0, n);
    }

    public static String quoteSqlIdentifier(String text) {
        return StringUtils.quote(text, '\"', '\u0000', true, true);
    }

    public static String quoteSqlString(String text) {
        return StringUtils.quote(text, '\'', '\u0000', true, true);
    }

    public static String stripUserName(String userName) {
        if (userName == null) {
            return null;
        }
        return StringUtils.isQuoted(userName, '\"') ? StringUtils.unquote(userName, '\"', '\u0000', true, false) : userName.toUpperCase(Locale.ENGLISH);
    }

    public static String stripPasswd(String passwd) {
        if (passwd == null) {
            return null;
        }
        return StringUtils.unquote(passwd, '\"', '\u0000', true, false);
    }
}

